/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PulsatingRoundRectBackground
extends Background {
    private int currentColor;
    private int currentStep;
    private boolean repeat;
    private boolean backAndForth;
    private boolean directionUp;
    private boolean animationStopped;
    private int startColor;
    private int endColor;
    private int steps;
    private int arcWidth;
    private int arcHeight;

    public PulsatingRoundRectBackground(int startColor, int endColor, int steps, boolean repeat, boolean backAndForth, int arcWidth, int arcHeight) {
        this.directionUp = true;
        this.startColor = startColor;
        this.endColor = endColor;
        this.steps = steps;
        this.repeat = repeat;
        this.backAndForth = backAndForth;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.currentColor = startColor;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.currentColor);
        g.fillRoundRect(x, y, width - 1, height, this.arcWidth, this.arcHeight);
    }

    public boolean animate() {
        if (this.animationStopped) {
            return false;
        }
        if (this.backAndForth) {
            if (this.directionUp) {
                ++this.currentStep;
                if (this.currentStep > this.steps) {
                    --this.currentStep;
                    this.directionUp = false;
                }
            } else {
                --this.currentStep;
                if (this.currentStep == -1) {
                    this.currentStep = 0;
                    if (this.repeat) {
                        this.directionUp = true;
                    } else {
                        this.animationStopped = true;
                    }
                }
            }
        } else {
            ++this.currentStep;
            if (this.currentStep > this.steps) {
                if (this.repeat) {
                    this.currentStep = 0;
                } else {
                    --this.currentStep;
                    this.animationStopped = true;
                }
            }
        }
        this.currentColor = DrawUtil.getGradientColor(this.startColor, this.endColor, this.currentStep, this.steps);
        return true;
    }

    public PulsatingRoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationStopped = dataInputStream.readBoolean();
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.backAndForth = dataInputStream.readBoolean();
        this.currentColor = dataInputStream.readInt();
        this.currentStep = dataInputStream.readInt();
        this.directionUp = dataInputStream.readBoolean();
        this.endColor = dataInputStream.readInt();
        this.repeat = dataInputStream.readBoolean();
        this.startColor = dataInputStream.readInt();
        this.steps = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationStopped);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeBoolean(this.backAndForth);
        dataOutputStream.writeInt(this.currentColor);
        dataOutputStream.writeInt(this.currentStep);
        dataOutputStream.writeBoolean(this.directionUp);
        dataOutputStream.writeInt(this.endColor);
        dataOutputStream.writeBoolean(this.repeat);
        dataOutputStream.writeInt(this.startColor);
        dataOutputStream.writeInt(this.steps);
    }
}

