/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PulsatingCirclesBackground
extends Background {
    private int startColor;
    private int firstColor;
    private int secondColor;
    private short[] diameters;
    private int preciseMinDiameter;
    private int preciseMaxDiameter;
    private int[] preciseDiameters;
    private int diameterGrowth;
    private Dimension maxDiameter;
    private Dimension minDiameter;
    int lastWidth;
    int lastHeight;

    public PulsatingCirclesBackground(int firstColor, int secondColor, int minDiameter, int maxDiameter, int numberOfCircles, int step) {
        this(firstColor, secondColor, new Dimension(minDiameter, false), new Dimension(maxDiameter, false), numberOfCircles, step);
    }

    public PulsatingCirclesBackground(int firstColor, int secondColor, Dimension minDiameter, Dimension maxDiameter, int numberOfCircles, int step) {
        this.startColor = firstColor;
        this.firstColor = firstColor;
        this.secondColor = secondColor;
        this.minDiameter = minDiameter;
        this.maxDiameter = maxDiameter;
        this.diameters = new short[numberOfCircles];
        this.preciseDiameters = new int[numberOfCircles];
        this.diameterGrowth = step <<= 8;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (width != this.lastWidth || height != this.lastHeight) {
            int min = Math.min(width, height);
            this.preciseMinDiameter = this.minDiameter.getValue(min) << 8;
            this.preciseMaxDiameter = this.maxDiameter.getValue(min) << 8;
            int numberOfCircles = this.diameters.length;
            int difference = (this.preciseMaxDiameter - this.preciseMinDiameter) / numberOfCircles;
            while (numberOfCircles > 0) {
                int diameter = difference * numberOfCircles;
                this.diameters[--numberOfCircles] = (short)(diameter >>> 8);
                this.preciseDiameters[numberOfCircles] = diameter;
            }
            this.startColor = this.firstColor;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        int centerX = x + (width >> 1);
        int centerY = y + (height >> 1);
        int color2 = this.startColor;
        for (int i = this.diameters.length - 1; i >= 0; --i) {
            short diameter = this.diameters[i];
            int offset = diameter >> 1;
            g.setColor(color2);
            g.fillArc(centerX - offset, centerY - offset, diameter, diameter, 0, 360);
            color2 = color2 == this.firstColor ? this.secondColor : this.firstColor;
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        int i = this.preciseDiameters.length - 1;
        int diameter = this.preciseDiameters[i] + this.diameterGrowth;
        if (diameter > this.preciseMaxDiameter) {
            while (i > 0) {
                this.preciseDiameters[i] = diameter = this.preciseDiameters[i - 1] + this.diameterGrowth;
                this.diameters[i] = (short)(diameter >>> 8);
                --i;
            }
            this.preciseDiameters[0] = this.preciseMinDiameter;
            this.diameters[0] = (short)(this.preciseMinDiameter >>> 8);
            this.startColor = this.startColor == this.firstColor ? this.secondColor : this.firstColor;
        } else {
            while (i >= 0) {
                this.preciseDiameters[i] = diameter = this.preciseDiameters[i] + this.diameterGrowth;
                this.diameters[i] = (short)(diameter >>> 8);
                --i;
            }
        }
        if (parent != null) {
            int w = parent.getBackgroundWidth();
            int h = parent.getBackgroundHeight();
            diameter = this.preciseMaxDiameter >>> 8;
            int x = w - diameter >> 1;
            int y = h - diameter >> 1;
            parent.addRelativeToBackgroundRegion(this, null, repaintRegion, x, y, diameter, diameter);
        } else {
            repaintRegion.addRegion(0, 0, screen.getWidth(), screen.getScreenHeight());
        }
    }

    public PulsatingCirclesBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.diameterGrowth = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.diameters = new short[n2];
            n = 0;
            while (n < n2) {
                this.diameters[n] = dataInputStream.readShort();
                ++n;
            }
        }
        this.firstColor = dataInputStream.readInt();
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
        this.maxDiameter = (Dimension)Serializer.deserialize(dataInputStream);
        this.minDiameter = (Dimension)Serializer.deserialize(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.preciseDiameters = new int[n2];
            n = 0;
            while (n < n2) {
                this.preciseDiameters[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.preciseMaxDiameter = dataInputStream.readInt();
        this.preciseMinDiameter = dataInputStream.readInt();
        this.secondColor = dataInputStream.readInt();
        this.startColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.diameterGrowth);
        if (this.diameters == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.diameters.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeShort(this.diameters[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.firstColor);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
        Serializer.serialize(this.maxDiameter, dataOutputStream);
        Serializer.serialize(this.minDiameter, dataOutputStream);
        if (this.preciseDiameters == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.preciseDiameters.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.preciseDiameters[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.preciseMaxDiameter);
        dataOutputStream.writeInt(this.preciseMinDiameter);
        dataOutputStream.writeInt(this.secondColor);
        dataOutputStream.writeInt(this.startColor);
    }
}

