/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PartialSimpleBackground
extends Background {
    private int color;
    private Dimension start;
    private Dimension end;

    public PartialSimpleBackground(int color2, int start, int end) {
        this(color2, new Dimension(start, true), new Dimension(end, true));
    }

    public PartialSimpleBackground(int color2, Dimension start, Dimension end) {
        this.color = color2;
        this.start = start;
        this.end = end;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int yStart = y + this.start.getValue(height);
        int h = this.end.getValue(height) - this.start.getValue(height);
        g.setColor(this.color);
        g.fillRect(x, yStart, width, h);
    }

    public PartialSimpleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.end = (Dimension)Serializer.deserialize(dataInputStream);
        this.start = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.end, dataOutputStream);
        Serializer.serialize(this.start, dataOutputStream);
    }
}

