/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class LayerBackground
extends Background {
    private Background[] layers;
    protected Dimension[] margins;

    public LayerBackground(Background[] layers) {
        this(layers, null);
    }

    public LayerBackground(Background[] layers, Dimension[] margins) {
        this.layers = layers;
        this.margins = margins;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int m = 0;
        Dimension[] mrgs = this.margins;
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            if (mrgs != null) {
                m = mrgs[i].getValue(width);
            }
            background.paint(x + m, y + m, width - m * 2, height - m * 2, g);
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.animate(screen, parent, currentTime, repaintRegion);
        }
    }

    public void showNotify() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.showNotify();
        }
    }

    public void hideNotify() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.hideNotify();
        }
    }

    public void releaseResources() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.releaseResources();
        }
    }

    public LayerBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.layers = new Background[n2];
            n = 0;
            while (n < n2) {
                this.layers[n] = (Background)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.margins = new Dimension[n2];
            n = 0;
            while (n < n2) {
                this.margins[n] = (Dimension)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        if (this.layers == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.layers.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.layers[n], dataOutputStream);
                ++n;
            }
        }
        if (this.margins == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.margins.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.margins[n], dataOutputStream);
                ++n;
            }
        }
    }
}

