/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalSplitRoundRectBackground
extends Background {
    private static final int SIDE_RIGHT = 1;
    private int leftColor;
    private int rightColor;
    private int splitPos;
    private boolean isPercent;
    private int arcWidth;
    private int arcHeight;
    private boolean isSplitRight;

    public HorizontalSplitRoundRectBackground(int leftColor, int rightColor, int splitPos, int splitSide, int arcWidth, int arcHeight) {
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
        this.isSplitRight = splitSide == 1;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = width * split / 100;
        }
        if (split == 0) {
            split = Math.min(width, height);
        }
        if (this.isSplitRight) {
            split = width - split;
        }
        g.setColor(this.leftColor);
        g.fillRoundRect(x, y, split + 1, height, this.arcWidth, this.arcHeight);
        g.fillRect(x + split - this.arcWidth, y, this.arcWidth, height);
        g.setColor(this.rightColor);
        g.fillRoundRect(x + split, y, width - split, height, this.arcWidth, this.arcHeight);
        g.fillRect(x + split, y, this.arcWidth, height);
    }

    public HorizontalSplitRoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.isSplitRight = dataInputStream.readBoolean();
        this.leftColor = dataInputStream.readInt();
        this.rightColor = dataInputStream.readInt();
        this.splitPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeBoolean(this.isSplitRight);
        dataOutputStream.writeInt(this.leftColor);
        dataOutputStream.writeInt(this.rightColor);
        dataOutputStream.writeInt(this.splitPos);
    }
}

