/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientHorizontalBackground
extends Background {
    private int leftColor;
    private int rightColor;
    private int stroke;
    private Dimension start;
    private Dimension end;
    private int[] gradient;
    private int lastWidth;
    private int startLine;
    private int endLine;

    public GradientHorizontalBackground(int leftColor, int rightColor, int stroke) {
        this(leftColor, rightColor, stroke, null, null);
    }

    public GradientHorizontalBackground(int leftColor, int rightColor, int stroke, int start, int end, boolean isPercent) {
        this(leftColor, rightColor, stroke, new Dimension(start, isPercent), new Dimension(end, isPercent));
    }

    public GradientHorizontalBackground(int leftColor, int rightColor, int stroke, Dimension start, Dimension end) {
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.stroke = stroke;
        if (start != null && end != null && start.getValue(100) != end.getValue(100)) {
            this.start = start;
            this.end = end;
        }
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setStrokeStyle(this.stroke);
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (this.gradient == null || this.lastWidth != width) {
            int steps = width;
            if (this.start != null) {
                this.startLine = this.start.getValue(width);
                this.endLine = this.end.getValue(width);
                steps = this.endLine - this.startLine;
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = width;
                endOffset = width;
            }
            this.gradient = DrawUtil.getGradient(this.leftColor, this.rightColor, steps);
            this.lastWidth = width;
        }
        g.setColor(this.leftColor);
        for (int i = 0; i < width; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color2 = this.gradient[i - startOffset];
                g.setColor(color2);
            }
            g.drawLine(x, y, x, y + height);
            ++x;
        }
        g.setStrokeStyle(0);
    }

    public GradientHorizontalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.end = (Dimension)Serializer.deserialize(dataInputStream);
        this.endLine = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.gradient = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gradient[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.lastWidth = dataInputStream.readInt();
        this.leftColor = dataInputStream.readInt();
        this.rightColor = dataInputStream.readInt();
        this.start = (Dimension)Serializer.deserialize(dataInputStream);
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.end, dataOutputStream);
        dataOutputStream.writeInt(this.endLine);
        if (this.gradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.gradient.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.gradient[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.leftColor);
        dataOutputStream.writeInt(this.rightColor);
        Serializer.serialize(this.start, dataOutputStream);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
    }
}

