/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class DoubleGradientVerticalBackground
extends Background {
    private int firstTopColor;
    private int firstBottomColor;
    private int secondTopColor;
    private int secondBottomColor;
    private int stroke;
    private int start;
    private int end;
    private boolean isPercent;
    private int[] firstGradient;
    private int[] secondGradient;
    private int lastHeight;
    private int startLine;
    private int endLine;

    public DoubleGradientVerticalBackground(int firstTopColor, int firstBottomColor, int secondTopColor, int secondBottomColor, int stroke) {
        this(firstTopColor, firstBottomColor, secondTopColor, secondBottomColor, stroke, 0, 0, false);
    }

    public DoubleGradientVerticalBackground(int firstTopColor, int firstBottomColor, int secondTopColor, int secondBottomColor, int stroke, int start, int end, boolean isPercent) {
        this.firstTopColor = firstTopColor;
        this.firstBottomColor = firstBottomColor;
        this.secondTopColor = secondTopColor;
        this.secondBottomColor = secondBottomColor;
        this.stroke = stroke;
        this.start = start;
        this.end = end;
        this.isPercent = isPercent;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setStrokeStyle(this.stroke);
        this.paintGradient(this.firstGradient, x, y, width, height / 2, this.firstTopColor, this.firstBottomColor, g);
        this.paintGradient(this.secondGradient, x, y + height / 2, width, height / 2, this.secondTopColor, this.secondBottomColor, g);
        g.setStrokeStyle(0);
    }

    private void paintGradient(int[] gradient, int x, int y, int width, int height, int topColor, int bottomColor, Graphics g) {
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (gradient == null || this.lastHeight != height) {
            int steps = height;
            if (this.start != this.end) {
                steps = this.end - this.start;
                if (this.isPercent) {
                    this.startLine = this.start * height / 100;
                    this.endLine = this.end * height / 100;
                    steps = this.endLine - this.startLine;
                } else {
                    this.startLine = this.start;
                    this.endLine = this.end;
                }
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = height;
                endOffset = height;
            }
            gradient = DrawUtil.getGradient(topColor, bottomColor, steps);
            this.lastHeight = height;
        }
        g.setColor(topColor);
        for (int i = 0; i < height; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color2 = gradient[i - startOffset];
                g.setColor(color2);
            }
            g.drawLine(x, y, x + width, y);
            ++y;
        }
    }

    public DoubleGradientVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.end = dataInputStream.readInt();
        this.endLine = dataInputStream.readInt();
        this.firstBottomColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.firstGradient = new int[n2];
            n = 0;
            while (n < n2) {
                this.firstGradient[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.firstTopColor = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.lastHeight = dataInputStream.readInt();
        this.secondBottomColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.secondGradient = new int[n2];
            n = 0;
            while (n < n2) {
                this.secondGradient[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.secondTopColor = dataInputStream.readInt();
        this.start = dataInputStream.readInt();
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.end);
        dataOutputStream.writeInt(this.endLine);
        dataOutputStream.writeInt(this.firstBottomColor);
        if (this.firstGradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.firstGradient.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.firstGradient[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.firstTopColor);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.secondBottomColor);
        if (this.secondGradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.secondGradient.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.secondGradient[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.secondTopColor);
        dataOutputStream.writeInt(this.start);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
    }
}

