/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CombinedVerticalBackground
extends Background {
    private static final int SIDE_BOTTOM = 1;
    private Background topBackground;
    private Background bottomBackground;
    private int splitPos;
    private boolean isPercent;
    private boolean isSplitRight;
    private int margin;

    public CombinedVerticalBackground(Background leftBackground, Background rightBackground, int splitPos, int splitSide, int margin) {
        this.topBackground = leftBackground;
        this.bottomBackground = rightBackground;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
        this.isSplitRight = splitSide == 1;
        this.margin = margin;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = height * split / 100;
        }
        if (split == 0) {
            split = Math.min(width, height);
        }
        if (this.isSplitRight) {
            split = height - split;
        }
        int m = this.margin >> 1;
        this.topBackground.paint(x, y, width, split - m, g);
        this.bottomBackground.paint(x, y + split + m, width, height - (split + m), g);
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        this.topBackground.animate(screen, parent, currentTime, repaintRegion);
        this.bottomBackground.animate(screen, parent, currentTime, repaintRegion);
    }

    public void showNotify() {
        this.topBackground.showNotify();
        this.bottomBackground.showNotify();
    }

    public void hideNotify() {
        this.topBackground.hideNotify();
        this.bottomBackground.hideNotify();
    }

    public void releaseResources() {
        this.topBackground.releaseResources();
        this.bottomBackground.releaseResources();
    }

    public CombinedVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomBackground = (Background)Serializer.deserialize(dataInputStream);
        this.isPercent = dataInputStream.readBoolean();
        this.isSplitRight = dataInputStream.readBoolean();
        this.margin = dataInputStream.readInt();
        this.splitPos = dataInputStream.readInt();
        this.topBackground = (Background)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.bottomBackground, dataOutputStream);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeBoolean(this.isSplitRight);
        dataOutputStream.writeInt(this.margin);
        dataOutputStream.writeInt(this.splitPos);
        Serializer.serialize(this.topBackground, dataOutputStream);
    }
}

