/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CombinedHorizontalBackground
extends Background {
    private static final int SIDE_RIGHT = 1;
    private Background leftBackground;
    private Background rightBackground;
    private int splitPos;
    private boolean isPercent;
    private boolean isSplitRight;
    private int margin;

    public CombinedHorizontalBackground(Background leftBackground, Background rightBackground, int splitPos, int splitSide, int margin) {
        this.leftBackground = leftBackground;
        this.rightBackground = rightBackground;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
        this.isSplitRight = splitSide == 1;
        this.margin = margin;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = width * split / 100;
        }
        if (split == 0) {
            split = Math.min(width, height);
        }
        if (this.isSplitRight) {
            split = width - split;
        }
        int m = this.margin >> 1;
        this.leftBackground.paint(x, y, split - m, height, g);
        this.rightBackground.paint(x + split + m, y, width - (split + m), height, g);
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        this.leftBackground.animate(screen, parent, currentTime, repaintRegion);
        this.rightBackground.animate(screen, parent, currentTime, repaintRegion);
    }

    public void showNotify() {
        this.leftBackground.showNotify();
        this.rightBackground.showNotify();
    }

    public void hideNotify() {
        this.leftBackground.hideNotify();
        this.rightBackground.hideNotify();
    }

    public void releaseResources() {
        this.leftBackground.releaseResources();
        this.rightBackground.releaseResources();
    }

    public CombinedHorizontalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isPercent = dataInputStream.readBoolean();
        this.isSplitRight = dataInputStream.readBoolean();
        this.leftBackground = (Background)Serializer.deserialize(dataInputStream);
        this.margin = dataInputStream.readInt();
        this.rightBackground = (Background)Serializer.deserialize(dataInputStream);
        this.splitPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeBoolean(this.isSplitRight);
        Serializer.serialize(this.leftBackground, dataOutputStream);
        dataOutputStream.writeInt(this.margin);
        Serializer.serialize(this.rightBackground, dataOutputStream);
        dataOutputStream.writeInt(this.splitPos);
    }
}

