/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.backgrounds.VideoBackground;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AnimatedGifBackground
extends VideoBackground {
    private byte[] data;

    public AnimatedGifBackground(int color2, String url, int loopCount, int anchor, int xOffset, int yOffset) {
        super(color2, url, "image/gif", loopCount, anchor, xOffset, yOffset);
    }

    public AnimatedGifBackground(int color2, byte[] data, int loopCount, int anchor, int xOffset, int yOffset) {
        super(color2, null, "image/gif", loopCount, anchor, xOffset, yOffset);
        this.data = data;
    }

    protected InputStream openInputStream() {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return super.openInputStream();
    }

    public AnimatedGifBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.data = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                this.data[n2] = dataInputStream.readByte();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.data == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.data.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeByte(this.data[n2]);
                ++n2;
            }
        }
    }
}

