/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ticker
extends IconItem {
    public static final int DIRECTION_RIGHT_TO_LEFT = 0;
    public static final int DIRECTION_LEFT_TO_RIGHT = 1;
    private int tickerXOffset = Integer.MIN_VALUE;
    private int step = 2;
    private int tickerWidth;
    private int direction;

    public Ticker(String str) {
        this(str, (Style)null);
    }

    public Ticker(String str, Style style) {
        super((String)null, (Image)null, style);
        this.setString(str);
        this.setAppearanceMode(0);
    }

    public void setString(String text) {
        if (text != null) {
            text = text.replace('\n', ' ');
        }
        super.setText(text);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(Integer.MAX_VALUE, Integer.MAX_VALUE, availHeight);
        this.tickerWidth = this.contentWidth;
        this.contentWidth = availWidth;
        if (this.tickerXOffset == Integer.MIN_VALUE) {
            this.tickerXOffset = this.direction == 1 ? this.tickerWidth : -availWidth;
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipHeight = g.getClipHeight();
        int clipWidth = g.getClipWidth();
        int width = rightBorder - leftBorder;
        g.clipRect(x, clipY, width, clipHeight);
        super.paintContent(x -= this.tickerXOffset, y, leftBorder, rightBorder, g);
        if (this.direction == 0 && x < leftBorder && x + this.tickerWidth + this.paddingHorizontal < rightBorder) {
            x = this.tickerWidth > width ? (x += this.tickerWidth + this.paddingHorizontal) : rightBorder + (x - leftBorder);
            super.paintContent(x, y, leftBorder, rightBorder, g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected String createCssSelector() {
        return "ticker";
    }

    public void setStyle(Style style, boolean resetStyle) {
        Integer stepInt;
        super.setStyle(style, resetStyle);
        if (resetStyle) {
            this.font = style.getFont();
            this.textColor = style.getFontColor();
        }
        if ((stepInt = style.getIntProperty(35)) != null) {
            this.step = stepInt;
        }
    }

    public boolean animate() {
        if (this.tickerWidth == 0) {
            return false;
        }
        this.tickerXOffset = this.direction == 0 ? (this.tickerXOffset < this.tickerWidth ? (this.tickerXOffset += this.step) : (this.tickerWidth > this.contentWidth ? (this.tickerXOffset -= this.tickerWidth + this.paddingHorizontal - this.step) : this.tickerXOffset - this.contentWidth + this.step)) : (this.tickerXOffset > -this.contentWidth ? (this.tickerXOffset -= this.step) : this.tickerWidth);
        return true;
    }

    protected void hideNotify() {
        super.hideNotify();
        AnimationThread.removeAnimationItem(this);
    }

    protected void showNotify() {
        super.showNotify();
        AnimationThread.addAnimationItem(this);
    }
}

