/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.TextUtil;
import de.enough.polish.util.WrappedText;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class TextEffect
implements Externalizable {
    protected transient Style style;
    protected boolean isTextSensitive;

    public void setStyle(Style style) {
        this.style = style;
        this.setStyle(style, false);
    }

    public void onAttach(Item parent) {
    }

    public void onDetach(Item parent) {
    }

    public void setStyle(Style style, boolean resetStyle) {
    }

    public boolean animate() {
        return false;
    }

    public void animate(Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            parent.addRelativeToContentRegion(repaintRegion, 0, 0, parent.contentWidth, parent.contentHeight);
        }
    }

    public void drawStrings(Item parent, WrappedText textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        this.drawStrings(textLines, textColor, x, y, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
    }

    public void drawStrings(WrappedText textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        boolean isLayoutRight = false;
        boolean isLayoutCenter = false;
        int centerX = 0;
        if ((layout & 3) == 3) {
            isLayoutCenter = true;
            centerX = leftBorder + (rightBorder - leftBorder) / 2;
        } else if ((layout & 2) == 2) {
            isLayoutRight = true;
        }
        Object[] lineObjects = textLines.getLinesInternalArray();
        int size = textLines.size();
        for (int i = 0; i < size; ++i) {
            String line = (String)lineObjects[i];
            int lineX = x;
            int lineY = y;
            int anchor = 0;
            if (isLayoutRight) {
                lineX = rightBorder;
                anchor = 24;
            } else if (isLayoutCenter) {
                lineX = centerX;
                anchor = 17;
            } else {
                anchor = 20;
            }
            this.drawString(line, textColor, lineX, lineY, anchor, g);
            x = leftBorder;
            y += lineHeight;
        }
    }

    public abstract void drawString(String var1, int var2, int var3, int var4, int var5, Graphics var6);

    public int getLeftX(int x, int anchor, int textWidth) {
        if ((anchor & 4) == 4) {
            return x;
        }
        if ((anchor & 8) == 8) {
            return x - textWidth;
        }
        return x - textWidth / 2;
    }

    public int getTopY(int y, int anchor, Font font) {
        return this.getTopY(y, anchor, font.getHeight(), font.getBaselinePosition());
    }

    public int getTopY(int y, int anchor, int height, int baseLine) {
        if ((anchor & 0x10) == 16) {
            return y;
        }
        if ((anchor & 0x20) == 32) {
            return y - height;
        }
        return y - (height - baseLine);
    }

    public static int[] getRgbData(String text, int textColor, Font font) {
        int transparentColor = DrawUtil.getComplementaryColor(textColor);
        if (transparentColor == textColor) {
            transparentColor = 0;
        }
        int width = font.stringWidth(text);
        int height = font.getHeight();
        return TextEffect.getRgbData(text, textColor, font, 0, 0, width, height, transparentColor);
    }

    public static int[] getRgbData(String text, int textColor, Font font, int x, int y, int width, int height) {
        int transparentColor = DrawUtil.getComplementaryColor(textColor);
        if (transparentColor == textColor) {
            transparentColor = 0;
        }
        return TextEffect.getRgbData(text, textColor, font, x, y, width, height, transparentColor);
    }

    public static int[] getRgbData(String text, int textColor, Font font, int x, int y, int width, int height, int transparentColor) {
        Image midp2ImageBuffer = Image.createImage(width, height);
        Graphics bufferG = midp2ImageBuffer.getGraphics();
        bufferG.setColor(transparentColor);
        bufferG.fillRect(0, 0, width, height);
        bufferG.setFont(font);
        bufferG.setColor(textColor);
        bufferG.drawString(text, x, y, 20);
        int[] rgbData = new int[width * height];
        midp2ImageBuffer.getRGB(rgbData, 0, width, 0, 0, width, height);
        int[] clearColorArray = new int[1];
        midp2ImageBuffer.getRGB(clearColorArray, 0, 1, 0, 0, 1, 1);
        transparentColor = clearColorArray[0];
        for (int i = 0; i < rgbData.length; ++i) {
            if (rgbData[i] != transparentColor) continue;
            rgbData[i] = 0;
        }
        return rgbData;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void releaseResources() {
    }

    public int stringWidth(String str) {
        return this.getFont().stringWidth(str);
    }

    public int charWidth(char c) {
        return this.getFont().charWidth(c);
    }

    public int getFontHeight() {
        return this.getFont().getHeight();
    }

    protected Font getFont() {
        if (this.style != null && this.style.getFont() != null) {
            return this.style.getFont();
        }
        return Font.getDefaultFont();
    }

    public void wrap(StringItem parent, String text, int textColor, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText wrappedText) {
        TextUtil.wrap(text, font, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedText);
    }

    public void drawChar(char c, int x, int y, int anchor, Graphics g) {
        g.drawChar(c, x, y, anchor);
    }

    public int calculateLinesHeight(WrappedText lines, int lineHeight, int paddingVertical) {
        return lines.size() * lineHeight - paddingVertical;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.isTextSensitive = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.isTextSensitive);
    }
}

