/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.TableData;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TableItem
extends Container {
    public static final int SELECTION_MODE_NONE = 0;
    public static final int SELECTION_MODE_CELL = 2;
    public static final int SELECTION_MODE_NONEMPTY = 4;
    public static final int SELECTION_MODE_INTERACTIVE = 8;
    public static final int SELECTION_MODE_ROW = 16;
    public static final int SELECTION_MODE_COLUMN = 32;
    public static final int LINE_STYLE_SOLID = 0;
    public static final int LINE_STYLE_DOTTED = 1;
    public static final int LINE_STYLE_INVISIBLE = 2;
    protected TableData tableData;
    protected Font font;
    protected int fontColor;
    protected int[] rowHeights;
    protected int[] columnWidths;
    protected int lineStroke;
    protected int lineColor = -1;
    protected int completeWidth;
    protected int xOffset;
    protected int targetXOffset;
    protected int selectionMode = 0;
    protected Background selectedBackground;
    protected Background selectedRowBackground;
    protected Background selectedColumnBackground;
    private int selectedRowIndex = -1;
    private int selectedColumnIndex = -1;
    private int currentColumnIndex = -1;
    private int currentRowIndex = -1;
    private Style cellContainerStyle;
    private final Object paintLock = new Object();
    private boolean focusedItemHandledKeyEvent;
    private boolean focusedItemHandledPointerEvent;
    private int pointerEventX;

    public TableItem() {
        this(null, null);
    }

    public TableItem(Style style) {
        this(null, null);
    }

    public TableItem(int columns, int rows) {
        this(columns, rows, null);
    }

    public TableItem(int columns, int rows, Style style) {
        this(new TableData(columns, rows), style);
    }

    public TableItem(TableData tableData) {
        this(tableData, null);
    }

    public TableItem(TableData tableData, Style style) {
        super(false, style);
        this.tableData = tableData;
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
        this.requestInit();
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.font = style.getFont();
        this.fontColor = style.getFontColor();
        if (this.lineColor == -1) {
            this.lineColor = this.fontColor;
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void setLineStyle(int lineStroke, int lineColor) {
        this.lineStroke = lineStroke;
        this.lineColor = lineColor;
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        int height;
        int width;
        int col;
        if (availWidth == 0) {
            return;
        }
        if (this.tableData == null) {
            this.contentWidth = 0;
            this.contentHeight = 0;
            return;
        }
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
        int numberOfColumns = this.tableData.getNumberOfColumns();
        int[] widths = new int[numberOfColumns];
        int numberOfRows = this.tableData.getNumberOfRows();
        int[] heights = new int[numberOfRows];
        int textHeight = this.font.getHeight();
        int availRowHeight = availHeight;
        for (col = 0; col < numberOfColumns; ++col) {
            for (int row = 0; row < numberOfRows; ++row) {
                Object data = this.tableData.get(col, row);
                if (data == null) continue;
                Item item = null;
                boolean columnSpan = true;
                boolean rowingSpan = true;
                if (data instanceof Item) {
                    item = (Item)data;
                    boolean isExpand = false;
                    if (item.isLayoutExpand) {
                        item.isLayoutExpand = false;
                        isExpand = true;
                    }
                    width = item.getItemWidth(availWidth, availWidth, availRowHeight);
                    height = item.getItemHeight(availWidth, availWidth, availRowHeight);
                    if (isExpand) {
                        item.isLayoutExpand = true;
                    }
                } else {
                    width = this.font.stringWidth(data.toString());
                    height = textHeight;
                }
                if (this.lineStroke != 2) {
                    width += (this.paddingHorizontal << 1) + 1;
                    height += (this.paddingVertical << 1) + 1;
                } else {
                    width += this.paddingHorizontal << 1;
                    height += this.paddingVertical << 1;
                }
                if (width > widths[col] && columnSpan) {
                    widths[col] = width;
                }
                if (height <= heights[row] || !rowingSpan) continue;
                heights[row] = height;
            }
        }
        height = 0;
        width = 0;
        for (col = 0; col < numberOfColumns; ++col) {
            height = 0;
            int colWidth = widths[col] - this.paddingHorizontal;
            for (int row = 0; row < numberOfRows; ++row) {
                int currentRowHeight = heights[row];
                Object data = this.tableData.get(col, row);
                if (data instanceof Item) {
                    Item item = (Item)data;
                    item.relativeX = width;
                    if (item.isLayoutExpand) {
                        int w = colWidth - this.paddingHorizontal;
                        if (this.lineStroke != 2) {
                            --w;
                        }
                        item.setItemWidth(w);
                    }
                    if (item.itemWidth < colWidth) {
                        if (item.isLayoutCenter) {
                            item.relativeX += (colWidth - item.itemWidth) / 2;
                        } else if (item.isLayoutRight) {
                            item.relativeX += colWidth - item.itemWidth;
                        }
                    }
                    item.relativeY = height;
                    if (item.itemHeight < currentRowHeight) {
                        if ((item.layout & 0x30) == 48) {
                            item.relativeY += (currentRowHeight - item.itemHeight) / 2;
                        } else if ((item.layout & 0x20) == 32) {
                            item.relativeY += currentRowHeight - item.itemHeight;
                        }
                    }
                }
                height += currentRowHeight;
            }
            width += colWidth + this.paddingHorizontal;
        }
        this.completeWidth = width;
        this.contentWidth = width;
        this.contentHeight = height - this.paddingVertical;
        this.columnWidths = widths;
        this.rowHeights = heights;
        if (this.completeWidth > availWidth) {
            this.appearanceMode = 3;
            this.contentWidth = availWidth;
        }
        this.updateInternalArea();
    }

    protected int getChildWidth(Item item) {
        boolean isExpand = false;
        int previousWidth = 0;
        if (item.isLayoutExpand) {
            item.isLayoutExpand = false;
            isExpand = true;
            previousWidth = item.itemWidth;
        }
        int width = item.getItemWidth(item.availableWidth, item.availableWidth, item.availableHeight);
        if (isExpand) {
            item.isLayoutExpand = true;
            width = previousWidth;
            item.setItemWidth(width);
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Object object = this.paintLock;
        synchronized (object) {
            if (this.tableData == null) {
                return;
            }
            int clipX = 0;
            int clipY = 0;
            int clipWidth = 0;
            int clipHeight = 0;
            if (this.completeWidth > rightBorder - leftBorder) {
                clipX = g.getClipX();
                clipY = g.getClipY();
                clipWidth = g.getClipWidth();
                clipHeight = g.getClipHeight();
                g.clipRect(x, clipY, rightBorder - leftBorder, clipHeight);
            }
            int numberOfColumns = this.tableData.getNumberOfColumns();
            int numberOfRows = this.tableData.getNumberOfRows();
            int[] widths = this.columnWidths;
            int[] heights = this.rowHeights;
            if (numberOfColumns != widths.length || numberOfRows != heights.length) {
                return;
            }
            int height = 0;
            int width = 0;
            x += this.xOffset;
            boolean paintSelection = this.isFocused;
            if (!paintSelection || this.selectedBackground == null || (this.selectionMode & 2) != 2) {
                paintSelection = false;
            }
            boolean horizontalLinesPainted = false;
            Item focItem = this.focusedItem;
            for (int col = 0; col < numberOfColumns; ++col) {
                height = 0;
                for (int row = 0; row < numberOfRows; ++row) {
                    int nextHeight = height + heights[row];
                    if (!horizontalLinesPainted && this.lineStroke != 2 && row != numberOfRows - 1) {
                        g.setColor(this.lineColor);
                        if (this.lineStroke == 1) {
                            g.setStrokeStyle(1);
                            g.drawLine(x, y + nextHeight - this.paddingVertical, x + this.completeWidth, y + nextHeight - this.paddingVertical);
                            g.setStrokeStyle(0);
                        } else {
                            g.drawLine(x, y + nextHeight - this.paddingVertical, x + this.completeWidth, y + nextHeight - this.paddingVertical);
                        }
                    }
                    Object data = this.tableData.get(col, row);
                    if (paintSelection && col == this.selectedColumnIndex && row == this.selectedRowIndex) {
                        this.selectedBackground.paint(x + this.internalX, y + this.internalY, this.internalWidth, this.internalHeight, g);
                    }
                    if (data instanceof Item) {
                        Item item = (Item)data;
                        if (item != focItem) {
                            item.paint(x + item.relativeX, y + item.relativeY, x + item.relativeX, x + item.relativeX + item.itemWidth, g);
                        }
                    } else if (data != null) {
                        g.setColor(this.fontColor);
                        g.setFont(this.font);
                        g.drawString(data.toString(), x + width, y + height, 20);
                    }
                    height = nextHeight;
                }
                horizontalLinesPainted = true;
                width += widths[col];
                if (this.lineStroke == 2 || col == numberOfColumns - 1) continue;
                g.setColor(this.lineColor);
                if (this.lineStroke == 1) {
                    g.setStrokeStyle(1);
                    g.drawLine(x + width - this.paddingHorizontal, y, x + width - this.paddingHorizontal, y + this.contentHeight);
                    g.setStrokeStyle(0);
                    continue;
                }
                g.drawLine(x + width - this.paddingHorizontal, y, x + width - this.paddingHorizontal, y + this.contentHeight);
            }
            if (focItem != null) {
                focItem.paint(x + focItem.relativeX, y + focItem.relativeY, x + focItem.relativeX, x + focItem.relativeX + focItem.itemWidth, g);
            }
            if (this.completeWidth > rightBorder - leftBorder) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
    }

    protected void paintBackground(int x, int y, int width, int height, Graphics g) {
        super.paintBackground(x, y, width, height, g);
        if (this.isFocused) {
            if ((this.selectionMode & 0x10) == 16 && this.selectedRowIndex != -1 && this.selectedRowBackground != null) {
                this.selectedRowBackground.paint(x, y + this.internalY + this.paddingTop, width, this.internalHeight, g);
            }
            if ((this.selectionMode & 0x20) == 32 && this.selectedColumnIndex != -1 && this.selectedColumnBackground != null) {
                int bgX = x + this.xOffset + this.internalX;
                int bgW = this.internalWidth;
                if (bgX < x) {
                    bgW -= x - bgX;
                    bgX = x;
                }
                if (bgX + bgW > x + width) {
                    bgW = x + width - bgX;
                }
                if (bgW > 0) {
                    this.selectedRowBackground.paint(bgX, y + this.paddingTop, bgW, this.contentHeight - (this.paddingTop + this.paddingBottom), g);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        int current = this.xOffset;
        int target = this.targetXOffset;
        if (target != current) {
            int speed = (target - current) / 3;
            if (speed > 0 && (current += (speed += target > current ? 1 : -1)) > target || speed < 0 && current < target) {
                current = target;
            }
            this.xOffset = current;
            this.addRelativeToContentRegion(repaintRegion, -1, -1, this.completeWidth + 2, this.contentHeight + 2);
        }
        Object object = this.paintLock;
        synchronized (object) {
            Object data;
            int sCol = this.selectedColumnIndex;
            int sRow = this.selectedRowIndex;
            if (sCol != -1 && sRow != -1 && this.tableData != null && (data = this.tableData.get(sCol, sRow)) instanceof Item) {
                ((Item)data).animate(currentTime, repaintRegion);
            }
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        Item item = this.focusedItem;
        if (item != null) {
            if (item.handleKeyPressed(keyCode, gameAction)) {
                this.focusedItemHandledKeyEvent = true;
                this.updateInternalArea();
                return true;
            }
            this.focusedItemHandledKeyEvent = false;
        }
        if (this.appearanceMode != 0) {
            int offset;
            if (this.selectionMode != 0) {
                Object cell;
                boolean selectInteractive = (this.selectionMode & 8) == 8;
                boolean selectNotempty = (this.selectionMode & 4) == 4;
                boolean selectCell = (this.selectionMode & 2) == 2;
                boolean selectRow = (this.selectionMode & 0x10) == 16;
                boolean selectColumn = (this.selectionMode & 0x20) == 32;
                if ((gameAction == 5 && keyCode != 54) | (gameAction == 2 && keyCode != 52) && (selectCell || selectColumn)) {
                    int addCol;
                    int endCol;
                    int startCol;
                    if (gameAction == 5) {
                        startCol = this.selectedColumnIndex + 1;
                        endCol = this.getNumberOfColumns();
                        addCol = 1;
                    } else {
                        startCol = this.selectedColumnIndex - 1;
                        endCol = -1;
                        addCol = -1;
                    }
                    for (int col = startCol; col != endCol; col += addCol) {
                        if (selectCell) {
                            Object cell2 = this.get(col, this.selectedRowIndex);
                            if (selectInteractive) {
                                if (!(cell2 instanceof Item) || ((Item)cell2).appearanceMode == 0) continue;
                                this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                                return true;
                            }
                            if (selectNotempty) {
                                if (cell2 == null) continue;
                                this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                                return true;
                            }
                            this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                            return true;
                        }
                        for (int row = 0; row < this.getNumberOfRows(); ++row) {
                            cell = this.get(col, row);
                            if (selectInteractive) {
                                if (!(cell instanceof Item) || ((Item)cell).appearanceMode == 0) continue;
                                this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                                return true;
                            }
                            if (selectNotempty) {
                                if (cell == null) continue;
                                this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                                return true;
                            }
                            this.setSelectedCell(col, this.selectedRowIndex, gameAction);
                            return true;
                        }
                    }
                }
                if ((gameAction == 6 && keyCode != 56 || gameAction == 1 && keyCode != 50) && (selectCell || selectRow)) {
                    int addRow;
                    int endRow;
                    int startRow;
                    if (gameAction == 6) {
                        startRow = this.selectedRowIndex + 1;
                        endRow = this.getNumberOfRows();
                        addRow = 1;
                    } else {
                        startRow = this.selectedRowIndex - 1;
                        endRow = -1;
                        addRow = -1;
                        if (startRow < 0) {
                            return false;
                        }
                    }
                    for (int row = startRow; row != endRow; row += addRow) {
                        if (selectCell) {
                            Object cell3 = this.get(this.selectedColumnIndex, row);
                            if (selectInteractive) {
                                if (!(cell3 instanceof Item) || ((Item)cell3).appearanceMode == 0) continue;
                                this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                                return true;
                            }
                            if (selectNotempty) {
                                if (cell3 == null) continue;
                                this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                                return true;
                            }
                            this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                            return true;
                        }
                        for (int col = 0; col < this.getNumberOfColumns(); ++col) {
                            cell = this.get(col, row);
                            if (selectInteractive) {
                                if (!(cell instanceof Item) || ((Item)cell).appearanceMode == 0) continue;
                                this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                                return true;
                            }
                            if (selectNotempty) {
                                if (cell == null) continue;
                                this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                                return true;
                            }
                            this.setSelectedCell(this.selectedColumnIndex, row, gameAction);
                            return true;
                        }
                    }
                }
            }
            if (gameAction == 5 && this.xOffset + this.completeWidth > this.contentWidth) {
                offset = this.targetXOffset - (this.contentWidth >> 1);
                if (offset + this.completeWidth < this.contentWidth) {
                    offset = this.contentWidth - this.completeWidth;
                }
                this.targetXOffset = offset;
                return true;
            }
            if (gameAction == 2 && this.xOffset < 0) {
                offset = this.targetXOffset + (this.contentWidth >> 1);
                if (offset > 0) {
                    offset = 0;
                }
                this.targetXOffset = offset;
                return true;
            }
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        Item item = this.focusedItem;
        if (item != null && this.focusedItemHandledKeyEvent && item.handleKeyReleased(keyCode, gameAction)) {
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        Item item = this.focusedItem;
        if (item != null && this.focusedItemHandledKeyEvent && item.handleKeyRepeated(keyCode, gameAction)) {
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        int row;
        int col;
        this.pointerEventX = relX;
        Item item = this.focusedItem;
        if (item != null) {
            if (item.handlePointerPressed(relX - this.xOffset - this.contentX - item.relativeX, relY - this.yOffset - this.contentY - item.relativeY)) {
                this.focusedItemHandledPointerEvent = true;
                return true;
            }
            this.focusedItemHandledPointerEvent = false;
        }
        if (this.appearanceMode != 0 && this.selectionMode != 0 && (col = this.getColumnIndex(relX)) != -1 && (row = this.getRowIndex(relY)) != -1) {
            if ((this.selectionMode & 8) == 8) {
                Object data = this.tableData.get(col, row);
                if (data != null && data instanceof Item && ((Item)data).appearanceMode != 0) {
                    this.setSelectedCell(col, row);
                    return true;
                }
            } else if ((this.selectionMode & 4) == 4) {
                Object data = this.tableData.get(col, row);
                if (data != null) {
                    this.setSelectedCell(col, row);
                    return true;
                }
            } else {
                this.setSelectedCell(col, row);
                return true;
            }
        }
        return super.handlePointerPressed(relX, relY);
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        Item item = this.focusedItem;
        if (item != null && this.focusedItemHandledPointerEvent && item.handlePointerReleased(relX - this.xOffset - this.contentX - item.relativeX, relY - this.yOffset - this.contentY - item.relativeY)) {
            return true;
        }
        int diff = relX - this.pointerEventX;
        if (diff > 5 || diff < -5) {
            if ((diff += this.targetXOffset) > 0) {
                diff = 0;
            } else if (diff + this.completeWidth < this.contentWidth) {
                diff = this.contentWidth - this.completeWidth;
            }
            this.targetXOffset = diff;
            return true;
        }
        return super.handlePointerReleased(relX, relY);
    }

    protected boolean handlePointerDragged(int relX, int relY, ClippingRegion repaintRegion) {
        Item item = this.focusedItem;
        if (item != null && this.focusedItemHandledPointerEvent && item.handlePointerDragged(relX - this.xOffset - this.contentX - item.relativeX, relY - this.yOffset - this.contentY - item.relativeY, repaintRegion)) {
            return true;
        }
        int diff = relX - this.pointerEventX;
        if (diff > 5 || diff < -5) {
            if ((diff += this.targetXOffset) > 0) {
                diff = 0;
            } else if (diff + this.completeWidth < this.contentWidth) {
                diff = this.contentWidth - this.completeWidth;
            }
            this.pointerEventX = relX;
            this.targetXOffset = diff;
            this.xOffset = diff;
            this.addRepaintArea(repaintRegion);
            return true;
        }
        return super.handlePointerDragged(relX, relY, repaintRegion);
    }

    public boolean contains(Item item) {
        int size = this.tableData.size();
        for (int i = 0; i < size; ++i) {
            Object data = this.tableData.get(i);
            if (data != item) continue;
            return true;
        }
        return false;
    }

    protected int getColumnIndex(int relX) {
        if (this.columnWidths == null) {
            return -1;
        }
        relX -= this.xOffset;
        relX -= this.contentX;
        int w = 0;
        for (int col = 0; col < this.columnWidths.length; ++col) {
            int cw = this.columnWidths[col];
            if (relX >= w && relX <= w + cw) {
                return col;
            }
            w += cw;
        }
        return -1;
    }

    protected int getRowIndex(int relY) {
        if (this.rowHeights == null) {
            return -1;
        }
        relY -= this.yOffset;
        relY -= this.contentY;
        int h = 0;
        for (int row = 0; row < this.rowHeights.length; ++row) {
            int rh = this.rowHeights[row];
            if (relY >= h && relY <= h + rh) {
                return row;
            }
            h += rh;
        }
        return -1;
    }

    protected int getColumnIndex(Object obj) {
        return this.tableData.getColumnIndex(obj);
    }

    protected int getRowIndex(Object obj) {
        return this.tableData.getRowIndex(obj);
    }

    public int getItemAreaHeight() {
        int max = super.getItemAreaHeight();
        Item item = this.focusedItem;
        if (item != null) {
            max = Math.max(max, item.relativeY + item.getItemAreaHeight());
        }
        return max;
    }

    public Item getItemAt(int relX, int relY) {
        Object data;
        int row;
        int col = this.getColumnIndex(relX);
        if (col != -1 && (row = this.getRowIndex(relY)) != -1 && (data = this.tableData.get(col, row)) instanceof Item) {
            return (Item)data;
        }
        return super.getItemAt(relX, relY);
    }

    public void setSelectedCell(int col, int row) {
        this.setSelectedCell(col, row, 0);
    }

    public void setSelectedCell(int col, int row, int direction) {
        if ((this.selectionMode & 2) == 2) {
            Item focItem = this.focusedItem;
            Object data = null;
            if (col >= 0 && row >= 0) {
                data = this.get(col, row);
            }
            if (focItem == data && data != null) {
                this.selectedColumnIndex = col;
                this.selectedRowIndex = row;
                return;
            }
            if (this.itemStyle != null && focItem != null) {
                focItem.defocus(this.itemStyle);
                if (this.isInitialized) {
                    int wBefore = focItem.itemWidth;
                    int hBefore = focItem.itemHeight;
                    int layoutBefore = focItem.layout;
                    int wAfter = this.getChildWidth(focItem);
                    int hAfter = focItem.itemHeight;
                    int layoutAfter = focItem.layout;
                    if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                        this.setInitialized(false);
                    }
                }
            }
            if (data instanceof Item) {
                Item item = (Item)data;
                int wBefore = item.itemWidth;
                int hBefore = item.itemHeight;
                int layoutBefore = item.layout;
                this.itemStyle = item.focus(null, direction);
                this.focusedItem = item;
                if (this.isInitialized) {
                    int wAfter = this.getChildWidth(item);
                    int hAfter = item.itemHeight;
                    int layoutAfter = item.layout;
                    if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                        this.setInitialized(false);
                    }
                }
            } else {
                this.focusedItem = null;
            }
        }
        this.selectedColumnIndex = col;
        this.selectedRowIndex = row;
        this.updateInternalArea();
        if (this.rowHeights != null) {
            if (this.targetXOffset + this.internalX < 0) {
                this.targetXOffset = -this.internalX;
            } else if (this.targetXOffset + this.internalX + this.internalWidth > this.contentWidth) {
                this.targetXOffset = this.contentWidth - (this.internalX + this.internalWidth);
            }
        }
        this.notifyStateChanged();
    }

    private int getRelativeRowY(int row) {
        int y = 0;
        for (int i = 0; i < row; ++i) {
            y += this.rowHeights[i];
        }
        if (y > 0) {
            y -= this.paddingVertical / 2;
        }
        return y;
    }

    private int getRelativeColumnX(int col) {
        int x = 0;
        for (int i = 0; i < col; ++i) {
            x += this.columnWidths[i];
        }
        if (col > 0) {
            x -= this.paddingHorizontal;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimension(int columns, int rows) {
        Object object = this.paintLock;
        synchronized (object) {
            if (this.tableData == null) {
                this.tableData = new TableData(columns, rows);
            } else {
                this.tableData.setDimension(columns, rows);
            }
        }
        this.requestInit();
    }

    public int getNumberOfColumns() {
        if (this.tableData == null) {
            return -1;
        }
        return this.tableData.getNumberOfColumns();
    }

    public int getNumberOfRows() {
        if (this.tableData == null) {
            return -1;
        }
        return this.tableData.getNumberOfRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addColumn() {
        int col = 0;
        Object object = this.paintLock;
        synchronized (object) {
            if (this.tableData == null) {
                this.tableData = new TableData(1, 0);
                this.requestInit();
            } else {
                this.requestInit();
                col = this.tableData.addColumn();
            }
        }
        this.currentColumnIndex = col;
        return col;
    }

    public void moveToNextColumn() {
        if (this.currentColumnIndex + 1 >= this.getNumberOfColumns()) {
            this.addColumn();
        } else {
            ++this.currentColumnIndex;
        }
    }

    public void moveToNextRow() {
        if (this.currentRowIndex + 1 >= this.getNumberOfRows()) {
            this.addRow();
        } else {
            ++this.currentRowIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertColumn(int index) {
        Object object = this.paintLock;
        synchronized (object) {
            this.tableData.insertColumn(index);
            this.requestInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(int index) {
        Object object = this.paintLock;
        synchronized (object) {
            this.tableData.removeColumn(index);
            this.requestInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow() {
        int row = 0;
        Object object = this.paintLock;
        synchronized (object) {
            if (this.tableData == null) {
                this.tableData = new TableData(0, 1);
                this.requestInit();
            } else {
                this.requestInit();
                row = this.tableData.addRow();
            }
        }
        this.currentRowIndex = row;
        this.currentColumnIndex = 0;
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(int index) {
        Object object = this.paintLock;
        synchronized (object) {
            this.tableData.insertRow(index);
            this.requestInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int index) {
        Object object = this.paintLock;
        synchronized (object) {
            this.tableData.removeRow(index);
            this.requestInit();
        }
    }

    public void set(int column, int row, Object value) {
        this.set(column, row, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int column, int row, Object value, Style itemStyle) {
        Item item = null;
        if (value instanceof Item) {
            item = (Item)value;
            item.parent = UiAccess.cast(this);
        }
        if (itemStyle != null) {
            if (item != null) {
                item.setStyle(itemStyle);
            } else if (value != null) {
                item = new StringItem(null, value.toString(), itemStyle);
                item.parent = UiAccess.cast(this);
                value = item;
            }
        }
        Object object = this.paintLock;
        synchronized (object) {
            this.tableData.set(column, row, value);
        }
        this.repaint();
    }

    public void setRow(int row, Object[] values) {
        this.setRow(row, values, null);
    }

    public void setRow(int row, Object[] values, Style itemStyle) {
        for (int i = 0; i < values.length; ++i) {
            this.set(i, row, values[i], itemStyle);
        }
    }

    public Object get(int column, int row) {
        return this.tableData.get(column, row);
    }

    public Object getSelectedCell() {
        if (this.selectedColumnIndex == -1 || this.selectedRowIndex == -1) {
            return null;
        }
        return this.tableData.get(this.getSelectedColumn(), this.getSelectedRow());
    }

    public int getSelectedRow() {
        return this.selectedRowIndex;
    }

    public int getSelectedColumn() {
        return this.selectedColumnIndex;
    }

    protected String createCssSelector() {
        return "table";
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (this.selectionMode == 0) {
            this.selectedColumnIndex = -1;
            this.selectedRowIndex = -1;
            this.appearanceMode = this.completeWidth > this.contentWidth ? 3 : 0;
        } else if (this.isFocused) {
            this.selectCell();
            if (this.selectedColumnIndex != -1 || this.selectedRowIndex != -1) {
                this.appearanceMode = 3;
            } else if (this.completeWidth <= this.contentWidth) {
                this.appearanceMode = 0;
            }
        }
    }

    public Background getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Background selectedBackground) {
        this.selectedBackground = selectedBackground;
        if (this.selectedRowBackground == null) {
            this.selectedRowBackground = selectedBackground;
        }
        if (this.selectedColumnBackground == null) {
            this.selectedColumnBackground = selectedBackground;
        }
    }

    public Background getSelectedRowBackground() {
        return this.selectedRowBackground;
    }

    public void setSelectedRowBackground(Background selectedBackgroundHorizontal) {
        this.selectedRowBackground = selectedBackgroundHorizontal;
    }

    public Background getSelectedColumnBackground() {
        return this.selectedColumnBackground;
    }

    public void setSelectedColumnBackground(Background selectedBackgroundVertical) {
        this.selectedColumnBackground = selectedBackgroundVertical;
    }

    public void defocus(Style originalStyle) {
        Object obj;
        super.defocus(originalStyle);
        if (this.selectionMode != 0 && this.appearanceMode != 0 && (obj = this.getSelectedCell()) instanceof Item) {
            Item item = (Item)obj;
            item.defocus(this.itemStyle);
        }
    }

    protected Style focus(Style newStyle, int direction) {
        Style oldStyle = super.focus(newStyle, direction);
        if ((this.selectionMode & 2) == 2) {
            Object obj = this.getSelectedCell();
            if (obj == null) {
                this.selectCell();
            } else if (obj instanceof Item) {
                Item item = (Item)obj;
                if (!item.isFocused) {
                    this.itemStyle = item.focus(null, direction);
                }
            }
        }
        return oldStyle;
    }

    private void selectCell() {
        boolean selectInteractive = (this.selectionMode & 8) == 8;
        boolean selectNotempty = (this.selectionMode & 4) == 4;
        boolean selectCell = (this.selectionMode & 2) == 2;
        boolean selectRow = (this.selectionMode & 0x10) == 16;
        boolean selectColumn = (this.selectionMode & 0x20) == 32;
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getNumberOfColumns(); ++col) {
                Object data = this.get(col, row);
                if (selectInteractive) {
                    if (!(data instanceof Item) || ((Item)data).appearanceMode == 0) continue;
                    if (!selectCell && !selectColumn) {
                        col = -1;
                    }
                    if (!selectCell && !selectRow) {
                        row = -1;
                    }
                    this.setSelectedCell(col, row);
                    return;
                }
                if (selectNotempty) {
                    if (data == null) continue;
                    if (!selectCell && !selectColumn) {
                        col = -1;
                    }
                    if (!selectCell && !selectRow) {
                        row = -1;
                    }
                    this.setSelectedCell(col, row);
                    return;
                }
                if (!selectCell && !selectColumn) {
                    col = -1;
                }
                if (!selectCell && !selectRow) {
                    row = -1;
                }
                this.setSelectedCell(col, row);
                return;
            }
        }
    }

    public void setCellContainerStyle(Style containerStyle) {
        this.cellContainerStyle = containerStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int col, int row, Item item) {
        Object object = this.paintLock;
        synchronized (object) {
            Object existing;
            if (this.tableData == null) {
                this.setDimension(col + 1, row + 1);
            }
            if ((existing = this.tableData.get(col, row)) == null) {
                this.set(col, row, item);
            } else if (existing instanceof Container) {
                ((Container)existing).add(item);
            } else {
                Container container = new Container(false, this.cellContainerStyle);
                if (existing instanceof Item) {
                    container.add((Item)existing);
                } else {
                    container.add(existing.toString());
                }
                container.add(item);
                this.set(col, row, container);
            }
        }
    }

    public void add(Item item) {
        this.add(this.currentColumnIndex, this.currentRowIndex, item);
    }

    public int size() {
        return this.getNumberOfColumns() * this.getNumberOfRows();
    }

    public Item get(int index) {
        int row = index / this.getNumberOfColumns();
        int col = index % this.getNumberOfColumns();
        Object object = this.tableData.get(col, row);
        if (object != null && !(object instanceof Item)) {
            object = new StringItem(null, object.toString());
        }
        return (Item)object;
    }

    public int indexOf(Item item) {
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getNumberOfColumns(); ++col) {
                Object obj = this.tableData.get(col, row);
                if (obj != item) continue;
                return row * this.getNumberOfColumns() + col;
            }
        }
        return -1;
    }

    public Item remove(int index) {
        int row = index / this.getNumberOfColumns();
        int col = index % this.getNumberOfColumns();
        Item previous = (Item)this.tableData.get(col, row);
        this.tableData.set(col, row, null);
        return previous;
    }

    public Item set(int index, Item item, Style itemStyle) {
        int row = index / this.getNumberOfColumns();
        int col = index % this.getNumberOfColumns();
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        Item prev = (Item)this.tableData.get(col, row);
        this.set(col, row, item);
        return prev;
    }

    public void updateInternalArea() {
        if (this.columnWidths == null) {
            return;
        }
        if (this.selectedColumnIndex != -1) {
            this.internalX = this.getRelativeColumnX(this.selectedColumnIndex);
            this.internalWidth = this.columnWidths[this.selectedColumnIndex];
        } else {
            this.internalX = 0;
            this.internalWidth = this.completeWidth;
        }
        if (this.selectedRowIndex != -1) {
            this.internalY = this.getRelativeRowY(this.selectedRowIndex);
            this.internalHeight = this.rowHeights[this.selectedRowIndex] - this.paddingVertical;
        } else {
            this.internalY = 0;
            this.internalHeight = this.contentHeight;
        }
        Item item = this.focusedItem;
        if (item != null && item.internalX != -9999) {
            int intX = item.relativeX + item.contentX + item.internalX;
            int intY = item.relativeY + item.contentY + item.internalY;
            if (this.internalHeight > this.availableHeight || intY + item.internalHeight > this.internalY + this.internalHeight || intY < this.internalY) {
                this.internalY = intY;
                this.internalHeight = item.internalHeight;
            }
            if (this.internalWidth > this.availableWidth || intX + item.internalWidth > this.internalX + this.internalWidth || intX < this.internalX) {
                this.internalX = intX;
                this.internalWidth = item.internalWidth;
            }
        }
        if (this.targetXOffset + this.internalX + this.internalWidth > this.availContentWidth) {
            this.targetXOffset = this.availContentWidth - this.internalX - this.internalWidth;
        }
    }
}

