/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.Color;
import de.enough.polish.ui.Dimension;
import de.enough.polish.util.IntHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;

public class Style
implements Externalizable {
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    public transient String name;
    public transient String dynamicName;
    public Background background;
    public Border border;
    private Font font;
    public int layout;
    private short[] attributeKeys;
    private Object[] attributeValues;

    public Style() {
        this(null, 20, null, null, null, null);
    }

    public Style(Style style) {
        Style focusedStyle;
        this.name = style.name;
        this.layout = style.layout;
        this.background = style.background;
        this.border = style.border;
        short[] keys = style.attributeKeys;
        Object[] values = style.attributeValues;
        if (keys != null) {
            this.attributeKeys = new short[keys.length];
            System.arraycopy(keys, 0, this.attributeKeys, 0, keys.length);
            this.attributeValues = new Object[values.length];
            System.arraycopy(values, 0, this.attributeValues, 0, values.length);
        }
        if ((focusedStyle = (Style)style.getObjectProperty(1)) != null) {
            style.addAttribute(1, new Style(focusedStyle));
        }
    }

    public void extendStyle(Style style) {
        this.name = style.name;
        this.layout = style.layout;
        this.background = style.background;
        this.border = style.border;
        IntHashMap map = new IntHashMap();
        this.addAttributesToMap(map, style);
        this.addAttributesToMap(map, this);
        int[] keys = map.keys();
        Object[] values = map.values();
        this.attributeKeys = new short[keys.length];
        this.attributeValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.attributeKeys[i] = (short)keys[i];
            this.attributeValues[i] = values[i];
        }
    }

    void addAttributesToMap(IntHashMap map, Style style) {
        short[] keys = style.attributeKeys;
        Object[] values = style.attributeValues;
        if (keys != null && values != null) {
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
        }
    }

    public Style(int marginLeft, int marginRight, int marginTop, int marginBottom, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom, int paddingVertical, int paddingHorizontal, int layout, int fontColor, Font font, Background background, Border border, short[] attributeKeys, Object[] attributeValues) {
        this(marginLeft, marginRight, marginTop, marginBottom, paddingLeft, paddingRight, paddingTop, paddingBottom, paddingVertical, paddingHorizontal, layout, fontColor, null, font, background, border, attributeKeys, attributeValues);
    }

    public Style(int marginLeft, int marginRight, int marginTop, int marginBottom, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom, int paddingVertical, int paddingHorizontal, int layout, int fontColor, Color fontColorObj, Font font, Background background, Border border, short[] attributeKeys, Object[] attributeValues) {
        this.layout = layout;
        this.font = font;
        this.background = background;
        this.border = border;
        this.attributeValues = attributeValues;
        this.attributeKeys = attributeKeys;
    }

    public Style(String name, int layout, Background background, Border border, short[] attributeKeys, Object[] attributeValues) {
        this.name = name;
        this.layout = layout;
        this.background = background;
        this.border = border;
        this.attributeKeys = attributeKeys;
        this.attributeValues = attributeValues;
    }

    public Style clone(boolean deepCopy) {
        Style style = null;
        if (deepCopy) {
            short[] keys = this.attributeKeys;
            Object[] values = this.attributeValues;
            if (keys != null) {
                short[] cKeys = new short[keys.length];
                System.arraycopy(keys, 0, cKeys, 0, keys.length);
                keys = cKeys;
                Object[] cValues = new Object[values.length];
                System.arraycopy(values, 0, cValues, 0, values.length);
                values = cValues;
            }
            style = new Style(this.name, this.layout, this.background, this.border, keys, values);
        } else {
            style = new Style(this.name, this.layout, this.background, this.border, this.attributeKeys, this.attributeValues);
        }
        return style;
    }

    public String getProperty(int key) {
        if (this.attributeKeys == null) {
            return null;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            Object value = this.attributeValues[i];
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public Object getObjectProperty(int key) {
        if (this.attributeKeys == null) {
            return null;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            return this.attributeValues[i];
        }
        return null;
    }

    public Integer getIntProperty(int key) {
        if (this.attributeKeys == null) {
            return null;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            Object value = this.attributeValues[i];
            if (value instanceof Color) {
                return ((Color)value).getInteger();
            }
            return (Integer)value;
        }
        return null;
    }

    public Color getColorProperty(int key) {
        if (this.attributeKeys == null) {
            return null;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            Object value = this.attributeValues[i];
            return (Color)value;
        }
        return null;
    }

    public Boolean getBooleanProperty(int key) {
        if (this.attributeKeys == null) {
            return null;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            return (Boolean)this.attributeValues[i];
        }
        return null;
    }

    public void releaseResources() {
        if (this.background != null) {
            this.background.releaseResources();
        }
    }

    public int getFontColor() {
        Style style = this;
        Color color2 = style.getColorProperty(-17);
        if (color2 != null) {
            return color2.getColor();
        }
        return 0;
    }

    public Font getFont() {
        if (this.font == null) {
            Style style = this;
            int fontStyle = 0;
            boolean fontDefined = false;
            Font f = (Font)style.getObjectProperty(-13);
            if (f != null) {
                this.font = f;
                return f;
            }
            Integer styleInt = style.getIntProperty(-14);
            if (styleInt != null) {
                fontStyle = styleInt;
                fontDefined = true;
            }
            int fontSizeConstant = 0;
            Dimension fontSizeDimension = null;
            Object size = style.getObjectProperty(-15);
            if (size instanceof Dimension) {
                fontSizeDimension = (Dimension)size;
                fontDefined = true;
            } else {
                Integer sizeInt = style.getIntProperty(-15);
                if (sizeInt != null) {
                    fontSizeConstant = sizeInt;
                    fontDefined = true;
                }
            }
            int fontFace = 0;
            Integer faceInt = style.getIntProperty(-16);
            if (faceInt != null) {
                fontFace = faceInt;
                fontDefined = true;
            }
            if (fontDefined) {
                if (fontSizeDimension != null) {
                    if (fontSizeDimension.isPercent()) {
                        fontSizeConstant = fontSizeDimension.getValue(100) < 100 ? 8 : (fontSizeDimension.getValue(100) == 100 ? 0 : 16);
                    } else {
                        int height = fontSizeDimension.getValue(100);
                        Font fnt = Font.getFont(fontFace, fontStyle, 0);
                        int minDifference = Math.abs(fnt.getHeight() - height);
                        fnt = Font.getFont(fontFace, fontStyle, 8);
                        int difference = Math.abs(fnt.getHeight() - height);
                        if (difference < minDifference) {
                            fontSizeConstant = 8;
                        } else {
                            fnt = Font.getFont(fontFace, fontStyle, 16);
                            difference = Math.abs(fnt.getHeight() - height);
                            if (difference < minDifference) {
                                fontSizeConstant = 16;
                            }
                        }
                    }
                    this.font = Font.getFont(fontFace, fontStyle, fontSizeConstant);
                } else {
                    this.font = Font.getFont(fontFace, fontStyle, fontSizeConstant);
                }
            }
        }
        return this.font;
    }

    public void removeAttribute(int key) {
        if (this.attributeKeys == null) {
            return;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            this.attributeValues[i] = null;
            return;
        }
    }

    public void addAttribute(int key, Object value) {
        if (this.attributeKeys == null) {
            this.attributeKeys = new short[]{(short)key};
            this.attributeValues = new Object[]{value};
            return;
        }
        for (int i = 0; i < this.attributeKeys.length; ++i) {
            if (this.attributeKeys[i] != key) continue;
            this.attributeValues[i] = value;
            return;
        }
        short[] keys = new short[this.attributeKeys.length + 1];
        System.arraycopy(this.attributeKeys, 0, keys, 0, this.attributeKeys.length);
        keys[this.attributeKeys.length] = (short)key;
        Object[] values = new Object[this.attributeKeys.length + 1];
        System.arraycopy(this.attributeValues, 0, values, 0, this.attributeKeys.length);
        values[this.attributeKeys.length] = value;
        this.attributeKeys = keys;
        this.attributeValues = values;
    }

    private int getMargin(Dimension value, int range) {
        if (value == null) {
            Style style = this;
            value = (Dimension)style.getObjectProperty(32713);
        }
        if (value != null) {
            return value.getValue(range);
        }
        return 0;
    }

    public int getMarginLeft(int width) {
        Style style = this;
        Dimension value = null;
        return this.getMargin(value, width);
    }

    public int getMarginRight(int width) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-3);
        return this.getMargin(value, width);
    }

    public int getMarginTop(int height) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-4);
        return this.getMargin(value, height);
    }

    public int getMarginBottom(int height) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-5);
        return this.getMargin(value, height);
    }

    private int getPadding(Dimension value, int range) {
        if (value == null) {
            Style style = this;
            value = (Dimension)style.getObjectProperty(-6);
        }
        if (value != null) {
            return value.getValue(range);
        }
        return 1;
    }

    public int getPaddingLeft(int width) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-7);
        return this.getPadding(value, width);
    }

    public int getPaddingRight(int width) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-8);
        return this.getPadding(value, width);
    }

    public int getPaddingTop(int height) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-9);
        return this.getPadding(value, height);
    }

    public int getPaddingBottom(int height) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-10);
        return this.getPadding(value, height);
    }

    public int getPaddingHorizontal(int width) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-11);
        return this.getPadding(value, width);
    }

    public int getPaddingVertical(int height) {
        Style style = this;
        Dimension value = null;
        value = (Dimension)style.getObjectProperty(-12);
        return this.getPadding(value, height);
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        this.layout = layout;
    }

    public int getAnchor() {
        int lo = this.layout;
        int orientation = 0;
        orientation = (lo & 3) == 3 ? (orientation |= 1) : ((lo & 2) == 2 ? (orientation |= 8) : (orientation |= 4));
        orientation = (lo & 0x30) == 48 ? (orientation |= 2) : ((lo & 0x20) == 32 ? (orientation |= 0x20) : (orientation |= 0x10));
        return orientation;
    }

    public int getAnchorForText() {
        int lo = this.layout;
        int orientation = 0;
        orientation = (lo & 3) == 3 ? (orientation |= 1) : ((lo & 2) == 2 ? (orientation |= 8) : (orientation |= 4));
        orientation = (lo & 0x30) == 48 ? (orientation |= 0x40) : ((lo & 0x20) == 32 ? (orientation |= 0x20) : (orientation |= 0x10));
        return orientation;
    }

    public int getAnchorHorizontal() {
        int lo = this.layout;
        int orientation = 0;
        orientation = (lo & 3) == 3 ? 1 : ((lo & 2) == 2 ? 8 : 4);
        return orientation;
    }

    public void read(DataInputStream in) throws IOException {
        this.background = (Background)Serializer.deserialize(in);
        this.border = (Border)Serializer.deserialize(in);
        this.layout = in.readInt();
        this.attributeKeys = (short[])Serializer.deserialize(in);
        this.attributeValues = (Object[])Serializer.deserialize(in);
    }

    public void write(DataOutputStream out) throws IOException {
        Serializer.serialize(this.background, out);
        Serializer.serialize(this.border, out);
        out.writeInt(this.layout);
        Serializer.serialize(this.attributeKeys, out);
        Serializer.serialize(this.attributeValues, out);
    }

    public short[] getRawAttributeKeys() {
        return this.attributeKeys;
    }

    public Object[] getRawAttributeValues() {
        return this.attributeValues;
    }

    public String toString() {
        return '[' + this.name + "] " + super.toString();
    }
}

