/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Border;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.CssAnimation;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ScreenChangeAnimation
extends Canvas
implements Runnable {
    protected static final int DIRECTION_FORWARD = 0;
    protected static final int DIRECTION_BACKWARD = 1;
    protected static final long DEFAULT_DURATION = 400L;
    protected Display display;
    protected Canvas nextCanvas;
    protected Image lastCanvasImage;
    protected int[] lastCanvasRgb;
    protected boolean useLastCanvasRgb;
    protected Image nextCanvasImage;
    protected int[] nextCanvasRgb;
    protected boolean useNextCanvasRgb;
    protected int screenWidth;
    protected int screenHeight;
    protected Displayable lastDisplayable;
    protected Displayable nextDisplayable;
    protected boolean isForwardAnimation;
    protected int nextContentX;
    protected int nextContentY;
    protected int lastContentX;
    protected int lastContentY;
    protected boolean supportsDifferentScreenSizes;
    protected boolean abort = false;
    protected long animationDuration = 400L;
    protected long startTime;
    protected int animationForwardFunction = 4;
    protected int animationBackwardFunction = 5;

    public ScreenChangeAnimation() {
        this.setFullScreenMode(true);
    }

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        this.abort = false;
        this.screenWidth = width;
        this.screenHeight = height;
        this.display = dsplay;
        this.nextCanvas = (Canvas)nxtDisplayable;
        this.lastDisplayable = lstDisplayable;
        this.nextDisplayable = nxtDisplayable;
        Screen lastScreen = (Screen)(lstDisplayable instanceof Screen ? lstDisplayable : null);
        Screen nextScreen = (Screen)(nxtDisplayable instanceof Screen ? nxtDisplayable : null);
        Image lastScreenImage = this.toImage(lstDisplayable, nextScreen, lastScreen, width, height);
        Image nextScreenImage = this.toImage(nxtDisplayable, nextScreen, lastScreen, width, height);
        if (lastScreenImage == null || nextScreenImage == null) {
            this.abort = true;
            return;
        }
        if (this.supportsDifferentScreenSizes) {
            Graphics g;
            Boolean limitToContentBool;
            if (lastScreen != null && nextScreen != null && nextScreen.container != null && nextScreen.style != null && (limitToContentBool = nextScreen.style.getBooleanProperty(116)) != null && limitToContentBool.booleanValue()) {
                g = lastScreenImage.getGraphics();
                if (nextScreen.previousScreenOverlayBackground != null) {
                    nextScreen.previousScreenOverlayBackground.paint(0, 0, width, height, g);
                }
                nextScreen.paintMenuBar(g);
            }
            if (lastScreen != null && nextScreen != null && lastScreen.container != null && lastScreen.style != null && (limitToContentBool = lastScreen.style.getBooleanProperty(116)) != null && limitToContentBool.booleanValue()) {
                g = nextScreenImage.getGraphics();
                if (lastScreen.previousScreenOverlayBackground != null) {
                    lastScreen.previousScreenOverlayBackground.paint(0, 0, width, nextScreen.contentY + nextScreen.contentHeight, g);
                }
            }
        }
        this.lastCanvasImage = lastScreenImage;
        if (this.useLastCanvasRgb) {
            int lstWidth = lastScreenImage.getWidth();
            int lstHeight = lastScreenImage.getHeight();
            this.lastCanvasRgb = new int[lstWidth * lstHeight];
            lastScreenImage.getRGB(this.lastCanvasRgb, 0, lstWidth, 0, 0, lstWidth, lstHeight);
        }
        this.nextCanvasImage = nextScreenImage;
        if (this.useNextCanvasRgb) {
            int nxtWidth = nextScreenImage.getWidth();
            int nxtHeight = nextScreenImage.getHeight();
            this.nextCanvasRgb = new int[nxtWidth * nxtHeight];
            nextScreenImage.getRGB(this.nextCanvasRgb, 0, nxtWidth, 0, 0, nxtWidth, nxtHeight);
        }
        this.isForwardAnimation = isForward;
        this.startTime = System.currentTimeMillis();
        this.setStyle(style);
        this.animate(0L, this.animationDuration);
    }

    protected Image toImage(Displayable displayable, Screen nextScreen, Screen lastScreen, int width, int height) {
        try {
            Boolean limitToContentBool;
            boolean isLastScreen = displayable == lastScreen;
            Screen screen = isLastScreen ? lastScreen : nextScreen;
            Image screenImage = null;
            if (!isLastScreen && displayable instanceof Canvas) {
                ((Canvas)displayable).showNotify();
            }
            boolean limitToContent = false;
            int contentX = 0;
            int contentY = 0;
            if (this.supportsDifferentScreenSizes && screen != null && screen.container != null && screen.style != null && (limitToContentBool = screen.style.getBooleanProperty(116)) != null && (limitToContent = limitToContentBool.booleanValue())) {
                Item title;
                width = screen.container.itemWidth;
                height = Math.min(screen.contentHeight, screen.container.itemHeight);
                Border border = screen.border;
                if (border != null) {
                    width += border.borderWidthLeft + border.borderWidthRight;
                    height += border.borderWidthTop + border.borderWidthBottom;
                    contentX = border.borderWidthLeft;
                    contentY = border.borderWidthTop;
                }
                if ((title = screen.getTitleItem()) != null) {
                    height += title.itemHeight;
                    contentY += title.itemHeight;
                    if (title.itemWidth > width) {
                        width = title.itemWidth;
                    }
                }
            }
            screenImage = Image.createImage(width, height);
            Graphics g = screenImage.getGraphics();
            g.setClip(0, 0, width, height);
            if (displayable instanceof Canvas) {
                if (limitToContent) {
                    g.translate(-(screen.container.relativeX - contentX), -(screen.container.relativeY - contentY));
                    screen.paintBackgroundAndBorder(g);
                    screen.paintTitleAndSubtitle(g);
                    if (isLastScreen) {
                        this.lastContentX = -g.getTranslateX();
                        this.lastContentY = -g.getTranslateY();
                    } else {
                        this.nextContentX = -g.getTranslateX();
                        this.nextContentY = -g.getTranslateY();
                    }
                    g.translate(-g.getTranslateX(), -g.getTranslateY());
                    screen.container.paint(contentX, contentY, contentX, width, g);
                } else {
                    if (isLastScreen) {
                        this.lastContentX = 0;
                        this.lastContentY = 0;
                    } else {
                        this.nextContentX = 0;
                        this.nextContentY = 0;
                    }
                    ((Canvas)displayable).paint(g);
                }
            }
            return screenImage;
        }
        catch (OutOfMemoryError error) {
            return null;
        }
    }

    protected void setStyle(Style style) {
    }

    protected int calculateAnimationPoint(int startValue, int endValue, long passedTime, long duration) {
        int function = this.isForwardAnimation ? this.animationForwardFunction : this.animationBackwardFunction;
        return CssAnimation.calculatePointInRange(startValue, endValue, passedTime, duration, function);
    }

    protected abstract boolean animate(long var1, long var3);

    protected abstract void paintAnimation(Graphics var1);

    public final void paint(Graphics g) {
        try {
            if (this.nextCanvasImage != null) {
                this.paintAnimation(g);
                this.display.callSerially(this);
            }
        }
        catch (Throwable e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 409, (Object)"Unable to paint animation", e);
        }
    }

    public boolean _pointerPressed(int x, int y) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        if (next != null) {
            handled = next._pointerPressed(x, y);
            this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
        }
        return handled;
    }

    public boolean _pointerReleased(int x, int y) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        if (next != null) {
            handled = next._pointerReleased(x, y);
            this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
        }
        return handled;
    }

    public boolean _pointerDragged(int x, int y) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        if (next != null) {
            handled = next._pointerDragged(x, y);
            this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
        }
        return handled;
    }

    public void showNotify() {
        this.setFullScreenMode(true);
    }

    public void hideNotify() {
    }

    public void sizeChanged(int width, int height) {
    }

    public boolean _keyRepeated(int keyCode) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                handled = next._keyRepeated(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 524, (Object)"Error while handling keyRepeated event", e);
        }
        return handled;
    }

    public boolean _keyReleased(int keyCode) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                handled = next._keyReleased(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 548, (Object)"Error while handling keyReleased event", e);
        }
        return handled;
    }

    public boolean _keyPressed(int keyCode) {
        boolean handled = false;
        Canvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                handled = next._keyPressed(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 572, (Object)"Error while handling keyPressed event", e);
        }
        return handled;
    }

    protected void updateNextScreen(Canvas next, Image nextImage, int[] rgb) {
        boolean isFullScreen = true;
        if (this.supportsDifferentScreenSizes) {
            Boolean repaintPrevScreen;
            Screen nextScreen;
            Screen screen = nextScreen = next instanceof Screen ? (Screen)next : null;
            if (nextScreen != null && nextScreen.style != null && (repaintPrevScreen = nextScreen.style.getBooleanProperty(116)) != null && repaintPrevScreen.booleanValue()) {
                this.nextCanvasImage = this.toImage(next, nextScreen, null, this.screenWidth, this.screenHeight);
                isFullScreen = false;
            }
        }
        if (isFullScreen) {
            Graphics g = nextImage.getGraphics();
            next.paint(g);
        }
        if (rgb != null) {
            nextImage.getRGB(rgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight);
        }
    }

    public void abort() {
        this.abort = true;
    }

    public void run() {
        block5: {
            try {
                long passedTime = System.currentTimeMillis() - this.startTime;
                if (this.nextCanvas != null && this.animate(passedTime, this.animationDuration) && !this.abort) {
                    this.repaint();
                } else {
                    this.lastCanvasImage = null;
                    this.lastCanvasRgb = null;
                    this.nextCanvasImage = null;
                    this.nextCanvasRgb = null;
                    this.nextCanvas = null;
                    Display disp = this.display;
                    this.display = null;
                    Displayable next = this.nextDisplayable;
                    this.nextDisplayable = null;
                    System.gc();
                    if (disp != null && !this.abort && next != null) {
                        disp.setCurrent(next, false, null);
                    }
                }
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 657, (Object)"Unable to animate", e);
                Display disp = this.display;
                Displayable next = this.nextDisplayable;
                if (disp == null || next == null) break block5;
                disp.setCurrent(next, false, null);
            }
        }
    }

    public Displayable getNextDisplayable() {
        return this.nextDisplayable;
    }
}

