/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Image;

public class ScaledImageItem
extends ImageItem {
    private Image originalImage;
    private Dimension scaledImageWidth;
    private Dimension scaledImageHeight;

    public ScaledImageItem(String label, Image image, Dimension imageWidth, Dimension imageHeight, int layout, String altText) {
        this(label, image, imageWidth, imageHeight, layout, altText, null);
    }

    public ScaledImageItem(String label, Image image, Dimension imageWidth, Dimension imageHeight, int layout, String altText, Style style) {
        super(label, image, layout, altText, style);
        this.originalImage = image;
        this.scaledImageWidth = imageWidth;
        this.scaledImageHeight = imageHeight;
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(firstLineWidth, availWidth, availHeight);
        int sourceWidth = 0;
        int sourceHeight = 0;
        if (this.originalImage != null) {
            sourceWidth = this.originalImage.getWidth();
            sourceHeight = this.originalImage.getHeight();
        }
        int targetWidth = sourceWidth;
        int targetHeight = sourceHeight;
        if (this.scaledImageWidth != null) {
            targetWidth = this.scaledImageWidth.getValue(availWidth);
        }
        if (this.scaledImageHeight != null) {
            targetHeight = this.scaledImageHeight.getValue(availHeight);
        }
        this.contentHeight = targetHeight;
        this.contentWidth = targetWidth;
        if (this.originalImage == null) {
            return;
        }
        Image currentImage = this.image;
        if (!(sourceWidth == targetWidth && sourceHeight == targetWidth || targetWidth == currentImage.getWidth() && targetHeight == currentImage.getHeight() || targetWidth <= 1 || targetHeight <= 1)) {
            Image img;
            int[] rgbData = new int[sourceWidth * sourceHeight];
            this.originalImage.getRGB(rgbData, 0, sourceWidth, 0, 0, sourceWidth, sourceHeight);
            int[] newRgbData = new int[targetWidth * targetHeight];
            ImageUtil.scale(rgbData, targetWidth, targetHeight, sourceWidth, sourceHeight, newRgbData);
            this.image = img = Image.createRGBImage(newRgbData, targetWidth, targetHeight, true);
        }
    }

    public void setImage(Image image) {
        this.originalImage = image;
        super.setImage(image);
    }
}

