/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Choice;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Locale;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class List
extends Screen
implements Choice {
    public static Command SELECT_COMMAND = new Command(Locale.get(167), 8, 3);
    private Command selectCommand = SELECT_COMMAND;
    protected int listType;
    protected ChoiceGroup choiceGroup;

    public List(String title, int listType) {
        this(title, listType, new String[0], null, null);
    }

    public List(String title, int listType, Style style) {
        this(title, listType, new String[0], new Image[0], style);
    }

    public List(String title, int listType, String[] stringElements, Image[] imageElements) {
        this(title, listType, stringElements, imageElements, null);
    }

    public List(String title, int listType, String[] stringElements, Image[] imageElements, Style style) {
        this(title, listType, ChoiceGroup.buildChoiceItems(stringElements, imageElements, listType, style), style);
    }

    public List(String title, int listType, ChoiceItem[] items) {
        this(title, listType, items, null);
    }

    public List(String title, int listType, ChoiceItem[] items, Style style) {
        super(title, style, false);
        this.listType = listType;
        String selectLabel = Locale.get(167);
        if (selectLabel != SELECT_COMMAND.getLabel()) {
            this.selectCommand = SELECT_COMMAND = new Command(selectLabel, 8, 3);
        }
        this.choiceGroup = new ChoiceGroup(null, this.listType, items, style, true);
        this.choiceGroup.setAutoFocusEnabled(true);
        this.choiceGroup.screen = this;
        this.choiceGroup.isFocused = true;
        this.container = this.choiceGroup;
    }

    public int size() {
        return this.container.size();
    }

    public String getString(int elementNum) {
        return this.getItem(elementNum).getText();
    }

    public Image getImage(int elementNum) {
        return this.getItem(elementNum).getImage();
    }

    public ChoiceItem getItem(int elementNum) {
        return (ChoiceItem)this.choiceGroup.get(elementNum);
    }

    public int append(String stringPart, Image imagePart) {
        return this.append(stringPart, imagePart, null);
    }

    public int append(String stringPart, Image imagePart, Style elementStyle) {
        return this.append(new ChoiceItem(stringPart, imagePart, this.listType, elementStyle));
    }

    public int append(ChoiceItem item) {
        int number = this.choiceGroup.append(item);
        if (number == 0) {
            if (this.listType == 3 && this.selectCommand != null) {
                this.addCommand(this.selectCommand);
            } else {
                this.setItemCommands(this.choiceGroup.commands, this.choiceGroup);
            }
        }
        return number;
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        this.insert(elementNum, stringPart, imagePart, null);
    }

    public void insert(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        this.insert(elementNum, new ChoiceItem(stringPart, imagePart, this.listType, elementStyle));
    }

    public void insert(int elementNum, ChoiceItem item) {
        this.choiceGroup.insert(elementNum, item);
        if (this.choiceGroup.size() == 0) {
            if (this.listType == 3 && this.selectCommand != null) {
                this.addCommand(this.selectCommand);
            } else {
                this.setItemCommands(this.choiceGroup.commands, this.choiceGroup);
            }
        }
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        this.set(elementNum, stringPart, imagePart, null);
    }

    public void set(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        this.set(elementNum, new ChoiceItem(stringPart, imagePart, this.listType, elementStyle));
    }

    public void set(int elementNum, ChoiceItem item) {
        this.choiceGroup.set(elementNum, item);
    }

    public void delete(int elementNum) {
        this.choiceGroup.delete(elementNum);
        if (this.choiceGroup.size() == 0) {
            if (this.listType == 3 && this.selectCommand != null) {
                super.removeCommand(this.selectCommand);
            } else {
                this.removeItemCommands(this.choiceGroup);
            }
        }
    }

    public void deleteAll() {
        this.choiceGroup.deleteAll();
        if (this.listType == 3 && this.selectCommand != null) {
            super.removeCommand(this.selectCommand);
        } else {
            this.removeItemCommands(this.choiceGroup);
        }
    }

    public boolean isSelected(int elementNum) {
        return this.choiceGroup.isSelected(elementNum);
    }

    public int getSelectedIndex() {
        return this.choiceGroup.getSelectedIndex();
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        return this.choiceGroup.getSelectedFlags(selectedArray_return);
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        this.choiceGroup.setSelectedIndex(elementNum, selected);
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        this.choiceGroup.setSelectedFlags(selectedArray);
    }

    public void removeCommand(Command cmd) {
        if (cmd == this.selectCommand) {
            this.selectCommand = null;
        }
        super.removeCommand(cmd);
    }

    public void setSelectCommand(Command command) {
        if (this.listType == 3) {
            if (this.selectCommand != null) {
                super.removeCommand(this.selectCommand);
            }
            this.selectCommand = command;
            if (this.choiceGroup.size() > 0 && command != null) {
                this.addCommand(command);
            }
            this.choiceGroup.setSelectCommand(command);
        }
    }

    public void setFitPolicy(int fitPolicy) {
        this.choiceGroup.setFitPolicy(fitPolicy);
    }

    public int getFitPolicy() {
        return this.choiceGroup.getFitPolicy();
    }

    public void setFont(int elementNum, Font font) {
        this.getItem(elementNum).setFont(font);
    }

    public Font getFont(int elementNum) {
        return this.getItem(elementNum).getFont();
    }

    protected String createCssSelector() {
        return "list";
    }

    protected Command getDefaultCommand(Item item) {
        if (this.choiceGroup.choiceType != 2 && this.selectCommand != null) {
            return this.selectCommand;
        }
        return super.getDefaultCommand(item);
    }
}

