/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Point;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public abstract class ItemView
implements Externalizable {
    protected int contentWidth;
    protected int contentHeight;
    protected int availableWidth;
    protected int availableHeight;
    protected int paddingVertical;
    protected int paddingHorizontal;
    protected int layout;
    protected boolean isLayoutCenter;
    protected boolean isLayoutRight;
    protected transient Item parentItem;
    protected boolean isFocused;

    protected void initMargin(Style style, int availWidth) {
        this.parentItem.initMargin(style, availWidth);
    }

    protected void initPadding(Style style, int availWidth) {
        this.parentItem.initPadding(style, availWidth);
    }

    protected void init(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.parentItem = parent;
        this.availableWidth = availWidth;
        this.availableHeight = availHeight;
        this.paddingHorizontal = parent.paddingHorizontal;
        this.paddingVertical = parent.paddingVertical;
        this.initContent(parent, firstLineWidth, availWidth, availHeight);
    }

    protected abstract void initContent(Item var1, int var2, int var3, int var4);

    protected abstract void paintContent(Item var1, int var2, int var3, int var4, int var5, Graphics var6);

    protected void initContentByParent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        parent.initContent(firstLineWidth, availWidth, availHeight);
        this.contentWidth = parent.contentWidth;
        this.contentHeight = parent.contentHeight;
    }

    protected void paintContentByParent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        parent.paintContent(x, y, leftBorder, rightBorder, g);
    }

    public void focus(Style focusstyle, int direction) {
        this.isFocused = true;
        if (focusstyle != null) {
            this.setStyle(focusstyle);
        }
    }

    protected void defocus(Style originalStyle) {
        this.isFocused = false;
        if (originalStyle != null) {
            this.setStyle(originalStyle);
        }
    }

    protected void setStyle(Style style) {
        if (this.parentItem != null) {
            this.paddingHorizontal = this.parentItem.paddingHorizontal;
            this.paddingVertical = this.parentItem.paddingVertical;
        }
        this.layout = style.layout;
        if ((this.layout & 3) == 3) {
            this.isLayoutCenter = true;
            this.isLayoutRight = false;
        } else {
            this.isLayoutCenter = false;
            this.isLayoutRight = (this.layout & 2) == 2;
        }
        this.setStyle(style, true);
    }

    protected void setStyle(Style style, boolean resetStyle) {
        if (!resetStyle && this.parentItem != null) {
            this.paddingHorizontal = this.parentItem.paddingHorizontal;
            this.paddingVertical = this.parentItem.paddingVertical;
        }
    }

    public void requestInit() {
        if (this.parentItem != null) {
            this.parentItem.requestInit();
        }
    }

    public Background removeParentBackground() {
        if (this.parentItem == null) {
            return null;
        }
        Background bg = this.parentItem.background;
        this.parentItem.background = null;
        return bg;
    }

    public Border removeParentBorder() {
        if (this.parentItem == null) {
            return null;
        }
        Border border = this.parentItem.border;
        this.parentItem.border = null;
        return border;
    }

    protected Border removeItemBorder(Item item) {
        Border border = item.border;
        item.border = null;
        return border;
    }

    protected Background removeItemBackground(Item item) {
        Background background = item.background;
        item.background = null;
        return background;
    }

    protected void addItemBackground(Item item, Background background) {
        item.background = background;
    }

    protected void addItemBorder(Item item, Border border) {
        item.border = border;
    }

    protected void addItemBackgroundBorder(Item item, Background background, Border border) {
        item.background = background;
        item.border = border;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            this.addFullRepaintRegion(this.parentItem, repaintRegion);
        }
    }

    protected void addFullRepaintRegion(Item item, ClippingRegion repaintRegion) {
        repaintRegion.addRegion(item.getAbsoluteX(), item.getAbsoluteY(), item.itemWidth, item.itemHeight);
    }

    public boolean animate() {
        return false;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    protected Screen getScreen() {
        return this.parentItem.getScreen();
    }

    public boolean handleKeyPressed(int keyCode, int gameAction) {
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int gameAction) {
        return false;
    }

    protected Point adjustToContentArea(int x, int y) {
        return new Point(x -= this.parentItem.getContentX(), y -= this.parentItem.getContentY());
    }

    public boolean handlePointerPressed(int x, int y) {
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        return false;
    }

    public boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        if (this.handlePointerDragged(x, y)) {
            this.parentItem.addRepaintArea(repaintRegion);
            return true;
        }
        return false;
    }

    public boolean handlePointerDragged(int x, int y) {
        return false;
    }

    public boolean handlePointerTouchDown(int x, int y) {
        return false;
    }

    public boolean handlePointerTouchUp(int x, int y) {
        return false;
    }

    protected boolean isValid(Item parent, Style style) {
        return true;
    }

    protected void removeViewFromParent() {
        this.parentItem.view = null;
    }

    protected boolean notifyItemPressedStart() {
        return this.parentItem.notifyItemPressedStart();
    }

    protected void notifyItemPressedEnd() {
        this.parentItem.notifyItemPressedEnd();
    }

    public void paintBackground(Background background, int x, int y, int width, int height, Graphics g) {
        background.paint(x, y, width, height, g);
    }

    public void paintBorder(Border border, int x, int y, int width, int height, Graphics g) {
        border.paint(x, y, width, height, g);
    }

    public void releaseResources() {
        if (this.parentItem != null) {
            this.parentItem.isInitialized = false;
        }
    }

    public void destroy() {
        this.releaseResources();
        this.parentItem = null;
    }

    protected boolean notifyItemPressedStart(Item item) {
        return item.notifyItemPressedStart();
    }

    protected void notifyItemPressedEnd(Item item) {
        item.notifyItemPressedEnd();
    }

    protected void setContentWidth(int width) {
        this.contentWidth = width;
    }

    protected void setContentHeight(int height) {
        this.contentHeight = height;
    }

    protected void onScreenSizeChanged(int screenWidth, int screenHeight) {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.availableHeight = dataInputStream.readInt();
        this.availableWidth = dataInputStream.readInt();
        this.contentHeight = dataInputStream.readInt();
        this.contentWidth = dataInputStream.readInt();
        this.isFocused = dataInputStream.readBoolean();
        this.isLayoutCenter = dataInputStream.readBoolean();
        this.isLayoutRight = dataInputStream.readBoolean();
        this.layout = dataInputStream.readInt();
        this.paddingHorizontal = dataInputStream.readInt();
        this.paddingVertical = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.availableHeight);
        dataOutputStream.writeInt(this.availableWidth);
        dataOutputStream.writeInt(this.contentHeight);
        dataOutputStream.writeInt(this.contentWidth);
        dataOutputStream.writeBoolean(this.isFocused);
        dataOutputStream.writeBoolean(this.isLayoutCenter);
        dataOutputStream.writeBoolean(this.isLayoutRight);
        dataOutputStream.writeInt(this.layout);
        dataOutputStream.writeInt(this.paddingHorizontal);
        dataOutputStream.writeInt(this.paddingVertical);
    }
}

