/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.event.EventManager;
import de.enough.polish.event.GestureEvent;
import de.enough.polish.event.UiEventListener;
import de.enough.polish.ui.Animatable;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.CycleListener;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.ItemTransition;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiElement;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DeviceControl;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.RgbImage;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Item
implements UiElement,
Animatable {
    public static final int TRANSPARENT = -1;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    public static final int INTERACTIVE = 3;
    private static final ArrayList COMMANDS = new ArrayList();
    protected int layout;
    protected ItemCommandListener itemCommandListener;
    protected Command defaultCommand;
    protected int preferredWidth;
    protected int preferredHeight;
    protected Dimension cssWidth;
    protected Dimension minimumWidth;
    protected Dimension minimumHeight;
    protected Dimension maximumWidth;
    boolean isInitialized;
    public Background background;
    protected Border border;
    protected Style style;
    public int itemWidth;
    public int itemHeight;
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;
    protected int paddingVertical;
    protected int paddingHorizontal;
    protected int marginLeft;
    protected int marginTop;
    protected int marginRight;
    protected int marginBottom;
    protected int contentWidth;
    protected int contentHeight;
    protected int availContentWidth;
    protected int availContentHeight;
    protected int backgroundWidth;
    protected int backgroundHeight;
    public int appearanceMode;
    protected Screen screen;
    protected String cssSelector;
    protected boolean isStyleInitialised;
    protected Item parent;
    protected ArrayList commands;
    protected boolean isLayoutCenter;
    protected boolean isLayoutExpand;
    protected boolean isLayoutRight;
    public int relativeX;
    public int relativeY;
    protected int contentX;
    protected int contentY;
    public static final int NO_POSITION_SET = -9999;
    protected int internalX = -9999;
    protected int internalY;
    protected int internalWidth;
    protected int internalHeight;
    public boolean isFocused;
    protected boolean isJustFocused;
    private String beforeUrl;
    private int beforeWidth;
    private int beforeHeight;
    private Image beforeImage;
    private String afterUrl;
    private int afterWidth;
    private int afterHeight;
    private Image afterImage;
    protected Style labelStyle = StyleSheet.labelStyle;
    protected StringItem label;
    protected boolean useSingleRow;
    protected Style focusedStyle;
    protected boolean isPressed;
    private Style normalStyle;
    private Style pressedStyle;
    protected boolean includeLabel;
    protected int backgroundYOffset;
    protected ItemView view;
    protected boolean preserveViewType;
    protected boolean setView;
    protected boolean isInvisible;
    private int invisibleAppearanceModeCache;
    private int invisibleItemHeight;
    protected boolean isShown;
    private HashMap attributes;
    private ItemStateListener itemStateListener;
    protected boolean isInlineLabel;
    protected int availableWidth;
    protected int availableHeight;
    protected boolean ignoreRepaintRequests;
    private ItemTransition itemTransition;
    private boolean preserveBackground;
    private boolean preserveBorder;
    protected Style landscapeStyle;
    protected Style portraitStyle;
    private UiEventListener uiEventListener;
    private CycleListener cycleListener;

    protected Item() {
        this(null, 0, 0, null);
    }

    protected Item(Style style) {
        this(null, 0, 0, style);
    }

    protected Item(String label, int layout) {
        this(label, layout, 0, null);
    }

    protected Item(String label, int layout, int appearanceMode, Style style) {
        this.style = style;
        this.layout = layout;
        this.appearanceMode = appearanceMode;
        if (label != null && label.length() != 0) {
            this.setLabel(label);
        }
        if (style == null) {
            this.layout = layout;
        } else {
            this.style = style;
            this.isStyleInitialised = false;
        }
    }

    public void setLabel(String label) {
        if (this.label == null) {
            this.label = new StringItem(null, label, this.labelStyle);
            this.label.parent = this;
            if (this.isShown) {
                this.label.showNotify();
            }
        } else {
            if (label == null && this.label.getText() == null || label != null && label.equals(this.label.getText())) {
                return;
            }
            this.label.setText(label);
        }
        if (this.isInitialized()) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getText();
    }

    public Item getLabelItem() {
        return this.label;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        if (layout != this.layout) {
            this.layout = layout;
            if ((layout & 3) == 3) {
                this.isLayoutCenter = true;
                this.isLayoutRight = false;
            } else {
                this.isLayoutCenter = false;
                this.isLayoutRight = (layout & 2) == 2;
            }
            this.isLayoutExpand = (layout & 0x800) == 2048;
            if (this.isInitialized()) {
                this.setInitialized(false);
                this.repaint();
            } else if (!this.isStyleInitialised && this.style != null) {
                this.setStyle(this.style);
                this.layout = layout;
            }
        }
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    public void setAppearanceMode(int appearanceMode) {
        this.appearanceMode = appearanceMode;
    }

    public void setView(ItemView view) {
        if (!this.isStyleInitialised && this.style != null) {
            this.setStyle(this.style);
        }
        this.view = view;
        if (view != null && this.style != null) {
            view.setStyle(this.style);
        }
    }

    public ItemView getView() {
        return this.view;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setBackground(Background background) {
        this.preserveBackground = true;
        this.background = background;
        this.background.setParentItem(this);
    }

    public void setBorder(Border border) {
        this.preserveBorder = true;
        this.border = border;
    }

    public void setStyle() {
    }

    public void setStyle(Style style) {
        Style lsStyle;
        Boolean inlineBool;
        ItemView viewType;
        Style pressed;
        Style focused;
        Style labStyle;
        this.isStyleInitialised = true;
        this.style = style;
        if (style != StyleSheet.defaultStyle) {
            this.setLayout(style.layout);
        }
        if (this.isShown) {
            if (this.background != style.background && !this.preserveBackground) {
                if (this.background != null) {
                    this.background.hideNotify();
                }
                if (style.background != null) {
                    style.background.showNotify();
                }
            }
            if (this.border != style.border && !this.preserveBackground) {
                if (this.border != null) {
                    this.border.hideNotify();
                }
                if (style.border != null) {
                    style.border.showNotify();
                }
            }
        }
        if (!this.preserveBackground) {
            this.background = style.background;
        }
        if (!this.preserveBorder) {
            this.border = style.border;
        }
        if ((labStyle = (Style)style.getObjectProperty(3)) != null) {
            this.labelStyle = labStyle;
        } else if (this.labelStyle == null) {
            this.labelStyle = StyleSheet.labelStyle;
        }
        if (this.label != null) {
            this.label.setStyle(this.labelStyle);
        }
        if ((focused = (Style)style.getObjectProperty(1)) != null) {
            this.focusedStyle = focused;
        }
        if ((pressed = (Style)style.getObjectProperty(292)) != null) {
            this.pressedStyle = pressed;
        }
        if ((viewType = (ItemView)style.getObjectProperty(39)) != null && viewType.isValid(this, style)) {
            this.view = this.getView(viewType, style);
        }
        if (this.view != null) {
            this.view.setStyle(style);
        }
        if ((inlineBool = style.getBooleanProperty(383)) != null) {
            this.isInlineLabel = inlineBool;
        }
        if ((lsStyle = (Style)style.getObjectProperty(397)) != null && lsStyle != style) {
            this.landscapeStyle = lsStyle;
            if (!this.isFocused && style.name != null && style.name.indexOf("landscape") == -1) {
                this.portraitStyle = style;
            }
        }
        this.setStyle(style, true);
        this.setInitialized(false);
    }

    protected ItemView getView(ItemView viewType, Style viewStyle) {
        if (this.view == null || this.view.getClass() != viewType.getClass()) {
            try {
                viewType = (ItemView)viewType.getClass().newInstance();
                viewType.parentItem = this;
                if (this.isShown) {
                    if (this.view != null) {
                        this.view.hideNotify();
                    }
                    viewType.showNotify();
                }
                return viewType;
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Item", 1383, (Object)"Container: Unable to init view-type ", e);
            }
        }
        return this.view;
    }

    public void setStyle(Style style, boolean resetStyle) {
        Boolean visibleBool;
        Boolean includeLabelBool;
        Dimension minHeightDim;
        Dimension widthDim;
        Dimension maxWidthDim;
        String beforeUrlStr;
        if (!resetStyle && this.isInitialized()) {
            Dimension value = (Dimension)style.getObjectProperty(32713);
            if (value != null) {
                int margin;
                this.marginLeft = margin = value.getValue(this.availableWidth);
                this.marginRight = margin;
                this.marginTop = margin;
                this.marginBottom = margin;
            }
            if ((value = (Dimension)style.getObjectProperty(-3)) != null) {
                this.marginRight = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-4)) != null) {
                this.marginTop = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-5)) != null) {
                this.marginBottom = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-6)) != null) {
                int padding;
                this.paddingLeft = padding = value.getValue(this.availableWidth);
                this.paddingRight = padding;
                this.paddingTop = padding;
                this.paddingHorizontal = padding;
                this.paddingVertical = padding;
            }
            if ((value = (Dimension)style.getObjectProperty(-7)) != null) {
                this.paddingLeft = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-8)) != null) {
                this.paddingRight = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-9)) != null) {
                this.paddingTop = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-10)) != null) {
                this.paddingBottom = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-11)) != null) {
                this.paddingHorizontal = value.getValue(this.availableWidth);
            }
            if ((value = (Dimension)style.getObjectProperty(-12)) != null) {
                this.paddingVertical = value.getValue(this.availableWidth);
            }
        }
        if ((beforeUrlStr = style.getProperty(190)) != null) {
            if (!beforeUrlStr.equals(this.beforeUrl)) {
                try {
                    this.beforeImage = StyleSheet.getImage(beforeUrlStr, null, true);
                    this.beforeWidth = this.beforeImage.getWidth();
                    this.beforeHeight = this.beforeImage.getHeight();
                }
                catch (IOException e) {
                    this.beforeUrl = null;
                    this.beforeImage = null;
                    this.beforeWidth = 0;
                    this.beforeHeight = 0;
                }
            }
            this.beforeUrl = beforeUrlStr;
        } else if (resetStyle) {
            this.beforeImage = null;
            this.beforeWidth = 0;
            this.beforeHeight = 0;
            this.beforeUrl = beforeUrlStr;
        }
        String afterUrlStr = style.getProperty(191);
        if (afterUrlStr != null) {
            if (!afterUrlStr.equals(this.afterUrl)) {
                try {
                    this.afterImage = StyleSheet.getImage(afterUrlStr, null, true);
                    this.afterWidth = this.afterImage.getWidth();
                    this.afterHeight = this.afterImage.getHeight();
                }
                catch (IOException e) {
                    this.afterUrl = null;
                    this.afterWidth = 0;
                    this.afterHeight = 0;
                    this.afterImage = null;
                }
            }
            this.afterUrl = afterUrlStr;
        } else if (resetStyle) {
            this.afterWidth = 0;
            this.afterHeight = 0;
            this.afterImage = null;
            this.afterUrl = afterUrlStr;
        }
        Dimension minWidthDim = (Dimension)style.getObjectProperty(58);
        if (minWidthDim != null) {
            this.minimumWidth = minWidthDim;
        }
        if ((maxWidthDim = (Dimension)style.getObjectProperty(59)) != null) {
            this.maximumWidth = maxWidthDim;
        }
        if ((widthDim = (Dimension)style.getObjectProperty(226)) != null) {
            this.cssWidth = widthDim;
        }
        if ((minHeightDim = (Dimension)style.getObjectProperty(144)) != null) {
            this.minimumHeight = minHeightDim;
        }
        if ((includeLabelBool = style.getBooleanProperty(132)) != null) {
            this.includeLabel = includeLabelBool;
        }
        if ((visibleBool = style.getBooleanProperty(311)) != null) {
            this.setVisible(visibleBool);
        }
        if (resetStyle || this.isInitialized()) {
            // empty if block
        }
    }

    public int getItemWidth(int firstLineWidth, int availWidth) {
        return this.getItemWidth(firstLineWidth, availWidth, this.availableHeight);
    }

    public int getItemWidth(int firstLineWidth, int availWidth, int availHeight) {
        if (!this.isInitialized() || this.availableWidth != availWidth || this.availableHeight != availHeight) {
            this.init(firstLineWidth, availWidth, availHeight);
        }
        return this.itemWidth;
    }

    public int getItemHeight(int firstLineWidth, int availWidth) {
        return this.getItemHeight(firstLineWidth, availWidth, this.availableHeight);
    }

    public int getItemHeight(int firstLineWidth, int availWidth, int availHeight) {
        if (!this.isInitialized() || this.availableWidth != availWidth || this.availableHeight != availHeight) {
            this.init(firstLineWidth, availWidth, availHeight);
        }
        return this.itemHeight;
    }

    public void addCommand(Command cmd) {
        this.addCommand(cmd, null);
    }

    public void addCommand(Command cmd, Style commandStyle) {
        if (this.commands == null) {
            this.commands = new ArrayList();
        }
        if (!this.commands.contains(cmd)) {
            this.commands.add(cmd);
            if (this.isInvisible) {
                if (this.invisibleAppearanceModeCache == 0) {
                    this.invisibleAppearanceModeCache = 1;
                }
            } else if (this.appearanceMode == 0) {
                this.appearanceMode = 1;
            }
            if (this.isFocused) {
                this.showCommands();
            }
            if (this.isInitialized) {
                this.repaint();
            }
        }
    }

    public void removeCommand(Command cmd) {
        if (this.commands != null) {
            if (cmd == this.defaultCommand) {
                this.defaultCommand = null;
            }
            if (this.commands.remove(cmd)) {
                Screen scr;
                if (this.isFocused && (scr = this.getScreen()) != null) {
                    scr.removeCommand(cmd);
                }
                if (this.isInitialized) {
                    this.repaint();
                }
            }
        }
    }

    protected void repaintFully() {
        Screen scr = this.getScreen();
        if (scr != null && scr == StyleSheet.currentScreen) {
            scr.requestRepaint();
        }
    }

    protected void repaint() {
        if (this.ignoreRepaintRequests) {
            return;
        }
        if (this.isInvisible) {
            return;
        }
        if (this.isInitialized) {
            this.repaint(-(this.paddingLeft + this.marginLeft + this.getBorderWidthLeft()), -(this.paddingTop + this.marginTop + this.getBorderWidthTop()), this.itemWidth, this.itemHeight);
        } else {
            this.repaintFully();
        }
    }

    protected int getBorderWidthLeft() {
        if (this.border != null) {
            return this.border.borderWidthLeft;
        }
        if (this.background != null) {
            return this.background.borderWidth;
        }
        return 0;
    }

    protected int getBorderWidthRight() {
        if (this.border != null) {
            return this.border.borderWidthRight;
        }
        if (this.background != null) {
            return this.background.borderWidth;
        }
        return 0;
    }

    protected int getBorderWidthTop() {
        if (this.border != null) {
            return this.border.borderWidthTop;
        }
        if (this.background != null) {
            return this.background.borderWidth;
        }
        return 0;
    }

    protected int getBorderWidthBottom() {
        if (this.border != null) {
            return this.border.borderWidthBottom;
        }
        if (this.background != null) {
            return this.background.borderWidth;
        }
        return 0;
    }

    protected void repaint(int relX, int relY, int width, int height) {
        Screen scr = this.getScreen();
        if (scr != null) {
            scr.requestRepaint(relX += this.getAbsoluteX(), relY += this.getAbsoluteY(), width, height + 1);
        }
    }

    public void requestInit() {
        if (this.isInitialized) {
            this.setInitialized(false);
            Item p = this.parent;
            while (p != null) {
                p.setInitialized(false);
                p = p.parent;
            }
            Screen scr = this.getScreen();
            if (scr != null) {
                scr.requestInit();
            }
            if (this.isShown) {
                this.repaint();
            }
        }
    }

    public Screen getScreen() {
        Item p = this;
        while (p != null) {
            if (p.screen != null) {
                return p.screen;
            }
            p = p.parent;
        }
        return null;
    }

    public void setItemCommandListener(ItemCommandListener l) {
        this.itemCommandListener = l;
    }

    public ItemCommandListener getItemCommandListener() {
        return this.itemCommandListener;
    }

    public void setItemStateListener(ItemStateListener listener) {
        this.itemStateListener = listener;
    }

    public ItemStateListener getItemStateListener() {
        return this.itemStateListener;
    }

    public int getpreferredWidth() {
        return this.preferredWidth;
    }

    public int getpreferredHeight() {
        return this.preferredHeight;
    }

    public void setpreferredSize(int width, int height) {
        this.preferredHeight = height;
        this.preferredWidth = width;
    }

    public int getMinimumWidth() {
        return this.getMinimumWidth(100);
    }

    public int getMinimumWidth(int availWidth) {
        if (this.minimumWidth != null) {
            return this.minimumWidth.getValue(availWidth);
        }
        return 0;
    }

    public int getMinimumHeight() {
        return this.getMinimumHeight(100);
    }

    public int getMinimumHeight(int availHeight) {
        if (this.minimumHeight != null) {
            return this.minimumHeight.getValue(availHeight);
        }
        return 0;
    }

    public int getMaximumWidth() {
        return this.getMaximumWidth(100);
    }

    public int getMaximumWidth(int availWidth) {
        if (this.maximumWidth != null) {
            return this.maximumWidth.getValue(availWidth);
        }
        return 0;
    }

    public void setDefaultCommand(Command cmd) {
        Screen scr;
        if (this.defaultCommand != null && cmd != this.defaultCommand) {
            this.addCommand(this.defaultCommand);
        }
        this.defaultCommand = cmd;
        if (cmd != null) {
            this.addCommand(cmd);
        }
        if (this.isFocused && (scr = this.getScreen()) != null) {
            scr.notifyDefaultCommand(cmd);
        }
    }

    public void notifyStateChanged() {
        Screen scr;
        if (this.itemStateListener != null) {
            try {
                this.itemStateListener.itemStateChanged(this);
                return;
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Item", 2528, (Object)("Unable to forward ItemStateChanged event to listener " + this.itemStateListener), e);
            }
        }
        if ((scr = StyleSheet.currentScreen) == null) {
            scr = this.getScreen();
        }
        if (scr != null) {
            scr.notifyStateListener(this);
        }
    }

    protected void notifyValueChanged(Object newValue) {
    }

    void setAvailableDimensions(int leftBorder, int rightBorder) {
        int w = rightBorder - leftBorder;
        int h = 0;
        Item p = this.parent;
        if (p != null) {
            while (p != null && (w < 1 || h < 1)) {
                if (p.contentWidth != 0) {
                    if (h < 1) {
                        h = Math.min(p.contentHeight, p.availableHeight);
                    }
                    if (w < 1) {
                        w = Math.min(p.contentWidth, p.availableWidth);
                    }
                } else {
                    if (h < 1) {
                        h = p.availableHeight;
                    }
                    if (w < 1) {
                        w = p.availableWidth;
                    }
                }
                p = p.parent;
            }
        } else {
            Screen scr = this.getScreen();
            if (scr != null) {
                h = scr.contentHeight;
                if (w < 1) {
                    w = scr.contentWidth;
                }
            }
        }
        this.availableWidth = w;
        this.availableHeight = h;
    }

    public void paint(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean isBottom;
        StringItem labelItem;
        if (this.isInvisible) {
            return;
        }
        if (!this.isInitialized) {
            if (this.availableWidth == 0) {
                this.setAvailableDimensions(leftBorder, rightBorder);
            }
            int previousItemWidth = this.itemWidth;
            int previousItemHeight = this.itemHeight;
            this.init(this.availableWidth, this.availableWidth, this.availableHeight);
            if (this.itemHeight < previousItemHeight && this.isLayoutVerticalExpand()) {
                this.setItemHeight(previousItemHeight);
            }
            if ((previousItemWidth != this.itemWidth || previousItemHeight != this.itemHeight) && this.parent != null) {
                this.parent.requestInit();
            }
        }
        int origX = x;
        int origY = y;
        if (this.includeLabel) {
            int width = this.itemWidth - this.marginLeft - this.marginRight;
            int height = this.itemHeight - this.marginTop - this.marginBottom;
            int bX = x + this.marginLeft;
            int bY = y + this.marginTop + this.backgroundYOffset;
            this.paintBackgroundAndBorder(bX, bY, width, height, g);
        }
        if ((labelItem = this.label) != null) {
            int labelX = x + labelItem.relativeX;
            labelItem.paint(labelX, y + labelItem.relativeY, labelX, labelX + labelItem.itemWidth, g);
            if (this.useSingleRow) {
                leftBorder += labelItem.itemWidth;
            } else {
                y += labelItem.itemHeight;
            }
        }
        leftBorder += this.marginLeft + this.getBorderWidthLeft() + this.paddingLeft;
        leftBorder += this.getBeforeWidthWithPadding();
        rightBorder -= this.marginRight + this.getBorderWidthRight() + this.paddingRight;
        rightBorder -= this.getAfterWidthWithPadding();
        x += this.marginLeft;
        y += this.marginTop;
        if (!this.includeLabel) {
            int backgroundX = x;
            if (labelItem != null && this.useSingleRow) {
                backgroundX += labelItem.itemWidth;
            }
            this.paintBackgroundAndBorder(backgroundX, y, this.backgroundWidth, this.backgroundHeight, g);
        }
        x += this.contentX - this.marginLeft;
        y += this.contentY - this.marginTop;
        if (labelItem != null && !this.useSingleRow) {
            y -= labelItem.itemHeight;
        }
        int originalContentY = y;
        boolean isVerticalCenter = (this.layout & 0x30) == 48;
        boolean isTop = !isVerticalCenter && (this.layout & 0x10) == 16;
        boolean bl = isBottom = !isVerticalCenter && (this.layout & 0x20) == 32;
        if (this.beforeImage != null) {
            int beforeX = origX + this.getBorderWidthLeft() + this.paddingLeft + this.marginLeft;
            if (labelItem != null && this.useSingleRow) {
                beforeX += labelItem.itemWidth;
            }
            int beforeY = y;
            int yAdjust = this.beforeHeight - this.contentHeight;
            if (this.beforeHeight < this.contentHeight) {
                if (!isTop) {
                    beforeY = isBottom ? (beforeY += yAdjust) : (beforeY -= yAdjust >> 1);
                }
            } else if (!isTop) {
                y = isBottom ? (y += yAdjust) : (y += yAdjust >> 1);
            }
            if (this.isLayoutRight) {
                beforeX = rightBorder - (this.contentWidth + this.beforeWidth);
            }
            g.drawImage(this.beforeImage, beforeX, beforeY, 20);
            x += this.getBeforeWidthWithPadding();
        }
        if (this.afterImage != null) {
            int afterY = originalContentY;
            int yAdjust = this.afterHeight - this.contentHeight;
            if (this.afterHeight < this.contentHeight) {
                afterY = isTop ? (afterY -= yAdjust) : (isBottom ? (afterY += yAdjust) : (afterY -= yAdjust >> 1));
            } else if (this.afterHeight > this.beforeHeight && !isTop) {
                y = isBottom ? originalContentY + yAdjust : originalContentY + (yAdjust >> 1);
            }
            g.drawImage(this.afterImage, rightBorder + this.paddingHorizontal, afterY, 20);
        }
        if (this.view != null) {
            this.view.paintContent(this, x, y, leftBorder, rightBorder, g);
        } else {
            this.paintContent(x, y, leftBorder, rightBorder, g);
        }
    }

    protected void paintCommands(int x, int y, Graphics g) {
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.background != null) {
            int bWidthL = 0;
            int bWidthR = 0;
            int bWidthT = 0;
            int bWidthB = 0;
            if (this.border != null) {
                bWidthL = this.getBorderWidthLeft();
                bWidthR = this.getBorderWidthRight();
                bWidthT = this.getBorderWidthTop();
                bWidthB = this.getBorderWidthBottom();
                x += bWidthL;
                y += bWidthT;
                width -= bWidthL + bWidthR;
                height -= bWidthT + bWidthB;
            }
            this.paintBackground(x, y, width, height, g);
            if (this.border != null) {
                x -= bWidthL;
                y -= bWidthT;
                width += bWidthL + bWidthR;
                height += bWidthT + bWidthB;
            }
        }
        if (this.border != null) {
            this.paintBorder(x, y, width, height, g);
        }
    }

    protected void paintBorder(int x, int y, int width, int height, Graphics g) {
        if (this.view != null) {
            this.view.paintBorder(this.border, x, y, width, height, g);
        } else {
            this.border.paint(x, y, width, height, g);
        }
    }

    protected void paintBackground(int x, int y, int width, int height, Graphics g) {
        if (this.view != null) {
            this.view.paintBackground(this.background, x, y, width, height, g);
        } else {
            this.background.paint(x, y, width, height, g);
        }
    }

    protected RgbImage paintFilter(int x, int y, RgbFilter[] partFilters, RgbImage rgbImage, int lo, Graphics g) {
        int origWidth = rgbImage.getWidth();
        int origHeight = rgbImage.getHeight();
        for (int i = 0; i < partFilters.length; ++i) {
            RgbFilter filter = partFilters[i];
            rgbImage = filter.process(rgbImage);
        }
        int width = rgbImage.getWidth();
        int height = rgbImage.getHeight();
        int[] rgb = rgbImage.getRgbData();
        if (origWidth != width) {
            if ((lo & 3) == 3) {
                x -= (width - origWidth) / 2;
            } else if ((lo & 3) == 2) {
                x -= width - origWidth;
            }
        }
        if (origHeight != height) {
            if ((lo & 0x30) == 48) {
                y -= (height - origHeight) / 2;
            } else if ((lo & 0x30) == 16) {
                y -= height - origHeight;
            }
        }
        DrawUtil.drawRgb(rgb, x, y, width, height, true, g);
        return rgbImage;
    }

    protected void init(int firstLineWidth, int availWidth, int availHeight) {
        int minHeight;
        int maxWidth;
        int minWidth;
        ItemView myView;
        int noneContentHeight;
        Style myStyle;
        this.availableWidth = availWidth;
        this.availableHeight = availHeight;
        if (this.isInvisible) {
            this.itemWidth = 0;
            this.itemHeight = 0;
            return;
        }
        if (this.style != null && !this.isStyleInitialised) {
            this.setStyle(this.style);
        } else if (this.style == null) {
            this.initStyle();
        }
        if (this.view != null) {
            this.view.parentItem = this;
        }
        if ((myStyle = this.style) != null) {
            this.initLayout(myStyle, availWidth);
        }
        int labelWidth = 0;
        int labelHeight = 0;
        StringItem labelItem = this.label;
        if (labelItem != null) {
            labelWidth = labelItem.getItemWidth(firstLineWidth, availWidth, availHeight);
            labelHeight = labelItem.itemHeight;
        }
        int noneContentWidth = this.marginLeft + this.getBorderWidthLeft() + this.paddingLeft + this.paddingRight + this.getBorderWidthRight() + this.marginRight;
        noneContentWidth += this.getBeforeWidthWithPadding();
        int firstLineContentWidth = firstLineWidth - (noneContentWidth += this.getAfterWidthWithPadding());
        int availableContentWidth = availWidth - noneContentWidth;
        if (this.maximumWidth != null) {
            int maxWidth2 = this.maximumWidth.getValue(availableContentWidth);
            if (firstLineContentWidth > maxWidth2) {
                firstLineContentWidth = maxWidth2;
            }
            if (availableContentWidth > maxWidth2) {
                availableContentWidth = maxWidth2;
            }
        }
        int targetWidth = 0;
        if (this.cssWidth != null) {
            firstLineContentWidth = availableContentWidth = this.cssWidth.getValue(availWidth - noneContentWidth);
            targetWidth = availableContentWidth;
        }
        this.contentX = this.marginLeft + this.getBorderWidthLeft() + this.paddingLeft;
        this.contentX += this.getBeforeWidthWithPadding();
        this.contentY = noneContentHeight = this.marginTop + this.getBorderWidthTop() + this.paddingTop;
        this.availContentWidth = availableContentWidth;
        this.availContentHeight = availHeight -= (noneContentHeight += this.paddingBottom + this.getBorderWidthBottom() + this.marginBottom);
        if (this.isInlineLabel && labelWidth < 90 * availWidth / 100) {
            firstLineContentWidth -= labelWidth;
            availableContentWidth -= labelWidth;
        }
        if ((myView = this.view) != null) {
            myView.init(this, firstLineContentWidth, availableContentWidth, availHeight);
            this.contentWidth = myView.contentWidth;
            this.contentHeight = myView.contentHeight;
        } else {
            this.initContent(firstLineContentWidth, availableContentWidth, availHeight);
        }
        if (this.isInlineLabel && labelWidth < 90 * availWidth / 100) {
            availableContentWidth += labelWidth;
        }
        int cWidth = this.contentWidth;
        int cHeight = this.contentHeight;
        if (cWidth == 0 && cHeight == 0) {
            this.itemWidth = labelWidth;
            this.itemHeight = labelHeight;
            this.backgroundHeight = 0;
            this.backgroundWidth = 0;
            this.setInitialized(true);
            return;
        }
        if (cWidth > availableContentWidth) {
            cWidth = availableContentWidth;
        }
        if (this.cssWidth != null) {
            this.setContentWidth(targetWidth);
            int diff = this.contentWidth - cWidth;
            if (this.isLayoutCenter()) {
                this.contentX += diff / 2;
            } else if (this.isLayoutRight()) {
                this.contentX += diff;
            }
            cWidth = this.contentWidth;
        }
        if (this.minimumWidth != null && cWidth < (minWidth = this.minimumWidth.getValue(availWidth - noneContentWidth))) {
            this.setContentWidth(minWidth);
            int diff = this.contentWidth - cWidth;
            if (this.isLayoutCenter()) {
                this.contentX += diff / 2;
            } else if (this.isLayoutRight()) {
                this.contentX += diff;
            }
            cWidth = this.contentWidth;
        }
        if (this.maximumWidth != null && cWidth > (maxWidth = this.maximumWidth.getValue(availWidth - noneContentWidth))) {
            this.setContentWidth(maxWidth);
            cWidth = this.contentWidth;
        }
        this.itemWidth = noneContentWidth + cWidth;
        if (this.isLayoutExpand) {
            if (cWidth < availableContentWidth) {
                int iWidth = this.itemWidth;
                iWidth = this.maximumWidth == null && this.itemWidth + labelWidth <= availWidth && (this.label == null || !this.label.isLayoutNewlineAfter() && !this.isLayoutNewlineBefore()) ? (iWidth += availableContentWidth - cWidth - labelWidth) : (iWidth += availableContentWidth - cWidth);
                this.setItemWidth(iWidth);
            }
        } else if (this.itemWidth > availWidth) {
            this.setItemWidth(availWidth);
        }
        if (this.itemWidth + labelWidth <= availWidth) {
            this.useSingleRow = true;
            if (this.label != null && ((this.label.layout & 0x200) != 0 || (this.layout & 0x100) == 256)) {
                this.useSingleRow = false;
                cHeight += labelHeight;
                this.contentY += labelHeight;
                if (this.itemWidth < labelWidth) {
                    this.setItemWidth(labelWidth);
                }
            }
            if (this.useSingleRow && labelWidth > 0) {
                this.itemWidth += labelWidth;
                this.contentX += labelWidth;
                if (cHeight + noneContentHeight < labelHeight) {
                    cHeight = labelHeight - noneContentHeight;
                }
            }
        } else {
            this.useSingleRow = false;
            cHeight += labelHeight;
            this.contentY += labelHeight;
            if (labelWidth > 0) {
                int labelX = 0;
                if (this.isLayoutCenter()) {
                    labelX = (this.itemWidth - availWidth) / 2;
                } else if (this.isLayoutRight()) {
                    labelX = this.itemWidth - availWidth;
                } else if (this.includeLabel) {
                    labelX += this.marginLeft;
                }
                if (this.label.isLayoutCenter()) {
                    labelX += (availWidth - labelWidth) / 2;
                } else if (this.label.isLayoutRight()) {
                    labelX += availWidth - labelWidth;
                }
                this.label.relativeX = labelX;
            }
        }
        int originalContentHeight = cHeight;
        int heightRelativeValue = availWidth;
        if (this.minimumHeight != null && cHeight < (minHeight = this.minimumHeight.getValue(heightRelativeValue))) {
            this.setContentHeight(minHeight);
            cHeight = this.contentHeight;
        }
        if (cHeight > originalContentHeight) {
            int ch = cHeight;
            if (!this.useSingleRow) {
                ch -= labelHeight;
            }
            if (this.isLayoutVerticalCenter()) {
                this.contentY += ch - originalContentHeight >> 1;
            } else if (this.isLayoutBottom()) {
                this.contentY += ch - originalContentHeight;
            }
        }
        if (cHeight < this.beforeHeight) {
            cHeight = this.beforeHeight;
        }
        if (cHeight < this.afterHeight) {
            cHeight = this.afterHeight;
        }
        this.itemHeight = cHeight + noneContentHeight;
        if (this.useSingleRow) {
            this.backgroundWidth = this.itemWidth - this.marginLeft - this.marginRight - labelWidth;
            this.backgroundHeight = cHeight + noneContentHeight - this.marginTop - this.marginBottom;
        } else {
            this.backgroundWidth = this.itemWidth - this.marginLeft - this.marginRight;
            this.backgroundHeight = cHeight + noneContentHeight - this.marginTop - this.marginBottom - labelHeight;
        }
        if (labelWidth > 0 && this.useSingleRow && labelHeight < this.itemHeight) {
            if (this.label.isLayoutVerticalCenter()) {
                this.label.relativeY = (this.itemHeight - labelHeight) / 2;
            } else if (this.label.isLayoutBottom()) {
                this.label.relativeY = this.itemHeight - labelHeight;
            }
        }
        if (this.isInvisible) {
            this.itemWidth = 0;
            this.itemHeight = 0;
        }
        this.setInitialized(true);
    }

    protected int getBeforeWidthWithPadding() {
        int w = this.beforeWidth;
        if (w != 0) {
            w += this.paddingHorizontal;
        }
        return w;
    }

    protected int getAfterWidthWithPadding() {
        int w = this.afterWidth;
        if (w != 0) {
            w += this.paddingHorizontal;
        }
        return w;
    }

    protected void initLayout(Style layoutStyle, int availWidth) {
        if (this.view != null) {
            this.view.initPadding(layoutStyle, availWidth);
        } else {
            this.initPadding(layoutStyle, availWidth);
        }
        if (this.view != null) {
            this.view.initMargin(layoutStyle, availWidth);
        } else {
            this.initMargin(layoutStyle, availWidth);
        }
    }

    protected void initMargin(Style itemStyle, int availWidth) {
        this.marginLeft = itemStyle.getMarginLeft(availWidth);
        this.marginRight = itemStyle.getMarginRight(availWidth);
        this.marginTop = itemStyle.getMarginTop(availWidth);
        this.marginBottom = itemStyle.getMarginBottom(availWidth);
    }

    protected void initPadding(Style itemStyle, int availWidth) {
        this.paddingLeft = itemStyle.getPaddingLeft(availWidth);
        this.paddingRight = itemStyle.getPaddingRight(availWidth);
        this.paddingTop = itemStyle.getPaddingTop(availWidth);
        this.paddingBottom = itemStyle.getPaddingBottom(availWidth);
        this.paddingVertical = itemStyle.getPaddingVertical(availWidth);
        this.paddingHorizontal = itemStyle.getPaddingHorizontal(availWidth);
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public int getPaddingHorizontal() {
        return this.paddingHorizontal;
    }

    public int getPaddingVertical() {
        return this.paddingVertical;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    protected void setContentWidth(int width) {
        this.contentWidth = width;
        if (this.view != null) {
            this.view.setContentWidth(width);
        }
    }

    protected void setContentHeight(int height) {
        this.contentHeight = height;
        if (this.view != null) {
            this.view.setContentHeight(height);
        }
    }

    protected void initStyle() {
        if (this.screen == null) {
            this.screen = this.parent != null ? this.getScreen() : StyleSheet.currentScreen;
        }
        if (this.style == null) {
            this.cssSelector = this.createCssSelector();
            Style myStyle = StyleSheet.getStyle(this);
            if (myStyle == null) {
                myStyle = StyleSheet.defaultStyle;
            }
            if (myStyle != null) {
                this.setStyle(myStyle);
            }
        } else {
            this.cssSelector = this.style.name;
        }
        this.isStyleInitialised = true;
    }

    protected abstract void initContent(int var1, int var2, int var3);

    protected abstract void paintContent(int var1, int var2, int var3, int var4, Graphics var5);

    protected abstract String createCssSelector();

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        Screen scr = this.getScreen();
        if (this.appearanceMode != 0 && null != scr && scr.isGameActionFire(keyCode, gameAction)) {
            return this.notifyItemPressedStart();
        }
        if (this.view != null) {
            return this.view.handleKeyPressed(keyCode, gameAction);
        }
        return false;
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        boolean handled = this.handleKeyPressed(keyCode, gameAction);
        if (!handled && this.view != null) {
            handled = this.view.handleKeyPressed(keyCode, gameAction);
        }
        return handled;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        int clearKey;
        Screen scr = this.getScreen();
        if (this.appearanceMode != 0 && this.isPressed && scr != null && scr.isGameActionFire(keyCode, gameAction)) {
            this.notifyItemPressedEnd();
            Item item = this;
            if (this.defaultCommand == null && this.parent != null) {
                item = this.parent;
            }
            if (item.defaultCommand != null) {
                if (!item.defaultCommand.commandAction(this, scr)) {
                    if (item.itemCommandListener != null) {
                        item.itemCommandListener.commandAction(item.defaultCommand, this);
                    } else {
                        scr.callCommandListener(item.defaultCommand);
                    }
                }
                return true;
            }
        }
        if (keyCode == (clearKey = -8) && this.commands != null) {
            Command cmd;
            Command deleteCommand = null;
            Object[] cmds = this.commands.getInternalArray();
            for (int i = 0; i < cmds.length && (cmd = (Command)cmds[i]) != null; ++i) {
                if (cmd.getCommandType() != 3 || deleteCommand != null && deleteCommand.getPriority() <= cmd.getPriority()) continue;
                deleteCommand = cmd;
            }
            if (deleteCommand != null) {
                if (this.itemCommandListener != null) {
                    this.itemCommandListener.commandAction(deleteCommand, this);
                } else if (scr != null) {
                    scr.callCommandListener(deleteCommand);
                }
            }
        }
        if (this.view != null) {
            return this.view.handleKeyReleased(keyCode, gameAction);
        }
        return false;
    }

    public void notifyVisited() {
    }

    public void notifyUnvisited() {
    }

    public boolean notifyItemPressedStart() {
        if (this.isPressed) {
            return false;
        }
        this.isPressed = true;
        boolean handled = false;
        if (this.pressedStyle != null && this.style != this.pressedStyle) {
            this.normalStyle = this.style;
            this.setStyle(this.pressedStyle);
            handled = true;
        }
        return handled;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void notifyItemPressedEnd() {
        if (!this.isPressed) {
            return;
        }
        this.isPressed = false;
        Style previousStyle = this.normalStyle;
        if (previousStyle != null && this.style != previousStyle) {
            boolean removeViewType = this.style.getObjectProperty(39) != null && previousStyle.getObjectProperty(39) == null;
            this.setStyle(previousStyle);
            this.repaint();
            this.normalStyle = null;
            if (removeViewType) {
                this.view = null;
            }
        }
        if (this.parent != null) {
            this.parent.notifyItemPressedEnd();
        }
    }

    public boolean isInContentArea(int relX, int relY) {
        int contTop = this.contentY;
        int contLeft = this.contentX;
        int contW = this.contentWidth;
        if (contW > this.availContentWidth) {
            contW = this.availContentWidth;
        }
        return relY >= contTop && relX >= contLeft && relY <= contTop + this.contentHeight && relX <= contLeft + contW;
    }

    public boolean isInContentWithPaddingArea(int relX, int relY) {
        int contTop = this.contentY - this.paddingTop;
        if (relY < contTop || relY > contTop + this.contentHeight + this.paddingTop + this.paddingBottom) {
            return false;
        }
        int contLeft = this.contentX - this.paddingLeft;
        return relX >= contLeft && relX <= contLeft + this.contentWidth + this.paddingLeft + this.paddingRight;
    }

    public boolean isInItemArea(int relX, int relY) {
        return relY >= 0 && relY <= this.itemHeight && relX >= 0 && relX <= this.itemWidth;
    }

    public boolean isInItemArea(int relX, int relY, Item child) {
        if (child != null) {
            return child.isInItemArea(relX - child.relativeX, relY - child.relativeY);
        }
        return false;
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        if (this.view != null && this.view.handlePointerPressed(relX, relY)) {
            return true;
        }
        if (this.isInItemArea(relX, relY)) {
            return this.handleKeyPressed(0, 8);
        }
        if (this.view != null) {
            return this.view.handlePointerPressed(relX, relY);
        }
        return false;
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        if (this.isJustFocused) {
            this.isJustFocused = false;
            this.handleOnFocusSoftKeyboardDisplayBehavior();
        }
        if (this.view != null && this.view.handlePointerReleased(relX, relY)) {
            return true;
        }
        if (this.isInItemArea(relX, relY)) {
            return this.handleKeyReleased(0, 8);
        }
        if (this.isPressed) {
            this.notifyItemPressedEnd();
            return true;
        }
        if (this.view != null) {
            return this.view.handlePointerReleased(relX, relY);
        }
        return false;
    }

    protected boolean handlePointerDragged(int relX, int relY, ClippingRegion repaintRegion) {
        boolean handled = false;
        if (this.view != null && this.view.handlePointerDragged(relX, relY, repaintRegion)) {
            handled = true;
        }
        if (this.handlePointerDragged(relX, relY)) {
            this.addRepaintArea(repaintRegion);
            handled = true;
        }
        return handled;
    }

    protected boolean handlePointerDragged(int relX, int relY) {
        return false;
    }

    public boolean handlePointerTouchDown(int x, int y) {
        return false;
    }

    public boolean handlePointerTouchUp(int x, int y) {
        return false;
    }

    protected boolean handleGesture(int gesture, int x, int y) {
        boolean handled = false;
        switch (gesture) {
            case 1: {
                handled = this.handleGestureHold(x, y);
                break;
            }
            case 2: {
                handled = this.handleGestureSwipeLeft(x, y);
                break;
            }
            case 3: {
                handled = this.handleGestureSwipeRight(x, y);
            }
        }
        if (!handled) {
            GestureEvent event = GestureEvent.getInstance();
            event.reset(gesture, x, y);
            UiEventListener listener = this.getUiEventListener();
            if (listener != null) {
                listener.handleUiEvent(event, this);
                handled = event.isHandled();
            }
        }
        return handled;
    }

    protected boolean handleGestureHold(int x, int y) {
        return false;
    }

    protected boolean handleGestureSwipeLeft(int x, int y) {
        return false;
    }

    protected boolean handleGestureSwipeRight(int x, int y) {
        return false;
    }

    public void addRepaintArea(ClippingRegion repaintRegion) {
        int absX = this.getAbsoluteX();
        int absY = this.getAbsoluteY();
        int w = this.itemWidth;
        int h = this.itemHeight + 1;
        repaintRegion.addRegion(absX, absY, w, h);
    }

    public void addRelativeToContentRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.contentX + x, this.getAbsoluteY() + this.contentY + y, width, height);
    }

    public void addRelativeToBackgroundRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.getBackgroundX() + x - 1, this.getAbsoluteY() + this.getBackgroundY() + y - 1, width + 2, height + 2);
    }

    public void addRelativeToBackgroundRegion(Background animatedBackground, Border animatedBorder, ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.getBackgroundX() + x - 1, this.getAbsoluteY() + this.getBackgroundY() + y - 1, width + 2, height + 2);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.label != null) {
            this.label.animate(currentTime, repaintRegion);
        }
        if (this.background != null) {
            this.background.animate(this.screen, this, currentTime, repaintRegion);
        }
        if (this.border != null) {
            this.border.animate(this.screen, this, currentTime, repaintRegion);
        }
        if (this.animate()) {
            this.addRepaintArea(repaintRegion);
        }
        if (this.view != null) {
            this.view.animate(currentTime, repaintRegion);
        }
    }

    public boolean animate() {
        return false;
    }

    public Style getFocusedStyle() {
        if (!this.isStyleInitialised) {
            if (this.style != null) {
                this.setStyle(this.style);
            } else {
                this.initStyle();
            }
        }
        Style focStyle = this.focusedStyle != null ? this.focusedStyle : (this.parent != null ? this.parent.getFocusedStyle() : StyleSheet.focusedStyle);
        return focStyle;
    }

    public void handleOnFocusSoftKeyboardDisplayBehavior() {
        DeviceControl.hideSoftKeyboard();
    }

    protected Style focus(Style newStyle, int direction) {
        Style oldStyle = this.style;
        if (!this.isFocused || newStyle != this.style && newStyle != null) {
            if (!this.isStyleInitialised && oldStyle != null) {
                this.setStyle(oldStyle);
            }
            if (newStyle == null) {
                newStyle = this.getFocusedStyle();
            }
            this.preserveViewType = true;
            this.isFocused = true;
            this.isJustFocused = true;
            this.setStyle(newStyle);
            if (this.isPressed) {
                this.normalStyle = newStyle;
            }
            this.preserveViewType = false;
            if (this.commands != null) {
                this.showCommands();
            }
            if (oldStyle == null) {
                oldStyle = StyleSheet.defaultStyle;
            }
        }
        return oldStyle;
    }

    protected void defocus(Style originalStyle) {
        Screen scr;
        if (this.isPressed) {
            this.notifyItemPressedEnd();
        }
        this.backgroundYOffset = 0;
        this.isFocused = false;
        if (originalStyle != null) {
            this.setStyle(originalStyle);
            if (this.label != null) {
                Style prevLabelStyle = this.label.style;
                prevLabelStyle = (Style)originalStyle.getObjectProperty(3);
                if (prevLabelStyle == null) {
                    prevLabelStyle = this.label.style;
                }
                this.label.defocus(prevLabelStyle);
            }
        } else {
            this.background = null;
            this.border = null;
            this.style = null;
        }
        if (this.commands != null && (scr = this.getScreen()) != null) {
            scr.removeItemCommands(this);
        }
    }

    public void showCommands() {
        COMMANDS.clear();
        this.addCommands(COMMANDS);
        Screen scr = this.getScreen();
        if (scr != null) {
            scr.setItemCommands(COMMANDS, this);
        }
    }

    protected void addCommands(ArrayList commandsList) {
        if (this.commands != null) {
            commandsList.addAll(this.commands);
        }
        if (this.parent != null) {
            this.parent.addCommands(commandsList);
        }
    }

    protected boolean handleCommand(Command cmd) {
        if (cmd == this.defaultCommand) {
            this.notifyVisited();
        }
        if (cmd.commandAction(this, null)) {
            return true;
        }
        ItemCommandListener listener = this.itemCommandListener;
        if (this.commands == null || listener == null || !this.commands.contains(cmd)) {
            return false;
        }
        try {
            listener.commandAction(cmd, this);
            return true;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.Item", 5123, (Object)("Unable to handle command " + cmd.getLabel()), e);
            return false;
        }
    }

    protected void showNotify() {
        if (!this.isStyleInitialised && this.style != null) {
            this.setStyle(this.style);
        }
        this.isShown = true;
        if (this.label != null) {
            this.label.showNotify();
        }
        if (this.background != null) {
            this.background.showNotify();
        }
        if (this.border != null) {
            this.border.showNotify();
        }
        if (this.view != null) {
            this.view.showNotify();
        }
    }

    protected void hideNotify() {
        this.isShown = false;
        if (this.label != null) {
            this.label.hideNotify();
        }
        if (this.background != null) {
            this.background.hideNotify();
        }
        if (this.border != null) {
            this.border.hideNotify();
        }
        if (this.view != null) {
            this.view.hideNotify();
        }
        if (this.isPressed) {
            this.notifyItemPressedEnd();
        }
    }

    public void show(Display display) {
        this.show(display, null);
    }

    public void show(Display display, Style screenTransitionStyle) {
        Screen myScreen = this.getScreen();
        if (myScreen == null) {
            return;
        }
        myScreen.focus(this);
        if (screenTransitionStyle != null) {
            display.setCurrent(myScreen, screenTransitionStyle);
        } else {
            display.setCurrent(myScreen);
        }
    }

    public void releaseResources() {
        if (this.background != null) {
            this.background.releaseResources();
        }
        if (this.view != null) {
            this.view.releaseResources();
        }
    }

    public void destroy() {
        this.releaseResources();
        AnimationThread.removeAnimationItem(this);
        if (null != this.itemCommandListener) {
            this.itemCommandListener = null;
        }
        if (null != this.itemStateListener) {
            this.itemStateListener = null;
        }
        if (null != this.parent) {
            this.parent = null;
        }
        if (null != this.screen) {
            this.screen = null;
        }
        if (this.view != null) {
            this.view.destroy();
            this.view = null;
        }
    }

    public void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public Item getItemAt(int relX, int relY) {
        if (this.isInItemArea(relX, relY)) {
            Item item;
            if (this.label != null && (item = this.label.getItemAt(relX, relY)) != null) {
                return item;
            }
            return this;
        }
        return null;
    }

    public int getAbsoluteX() {
        int absX = this.relativeX;
        Item item = this.parent;
        if (item != null && item.label == this && item.useSingleRow) {
            absX -= item.contentX;
        }
        while (item != null) {
            absX += item.relativeX + item.contentX;
            item = item.parent;
        }
        return absX;
    }

    public int getAbsoluteY() {
        int absY = this.relativeY;
        Item item = this.parent;
        if (item != null && item.label == this) {
            absY -= item.contentY;
        }
        while (item != null) {
            absY += item.relativeY + item.contentY;
            if (item instanceof Container) {
                absY += ((Container)item).yOffset;
            }
            item = item.parent;
        }
        return absY;
    }

    public void setAbsoluteY(int absY) {
        int currentAbsY = this.getAbsoluteY();
        int diff = absY - currentAbsY;
        Item item = this;
        while (item.parent != null) {
            item = item.parent;
        }
        if (item instanceof Container) {
            Container container = (Container)item;
            int offset = container.getScrollYOffset() + diff;
            container.setScrollYOffset(offset, false);
        }
    }

    public int getContentX() {
        return this.contentX;
    }

    public int getContentY() {
        return this.contentY;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getAvailableContentWidth() {
        return this.availContentWidth;
    }

    public int getAvailableContentHeight() {
        return this.availContentHeight;
    }

    public int getItemAreaHeight() {
        return Math.max(this.itemHeight, this.marginTop + this.backgroundHeight + this.marginBottom);
    }

    public int getBackgroundX() {
        if (this.includeLabel) {
            return this.marginLeft;
        }
        return this.contentX - this.paddingLeft;
    }

    public int getBackgroundY() {
        if (this.includeLabel) {
            return this.marginTop;
        }
        return this.contentY - this.paddingTop;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public Item getParent() {
        return this.parent;
    }

    public Item getParentRoot() {
        Item p = this;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    public void setParent(Item parent) {
        this.parent = parent;
    }

    public void setParent(javax.microedition.lcdui.Item parent) {
    }

    public void setVisible(boolean visible) {
        boolean invisible;
        boolean bl = invisible = !visible;
        if (invisible == this.isInvisible) {
            return;
        }
        if (this.parent instanceof Container) {
            Container parentContainer = (Container)this.parent;
            if (invisible && this.isFocused) {
                Screen scr = this.getScreen();
                if (scr != null) {
                    scr.removeItemCommands(this);
                }
                int itemIndex = parentContainer.indexOf(this);
                boolean isFocusSet = parentContainer.focusClosestItemAbove(itemIndex);
                this.isFocused = false;
                if (isFocusSet) {
                    if (parentContainer.focusedIndex > itemIndex) {
                        int offset = parentContainer.yOffset + this.itemHeight + parentContainer.paddingVertical;
                        if (offset > 0) {
                            offset = 0;
                        }
                        parentContainer.setScrollYOffset(offset, false);
                    } else {
                        parentContainer.scroll(0, parentContainer.focusedItem, true);
                    }
                } else {
                    parentContainer.focusChild(-1);
                }
                if (this instanceof Container) {
                    ((Container)this).focusChild(-1);
                }
            } else if (!this.isFocused && parentContainer.focusedIndex > parentContainer.indexOf(this)) {
                int offset;
                if (invisible) {
                    offset = parentContainer.getScrollYOffset() + this.itemHeight;
                    if (offset > 0) {
                        offset = 0;
                    }
                    parentContainer.setScrollYOffset(offset, false);
                } else {
                    int height = this.invisibleItemHeight;
                    if (height == 0 && this.parent != null) {
                        this.isInvisible = false;
                        this.setInitialized(false);
                        height = this.getItemHeight(this.parent.contentWidth, this.parent.contentWidth, this.parent.contentHeight);
                    } else {
                        this.itemHeight = height;
                    }
                    offset = parentContainer.getScrollYOffset() - height;
                    parentContainer.setScrollYOffset(offset, false);
                }
                Item parentItem = this;
                while (parentItem != null) {
                    if (parentItem.internalX != -9999) {
                        parentItem.internalY = invisible ? (parentItem.internalY -= this.itemHeight) : (parentItem.internalY += this.itemHeight);
                    }
                    parentItem = parentItem.parent;
                }
            } else if (parentContainer.focusedIndex == -1 && visible) {
                this.relativeY = 0;
                parentContainer.setScrollYOffset(0);
                parentContainer.focusChild(parentContainer.indexOf(this));
            }
        }
        if (invisible) {
            this.invisibleAppearanceModeCache = this.appearanceMode;
            this.invisibleItemHeight = this.itemHeight;
            this.appearanceMode = 0;
        } else {
            this.appearanceMode = this.invisibleAppearanceModeCache;
        }
        this.isInvisible = invisible;
        this.requestInit();
    }

    public boolean isVisible() {
        boolean result = !this.isInvisible;
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.label != null && this.label.text != null) {
            buffer.append('\"').append(this.label.text).append("\"");
        }
        if (this.style != null) {
            buffer.append(" [").append(this.style.name).append("]");
        }
        buffer.append(": ");
        buffer.append(super.toString());
        return buffer.toString();
    }

    public boolean containsCommand(Command command) {
        return this.commands != null && this.commands.contains(command);
    }

    public Command getDefaultCommand() {
        return this.defaultCommand;
    }

    public ArrayList getItemCommands() {
        return this.commands;
    }

    public void setInitialized(boolean initialized) {
        this.isInitialized = initialized;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setItemHeight(int height) {
        int diff = height - this.itemHeight;
        this.itemHeight = height;
        this.backgroundHeight += diff;
        if (this.isLayoutVerticalCenter()) {
            this.contentY += diff / 2;
        } else if (this.isLayoutBottom()) {
            this.contentY += diff;
        }
    }

    public void setItemWidth(int width) {
        int diff = width - this.itemWidth;
        this.itemWidth = width;
        this.backgroundWidth += diff;
        if (this.isLayoutCenter()) {
            this.contentX += diff / 2;
        } else if (this.isLayoutRight()) {
            this.contentX += diff;
        }
    }

    public int getInternalX() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalX;
    }

    public int getInternalY() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalY;
    }

    public int getInternalWidth() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalWidth;
    }

    public int getInternalHeight() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalHeight;
    }

    public void fireEvent(String eventName, Object eventData) {
        if (this.label != null) {
            EventManager.fireEvent(eventName, this.label, eventData);
        }
        EventManager.fireEvent(eventName, this, eventData);
    }

    public void updateInternalArea() {
    }

    public boolean isLayoutRight() {
        return this.isLayoutRight;
    }

    public boolean isLayoutLeft() {
        return !(this.isLayoutRight | this.isLayoutCenter);
    }

    public boolean isLayoutCenter() {
        return this.isLayoutCenter;
    }

    public boolean isLayoutTop() {
        return (this.layout & 0x20) == 0;
    }

    public boolean isLayoutBottom() {
        return (this.layout & 0x30) == 32;
    }

    public boolean isLayoutVerticalCenter() {
        return (this.layout & 0x30) == 48;
    }

    public boolean isLayoutVerticalShrink() {
        return (this.layout & 0x1000) == 4096;
    }

    public boolean isLayoutVerticalExpand() {
        return (this.layout & 0x2000) == 8192;
    }

    public boolean isLayoutExpand() {
        return (this.layout & 0x800) == 2048;
    }

    public boolean isLayoutShrink() {
        return (this.layout & 0x400) == 1024;
    }

    public boolean isLayoutNewlineAfter() {
        return (this.layout & 0x200) == 512;
    }

    public boolean isLayoutNewlineBefore() {
        return (this.layout & 0x100) == 256;
    }

    public void setItemTransition(ItemTransition transition) {
        this.itemTransition = transition;
    }

    public Image toImage() {
        int[] pixels = new int[this.itemWidth * this.itemHeight];
        Image img = Image.createRGBImage(pixels, this.itemWidth, this.itemHeight, true);
        Graphics g = img.getGraphics();
        ItemTransition t = this.itemTransition;
        this.itemTransition = null;
        this.paint(0, 0, 0, this.itemWidth, g);
        this.itemTransition = t;
        return img;
    }

    public RgbImage toRgbImage() {
        return new RgbImage(this.toImage(), true);
    }

    public boolean isInteractive() {
        return this.appearanceMode != 0;
    }

    public void resetStyle(boolean recursive) {
        if (this.style != null) {
            this.setStyle(this.style);
        }
        if (recursive && this.label != null) {
            this.label.resetStyle(recursive);
        }
    }

    public void onScreenSizeChanged(int screenWidth, int screenHeight) {
        if (this.label != null) {
            this.label.onScreenSizeChanged(screenWidth, screenHeight);
        }
        if (this.view != null) {
            this.view.onScreenSizeChanged(screenWidth, screenHeight);
        }
        if (!this.isStyleInitialised && this.style != null) {
            this.setStyle(this.style);
        }
        Style newStyle = null;
        if (screenWidth > screenHeight) {
            if (this.landscapeStyle != null && this.style != this.landscapeStyle) {
                newStyle = this.landscapeStyle;
            }
        } else if (this.portraitStyle != null && this.style != this.portraitStyle) {
            newStyle = this.portraitStyle;
        }
        Style oldStyle = null;
        if (newStyle != null) {
            oldStyle = this.style;
            this.setStyle(newStyle);
            if (this.isPressed) {
                this.normalStyle = newStyle;
            }
            if (this.isFocused) {
                if (this.parent instanceof Container) {
                    Container cont = (Container)this.parent;
                    cont.itemStyle = newStyle;
                    this.setStyle(this.getFocusedStyle());
                }
            } else if (oldStyle != null && this.parent instanceof Container) {
                Container cont = (Container)this.parent;
                if (cont.itemStyle == oldStyle) {
                    cont.itemStyle = newStyle;
                }
            }
        }
    }

    public int getAvailableWidth() {
        return this.availableWidth;
    }

    public int getAvailableHeight() {
        return this.availableHeight;
    }

    public void setUiEventListener(UiEventListener listener) {
        this.uiEventListener = listener;
    }

    public UiEventListener getUiEventListener() {
        UiEventListener listener = this.uiEventListener;
        if (listener == null) {
            Item parentItem = this.parent;
            while (parentItem != null && listener == null) {
                listener = parentItem.uiEventListener;
                parentItem = parentItem.parent;
            }
            if (listener == null) {
                listener = this.getScreen().getUiEventListener();
            }
        }
        return listener;
    }

    public int[] getRgbData() {
        return this.getRgbData(true, 255);
    }

    public int[] getRgbData(boolean supportTranslucency, int rgbOpacity) {
        int[] result = new int[]{};
        if (this.itemWidth < 1 || this.itemHeight < 1) {
            Debug.debug("error", "de.enough.polish.ui.Item", 6260, (Object)("Unable to retrieve RGB data for item with a dimension of " + this.itemWidth + "x" + this.itemHeight + " for "), this);
            return new int[0];
        }
        Image image = Image.createImage(this.itemWidth, this.itemHeight);
        if (supportTranslucency) {
            Graphics g = image.getGraphics();
            int bgColorBlack = 0;
            g.setColor(bgColorBlack);
            g.fillRect(0, 0, this.itemWidth, this.itemHeight);
            int[] transparentColorRgb = new int[1];
            image.getRGB(transparentColorRgb, 0, 1, 0, 0, 1, 1);
            bgColorBlack = transparentColorRgb[0];
            this.paint(0, 0, 0, this.itemWidth, g);
            int[] dataBlack = new int[this.itemWidth * this.itemHeight];
            image.getRGB(dataBlack, 0, this.itemWidth, 0, 0, this.itemWidth, this.itemHeight);
            int bgColorWhite = 0xFFFFFF;
            g.setColor(bgColorWhite);
            g.fillRect(0, 0, this.itemWidth, this.itemHeight);
            image.getRGB(transparentColorRgb, 0, 1, 0, 0, 1, 1);
            bgColorWhite = transparentColorRgb[0];
            this.paint(0, 0, 0, this.itemWidth, g);
            int[] dataWhite = new int[this.itemWidth * this.itemHeight];
            image.getRGB(dataWhite, 0, this.itemWidth, 0, 0, this.itemWidth, this.itemHeight);
            rgbOpacity = rgbOpacity << 24 | 0xFFFFFF;
            result = new int[dataBlack.length];
            int lastPixelWhite = 0;
            int lastPixelBlack = 0;
            int lastPixelResult = 0;
            for (int i = 0; i < dataBlack.length; ++i) {
                int originalBlue;
                int originalGreen;
                int originalRed;
                int pixelBlack = dataBlack[i];
                int pixelWhite = dataWhite[i];
                if (pixelBlack == pixelWhite) {
                    result[i] = pixelBlack & rgbOpacity;
                    continue;
                }
                if (pixelBlack == bgColorBlack && pixelWhite == bgColorWhite) continue;
                if (pixelBlack == lastPixelBlack && pixelWhite == lastPixelWhite) {
                    result[i] = lastPixelResult;
                    continue;
                }
                int redBlack = (pixelBlack & 0xFF0000) >> 16;
                int greenBlack = (pixelBlack & 0xFF00) >> 8;
                int blueBlack = pixelBlack & 0xFF;
                int redWhite = (pixelWhite & 0xFF0000) >> 16;
                int greenWhite = (pixelWhite & 0xFF00) >> 8;
                int blueWhite = pixelWhite & 0xFF;
                int originalAlpha = 0;
                if (redBlack == 0 && redWhite == 255) {
                    originalRed = 0;
                } else {
                    if (redBlack == 0) {
                        redBlack = 1;
                    } else if (redWhite == 255) {
                        redWhite = 254;
                    }
                    originalRed = 255 * redBlack / (redBlack - redWhite + 255);
                    originalAlpha = redBlack - redWhite + 255;
                }
                if (greenBlack == 0 && greenWhite == 255) {
                    originalGreen = 0;
                } else {
                    if (greenBlack == 0) {
                        greenBlack = 1;
                    } else if (greenWhite == 255) {
                        greenWhite = 254;
                    }
                    originalGreen = 255 * greenBlack / (greenBlack - greenWhite + 255);
                    originalAlpha = greenBlack - greenWhite + 255;
                }
                if (blueBlack == 0 && blueWhite == 255) {
                    originalBlue = 0;
                } else {
                    if (blueBlack == 0) {
                        blueBlack = 1;
                    } else if (blueWhite == 255) {
                        blueWhite = 254;
                    }
                    originalBlue = 255 * blueBlack / (blueBlack - blueWhite + 255);
                    originalAlpha = blueBlack - blueWhite + 255;
                }
                if (originalAlpha > 255) {
                    originalAlpha = 255;
                }
                lastPixelWhite = pixelWhite;
                lastPixelBlack = pixelBlack;
                result[i] = lastPixelResult = (originalAlpha << 24 | originalRed << 16 | originalGreen << 8 | originalBlue) & rgbOpacity;
            }
        } else {
            int transparentColor = 305419896;
            Graphics g = image.getGraphics();
            g.setColor(transparentColor);
            g.fillRect(0, 0, this.itemWidth, this.itemHeight);
            int[] transparentColorRgb = new int[1];
            image.getRGB(transparentColorRgb, 0, 1, 0, 0, 1, 1);
            transparentColor = transparentColorRgb[0];
            this.paint(0, 0, 0, this.itemWidth, g);
            int[] itemRgbData = new int[this.itemWidth * this.itemHeight];
            image.getRGB(itemRgbData, 0, this.itemWidth, 0, 0, this.itemWidth, this.itemHeight);
            boolean addOpacity = rgbOpacity != 255;
            rgbOpacity = rgbOpacity << 24 | 0xFFFFFF;
            for (int i = 0; i < itemRgbData.length; ++i) {
                int data = itemRgbData[i];
                if (data == transparentColor) {
                    itemRgbData[i] = 0;
                    continue;
                }
                if (!addOpacity) continue;
                itemRgbData[i] = data & rgbOpacity;
            }
        }
        return result;
    }

    public boolean fireContinueCycle(int direction) {
        if (this.cycleListener != null) {
            return this.cycleListener.onCycle(this, direction);
        }
        if (this.parent != null) {
            return this.parent.fireContinueCycle(direction);
        }
        return true;
    }

    public void setCycleListener(CycleListener listener) {
        this.cycleListener = listener;
    }

    public CycleListener getCycleListener() {
        return this.cycleListener;
    }
}

