/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.CycleListener;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Graphics;

public class FramedForm
extends Form
implements CycleListener {
    public static final int FRAME_TOP = 16;
    public static final int FRAME_BOTTOM = 32;
    public static final int FRAME_LEFT = 4;
    public static final int FRAME_RIGHT = 8;
    public static final int FRAME_CENTER = -1;
    protected Container leftFrame;
    protected Container rightFrame;
    protected Container topFrame;
    protected Container bottomFrame;
    private int originalContentHeight;
    private int originalContentWidth;
    private boolean expandRightFrame;
    private boolean expandLeftFrame;
    protected Container currentlyActiveContainer;
    private Style topFrameStyle;
    private Style bottomFrameStyle;
    private int originalContentY;
    private int originalContentX;
    private boolean keepContentFocused;
    private boolean isCycled;

    public FramedForm(String title) {
        this(title, (Style)null);
    }

    public FramedForm(String title, Style style) {
        super(title, style);
        this.currentlyActiveContainer = this.container;
        this.container.setCycleListener(this);
    }

    private Container getFrame(int frameOrientation) {
        switch (frameOrientation) {
            case 16: {
                return this.topFrame;
            }
            case 32: {
                return this.bottomFrame;
            }
            case 4: {
                return this.leftFrame;
            }
            case 8: {
                return this.rightFrame;
            }
        }
        return this.container;
    }

    public Container getFrame(int x, int y) {
        if (this.topFrame != null && y < this.topFrame.relativeY + this.topFrame.itemHeight) {
            return this.topFrame;
        }
        if (this.bottomFrame != null && y > this.bottomFrame.relativeY) {
            return this.bottomFrame;
        }
        if (this.leftFrame != null && x < this.leftFrame.relativeX + this.leftFrame.itemWidth) {
            return this.leftFrame;
        }
        if (this.rightFrame != null && x > this.rightFrame.relativeX) {
            return this.rightFrame;
        }
        if (this.container.isInItemArea(x - this.container.relativeX, y - this.container.relativeY)) {
            return this.container;
        }
        return null;
    }

    public Item getItemAt(int x, int y) {
        Item item;
        Container cont = this.container;
        Item superItemAt = null;
        if (this.isMenuOpened() && (superItemAt = super.getItemAt(x, y)) instanceof CommandItem) {
            return superItemAt;
        }
        Container frame = this.topFrame;
        if (frame != null && y >= frame.relativeY && y <= frame.relativeY + frame.itemHeight) {
            return frame.getItemAt(x - frame.relativeX, y - frame.relativeY);
        }
        frame = this.bottomFrame;
        if (frame != null && y >= frame.relativeY && y <= frame.relativeY + frame.itemHeight) {
            return frame.getItemAt(x - frame.relativeX, y - frame.relativeY);
        }
        frame = this.leftFrame;
        if (frame != null && x >= frame.relativeX && x <= frame.relativeX + frame.itemWidth && y >= frame.relativeY && y <= frame.relativeY + frame.itemHeight) {
            return frame.getItemAt(x - frame.relativeX, y - frame.relativeY);
        }
        frame = this.rightFrame;
        if (frame != null && x >= frame.relativeX && x <= frame.relativeX + frame.itemWidth && y >= frame.relativeY && y <= frame.relativeY + frame.itemHeight) {
            return frame.getItemAt(x - frame.relativeX, y - frame.relativeY);
        }
        frame = this.currentlyActiveContainer;
        if (frame != cont && (item = frame.getItemAt(x - frame.relativeX, y - frame.relativeY)) != null && item != frame) {
            return item;
        }
        if (superItemAt != null) {
            return superItemAt;
        }
        return super.getItemAt(x, y);
    }

    public void focus(Item item, boolean force) {
        this.focus(item, force, false);
    }

    public void focus(Item item, boolean force, boolean keepCurrentFrame) {
        if (item.isFocused) {
            return;
        }
        if (item.parent != null && item.parent.label == item) {
            item = item.parent;
        }
        ArrayList children = new ArrayList();
        while (item.parent != null) {
            if (force || item.isInteractive()) {
                children.add(item);
            }
            item = item.parent;
        }
        Container frame = null;
        int offset = 0;
        if (!keepCurrentFrame && item != this.currentlyActiveContainer && item instanceof Container) {
            frame = (Container)item;
            offset = frame.getScrollYOffset();
            this.setActiveFrame(frame, this.keepContentFocused, 0);
        }
        int i = children.size();
        while (--i >= 0) {
            Item child = (Item)children.get(i);
            if (!child.isFocused && item instanceof Container) {
                Container cont = (Container)item;
                cont.focusChild(cont.indexOf(child), child, 0, force);
            }
            item = child;
        }
        if (frame != null) {
            frame.setScrollYOffset(offset, false);
        }
    }

    public void deleteAll() {
        super.deleteAll();
        if (this.leftFrame != null) {
            this.leftFrame.clear();
            this.leftFrame = null;
        }
        if (this.rightFrame != null) {
            this.rightFrame.clear();
            this.rightFrame = null;
        }
        if (this.topFrame != null) {
            this.topFrame.clear();
            this.topFrame = null;
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.clear();
            this.bottomFrame = null;
        }
        this.requestInit();
    }

    public void deleteAll(int frameOrientation) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.clear();
            this.deleteFrame(frameOrientation);
        }
    }

    public void append(int frameOrientation, Item item) {
        this.append(frameOrientation, item, null);
    }

    public void set(int frameOrientation, int itemNum, Item item) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.set(itemNum, item);
        }
    }

    public void delete(int frameOrientation, int itemNum) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.remove(itemNum);
            if (frame.size() == 0) {
                this.deleteFrame(frameOrientation);
            } else {
                this.requestInit();
            }
        }
    }

    public int size(int frameOrientation) {
        Container frame = this.getFrame(frameOrientation);
        if (frame == null) {
            return -1;
        }
        return frame.size();
    }

    public boolean deleteFrame(int frameOrientation) {
        Container frame;
        switch (frameOrientation) {
            case 16: {
                frame = this.topFrame;
                this.topFrame = null;
                break;
            }
            case 32: {
                frame = this.bottomFrame;
                this.bottomFrame = null;
                break;
            }
            case 4: {
                frame = this.leftFrame;
                this.leftFrame = null;
                break;
            }
            case 8: {
                frame = this.rightFrame;
                this.rightFrame = null;
                break;
            }
            default: {
                return false;
            }
        }
        if (frame == null) {
            return false;
        }
        if (frame == this.currentlyActiveContainer) {
            this.setActiveFrame(this.container);
        }
        frame.hideNotify();
        this.requestInit();
        return true;
    }

    public void append(int frameOrientation, Item item, Style itemStyle) {
        Container frame;
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        switch (frameOrientation) {
            case 16: {
                if (this.topFrame == null) {
                    this.topFrame = new Container(false, StyleSheet.defaultStyle);
                    this.topFrame.setCycleListener(this);
                    if (this.topFrameStyle != null) {
                        this.topFrame.setStyle(this.topFrameStyle);
                    }
                }
                frame = this.topFrame;
                break;
            }
            case 32: {
                if (this.bottomFrame == null) {
                    this.bottomFrame = new Container(false, StyleSheet.defaultStyle);
                    this.bottomFrame.setCycleListener(this);
                    if (this.bottomFrameStyle != null) {
                        this.bottomFrame.setStyle(this.bottomFrameStyle);
                    }
                }
                frame = this.bottomFrame;
                break;
            }
            case 4: {
                if (this.leftFrame == null) {
                    this.leftFrame = new Container(false, StyleSheet.defaultStyle);
                    this.leftFrame.setCycleListener(this);
                }
                frame = this.leftFrame;
                break;
            }
            case 8: {
                if (this.rightFrame == null) {
                    this.rightFrame = new Container(false, StyleSheet.defaultStyle);
                    this.rightFrame.setCycleListener(this);
                }
                frame = this.rightFrame;
                break;
            }
            default: {
                super.append(item, itemStyle);
                return;
            }
        }
        frame.screen = this;
        frame.add(item);
        if (this.isShown()) {
            this.requestInit();
        }
    }

    protected void adjustContentArea(int x, int y, int width, int height, Container cont) {
        int frameHeight;
        this.originalContentX = x;
        this.originalContentY = y;
        this.originalContentWidth = width;
        this.originalContentHeight = height;
        if (this.leftFrame != null) {
            boolean bl = this.expandLeftFrame = (this.leftFrame.style.layout & 0x2000) == 8192;
            if (this.expandLeftFrame) {
                this.leftFrame.setStyleWithBackground(this.leftFrame.style, true);
            }
            int frameWidth = this.leftFrame.getItemWidth(width / 2, width / 2, height);
            x += frameWidth;
            width -= frameWidth;
        }
        if (this.rightFrame != null) {
            boolean bl = this.expandRightFrame = (this.rightFrame.style.layout & 0x2000) == 8192;
            if (this.expandRightFrame) {
                this.rightFrame.setStyleWithBackground(this.rightFrame.style, true);
            }
            width -= this.rightFrame.getItemWidth(this.originalContentWidth / 2, this.originalContentWidth / 2, this.originalContentHeight);
        }
        if (this.topFrame != null) {
            frameHeight = this.topFrame.getItemHeight(this.originalContentWidth, this.originalContentWidth, this.originalContentHeight);
            y += frameHeight;
            height -= frameHeight;
        }
        if (this.bottomFrame != null) {
            frameHeight = this.bottomFrame.getItemHeight(this.originalContentWidth, this.originalContentWidth, this.originalContentHeight);
            height -= frameHeight;
        }
        this.contentX = x;
        this.contentY = y;
        this.contentWidth = width;
        this.contentHeight = height;
        int yOffset = this.getScrollYOffset();
        if (cont != null && yOffset < 0 && yOffset + cont.getItemAreaHeight() < height) {
            cont.setScrollYOffset(-(cont.getItemAreaHeight() - height));
        }
        super.adjustContentArea(x, yOffset, width, height, cont);
    }

    protected boolean checkForRequestInit(Item source) {
        return super.checkForRequestInit(source) || source == this.topFrame || source == this.bottomFrame || source == this.leftFrame || source == this.rightFrame;
    }

    protected void paintScreen(Graphics g) {
        int y;
        Style frameStyle;
        boolean paintContentContainerLast;
        boolean bl = paintContentContainerLast = this.currentlyActiveContainer == this.container;
        if (!paintContentContainerLast) {
            super.paintScreen(g);
        }
        if (this.leftFrame != null) {
            frameStyle = this.leftFrame.style;
            if (this.expandLeftFrame) {
                if (frameStyle.background != null) {
                    frameStyle.background.paint(frameStyle.getMarginLeft(this.screenWidth), frameStyle.getMarginTop(this.screenHeight), this.leftFrame.backgroundWidth, this.originalContentHeight - frameStyle.getMarginTop(this.screenHeight) - frameStyle.getMarginBottom(this.screenHeight), g);
                }
                if (frameStyle.border != null) {
                    frameStyle.border.paint(frameStyle.getMarginLeft(this.screenWidth), frameStyle.getMarginTop(this.screenHeight), this.leftFrame.backgroundWidth, this.originalContentHeight - frameStyle.getMarginTop(this.screenHeight) - frameStyle.getMarginBottom(this.screenHeight), g);
                }
            }
            y = this.originalContentY;
            if ((frameStyle.layout & 0x30) == 48) {
                y += (this.originalContentHeight - frameStyle.getMarginBottom(this.screenHeight) - this.leftFrame.itemHeight) / 2;
            } else if ((frameStyle.layout & 0x20) == 32) {
                y += this.originalContentHeight - frameStyle.getMarginBottom(this.screenHeight) - this.leftFrame.itemHeight;
            }
            this.leftFrame.relativeX = 0;
            this.leftFrame.relativeY = y;
            this.leftFrame.paint(0, y, 0, this.contentWidth, g);
        }
        if (this.rightFrame != null) {
            frameStyle = this.rightFrame.style;
            if (this.expandRightFrame) {
                int leftFrameBackgroundWidth = 0;
                if (this.leftFrame != null) {
                    leftFrameBackgroundWidth = this.leftFrame.getBackgroundWidth();
                }
                if (frameStyle.background != null) {
                    frameStyle.background.paint(this.contentX + this.contentWidth + frameStyle.getMarginLeft(this.screenWidth), frameStyle.getMarginTop(this.screenHeight), leftFrameBackgroundWidth, this.originalContentHeight - frameStyle.getMarginTop(this.screenHeight) - frameStyle.getMarginBottom(this.screenHeight), g);
                }
                if (frameStyle.border != null) {
                    frameStyle.border.paint(this.contentX + this.contentWidth + frameStyle.getMarginLeft(this.screenWidth), frameStyle.getMarginTop(this.screenHeight), leftFrameBackgroundWidth, this.originalContentHeight - frameStyle.getMarginTop(this.screenHeight) - frameStyle.getMarginBottom(this.screenHeight), g);
                }
            }
            y = this.originalContentY;
            if ((frameStyle.layout & 0x30) == 48) {
                y += (this.originalContentHeight - frameStyle.getMarginBottom(this.screenHeight) - this.rightFrame.itemHeight) / 2;
            } else if ((frameStyle.layout & 0x20) == 32) {
                y += this.originalContentHeight - frameStyle.getMarginBottom(this.screenHeight) - this.rightFrame.itemHeight;
            }
            this.rightFrame.relativeX = this.contentWidth;
            this.rightFrame.relativeY = y;
            this.rightFrame.paint(this.contentWidth, y, this.contentWidth, this.screenWidth, g);
        }
        if (this.topFrame != null) {
            int clipY = g.getClipY();
            this.topFrame.relativeX = this.originalContentX;
            this.topFrame.relativeY = this.originalContentY;
            int frameY = this.originalContentY;
            if (clipY < frameY + this.topFrame.itemHeight) {
                this.topFrame.paint(this.originalContentX, frameY, this.originalContentX, this.originalContentX + this.originalContentWidth, g);
            }
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.relativeX = this.originalContentX;
            this.bottomFrame.relativeY = this.contentY + this.contentHeight;
            int frameY = this.contentY + this.contentHeight;
            this.bottomFrame.paint(this.originalContentX, frameY, this.originalContentX, this.originalContentX + this.originalContentWidth, g);
        }
        if (paintContentContainerLast) {
            super.paintScreen(g);
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.isCycled = false;
        boolean handled = this.currentlyActiveContainer.handleKeyPressed(keyCode, gameAction);
        if (!handled && !this.keepContentFocused) {
            if (this.isCycled) {
                handled = true;
                this.isCycled = false;
            } else {
                Container nextFrame = this.getNextFrame(gameAction);
                if (nextFrame != null) {
                    this.setActiveFrame(nextFrame, false, gameAction);
                    handled = true;
                } else {
                    return false;
                }
            }
        }
        return handled || super.handleKeyPressed(keyCode, gameAction);
    }

    public void focusByAction(int gameAction, Container cont) {
        block0 : switch (gameAction) {
            case 2: 
            case 5: 
            case 6: {
                for (int i = 0; i < cont.size(); ++i) {
                    Item item = cont.get(i);
                    if (item.appearanceMode == 0) continue;
                    cont.focusChild(i);
                    break block0;
                }
                break;
            }
            case 1: {
                int i = cont.size();
                while (--i >= 0) {
                    Item item = cont.get(i);
                    if (item.appearanceMode == 0) continue;
                    cont.focusChild(i);
                    break block0;
                }
                break;
            }
        }
    }

    Container getNextFrame(int gameAction) {
        Container newFrame = null;
        if (this.currentlyActiveContainer == this.container) {
            newFrame = this.getFrameByGameAction(gameAction, new Container[]{this.bottomFrame, this.leftFrame, this.rightFrame, this.topFrame}, new Container[]{this.topFrame, this.leftFrame, this.rightFrame, this.bottomFrame}, new Container[]{this.leftFrame, this.topFrame, this.bottomFrame, this.rightFrame}, new Container[]{this.rightFrame, this.bottomFrame, this.topFrame, this.leftFrame});
        }
        if (this.container.appearanceMode != 0 && (gameAction == 1 && this.currentlyActiveContainer == this.bottomFrame || gameAction == 6 && this.currentlyActiveContainer == this.topFrame || gameAction == 2 && this.currentlyActiveContainer == this.rightFrame || gameAction == 5 && this.currentlyActiveContainer == this.leftFrame)) {
            newFrame = this.container;
        }
        return newFrame;
    }

    Container getFrameByGameAction(int gameAction, Container[] down, Container[] up, Container[] left, Container[] right) {
        Container[] nextFrames;
        switch (gameAction) {
            case 6: {
                nextFrames = down;
                break;
            }
            case 1: {
                nextFrames = up;
                break;
            }
            case 2: {
                nextFrames = left;
                break;
            }
            case 5: {
                nextFrames = right;
                break;
            }
            default: {
                return null;
            }
        }
        Container newFrame = null;
        for (int i = 0; i < nextFrames.length; ++i) {
            Container frame = nextFrames[i];
            if (frame == null || frame.appearanceMode == 0) continue;
            newFrame = frame;
            break;
        }
        return newFrame;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        return this.currentlyActiveContainer.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        return this.currentlyActiveContainer.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handleCommand(Command cmd) {
        if (this.currentlyActiveContainer != this.container && this.currentlyActiveContainer != null && this.currentlyActiveContainer.handleCommand(cmd)) {
            return true;
        }
        return super.handleCommand(cmd);
    }

    public Item getCurrentItem() {
        if (!this.keepContentFocused && this.currentlyActiveContainer != null) {
            return this.currentlyActiveContainer.focusedItem;
        }
        return this.container.focusedItem;
    }

    public void setActiveFrame(int frameOrientation) {
        this.setActiveFrame(frameOrientation, false);
    }

    public void setActiveFrame(int frameOrientation, boolean keepMainFocus) {
        this.setActiveFrame(this.getFrame(frameOrientation), keepMainFocus);
    }

    private void setActiveFrame(Container newFrame) {
        this.setActiveFrame(newFrame, false);
    }

    protected void setActiveFrame(Container newFrame, boolean keepMainFocus) {
        int direction = 0;
        if (newFrame.appearanceMode != 0) {
            direction = this.currentlyActiveContainer == this.bottomFrame ? 1 : (this.currentlyActiveContainer == this.topFrame ? 6 : (this.currentlyActiveContainer == this.leftFrame ? 5 : (this.currentlyActiveContainer == this.rightFrame ? 2 : (newFrame == this.bottomFrame ? 6 : (newFrame == this.topFrame ? 1 : (newFrame == this.leftFrame ? 2 : 5))))));
        }
        this.setActiveFrame(newFrame, keepMainFocus, direction);
    }

    protected void setActiveFrame(Container newFrame, boolean keepMainFocus, int direction) {
        if (newFrame == null || newFrame == this.currentlyActiveContainer) {
            return;
        }
        if (!keepMainFocus) {
            this.currentlyActiveContainer.defocus(this.currentlyActiveContainer.style);
        }
        if (newFrame.appearanceMode != 0) {
            newFrame.focus(StyleSheet.focusedStyle, direction);
        }
        this.currentlyActiveContainer = newFrame;
        if (newFrame == this.container) {
            int ch;
            int w = this.contentWidth;
            int h = this.contentHeight;
            if (newFrame.itemHeight > h && (ch = newFrame.getItemHeight(w -= this.getScrollBarWidth(), w, h)) <= h) {
                newFrame.init(w += this.getScrollBarWidth(), w, h);
            }
            this.initContent(newFrame);
        }
        if (keepMainFocus) {
            if (newFrame != this.container) {
                this.keepContentFocused = true;
            }
        } else {
            this.keepContentFocused = false;
        }
        if (this.screenStateListener != null) {
            this.screenStateListener.screenStateChanged(this);
        }
    }

    protected boolean handlePointerPressed(int x, int y) {
        Container areaFrame = this.getFrame(x, y);
        Container activeFrame = this.currentlyActiveContainer;
        if (areaFrame != null && areaFrame != activeFrame && areaFrame.isInteractive()) {
            int yOffset = areaFrame.getScrollYOffset();
            this.setActiveFrame(areaFrame);
            areaFrame.setScrollYOffset(yOffset, false);
            if (areaFrame.handlePointerPressed(x - areaFrame.relativeX, y - areaFrame.relativeY)) {
                return true;
            }
        }
        Container newFrame = null;
        if (activeFrame != null && activeFrame.handlePointerPressed(x - activeFrame.relativeX, y - activeFrame.relativeY)) {
            newFrame = activeFrame;
        } else if (this.container != activeFrame && this.container.handlePointerPressed(x - this.container.relativeX, y - this.container.relativeY)) {
            newFrame = this.container;
        } else if (this.topFrame != null && this.topFrame != activeFrame && this.topFrame.handlePointerPressed(x - this.topFrame.relativeX, y - this.topFrame.relativeY)) {
            newFrame = this.topFrame;
        } else if (this.bottomFrame != null && this.bottomFrame != activeFrame && this.bottomFrame.handlePointerPressed(x - this.bottomFrame.relativeX, y - this.bottomFrame.relativeY)) {
            newFrame = this.bottomFrame;
        } else if (this.leftFrame != null && this.leftFrame != activeFrame && this.leftFrame.handlePointerPressed(x - this.leftFrame.relativeX, y - this.leftFrame.relativeY)) {
            newFrame = this.leftFrame;
        } else if (this.rightFrame != null && this.rightFrame != activeFrame && this.rightFrame.handlePointerPressed(x - this.rightFrame.relativeX, y - this.rightFrame.relativeY)) {
            newFrame = this.rightFrame;
        }
        if (!this.keepContentFocused && newFrame != null && newFrame != activeFrame) {
            this.setActiveFrame(newFrame);
        }
        return newFrame != null;
    }

    protected boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        Container activeFrame = this.currentlyActiveContainer;
        if (activeFrame != null) {
            return activeFrame.handlePointerDragged(x - activeFrame.relativeX, y - activeFrame.relativeY, repaintRegion);
        }
        return false;
    }

    protected boolean handlePointerReleased(int x, int y) {
        Container newFrame = null;
        Container activeFrame = this.currentlyActiveContainer;
        if (activeFrame != null && activeFrame.handlePointerReleased(x - activeFrame.relativeX, y - activeFrame.relativeY)) {
            newFrame = activeFrame;
        } else if (this.container != activeFrame && this.container.handlePointerReleased(x - this.container.relativeX, y - this.container.relativeY)) {
            newFrame = this.container;
        } else if (this.topFrame != null && this.topFrame != activeFrame && this.topFrame.handlePointerReleased(x - this.topFrame.relativeX, y - this.topFrame.relativeY)) {
            newFrame = this.topFrame;
        } else if (this.bottomFrame != null && this.bottomFrame != activeFrame && this.bottomFrame.handlePointerReleased(x - this.bottomFrame.relativeX, y - this.bottomFrame.relativeY)) {
            newFrame = this.bottomFrame;
        } else if (this.leftFrame != null && this.leftFrame != activeFrame && this.leftFrame.handlePointerReleased(x - this.leftFrame.relativeX, y - this.leftFrame.relativeY)) {
            newFrame = this.leftFrame;
        } else if (this.rightFrame != null && this.rightFrame != activeFrame && this.rightFrame.handlePointerReleased(x - this.rightFrame.relativeX, y - this.rightFrame.relativeY)) {
            newFrame = this.rightFrame;
        }
        if (!this.keepContentFocused && newFrame != null && newFrame != activeFrame) {
            this.setActiveFrame(newFrame);
        }
        return newFrame != null;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.leftFrame != null) {
            this.leftFrame.animate(currentTime, repaintRegion);
        }
        if (this.rightFrame != null) {
            this.rightFrame.animate(currentTime, repaintRegion);
        }
        if (this.topFrame != null) {
            this.topFrame.animate(currentTime, repaintRegion);
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.animate(currentTime, repaintRegion);
        }
    }

    protected Item[] getRootItems() {
        Item[] frames = new Container[4];
        int index = 0;
        if (this.topFrame != null) {
            frames[index] = this.topFrame;
            ++index;
        }
        if (this.bottomFrame != null) {
            frames[index] = this.bottomFrame;
            ++index;
        }
        if (this.leftFrame != null) {
            frames[index] = this.leftFrame;
            ++index;
        }
        if (this.rightFrame != null) {
            frames[index] = this.rightFrame;
            ++index;
        }
        if (index < 4) {
            Container[] activeFrames = new Container[index];
            System.arraycopy(frames, 0, activeFrames, 0, index);
            frames = activeFrames;
        }
        return frames;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.topFrameStyle = (Style)style.getObjectProperty(316);
        if (this.topFrame != null && this.topFrameStyle != null) {
            this.topFrame.setStyle(this.topFrameStyle);
        }
        this.bottomFrameStyle = (Style)style.getObjectProperty(317);
        if (this.bottomFrame != null && this.bottomFrameStyle != null) {
            this.bottomFrame.setStyle(this.bottomFrameStyle);
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void setFrameStyle(int frameOrientation, Style style) {
        Container frame = null;
        switch (frameOrientation) {
            case 16: {
                this.topFrameStyle = style;
                frame = this.topFrame;
                break;
            }
            case 32: {
                this.bottomFrameStyle = style;
                frame = this.bottomFrame;
                break;
            }
            case 4: {
                frame = this.leftFrame;
                break;
            }
            case 8: {
                frame = this.rightFrame;
            }
        }
        if (style != null && frame != null) {
            frame.setStyle(style);
        }
    }

    protected void setItemCommands(ArrayList commandsList, Item item) {
        while (item.parent != null) {
            item = item.parent;
        }
        if (item != this.container) {
            this.addItemCommands(this.container, commandsList);
        } else {
            if (this.topFrame != null && this.topFrame.isFocused) {
                this.addItemCommands(this.topFrame, commandsList);
            }
            if (this.bottomFrame != null && this.bottomFrame.isFocused) {
                this.addItemCommands(this.bottomFrame, commandsList);
            }
            if (this.leftFrame != null && this.leftFrame.isFocused) {
                this.addItemCommands(this.leftFrame, commandsList);
            }
            if (this.rightFrame != null && this.rightFrame.isFocused) {
                this.addItemCommands(this.rightFrame, commandsList);
            }
        }
        super.setItemCommands(commandsList, item);
    }

    private void addItemCommands(Container cont, ArrayList commandsList) {
        Item item = cont.getFocusedItem();
        if (item != null) {
            item.addCommands(commandsList);
        }
    }

    public void sizeChanged(int width, int height) {
        if (this.leftFrame != null) {
            this.leftFrame.onScreenSizeChanged(width, height);
        }
        if (this.rightFrame != null) {
            this.rightFrame.onScreenSizeChanged(width, height);
        }
        if (this.topFrame != null) {
            this.topFrame.onScreenSizeChanged(width, height);
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.onScreenSizeChanged(width, height);
        }
        super.sizeChanged(width, height);
    }

    public void releaseResources() {
        super.releaseResources();
        if (this.leftFrame != null) {
            this.leftFrame.releaseResources();
        }
        if (this.rightFrame != null) {
            this.rightFrame.releaseResources();
        }
        if (this.topFrame != null) {
            this.topFrame.releaseResources();
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.releaseResources();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.leftFrame != null) {
            this.leftFrame.destroy();
        }
        if (this.rightFrame != null) {
            this.rightFrame.destroy();
        }
        if (this.topFrame != null) {
            this.topFrame.destroy();
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.destroy();
        }
    }

    public boolean onCycle(Item item, int direction) {
        int gameAction;
        Container newFrame;
        if (!this.keepContentFocused && (newFrame = this.getNextFrame(gameAction = direction == 1 ? 1 : (direction == 2 ? 6 : (direction == 2 ? 2 : 5)))) != null && newFrame != this.currentlyActiveContainer) {
            this.isCycled = true;
            this.setActiveFrame(newFrame, false, gameAction);
            return false;
        }
        return true;
    }
}

