/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.DebugCallback;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;

public class DebugHelper {
    public static boolean breakOn(Item item, String text, DebugCallback callback) {
        if (item instanceof StringItem) {
            StringItem stringItem = (StringItem)item;
            if (stringItem.getText() != null && stringItem.getText().indexOf(text) != -1) {
                DebugHelper.callback(callback);
                return true;
            }
        } else if (item.getLabel() != null && item.getLabel().indexOf(text) != -1) {
            DebugHelper.callback(callback);
            return true;
        }
        return false;
    }

    public static boolean breakOn(int value, int equals, DebugCallback callback) {
        if (value == equals) {
            DebugHelper.callback(callback);
            return true;
        }
        return false;
    }

    public static boolean breakOn(Command cmd, String text, DebugCallback callback) {
        if (cmd.getLabel().equals(text)) {
            DebugHelper.callback(callback);
            return true;
        }
        return false;
    }

    public static boolean breakOn(Style style, String name, DebugCallback callback) {
        if (style.name != null && style.name.indexOf(name) != -1) {
            DebugHelper.callback(callback);
            return true;
        }
        return false;
    }

    static void callback(DebugCallback callback) {
        if (callback != null) {
            callback.onDebug();
        } else {
            System.out.println("BREAK");
        }
    }

    public static void trace() {
        try {
            throw new RuntimeException();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void print(Item item) {
        if (item instanceof Container) {
            DebugHelper.print((Container)item);
        } else {
            DebugHelper.printItem(item, "");
        }
    }

    public static void print(Container container) {
        DebugHelper.print(container, 0);
    }

    static String getIndent(int depth) {
        String indent = "";
        for (int i = 0; i < depth; ++i) {
            indent = indent + "  ";
        }
        return indent;
    }

    static void print(Container container, int depth) {
        DebugHelper.printItem(container, DebugHelper.getIndent(depth));
        for (int i = 0; i < container.size(); ++i) {
            Item item = container.get(i);
            DebugHelper.printItem(item, DebugHelper.getIndent(depth));
            if (!(item instanceof Container)) continue;
            DebugHelper.print((Container)item, ++depth);
        }
    }

    static void printItem(Item item, String indent) {
        System.out.println(indent + item);
    }
}

