/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.CssAnimation;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.TextUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ContainerView
extends ItemView {
    protected static final int NO_COLUMNS = 0;
    protected static final int EQUAL_WIDTH_COLUMNS = 1;
    protected static final int NORMAL_WIDTH_COLUMNS = 2;
    protected static final int STATIC_WIDTH_COLUMNS = 3;
    protected int xOffset;
    protected int targetXOffset;
    protected int yOffset;
    protected int focusedIndex = -1;
    protected transient Container parentContainer;
    protected boolean restartAnimation;
    protected boolean focusFirstElement;
    protected int appearanceMode;
    protected transient Item focusedItem;
    protected int columnsSetting = 0;
    protected int numberOfColumns;
    protected Dimension[] columnsWidths;
    protected int[] rowsHeights;
    protected int numberOfRows;
    protected boolean allowCycling = true;
    protected boolean isAlignHeights;
    protected boolean allowsAutoTraversal = true;
    protected boolean isHorizontal = true;
    protected boolean isVertical = true;
    protected boolean allowsDirectSelectionByPointerEvent = true;
    private int lastAvailableContentWidth;
    private int scrollDirection;
    private int scrollSpeed;
    private int scrollDamping;
    private long lastAnimationTime;
    private long lastPointerPressTime;
    private int lastPointerPressXOffset;
    protected boolean isPointerPressedHandled;
    private int pointerPressedX;
    private long scrollStartTime;
    private int scrollStartXOffset;
    private long scrollDuration = 300L;
    protected boolean scrollContinuous;

    protected ContainerView() {
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        int speed;
        int height;
        Screen scr;
        super.animate(currentTime, repaintRegion);
        int target = this.targetXOffset;
        int current = this.xOffset;
        if (target != current) {
            int nextOffset;
            long passedTime = currentTime - this.scrollStartTime;
            int startX = this.scrollStartXOffset;
            this.xOffset = nextOffset = CssAnimation.calculatePointInRange(startX, target, passedTime, this.scrollDuration, 5);
            scr = this.getScreen();
            int x = this.parentContainer.getAbsoluteX();
            int y = this.parentContainer.getAbsoluteY();
            int width = this.parentContainer.itemWidth;
            height = this.parentContainer.itemHeight;
            repaintRegion.addRegion(x, y, width += scr.getScrollBarWidth(), height + 1);
        }
        if ((speed = this.scrollSpeed) != 0) {
            if ((speed = speed * (100 - this.scrollDamping) / 100) <= 0) {
                speed = 0;
            }
            this.scrollSpeed = speed;
            long timeDelta = currentTime - this.lastAnimationTime;
            if (timeDelta > 1000L) {
                timeDelta = 50L;
            }
            this.lastAnimationTime = currentTime;
            if ((speed = (int)((long)speed * timeDelta / 1000L)) == 0) {
                this.scrollSpeed = 0;
            }
            int offset = this.xOffset;
            int width = this.contentWidth;
            if (this.scrollDirection == 2) {
                target = offset += speed;
                if (offset > 0) {
                    this.scrollSpeed = 0;
                    target = 0;
                }
            } else {
                target = offset -= speed;
                if (offset + width < this.availableWidth) {
                    this.scrollSpeed = 0;
                    target = this.availableWidth - width;
                }
            }
            this.xOffset = offset;
            this.targetXOffset = target;
            scr = this.getScreen();
            int x = this.parentContainer.getAbsoluteX();
            int y = this.parentContainer.getAbsoluteY();
            height = this.parentContainer.itemHeight;
            repaintRegion.addRegion(x, y, width += scr.getScrollBarWidth(), height + 1);
        }
    }

    public void setScrollXOffset(int offset) {
        this.setScrollXOffset(offset, false);
    }

    public void setScrollXOffset(int offset, boolean smooth) {
        int startX;
        this.scrollStartXOffset = startX = this.xOffset;
        this.scrollStartTime = System.currentTimeMillis();
        if (!smooth) {
            this.xOffset = offset;
        }
        this.targetXOffset = offset;
        this.scrollSpeed = 0;
    }

    public int getScrollXOffset() {
        return this.xOffset;
    }

    public int getScrollTargetXOffset() {
        return this.targetXOffset;
    }

    protected void addFullRepaintRegion(Item item, ClippingRegion repaintRegion) {
        repaintRegion.addRegion(item.getAbsoluteX() - this.xOffset, item.getAbsoluteY(), item.itemWidth, item.itemHeight);
    }

    protected void initMargin(Style style, int availWidth) {
        this.parentContainer.initMargin(style, availWidth);
    }

    protected void initPadding(Style style, int availWidth) {
        this.parentContainer.initPadding(style, availWidth);
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        int i;
        int i2;
        boolean isNormalWidthColumns;
        Container parent = (Container)parentContainerItem;
        this.paddingHorizontal = parentContainerItem.paddingHorizontal;
        this.paddingVertical = parentContainerItem.paddingVertical;
        this.focusedIndex = parent.getFocusedIndex();
        this.focusedItem = parent.getFocusedItem();
        boolean reinitInAnyCase = availWidth != this.lastAvailableContentWidth;
        this.lastAvailableContentWidth = availWidth;
        this.parentContainer = parent;
        Item[] myItems = parent.getItems();
        int myItemsLength = myItems.length;
        boolean hasVerticalExpandItems = false;
        for (int i3 = 0; i3 < myItems.length; ++i3) {
            Item item = myItems[i3];
            if (!item.isLayoutVerticalExpand()) continue;
            hasVerticalExpandItems = true;
            break;
        }
        int numberOfVerticalExpandItems = 0;
        Item lastVerticalExpandItem = null;
        int lastVerticalExpandItemIndex = 0;
        if (this.columnsSetting == 0 || myItemsLength <= 1 || this.numberOfColumns <= 1) {
            int width;
            this.isHorizontal = false;
            this.isVertical = true;
            boolean isLayoutShrink = (this.parentContainer.layout & 0x400) == 1024;
            int myContentWidth = 0;
            int myContentHeight = 0;
            boolean hasFocusableItem = false;
            for (int i4 = 0; i4 < myItemsLength; ++i4) {
                Item item = myItems[i4];
                if (hasVerticalExpandItems) {
                    item.setInitialized(false);
                }
                width = item.itemWidth;
                if (reinitInAnyCase || !item.isInitialized) {
                    width = item.getItemWidth(firstLineWidth, availWidth, availHeight);
                }
                int height = item.itemHeight;
                if (item.isLayoutVerticalExpand()) {
                    ++numberOfVerticalExpandItems;
                    lastVerticalExpandItem = item;
                    lastVerticalExpandItemIndex = i4;
                }
                if (item.appearanceMode != 0) {
                    hasFocusableItem = true;
                }
                if (isLayoutShrink && i4 == this.focusedIndex) {
                    width = 0;
                }
                if (width > myContentWidth) {
                    myContentWidth = width;
                }
                item.relativeY = myContentHeight;
                item.relativeX = item.isLayoutExpand ? 0 : (item.isLayoutCenter ? (availWidth - width) / 2 : (item.isLayoutRight ? availWidth - width : 0));
                myContentHeight += height + (height != 0 ? this.paddingVertical : 0);
            }
            if (hasFocusableItem) {
                this.appearanceMode = 3;
                if (isLayoutShrink && this.focusedItem != null) {
                    Item item = this.focusedItem;
                    item.setInitialized(false);
                    boolean doExpand = item.isLayoutExpand;
                    if (doExpand) {
                        item.isLayoutExpand = false;
                        width = item.getItemWidth(availWidth, availWidth, availHeight);
                        item.setInitialized(false);
                        item.isLayoutExpand = true;
                    } else {
                        width = item.itemWidth;
                    }
                    if (width > myContentWidth) {
                        myContentWidth = width;
                    }
                    if (parent.minimumWidth != null && myContentWidth < parent.minimumWidth.getValue(firstLineWidth)) {
                        myContentWidth = parent.minimumWidth.getValue(firstLineWidth);
                    }
                    if (doExpand) {
                        item.init(myContentWidth, myContentWidth, availHeight);
                    }
                }
            } else {
                this.appearanceMode = 0;
            }
            if (numberOfVerticalExpandItems > 0 && myContentHeight < availHeight) {
                int diff = availHeight - myContentHeight;
                if (numberOfVerticalExpandItems == 1) {
                    lastVerticalExpandItem.setItemHeight(lastVerticalExpandItem.itemHeight + diff);
                    for (int i5 = lastVerticalExpandItemIndex + 1; i5 < myItems.length; ++i5) {
                        Item item = myItems[i5];
                        item.relativeY += diff;
                    }
                } else {
                    diff /= numberOfVerticalExpandItems;
                    int relYAdjust = 0;
                    for (int i6 = 0; i6 < myItems.length; ++i6) {
                        Item item = myItems[i6];
                        item.relativeY += relYAdjust;
                        if (!item.isLayoutVerticalExpand()) continue;
                        item.setItemHeight(item.itemHeight + diff);
                        relYAdjust += diff;
                    }
                }
                myContentHeight = availHeight;
            }
            this.contentHeight = myContentHeight;
            this.contentWidth = myContentWidth;
            return;
        }
        this.isHorizontal = true;
        boolean bl = isNormalWidthColumns = this.columnsSetting == 2;
        if (this.columnsSetting != 3 || this.columnsWidths == null) {
            int availableColumnWidth = isNormalWidthColumns ? availWidth - (this.numberOfColumns - 1) * this.paddingHorizontal : (availWidth - (this.numberOfColumns - 1) * this.paddingHorizontal) / this.numberOfColumns;
            this.columnsWidths = new Dimension[this.numberOfColumns];
            for (int i7 = 0; i7 < this.numberOfColumns; ++i7) {
                this.columnsWidths[i7] = new Dimension(availableColumnWidth, false);
            }
        }
        this.numberOfRows = myItemsLength / this.numberOfColumns;
        if (myItemsLength % this.numberOfColumns != 0) {
            ++this.numberOfRows;
        }
        this.rowsHeights = new int[this.numberOfRows];
        int maxRowHeight = 0;
        int columnIndex = 0;
        int rowIndex = 0;
        int[] maxColumnWidths = null;
        if (isNormalWidthColumns) {
            maxColumnWidths = new int[this.numberOfColumns];
        }
        int maxWidth = 0;
        int myContentHeight = 0;
        boolean hasFocusableItem = false;
        int columnX = 0;
        int rowStartIndex = 0;
        for (i2 = 0; i2 < myItemsLength; ++i2) {
            Item item = myItems[i2];
            Dimension colWidthDim = this.columnsWidths[columnIndex];
            if (colWidthDim == null) {
                this.columnsWidths[columnIndex] = colWidthDim = new Dimension(availWidth / this.numberOfColumns);
            }
            int availColWidth = colWidthDim.getValue(availWidth);
            if (this.isAlignHeights) {
                item.setInitialized(false);
            }
            int width = item.itemWidth;
            if (reinitInAnyCase || width > availColWidth || !item.isInitialized) {
                width = item.getItemWidth(availColWidth, availColWidth, availHeight);
            }
            int height = item.itemHeight;
            if (item.appearanceMode != 0) {
                hasFocusableItem = true;
            }
            if (height > maxRowHeight) {
                maxRowHeight = height;
            }
            if (isNormalWidthColumns && width > maxColumnWidths[columnIndex]) {
                maxColumnWidths[columnIndex] = width;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++columnIndex;
            item.relativeX = columnX;
            if (width < availColWidth) {
                if (item.isLayoutCenter) {
                    item.relativeX += (availColWidth - width) / 2;
                } else if (item.isLayoutRight) {
                    item.relativeX += availColWidth - width;
                }
            }
            item.relativeY = myContentHeight;
            if (columnIndex == this.numberOfColumns || i2 == myItemsLength - 1) {
                if (item.isLayoutRight && this.isLayoutExpand()) {
                    item.relativeX = availWidth - width + 1;
                }
                columnIndex = 0;
                columnX = 0;
                this.rowsHeights[rowIndex] = maxRowHeight;
                myContentHeight += maxRowHeight + (maxRowHeight != 0 ? this.paddingVertical : 0);
                ++rowIndex;
                if (maxRowHeight != 0) {
                    for (int j = rowStartIndex; j <= i2; ++j) {
                        item = myItems[j];
                        if (item.itemHeight >= maxRowHeight) continue;
                        if (this.isAlignHeights && !item.isLayoutVerticalShrink()) {
                            item.setItemHeight(maxRowHeight);
                            continue;
                        }
                        if (item.isLayoutVerticalCenter()) {
                            item.relativeY += maxRowHeight - item.itemHeight >> 1;
                            continue;
                        }
                        if (!item.isLayoutBottom()) continue;
                        item.relativeY += maxRowHeight - item.itemHeight;
                    }
                }
                maxRowHeight = 0;
                rowStartIndex = i2 + 1;
                continue;
            }
            int columnXCent = 0;
            for (int j = 0; j < columnIndex; ++j) {
                columnXCent += this.columnsWidths[j].getValue(availWidth * 100) + this.paddingHorizontal;
            }
            columnX = columnXCent / 100;
            if (columnXCent % 100 < 50) continue;
            ++columnX;
        }
        this.appearanceMode = hasFocusableItem ? 3 : 0;
        if (columnIndex != 0) {
            this.rowsHeights[rowIndex] = maxRowHeight;
            myContentHeight += maxRowHeight;
        }
        columnX = 0;
        if (isNormalWidthColumns) {
            int i8;
            int availableRowWidth = availWidth - (this.numberOfColumns - 1) * this.paddingHorizontal;
            int availableColumnWidth = availableRowWidth / this.numberOfColumns;
            int usedUpWidth = 0;
            int leftColumns = this.numberOfColumns;
            int completeWidth = 0;
            for (i8 = 0; i8 < maxColumnWidths.length; ++i8) {
                int maxColumnWidth = maxColumnWidths[i8];
                if (maxColumnWidth <= availableColumnWidth) {
                    usedUpWidth += maxColumnWidth;
                    --leftColumns;
                }
                completeWidth += maxColumnWidth;
            }
            if (completeWidth <= availableRowWidth) {
                for (i8 = 0; i8 < this.numberOfColumns; ++i8) {
                    this.columnsWidths[i8] = new Dimension(maxColumnWidths[i8], false);
                }
            } else {
                int i9;
                int leftAvailableColumnWidth = (availableRowWidth - usedUpWidth) / leftColumns;
                int[] newMaxColumnWidths = new int[this.numberOfColumns];
                myContentHeight = 0;
                columnIndex = 0;
                rowIndex = 0;
                maxRowHeight = 0;
                maxWidth = 0;
                rowStartIndex = 0;
                for (i9 = 0; i9 < myItemsLength; ++i9) {
                    Item item = myItems[i9];
                    int width = item.itemWidth;
                    int height = item.itemHeight;
                    int maxColumnWidth = maxColumnWidths[columnIndex];
                    if (maxColumnWidth <= availableColumnWidth) {
                        newMaxColumnWidths[columnIndex] = maxColumnWidth;
                    } else {
                        if (width > leftAvailableColumnWidth) {
                            width = item.getItemWidth(leftAvailableColumnWidth, leftAvailableColumnWidth, availHeight);
                            height = item.itemHeight;
                        }
                        if (width > newMaxColumnWidths[columnIndex]) {
                            newMaxColumnWidths[columnIndex] = width;
                        }
                    }
                    ++columnIndex;
                    if (height > maxRowHeight) {
                        maxRowHeight = height;
                    }
                    item.relativeY = myContentHeight;
                    if (columnIndex != this.numberOfColumns && i9 != myItemsLength - 1) continue;
                    columnIndex = 0;
                    this.rowsHeights[rowIndex] = maxRowHeight;
                    myContentHeight += maxRowHeight + (maxRowHeight != 0 ? this.paddingVertical : 0);
                    for (int j = rowStartIndex; j <= i9; ++j) {
                        item = myItems[j];
                        if (item.itemHeight >= maxRowHeight) continue;
                        if (this.isAlignHeights) {
                            item.setItemHeight(maxRowHeight);
                            continue;
                        }
                        if ((item.layout & 0x30) == 48) {
                            item.relativeY += maxRowHeight - item.itemHeight >> 1;
                            continue;
                        }
                        if ((item.layout & 0x20) != 32) continue;
                        item.relativeY += maxRowHeight - item.itemHeight;
                    }
                    rowStartIndex = i9 + 1;
                    maxRowHeight = 0;
                    ++rowIndex;
                }
                for (i9 = 0; i9 < this.numberOfColumns; ++i9) {
                    this.columnsWidths[i9] = new Dimension(newMaxColumnWidths[i9], false);
                }
            }
        } else if (this.columnsSetting == 1 && !this.isLayoutExpand()) {
            for (i2 = 0; i2 < this.columnsWidths.length; ++i2) {
                this.columnsWidths[i2] = new Dimension(maxWidth, false);
            }
        }
        int myContentWidth = 0;
        columnIndex = 0;
        for (i = 0; i < myItemsLength; ++i) {
            Item item = myItems[i];
            int cw = this.columnsWidths[columnIndex].getValue(availWidth);
            item.relativeX = myContentWidth;
            if (item.itemWidth < cw) {
                if (item.isLayoutCenter) {
                    item.relativeX += (cw - item.itemWidth) / 2;
                } else if (item.isLayoutRight) {
                    item.relativeX += cw - item.itemWidth;
                }
            }
            myContentWidth += cw + this.paddingHorizontal;
            if (++columnIndex != this.numberOfColumns) continue;
            columnIndex = 0;
            myContentWidth = 0;
        }
        myContentWidth = 0;
        for (i = 0; i < this.columnsWidths.length; ++i) {
            myContentWidth += this.columnsWidths[i].getValue(availWidth) + this.paddingHorizontal;
        }
        this.isVertical = this.numberOfRows > 1;
        this.contentWidth = myContentWidth -= this.paddingHorizontal;
        this.contentHeight = myContentHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    protected boolean isLayoutExpand() {
        return (this.layout & 0x800) == 2048;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Item[] myItems = this.parentContainer.getItems();
        this.paintContent(this.parentContainer, myItems, x, y, leftBorder, rightBorder, g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight(), g);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int currentXOffset = this.xOffset;
        x += currentXOffset;
        for (int i = 0; i < myItems.length; ++i) {
            if (i == this.focusedIndex) continue;
            Item item = myItems[i];
            int itemX = x + item.relativeX;
            int itemY = y + item.relativeY;
            this.paintItem(item, i, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
        }
        Item focItem = this.focusedItem;
        if (focItem != null) {
            this.paintItem(focItem, this.focusedIndex, x += focItem.relativeX, y + focItem.relativeY, x, x + focItem.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (index == this.focusedIndex || (y < clipY + clipHeight && y + item.getItemAreaHeight() > clipY || item.internalX != -9999 && y + item.internalY < clipY + clipHeight && y + item.internalY + item.internalHeight > clipY) && x < clipX + clipWidth && x + item.itemWidth > clipX) {
            item.paint(x, y, leftBorder, rightBorder, g);
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        Item[] myItems = this.parentContainer.getItems();
        if (this.isHorizontal && gameAction == 5 && keyCode != 54 || this.isVertical && gameAction == 6 && keyCode != 56) {
            if (gameAction == 6 && this.columnsSetting != 0) {
                return this.shiftFocus(true, this.numberOfColumns - 1, myItems, this.allowCycling, gameAction);
            }
            boolean allowCycle = this.allowCycling;
            if (this.isHorizontal && gameAction == 5 && !this.isVertical) {
                allowCycle = true;
            }
            return this.shiftFocus(true, 0, myItems, allowCycle, gameAction);
        }
        if (this.isHorizontal && gameAction == 2 && keyCode != 52 || this.isVertical && gameAction == 1 && keyCode != 50) {
            if (gameAction == 1 && this.columnsSetting != 0) {
                return this.shiftFocus(false, -(this.numberOfColumns - 1), myItems, this.allowCycling, gameAction);
            }
            boolean allowCycle = this.allowCycling;
            if (this.isHorizontal && gameAction == 2 && !this.isVertical) {
                allowCycle = true;
            }
            return this.shiftFocus(false, 0, myItems, allowCycle, gameAction);
        }
        return null;
    }

    protected Item shiftFocus(boolean forwardFocus, int steps, Item[] items) {
        return this.shiftFocus(forwardFocus, steps, items, this.allowCycling, 0);
    }

    protected Item shiftFocus(boolean forwardFocus, int steps, Item[] items, boolean allowCycle) {
        return this.shiftFocus(forwardFocus, steps, items, allowCycle, 0);
    }

    protected Item shiftFocus(boolean forwardFocus, int steps, Item[] items, boolean allowCycle, int direction) {
        if (!allowCycle && forwardFocus && steps != 0 && this.isInBottomRow(this.focusedIndex)) {
            return null;
        }
        int i = this.focusedIndex + steps;
        if (steps != 0) {
            if (!forwardFocus) {
                if (i < 0) {
                    if (!allowCycle) {
                        return null;
                    }
                    i = items.length + i;
                }
            } else if ((i %= items.length) >= items.length) {
                if (!allowCycle) {
                    return null;
                }
                i -= items.length;
            }
        }
        Item nextItem = null;
        while (!(forwardFocus ? ++i >= items.length : --i < 0)) {
            nextItem = items[i];
            if (nextItem.appearanceMode == 0) continue;
        }
        if (nextItem == null || nextItem.appearanceMode == 0 || nextItem == this.focusedItem) {
            return null;
        }
        Screen screen = this.getScreen();
        Item focItem = this.focusedItem;
        if (forwardFocus && focItem != null && nextItem.relativeY < focItem.relativeY) {
            this.parentContainer.setScrollYOffset(0, true);
        }
        if (screen != null && focItem != null && screen.container == this.parentContainer && forwardFocus && i > this.focusedIndex && nextItem.relativeY - focItem.relativeY + (focItem.relativeY + this.parentContainer.getRelativeScrollYOffset()) > screen.contentHeight) {
            return null;
        }
        this.focusItem(i, nextItem);
        return nextItem;
    }

    protected boolean isInBottomRow(int index) {
        if (this.columnsSetting == 0 || this.parentContainer.size() <= 1) {
            return index == this.parentContainer.size() - 1;
        }
        int row = index / this.numberOfColumns;
        return row == this.numberOfRows - 1;
    }

    protected void focusItem(int index, Item item) {
        int direction = 0;
        direction = this.focusedIndex < index ? 6 : (this.focusedIndex == index ? 0 : 1);
        this.focusItem(index, item, direction);
    }

    protected void focusItem(int index, Item item, int direction) {
        this.parentContainer.focusChild(index, item, direction, true);
    }

    protected void setStyle(Style style) {
        Boolean alignHeightsBool;
        super.setStyle(style);
        Integer columns = style.getIntProperty(4);
        if (columns != null) {
            this.numberOfColumns = columns;
            this.columnsSetting = 2;
            String width = style.getProperty(5);
            if (width != null) {
                if ("equal".equals(width)) {
                    this.columnsSetting = 1;
                } else if (!"normal".equals(width)) {
                    String[] widths = TextUtil.split(width, ',');
                    if (widths.length != this.numberOfColumns) {
                        this.columnsSetting = 2;
                    } else {
                        this.columnsSetting = 3;
                        this.columnsWidths = new Dimension[this.numberOfColumns];
                        for (int i = 0; i < widths.length; ++i) {
                            String widthStr = widths[i];
                            this.columnsWidths[i] = new Dimension(widthStr);
                        }
                        this.columnsSetting = 3;
                    }
                }
            }
        }
        if ((alignHeightsBool = style.getBooleanProperty(381)) != null) {
            this.isAlignHeights = alignHeightsBool;
        }
    }

    protected Item getNextFocusableItem(Item[] items, boolean forward, int steps, boolean allowCircle) {
        block11: {
            Item item;
            int i = this.focusedIndex;
            do {
                boolean isInLoop;
                if (forward) {
                    boolean bl = isInLoop = (i += steps) < items.length;
                    if (!isInLoop) {
                        if (steps > 1) {
                            i = items.length - 1;
                            isInLoop = true;
                        } else if (allowCircle) {
                            steps = 1;
                            allowCircle = false;
                            i = 0;
                            isInLoop = true;
                        }
                    }
                } else {
                    boolean bl = isInLoop = (i -= steps) >= 0;
                    if (!isInLoop) {
                        if (steps > 1) {
                            i = 0;
                            isInLoop = true;
                        } else if (allowCircle) {
                            steps = 1;
                            allowCircle = false;
                            i = items.length - 1;
                            isInLoop = true;
                        }
                    }
                }
                if (!isInLoop) break block11;
                item = items[i];
            } while (item.appearanceMode == 0);
            this.focusedIndex = i;
            return item;
        }
        return null;
    }

    public void showNotify() {
        this.restartAnimation = true;
        super.showNotify();
    }

    protected Screen getScreen() {
        return this.parentContainer.getScreen();
    }

    public boolean handleKeyPressed(int keyCode, int gameAction) {
        Item item = this.getNextItem(keyCode, gameAction);
        return item != null;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (this.contentWidth > this.availableWidth) {
            this.initHorizontalScrolling(x, y);
        }
        return super.handlePointerPressed(x, y);
    }

    private void initHorizontalScrolling(int x, int y) {
        this.pointerPressedX = x;
        this.lastPointerPressXOffset = this.getScrollXOffset();
        this.lastPointerPressTime = System.currentTimeMillis();
        this.isPointerPressedHandled = this.parentContainer.isInContentWithPaddingArea(x, y);
    }

    public boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        int availWidth = this.availableWidth;
        if (this.isPointerPressedHandled && this.contentWidth > availWidth) {
            int offset = this.xOffset + (x - this.pointerPressedX);
            if (offset + this.contentWidth < availWidth - availWidth / 3) {
                offset = availWidth - availWidth / 3 - this.contentWidth;
            } else if (offset > availWidth / 3) {
                offset = availWidth / 3;
            }
            if (offset != this.xOffset) {
                this.setScrollXOffset(offset, false);
                this.pointerPressedX = x;
                this.parentContainer.addRepaintArea(repaintRegion);
                return true;
            }
        }
        return super.handlePointerDragged(x, y, repaintRegion);
    }

    public boolean handlePointerReleased(int x, int y) {
        this.isPointerPressedHandled = false;
        if (this.contentWidth > this.availableWidth && this.startHorizontalScroll(x, y)) {
            return true;
        }
        return super.handlePointerReleased(x, y);
    }

    private boolean startHorizontalScroll(int x, int y) {
        int offset = this.xOffset;
        int scrollDiff = Math.abs(offset - this.lastPointerPressXOffset);
        if (scrollDiff > this.availableWidth / 10 || offset > 0 || offset + this.contentWidth < this.availableWidth) {
            long dragTime = System.currentTimeMillis() - this.lastPointerPressTime;
            if (dragTime < 1000L && dragTime > 1L) {
                int direction = 5;
                if (offset > this.lastPointerPressXOffset) {
                    direction = 2;
                }
                this.startScroll(direction, (int)((long)(scrollDiff * 1000) / dragTime), 20);
            } else if (offset > 0) {
                this.setScrollXOffset(0, true);
            } else if (offset + this.contentWidth < this.availableWidth) {
                this.setScrollXOffset(this.availableWidth - this.contentWidth, true);
            }
            return true;
        }
        return false;
    }

    protected void scroll(int direction, int x, int y, int width, int height, boolean force) {
        Item item;
        Container container = this.parentContainer;
        while (!container.enableScrolling && (item = container.parent) instanceof Container) {
            x += container.relativeX;
            y += container.relativeY;
            container = (Container)item;
        }
        if (container.enableScrolling) {
            container.scroll(direction, x, y, width, height, force);
        }
    }

    protected int getParentRelativeY() {
        return this.parentContainer.relativeY;
    }

    protected int getItemRelativeY(Item item) {
        return item.relativeY;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Container;
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        this.focusedIndex = index;
        this.focusedItem = item;
        return item.focus(focusedStyle, direction);
    }

    public void releaseResources() {
        super.releaseResources();
        if (this.parentContainer != null) {
            this.parentContainer.isInitialized = false;
        }
    }

    public void destroy() {
        this.releaseResources();
        this.parentContainer = null;
    }

    protected boolean isVirtualContainer() {
        return false;
    }

    public void startScroll(int direction, int speed, int damping) {
        if (direction == 1 || direction == 6) {
            this.parentContainer.startScroll(direction, speed, damping);
        } else {
            this.lastAnimationTime = System.currentTimeMillis();
            this.scrollDirection = direction;
            this.scrollSpeed = speed;
            this.scrollDamping = damping;
        }
    }

    public void setAppearanceMode(int appearanceMode) {
        this.appearanceMode = appearanceMode;
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    public Item getChildAt(int relX, int relY) {
        return this.parentContainer.getChildAtImpl(relX, relY);
    }

    protected int getChildWidth(Item item) {
        Container parent = this.parentContainer;
        int w = item.availableWidth > 0 ? item.getItemWidth(item.availableWidth, item.availableWidth, item.availableHeight) : item.getItemWidth(parent.availContentWidth, parent.availContentWidth, parent.availContentHeight);
        return w;
    }

    protected int getChildHeight(Item item) {
        Container parent = this.parentContainer;
        int h = item.availableWidth > 0 ? item.getItemHeight(item.availableWidth, item.availableWidth, item.availableHeight) : item.getItemHeight(parent.availContentWidth, parent.availContentWidth, parent.availContentHeight);
        return h;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.allowCycling = dataInputStream.readBoolean();
        this.allowsAutoTraversal = dataInputStream.readBoolean();
        this.allowsDirectSelectionByPointerEvent = dataInputStream.readBoolean();
        this.appearanceMode = dataInputStream.readInt();
        this.columnsSetting = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.columnsWidths = new Dimension[n2];
            n = 0;
            while (n < n2) {
                this.columnsWidths[n] = (Dimension)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        this.focusFirstElement = dataInputStream.readBoolean();
        this.focusedIndex = dataInputStream.readInt();
        this.isAlignHeights = dataInputStream.readBoolean();
        this.isHorizontal = dataInputStream.readBoolean();
        this.isPointerPressedHandled = dataInputStream.readBoolean();
        this.isVertical = dataInputStream.readBoolean();
        this.lastAnimationTime = dataInputStream.readLong();
        this.lastAvailableContentWidth = dataInputStream.readInt();
        this.lastPointerPressTime = dataInputStream.readLong();
        this.lastPointerPressXOffset = dataInputStream.readInt();
        this.numberOfColumns = dataInputStream.readInt();
        this.numberOfRows = dataInputStream.readInt();
        this.pointerPressedX = dataInputStream.readInt();
        this.restartAnimation = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rowsHeights = new int[n2];
            n = 0;
            while (n < n2) {
                this.rowsHeights[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.scrollContinuous = dataInputStream.readBoolean();
        this.scrollDamping = dataInputStream.readInt();
        this.scrollDirection = dataInputStream.readInt();
        this.scrollDuration = dataInputStream.readLong();
        this.scrollSpeed = dataInputStream.readInt();
        this.scrollStartTime = dataInputStream.readLong();
        this.scrollStartXOffset = dataInputStream.readInt();
        this.targetXOffset = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.allowCycling);
        dataOutputStream.writeBoolean(this.allowsAutoTraversal);
        dataOutputStream.writeBoolean(this.allowsDirectSelectionByPointerEvent);
        dataOutputStream.writeInt(this.appearanceMode);
        dataOutputStream.writeInt(this.columnsSetting);
        if (this.columnsWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.columnsWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.columnsWidths[n], dataOutputStream);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.focusFirstElement);
        dataOutputStream.writeInt(this.focusedIndex);
        dataOutputStream.writeBoolean(this.isAlignHeights);
        dataOutputStream.writeBoolean(this.isHorizontal);
        dataOutputStream.writeBoolean(this.isPointerPressedHandled);
        dataOutputStream.writeBoolean(this.isVertical);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.lastAvailableContentWidth);
        dataOutputStream.writeLong(this.lastPointerPressTime);
        dataOutputStream.writeInt(this.lastPointerPressXOffset);
        dataOutputStream.writeInt(this.numberOfColumns);
        dataOutputStream.writeInt(this.numberOfRows);
        dataOutputStream.writeInt(this.pointerPressedX);
        dataOutputStream.writeBoolean(this.restartAnimation);
        if (this.rowsHeights == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rowsHeights.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rowsHeights[n]);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.scrollContinuous);
        dataOutputStream.writeInt(this.scrollDamping);
        dataOutputStream.writeInt(this.scrollDirection);
        dataOutputStream.writeLong(this.scrollDuration);
        dataOutputStream.writeInt(this.scrollSpeed);
        dataOutputStream.writeLong(this.scrollStartTime);
        dataOutputStream.writeInt(this.scrollStartXOffset);
        dataOutputStream.writeInt(this.targetXOffset);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

