/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.CssAnimation;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.FocusListener;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Graphics;

public class Container
extends Item {
    public static final int SCROLL_DEFAULT = 0;
    public static final int SCROLL_SMOOTH = 1;
    protected ArrayList itemsList = new ArrayList();
    protected boolean autoFocusEnabled;
    protected int autoFocusIndex;
    protected Style itemStyle;
    protected Item focusedItem;
    public int focusedIndex = -1;
    protected boolean enableScrolling;
    public boolean allowCycling = false;
    protected int yOffset;
    protected int targetYOffset;
    private int focusedTopMargin;
    protected ContainerView containerView;
    protected int lastPointerPressY;
    protected int lastPointerPressYOffset;
    protected long lastPointerPressTime;
    private boolean isScrollRequired;
    protected int scrollHeight = -1;
    private Item[] containerItems;
    private boolean showCommandsHasBeenCalled;
    private Item scrollItem;
    protected Style plainStyle;
    private static final String KEY_ORIGINAL_STYLE = "os";
    private boolean isFocusAllChildren;
    private boolean isPressAllChildren;
    private boolean isIgnoreMargins;
    boolean appearanceModeSet;
    private int scrollDirection;
    private int scrollSpeed;
    private int scrollDamping;
    private long lastAnimationTime;
    private boolean isScrolling;
    private FocusListener focusListener;
    private long scrollStartTime;
    private int scrollStartYOffset;
    private long scrollDuration = 300L;

    public Container() {
        this(null, false, null, -1);
    }

    public Container(Style style) {
        this(null, false, style, -1);
    }

    public Container(boolean focusFirstElement) {
        this(null, focusFirstElement, null, -1);
    }

    public Container(boolean focusFirstElement, Style style) {
        this(null, focusFirstElement, style, -1);
    }

    public Container(String label, boolean focusFirstElement, Style style, int height) {
        super(label, 0, 3, style);
        this.setAutoFocusEnabled(focusFirstElement);
        this.layout |= 0x100;
        this.setScrollHeight(height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollHeight(int height) {
        Item item;
        boolean scrollAutomatic = this.scrollHeight != -1 && height != -1 && height != this.scrollHeight && this.isInitialized();
        this.scrollHeight = height;
        boolean bl = this.enableScrolling = height != -1;
        Item item2 = this.scrollItem != null ? this.scrollItem : (item = this.isFocused ? this.focusedItem : null);
        if (scrollAutomatic && item != null) {
            this.scroll(0, item, true);
            ArrayList arrayList = this.itemsList;
            synchronized (arrayList) {
                this.isScrollRequired = false;
            }
        }
    }

    public int getScrollHeight() {
        if (this.scrollHeight == -1 && this.parent instanceof Container) {
            return ((Container)this.parent).getScrollHeight();
        }
        return this.scrollHeight;
    }

    int getContentScrollHeight() {
        return this.getScrollHeight() - (this.contentY + this.getBorderWidthTop() + this.getBorderWidthBottom() + this.paddingBottom + this.marginBottom);
    }

    public void add(String text) {
        this.add(new StringItem(null, text));
    }

    public void add(String text, Style textAddStyle) {
        this.add(new StringItem(null, text), textAddStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Item item) {
        Style itemFocusedStyle;
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            item.relativeY = 0;
            item.internalX = -9999;
            item.parent = this;
            this.itemsList.add(item);
            if (this.isInitialized()) {
                this.requestInit();
            }
        }
        if (this.isShown) {
            item.showNotify();
        }
        if (this.isFocused && this.isFocusAllChildren && !item.isFocused && (itemFocusedStyle = item.getFocusedStyle()) != this.style && itemFocusedStyle != StyleSheet.focusedStyle) {
            if (item.style != null) {
                item.setAttribute(KEY_ORIGINAL_STYLE, item.style);
            }
            item.focus(itemFocusedStyle, 0);
        }
        if (this.isShown) {
            this.repaint();
        }
        this.notifyValueChanged(item);
    }

    public void add(Item item, Style itemAddStyle) {
        this.add(item);
        if (itemAddStyle != null) {
            item.style = itemAddStyle;
            item.isStyleInitialised = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Item item) {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            Style itemFocusedStyle;
            item.relativeY = 0;
            item.internalX = -9999;
            item.parent = this;
            this.itemsList.add(index, item);
            if (index <= this.focusedIndex) {
                ++this.focusedIndex;
                if (this.containerView != null) {
                    this.containerView.focusedIndex = this.focusedIndex;
                }
            }
            if (this.isShown) {
                this.requestInit();
            }
            for (int i = index + 1; i < this.itemsList.size(); ++i) {
                Item followingItem = this.get(i);
                followingItem.relativeY = 0;
            }
            if (this.isShown) {
                item.showNotify();
            }
            if (this.isFocused && this.isFocusAllChildren && (itemFocusedStyle = item.getFocusedStyle()) != this.style && itemFocusedStyle != StyleSheet.focusedStyle) {
                if (item.style != null) {
                    item.setAttribute(KEY_ORIGINAL_STYLE, item.style);
                }
                item.focus(itemFocusedStyle, 0);
            }
        }
        if (this.isShown) {
            this.repaint();
        }
    }

    public Item set(int index, Item item) {
        return this.set(index, item, null);
    }

    public Item set(int index, Item item, Style itemStyle) {
        Style itemFocusedStyle;
        Item last = this.get(index);
        if (last == item && (itemStyle == null || itemStyle == item.style)) {
            return last;
        }
        item.parent = this;
        boolean focusNewItem = index == this.focusedIndex && last.isFocused;
        this.itemsList.set(index, item);
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        if (index == this.focusedIndex) {
            if (item.appearanceMode != 0) {
                if (focusNewItem) {
                    this.focusedItem = null;
                    this.focusChild(index, item, 0, true);
                } else {
                    this.focusedItem = item;
                }
            } else {
                this.focusChild(-1);
            }
        }
        if (this.enableScrolling && (this.focusedIndex == -1 || index <= this.focusedIndex)) {
            int offset = this.getScrollYOffset() + last.itemHeight;
            if (offset > 0) {
                offset = 0;
            }
            this.setScrollYOffset(offset, true);
        }
        if (this.isFocused && this.isFocusAllChildren && !item.isFocused && (itemFocusedStyle = item.getFocusedStyle()) != this.style && itemFocusedStyle != StyleSheet.focusedStyle) {
            if (item.style != null) {
                item.setAttribute(KEY_ORIGINAL_STYLE, item.style);
            }
            item.focus(itemFocusedStyle, 0);
        }
        for (int i = index + 1; i < this.itemsList.size(); ++i) {
            Item followingItem = this.get(i);
            followingItem.relativeY = 0;
        }
        this.requestInit();
        this.repaint();
        if (this.isShown) {
            item.showNotify();
        }
        this.notifyValueChanged(item);
        return last;
    }

    public Item get(int index) {
        return (Item)this.itemsList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item remove(int index) {
        Item removedItem = null;
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            Item item;
            removedItem = (Item)this.itemsList.remove(index);
            if (removedItem == this.scrollItem) {
                this.scrollItem = null;
            }
            Object[] myItems = this.itemsList.getInternalArray();
            int removedItemHeight = removedItem.itemHeight + this.paddingVertical;
            if (this.containerView == null) {
                for (int i = index; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
                    item.relativeY -= removedItemHeight;
                }
            }
            if (index == this.focusedIndex) {
                Screen scr;
                this.focusedItem = null;
                removedItem.defocus(this.itemStyle);
                if (this.containerView != null) {
                    this.containerView.focusedIndex = -1;
                    this.containerView.focusedItem = null;
                }
                if ((scr = this.getScreen()) != null) {
                    scr.removeItemCommands(removedItem);
                }
                if (index >= this.itemsList.size()) {
                    index = this.itemsList.size() - 1;
                }
                if (index != -1) {
                    item = (Item)myItems[index];
                    if (item.appearanceMode != 0) {
                        this.focusChild(index, item, 6, true);
                    } else {
                        this.focusClosestItem(index);
                    }
                } else {
                    this.focusedIndex = -1;
                    this.setAutoFocusEnabled(true);
                    this.autoFocusIndex = 0;
                }
            } else if (index < this.focusedIndex) {
                if (this.containerView != null) {
                    --this.containerView.focusedIndex;
                } else {
                    int offset = this.getScrollYOffset() + removedItemHeight;
                    this.setScrollYOffset(offset > 0 ? 0 : offset, false);
                }
                --this.focusedIndex;
            }
            this.setInitialized(false);
            if (this.parent != null) {
                this.parent.setInitialized(false);
            }
            if (this.isShown) {
                removedItem.hideNotify();
            }
        }
        this.repaint();
        this.notifyValueChanged(removedItem);
        return removedItem;
    }

    public boolean focusClosestItemAbove(int index) {
        Item item;
        int i;
        Item[] myItems = this.getItems();
        Item newFocusedItem = null;
        int newFocusedIndex = -1;
        for (i = index - 1; i >= 0; --i) {
            item = myItems[i];
            if (item.appearanceMode == 0) continue;
            newFocusedIndex = i;
            newFocusedItem = item;
            break;
        }
        if (newFocusedItem == null) {
            for (i = index + 1; i < myItems.length; ++i) {
                item = myItems[i];
                if (item.appearanceMode == 0) continue;
                newFocusedIndex = i;
                newFocusedItem = item;
                break;
            }
        }
        if (newFocusedItem != null) {
            int direction = 6;
            if (newFocusedIndex < index) {
                direction = 1;
            }
            this.focusChild(newFocusedIndex, newFocusedItem, direction, true);
        } else {
            this.setAutoFocusEnabled(true);
            this.focusedItem = null;
            this.focusedIndex = -1;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
        }
        return newFocusedItem != null;
    }

    public boolean focusClosestItem(int index) {
        int i = 1;
        Item newFocusedItem = null;
        boolean continueFocus = true;
        Object[] myItems = this.itemsList.getInternalArray();
        int size = this.itemsList.size();
        while (continueFocus) {
            Item item;
            continueFocus = false;
            int testIndex = index + i;
            if (testIndex < size) {
                item = (Item)myItems[testIndex];
                if (item == null) break;
                if (item.appearanceMode != 0) {
                    newFocusedItem = item;
                    i = testIndex;
                    break;
                }
                continueFocus = true;
            }
            if ((testIndex = index - i) >= 0) {
                item = (Item)myItems[testIndex];
                if (item.appearanceMode != 0) {
                    i = testIndex;
                    newFocusedItem = item;
                    break;
                }
                continueFocus = true;
            }
            ++i;
        }
        if (newFocusedItem != null) {
            int direction = 6;
            if (i < index) {
                direction = 1;
            }
            this.focusChild(i, newFocusedItem, direction, true);
        } else {
            this.setAutoFocusEnabled(true);
            this.focusedItem = null;
            this.focusedIndex = -1;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
        }
        return newFocusedItem != null;
    }

    public boolean remove(Item item) {
        int index = this.itemsList.indexOf(item);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            Container parentContainer;
            int scrollOffset;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
            this.scrollItem = null;
            if (this.isShown) {
                Item item;
                Object[] myItems = this.itemsList.getInternalArray();
                for (int i = 0; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
                    item.hideNotify();
                }
            }
            this.itemsList.clear();
            this.containerItems = new Item[0];
            if (this.focusedIndex != -1) {
                this.setAutoFocusEnabled(this.isFocused);
                this.autoFocusIndex = 0;
                this.focusedIndex = -1;
                if (this.focusedItem != null) {
                    Screen scr;
                    if (this.itemStyle != null) {
                        this.focusedItem.defocus(this.itemStyle);
                    }
                    if (this.focusedItem.commands != null && (scr = this.getScreen()) != null) {
                        scr.removeItemCommands(this.focusedItem);
                    }
                }
                this.focusedItem = null;
            }
            this.yOffset = 0;
            this.targetYOffset = 0;
            if (this.internalX != -9999) {
                this.internalX = -9999;
                this.internalY = 0;
            }
            if (this.isFocused && this.parent instanceof Container && (scrollOffset = -(parentContainer = (Container)this.parent).getScrollYOffset()) > this.relativeY) {
                int diff = scrollOffset - this.relativeY;
                parentContainer.setScrollYOffset(diff - scrollOffset, false);
            }
            this.contentHeight = 0;
            this.contentWidth = 0;
            this.itemHeight = this.marginTop + this.paddingTop + this.paddingBottom + this.marginBottom;
            this.itemWidth = this.marginLeft + this.paddingLeft + this.paddingRight + this.marginRight;
            if (this.isInitialized()) {
                this.setInitialized(false);
                this.repaint();
            }
        }
    }

    public int size() {
        return this.itemsList.size();
    }

    public Item[] getItems() {
        if (!this.isInitialized() || this.containerItems == null) {
            this.containerItems = (Item[])this.itemsList.toArray(new Item[this.itemsList.size()]);
        }
        return this.containerItems;
    }

    public void setFocusListener(FocusListener listener) {
        this.focusListener = listener;
    }

    public FocusListener getFocusListener() {
        return this.focusListener;
    }

    public boolean focusChild(int index) {
        if (index == -1) {
            this.focusedIndex = -1;
            Item item = this.focusedItem;
            if (item != null && this.itemStyle != null && item.isFocused) {
                item.defocus(this.itemStyle);
            }
            this.focusedItem = null;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
            if (this.focusListener != null) {
                this.focusListener.onFocusChanged(this, null, -1);
            }
            return true;
        }
        if (!this.isFocused) {
            this.setAutoFocusEnabled(true);
        }
        Item item = this.get(index);
        if (item.appearanceMode != 0) {
            int direction = 0;
            if (this.isFocused && this.focusedIndex != -1) {
                if (this.focusedIndex < index) {
                    direction = 6;
                } else if (this.focusedIndex > index) {
                    direction = 1;
                }
            }
            this.focusChild(index, item, direction, true);
            return true;
        }
        return false;
    }

    public void focusChild(int index, Item item, int direction, boolean force) {
        int layoutBefore;
        int hBefore;
        int wBefore;
        if (!this.isInitialized() && this.autoFocusEnabled) {
            this.autoFocusIndex = index;
        }
        if (this.isFocused) {
            this.setAutoFocusEnabled(false);
        }
        if (index == this.focusedIndex && item.isFocused && item == this.focusedItem) {
            if (this.containerView != null && this.containerView.focusedIndex != index) {
                this.containerView.focusedItem = item;
                this.containerView.focusedIndex = index;
            }
            return;
        }
        boolean isReinitializationRequired = false;
        Item previouslyFocusedItem = this.focusedItem;
        if (previouslyFocusedItem != null) {
            wBefore = previouslyFocusedItem.itemWidth;
            hBefore = previouslyFocusedItem.itemHeight;
            layoutBefore = previouslyFocusedItem.layout;
            if (this.itemStyle != null) {
                previouslyFocusedItem.defocus(this.itemStyle);
            } else {
                Debug.debug("error", "de.enough.polish.ui.Container", 1049, "Container: Unable to defocus item - no previous style found.");
                previouslyFocusedItem.defocus(StyleSheet.defaultStyle);
            }
            if (this.isInitialized()) {
                int wAfter = this.getChildWidth(item);
                int hAfter = previouslyFocusedItem.itemHeight;
                int layoutAfter = previouslyFocusedItem.layout;
                if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                    isReinitializationRequired = true;
                    if (this.containerView != null) {
                        previouslyFocusedItem.setInitialized(false);
                    }
                }
            }
        }
        wBefore = item.itemWidth;
        hBefore = item.itemHeight;
        layoutBefore = item.layout;
        Style newStyle = this.getFocusedStyle(index, item);
        boolean isDownwards = direction == 6 || direction == 5 || direction == 0 && index > this.focusedIndex;
        int previousIndex = this.focusedIndex;
        this.focusedIndex = index;
        this.focusedItem = item;
        int scrollOffsetBeforeScroll = this.getScrollYOffset();
        this.itemStyle = this.containerView != null ? this.containerView.focusItem(index, item, direction, newStyle) : item.focus(newStyle, direction);
        if (this.itemStyle == null) {
            Debug.debug("error", "de.enough.polish.ui.Container", 1093, (Object)"Container: Unable to retrieve style of item ", item.getClass().getName());
        }
        if (this.isInitialized()) {
            int wAfter = this.getChildWidth(item);
            int hAfter = item.itemHeight;
            int layoutAfter = item.layout;
            if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                isReinitializationRequired = true;
                if (this.containerView != null) {
                    item.setInitialized(false);
                }
            }
            this.updateInternalPosition(item);
            if (this.getScrollHeight() != -1) {
                Item nextItem = isDownwards && index < this.itemsList.size() - 1 ? this.get(index + 1) : (!isDownwards && index > 0 ? this.get(index - 1) : item);
                if (this.getScrollYOffset() == scrollOffsetBeforeScroll) {
                    if (this.enableScrolling && (isDownwards && index < previousIndex || previousIndex == -1)) {
                        if (this.containerView == null || !this.containerView.isVirtualContainer()) {
                            this.setScrollYOffset(0, true);
                        }
                    } else {
                        int itemYTop = isDownwards ? item.relativeY : nextItem.relativeY;
                        int itemYBottom = isDownwards ? nextItem.relativeY + nextItem.itemHeight : item.relativeY + item.itemHeight;
                        int height = itemYBottom - itemYTop;
                        this.scroll(direction, this.relativeX, itemYTop, item.internalWidth, height, force);
                    }
                }
            }
        } else if (this.getScrollHeight() != -1) {
            this.isScrollRequired = true;
        }
        if (this.isInitialized()) {
            this.setInitialized(!isReinitializationRequired);
        } else if (this.contentWidth != 0) {
            this.updateInternalPosition(item);
        }
        if (this.focusListener != null) {
            this.focusListener.onFocusChanged(this, this.focusedItem, this.focusedIndex);
        }
    }

    protected int getChildWidth(Item item) {
        ContainerView contView = this.containerView;
        if (contView != null) {
            return contView.getChildWidth(item);
        }
        int w = item.availableWidth > 0 ? item.getItemWidth(item.availableWidth, item.availableWidth, item.availableHeight) : item.getItemWidth(this.availContentWidth, this.availContentWidth, this.availContentHeight);
        return w;
    }

    protected int getChildHeight(Item item) {
        ContainerView contView = this.containerView;
        if (contView != null) {
            return contView.getChildHeight(item);
        }
        int h = item.availableWidth > 0 ? item.getItemHeight(item.availableWidth, item.availableWidth, item.availableHeight) : item.getItemHeight(this.availContentWidth, this.availContentWidth, this.availContentHeight);
        return h;
    }

    protected Style getFocusedStyle(int index, Item item) {
        Style newStyle = item.getFocusedStyle();
        return newStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scroll(int direction, Item item, boolean force) {
        if (item.internalX != -9999 && (item.itemHeight > this.getScrollHeight() || item.internalY + item.internalHeight > item.contentHeight)) {
            int relativeInternalX = item.relativeX + item.contentX + item.internalX;
            int relativeInternalY = item.relativeY + item.contentY + item.internalY;
            return this.scroll(direction, relativeInternalX, relativeInternalY, item.internalWidth, item.internalHeight, force);
        }
        if (!this.isInitialized() && item.relativeY == 0) {
            ArrayList arrayList = this.itemsList;
            synchronized (arrayList) {
                this.scrollItem = item;
            }
            return true;
        }
        return this.scroll(direction, item.relativeX, item.relativeY, item.itemWidth, item.itemHeight, force);
    }

    protected boolean scroll(int direction, int x, int y, int width, int height) {
        return this.scroll(direction, x, y, width, height, false);
    }

    protected boolean scroll(int direction, int x, int y, int width, int height, boolean force) {
        boolean isCenterOrBottomLayout;
        int currentYOffset;
        if (!this.enableScrolling) {
            if (this.parent instanceof Container) {
                return ((Container)this.parent).scroll(direction, x += this.contentX + this.relativeX, y += this.contentY + this.relativeY, width, height, force);
            }
            return false;
        }
        if (height == 0) {
            return false;
        }
        boolean isDownwards = direction == 6 || direction == 5 || direction == 0;
        boolean isUpwards = direction == 1;
        int originalYOffset = currentYOffset = this.targetYOffset;
        int verticalSpace = this.scrollHeight - (this.contentY + this.marginBottom + this.paddingBottom + this.getBorderWidthBottom());
        int yTopAdjust = 0;
        Screen scr = this.screen;
        boolean bl = isCenterOrBottomLayout = (this.layout & 0x30) == 48 || (this.layout & 0x20) == 32;
        if (isCenterOrBottomLayout && scr != null && this == scr.container && this.relativeY > scr.contentY) {
            yTopAdjust = this.relativeY - scr.contentY;
        }
        if (y + height + currentYOffset + yTopAdjust > verticalSpace) {
            int difference;
            int newYOffset = verticalSpace - (y + height + yTopAdjust);
            if (!isUpwards && y + newYOffset < 0) {
                newYOffset = -y;
            }
            if (isDownwards && (difference = Math.max(Math.abs(currentYOffset), Math.abs(newYOffset)) - Math.min(Math.abs(currentYOffset), Math.abs(newYOffset))) > verticalSpace && !force) {
                newYOffset = currentYOffset - verticalSpace;
            }
            currentYOffset = newYOffset;
        } else if (y + currentYOffset < 0) {
            int difference;
            int newYOffset = -y;
            if (isUpwards && newYOffset + y + height > verticalSpace) {
                newYOffset = -(y + height) + verticalSpace;
            }
            if ((difference = Math.max(Math.abs(currentYOffset), Math.abs(newYOffset)) - Math.min(Math.abs(currentYOffset), Math.abs(newYOffset))) > verticalSpace && !force) {
                newYOffset = currentYOffset + verticalSpace;
            }
            currentYOffset = newYOffset;
        } else {
            return false;
        }
        if (currentYOffset != originalYOffset) {
            this.setScrollYOffset(currentYOffset, true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppearanceMode(int appearanceMode) {
        super.setAppearanceMode(appearanceMode);
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            this.appearanceModeSet = true;
        }
    }

    protected void initLayout(Style style, int availWidth) {
        if (this.containerView != null) {
            this.containerView.initPadding(style, availWidth);
        } else {
            this.initPadding(style, availWidth);
        }
        if (this.containerView != null) {
            this.containerView.initMargin(style, availWidth);
        } else {
            this.initMargin(style, availWidth);
        }
    }

    public Object getSynchronizationLock() {
        Object lock = this.itemsList;
        Screen scr = this.getScreen();
        if (scr != null) {
            lock = scr.getPaintLock();
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        if (this.focusedStyle != null) {
            this.focusedTopMargin = this.focusedStyle.getMarginTop(availWidth) + this.focusedStyle.getPaddingTop(availWidth);
            if (this.focusedStyle.border != null) {
                this.focusedTopMargin += this.focusedStyle.border.borderWidthTop;
            }
            if (this.focusedStyle.background != null) {
                this.focusedTopMargin += this.focusedStyle.background.borderWidth;
            }
        }
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            boolean scrolled;
            Item item;
            int i;
            Item[] myItems;
            int myContentWidth = 0;
            int myContentHeight = 0;
            if (this.containerItems == null || this.containerItems.length != this.itemsList.size()) {
                myItems = (Item[])this.itemsList.toArray(new Item[this.itemsList.size()]);
                this.containerItems = myItems;
            } else {
                myItems = (Item[])this.itemsList.toArray(this.containerItems);
            }
            if (this.autoFocusEnabled && this.autoFocusIndex >= myItems.length) {
                this.autoFocusIndex = 0;
            }
            if (this.containerView != null) {
                boolean scrolled2;
                boolean requireScrolling = this.isScrollRequired && this.isFocused;
                this.containerView.parentItem = this;
                this.containerView.parentContainer = this;
                this.containerView.init(this, firstLineWidth, availWidth, availHeight);
                if (this.defaultCommand != null || this.commands != null && this.commands.size() > 0) {
                    this.appearanceMode = 3;
                } else if (!this.appearanceModeSet) {
                    this.appearanceMode = this.containerView.appearanceMode;
                }
                if (this.isFocused && this.autoFocusEnabled) {
                    System.out.println("Container/View: autofocusing element starting at " + this.autoFocusIndex);
                    if (this.autoFocusIndex >= 0 && this.appearanceMode != 0) {
                        for (int i2 = this.autoFocusIndex; i2 < myItems.length; ++i2) {
                            Item item2 = myItems[i2];
                            if (item2.appearanceMode == 0) continue;
                            this.setAutoFocusEnabled(false);
                            requireScrolling = this.autoFocusIndex != 0;
                            this.focusChild(i2, item2, 0, true);
                            this.isScrollRequired = this.isScrollRequired && requireScrolling;
                            break;
                        }
                    }
                }
                this.contentWidth = this.containerView.contentWidth;
                this.contentHeight = this.containerView.contentHeight;
                if (requireScrolling && this.focusedItem != null) {
                    Item item3 = this.focusedItem;
                    this.scroll(0, item3.relativeX, item3.relativeY, item3.itemWidth, item3.itemHeight, true);
                } else if (this.scrollItem != null && (scrolled2 = this.scroll(0, this.scrollItem, true))) {
                    this.scrollItem = null;
                }
                if (this.focusedItem != null) {
                    this.updateInternalPosition(this.focusedItem);
                }
                return;
            }
            boolean isLayoutShrink = (this.layout & 0x400) == 1024;
            boolean hasFocusableItem = false;
            int numberOfVerticalExpandItems = 0;
            Item lastVerticalExpandItem = null;
            int lastVerticalExpandItemIndex = 0;
            boolean hasCenterOrRightItems = false;
            boolean hasVerticalExpandItems = false;
            for (i = 0; i < myItems.length; ++i) {
                item = myItems[i];
                if (!item.isLayoutVerticalExpand()) continue;
                hasVerticalExpandItems = true;
                break;
            }
            for (i = 0; i < myItems.length; ++i) {
                item = myItems[i];
                if (hasVerticalExpandItems && item.isLayoutVerticalExpand()) {
                    item.setInitialized(false);
                }
                int width = item.getItemWidth(availWidth, availWidth, availHeight);
                int height = item.itemHeight;
                if (item.appearanceMode != 0) {
                    hasFocusableItem = true;
                }
                if (this.isFocused && this.autoFocusEnabled && i >= this.autoFocusIndex && item.appearanceMode != 0) {
                    this.setAutoFocusEnabled(false);
                    this.focusChild(i, item, 0, true);
                    this.isScrollRequired = (this.isScrollRequired || hasFocusableItem) && this.autoFocusIndex != 0;
                    height = item.getItemHeight(availWidth, availWidth, availHeight);
                    width = !isLayoutShrink ? item.itemWidth : 0;
                    if (this.enableScrolling && this.autoFocusIndex != 0) {
                        this.scroll(0, 0, myContentHeight, width, height, true);
                    }
                } else if (i == this.focusedIndex) {
                    if (isLayoutShrink) {
                        width = 0;
                    }
                    if (this.isScrollRequired) {
                        this.scroll(0, 0, myContentHeight, width, height, true);
                        this.isScrollRequired = false;
                    }
                }
                if (item.isLayoutVerticalExpand()) {
                    ++numberOfVerticalExpandItems;
                    lastVerticalExpandItem = item;
                    lastVerticalExpandItemIndex = i;
                }
                if (width > myContentWidth) {
                    myContentWidth = width;
                }
                item.relativeY = myContentHeight;
                if (item.isLayoutCenter || item.isLayoutRight) {
                    hasCenterOrRightItems = true;
                    if (this.parent == null) {
                        myContentWidth = availWidth;
                    }
                } else {
                    item.relativeX = 0;
                }
                myContentHeight += height != 0 ? height + this.paddingVertical : 0;
            }
            if (numberOfVerticalExpandItems > 0 && myContentHeight < availHeight) {
                int diff = availHeight - myContentHeight;
                if (numberOfVerticalExpandItems == 1) {
                    lastVerticalExpandItem.setItemHeight(lastVerticalExpandItem.itemHeight + diff);
                    for (int i3 = lastVerticalExpandItemIndex + 1; i3 < myItems.length; ++i3) {
                        Item item4 = myItems[i3];
                        item4.relativeY += diff;
                    }
                } else {
                    diff /= numberOfVerticalExpandItems;
                    int relYAdjust = 0;
                    for (int i4 = 0; i4 < myItems.length; ++i4) {
                        Item item5 = myItems[i4];
                        item5.relativeY += relYAdjust;
                        if (!item5.isLayoutVerticalExpand()) continue;
                        item5.setItemHeight(item5.itemHeight + diff);
                        relYAdjust += diff;
                    }
                }
                myContentHeight = availHeight;
            }
            if (this.minimumWidth != null && this.minimumWidth.getValue(firstLineWidth) > myContentWidth) {
                myContentWidth = this.minimumWidth.getValue(firstLineWidth) - (this.getBorderWidthLeft() + this.getBorderWidthRight() + this.marginLeft + this.paddingLeft + this.marginRight + this.paddingRight);
            }
            if (!hasFocusableItem) {
                if (this.defaultCommand != null || this.commands != null && this.commands.size() > 0) {
                    this.appearanceMode = 3;
                } else if (!this.appearanceModeSet) {
                    this.appearanceMode = 0;
                }
            } else {
                this.appearanceMode = 3;
                Item item6 = this.focusedItem;
                if (item6 == null) {
                    this.internalX = -9999;
                } else {
                    this.updateInternalPosition(item6);
                    if (isLayoutShrink) {
                        boolean doExpand = item6.isLayoutExpand;
                        if (doExpand) {
                            item6.setInitialized(false);
                            item6.isLayoutExpand = false;
                            int width = item6.getItemWidth(availWidth, availWidth, availHeight);
                            item6.setInitialized(false);
                            item6.isLayoutExpand = true;
                            if (width > myContentWidth) {
                                myContentWidth = width;
                            }
                        }
                        if (this.minimumWidth != null && myContentWidth < this.minimumWidth.getValue(availWidth)) {
                            myContentWidth = this.minimumWidth.getValue(availWidth);
                        }
                        if (doExpand) {
                            item6.init(myContentWidth, myContentWidth, availHeight);
                        }
                    }
                }
            }
            if (hasCenterOrRightItems) {
                for (int i5 = 0; i5 < myItems.length; ++i5) {
                    Item item7 = myItems[i5];
                    int width = item7.itemWidth;
                    if (item7.isLayoutCenter) {
                        item7.relativeX = (myContentWidth - width) / 2;
                        continue;
                    }
                    if (!item7.isLayoutRight) continue;
                    item7.relativeX = myContentWidth - width;
                }
            }
            if (this.scrollItem != null && (scrolled = this.scroll(0, this.scrollItem, true))) {
                this.scrollItem = null;
            }
            this.contentHeight = myContentHeight;
            this.contentWidth = myContentWidth;
        }
    }

    protected void setAutoFocusEnabled(boolean enable) {
        this.autoFocusEnabled = enable;
    }

    protected void updateInternalPosition(Item item) {
        if (item == null) {
            return;
        }
        int prevX = this.internalX;
        int prevY = this.internalY;
        int prevWidth = this.internalWidth;
        int prevHeight = this.internalHeight;
        if (item.internalX != -9999) {
            this.internalX = item.relativeX + item.contentX + item.internalX;
            this.internalY = this.enableScrolling ? this.getScrollYOffset() + item.relativeY + item.contentY + item.internalY : item.relativeY + item.contentY + item.internalY;
            this.internalWidth = item.internalWidth;
            this.internalHeight = item.internalHeight;
        } else {
            this.internalX = item.relativeX;
            this.internalY = this.enableScrolling ? this.getScrollYOffset() + item.relativeY : item.relativeY;
            this.internalWidth = item.itemWidth;
            this.internalHeight = item.itemHeight;
        }
        if (this.isFocused && this.parent instanceof Container && (prevY != this.internalY || prevX != this.internalX || prevWidth != this.itemWidth || prevHeight != this.internalHeight)) {
            ((Container)this.parent).updateInternalPosition(this);
        }
    }

    protected void setContentWidth(int width) {
        if (width < this.contentWidth) {
            this.initContent(width, width, this.availContentHeight);
        } else {
            super.setContentWidth(width);
            if (this.containerView != null) {
                this.containerView.setContentWidth(width);
            }
            if (this.focusedItem != null && (this.layout & 0x400) == 1024) {
                this.focusedItem.init(width, width, this.contentHeight);
            }
        }
    }

    protected void setContentHeight(int height) {
        super.setContentHeight(height);
        if (this.containerView != null) {
            this.containerView.setContentHeight(height);
        }
    }

    public void setItemWidth(int width) {
        int prevContentX = this.contentX;
        int myContentWidth = this.contentWidth + width - this.itemWidth;
        super.setItemWidth(width);
        if (this.containerView == null) {
            boolean hasCenterOrRightAlignedItems = false;
            Item[] myItems = this.containerItems;
            if (myItems != null) {
                for (int i = 0; i < myItems.length; ++i) {
                    Item item = myItems[i];
                    width = item.itemWidth;
                    if (item.isLayoutCenter) {
                        item.relativeX = (myContentWidth - width) / 2;
                        hasCenterOrRightAlignedItems = true;
                        continue;
                    }
                    if (!item.isLayoutRight) continue;
                    item.relativeX = myContentWidth - width;
                    hasCenterOrRightAlignedItems = true;
                }
            }
            if (hasCenterOrRightAlignedItems) {
                this.contentWidth = myContentWidth;
                this.contentX = prevContentX;
            }
        }
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean setClipping = this.enableScrolling && (this.yOffset != 0 || this.itemHeight > this.scrollHeight);
        int clipX = 0;
        int clipY = 0;
        int clipWidth = 0;
        int clipHeight = 0;
        if (setClipping) {
            clipX = g.getClipX();
            clipY = g.getClipY();
            clipWidth = g.getClipWidth();
            clipHeight = g.getClipHeight();
            Screen scr = this.screen;
            if (scr != null && scr.container == this && this.relativeY > scr.contentY) {
                int diff = this.relativeY - scr.contentY;
                g.clipRect(clipX, y - diff, clipWidth, clipHeight - (y - clipY) + diff);
            } else {
                g.clipRect(clipX, y, clipWidth, this.scrollHeight - this.paddingTop - this.paddingBottom);
            }
        }
        y += this.yOffset;
        if (this.containerView != null) {
            this.containerView.paintContent(this, x, y, leftBorder, rightBorder, g);
            if (setClipping) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else {
            int itemX;
            Item[] myItems = this.containerItems;
            int startY = g.getClipY();
            int endY = startY + g.getClipHeight();
            Item focItem = this.focusedItem;
            int focIndex = this.focusedIndex;
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                int itemY = y + item.relativeY;
                if (i == focIndex || itemY + item.itemHeight < startY || itemY >= endY) continue;
                itemX = x + item.relativeX;
                item.paint(itemX, itemY, itemX, itemX + item.itemWidth, g);
            }
            boolean paintFocusedItemOutside = false;
            if (focItem != null) {
                boolean bl = paintFocusedItemOutside = setClipping && focItem.internalX != -9999;
                if (!paintFocusedItemOutside) {
                    itemX = x + focItem.relativeX;
                    focItem.paint(itemX, y + focItem.relativeY, itemX, itemX + focItem.itemWidth, g);
                }
            }
            if (setClipping) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            if (paintFocusedItemOutside) {
                itemX = x + focItem.relativeX;
                focItem.paint(itemX, y + focItem.relativeY, itemX, itemX + focItem.itemWidth, g);
            }
        }
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.containerView == null) {
            super.paintBackgroundAndBorder(x, y, width, height, g);
        } else {
            if (this.background != null) {
                int bWidthL = this.getBorderWidthLeft();
                int bWidthR = this.getBorderWidthRight();
                int bWidthT = this.getBorderWidthTop();
                int bWidthB = this.getBorderWidthBottom();
                if (this.border != null) {
                    x += bWidthL;
                    y += bWidthT;
                    width -= bWidthL + bWidthR;
                    height -= bWidthT + bWidthB;
                }
                this.containerView.paintBackground(this.background, x, y, width, height, g);
                if (this.border != null) {
                    x -= bWidthL;
                    y -= bWidthT;
                    width += bWidthL + bWidthR;
                    height += bWidthT + bWidthB;
                }
            }
            if (this.border != null) {
                this.containerView.paintBorder(this.border, x, y, width, height, g);
            }
        }
    }

    protected String createCssSelector() {
        return "container";
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.itemsList.size() == 0 && this.focusedItem == null) {
            return super.handleKeyPressed(keyCode, gameAction);
        }
        Item item = this.focusedItem;
        if (item != null) {
            int startY;
            if (!item.isInitialized()) {
                if (item.availableWidth != 0) {
                    item.init(item.availableWidth, item.availableWidth, item.availableHeight);
                } else {
                    item.init(this.contentWidth, this.contentWidth, this.contentHeight);
                }
            } else if (this.enableScrolling && item.internalX != -9999 && ((startY = this.getScrollYOffset() + item.relativeY + item.contentY + item.internalY) < 0 && gameAction == 1 && keyCode != 50 || startY + item.internalHeight > this.scrollHeight && gameAction == 6 && keyCode != 56) && this.scroll(gameAction, item, false)) {
                return true;
            }
            int scrollOffset = this.getScrollYOffset();
            if (item.handleKeyPressed(keyCode, gameAction)) {
                if (this.enableScrolling) {
                    if (this.getScrollYOffset() == scrollOffset) {
                        this.scroll(gameAction, item, false);
                    }
                } else {
                    this.updateInternalPosition(item);
                }
                return true;
            }
        }
        return this.handleNavigate(keyCode, gameAction) || super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleNavigate(int keyCode, int gameAction) {
        boolean processed = false;
        int offset = this.getRelativeScrollYOffset();
        int availableScrollHeight = this.getScrollHeight();
        Item focItem = this.focusedItem;
        int y = 0;
        int h = 0;
        if (focItem != null && availableScrollHeight != -1) {
            if (focItem.internalX == -9999 || focItem.relativeY + focItem.contentY + focItem.internalY + focItem.internalHeight < availableScrollHeight) {
                y = focItem.relativeY;
                h = focItem.itemHeight;
            } else {
                y = focItem.relativeY + focItem.contentY + focItem.internalY;
                h = focItem.internalHeight;
            }
        }
        if (gameAction == 6 && keyCode != 56) {
            if (focItem == null || availableScrollHeight == -1 || offset + y + h <= availableScrollHeight) {
                processed = this.containerView != null ? this.containerView.handleKeyPressed(keyCode, gameAction) : this.shiftFocus(true, 0);
            }
            if (!processed && (availableScrollHeight != -1 && offset + y + h > availableScrollHeight || this.enableScrolling && offset + this.itemHeight > availableScrollHeight)) {
                int containerHeight = Math.max(this.contentHeight, this.backgroundHeight);
                int availScrollHeight = this.getContentScrollHeight();
                int scrollOffset = this.getScrollYOffset();
                int difference = containerHeight + scrollOffset - availScrollHeight;
                if (difference > availScrollHeight / 2) {
                    difference = availScrollHeight / 2;
                }
                if (difference == 0) {
                    return false;
                }
                offset = scrollOffset - difference;
                if (offset > 0) {
                    offset = 0;
                }
                this.setScrollYOffset(offset, true);
                processed = true;
            }
        } else if (gameAction == 1 && keyCode != 50) {
            if (focItem == null || availableScrollHeight == -1 || offset + focItem.relativeY >= 0) {
                processed = this.containerView != null ? this.containerView.handleKeyPressed(keyCode, gameAction) : this.shiftFocus(false, 0);
            }
            if (!processed && (this.enableScrolling && offset < 0 || availableScrollHeight != -1 && focItem != null && offset + focItem.relativeY < 0)) {
                int difference = this.getScreen() != null ? this.getScreen().contentHeight / 2 : 30;
                offset = this.getScrollYOffset() + difference;
                if (offset > 0) {
                    offset = 0;
                }
                this.setScrollYOffset(offset, true);
                processed = true;
            }
        } else if (this.containerView != null) {
            processed = this.containerView.handleKeyPressed(keyCode, gameAction);
        }
        return processed;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.itemsList.size() == 0 && this.focusedItem == null) {
            return super.handleKeyReleased(keyCode, gameAction);
        }
        Item item = this.focusedItem;
        if (item != null) {
            int scrollOffset = this.getScrollYOffset();
            if (item.handleKeyReleased(keyCode, gameAction)) {
                if (item.isShown) {
                    if (this.enableScrolling) {
                        if (this.getScrollYOffset() == scrollOffset) {
                            this.scroll(gameAction, item, false);
                        }
                    } else {
                        this.updateInternalPosition(item);
                    }
                }
                return true;
            }
        }
        if (this.containerView != null && this.containerView.handleKeyReleased(keyCode, gameAction)) {
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        Item item;
        if (this.itemsList.size() == 0 && this.focusedItem == null) {
            return false;
        }
        if (this.focusedItem != null && (item = this.focusedItem).handleKeyRepeated(keyCode, gameAction)) {
            if (this.enableScrolling && item.internalX != -9999) {
                this.scroll(gameAction, item, false);
            }
            return true;
        }
        return this.handleNavigate(keyCode, gameAction);
    }

    Item focusVisible(Container container, int verticalMin, int verticalMax) {
        Item[] items = container.getItems();
        Item focusedItem = null;
        for (int index = 0; index < items.length; ++index) {
            Item item = items[index];
            int itemTop = item.getAbsoluteY();
            int itemBottom = itemTop + item.itemHeight;
            int itemAppearanceMode = item.getAppearanceMode();
            if (itemAppearanceMode != 3 && itemAppearanceMode != 1 && itemAppearanceMode != 2) continue;
            if (item instanceof Container && !this.isItemVisible(verticalMin, verticalMax, itemTop, itemBottom, true)) {
                if (!this.isItemVisible(verticalMin, verticalMax, itemTop, itemBottom, false) || (focusedItem = this.focusVisible((Container)item, verticalMin, verticalMax)) == null) continue;
                this.focusIndex(index);
                return item;
            }
            if (!this.isItemVisible(verticalMin, verticalMax, itemTop, itemBottom, true)) continue;
            return this.focusIndex(index);
        }
        return null;
    }

    protected boolean isItemVisible(int verticalMin, int verticalMax, int itemTop, int itemBottom, boolean full) {
        if (full) {
            return itemTop >= verticalMin && itemBottom <= verticalMax;
        }
        return itemBottom > verticalMin && itemTop < verticalMax;
    }

    Item focusIndex(int index) {
        int scrollOffset = this.getScrollYOffset();
        this.setInitialized(false);
        this.focusChild(index);
        this.setInitialized(true);
        this.setScrollYOffset(scrollOffset);
        return this.getFocusedChild();
    }

    private boolean shiftFocus(boolean forwardFocus, int steps) {
        int verticalMax;
        int verticalMin;
        Item newFocusedItem;
        Item[] items = this.getItems();
        if (items == null || items.length <= 1) {
            return false;
        }
        if (this.focusedIndex == -1 && (newFocusedItem = this.focusVisible(this, verticalMin = this.getAbsoluteY(), verticalMax = verticalMin + this.getScrollHeight())) != null) {
            return true;
        }
        Item focItem = this.focusedItem;
        int i = this.focusedIndex + steps;
        if (i > items.length) {
            i = items.length - 2;
        }
        if (i < 0) {
            i = 1;
        }
        Item item = null;
        boolean allowCycle = this.allowCycling;
        if (allowCycle) {
            if (forwardFocus) {
                allowCycle = this.getScrollYOffset() + this.itemHeight <= this.getScrollHeight() + 1;
            } else {
                boolean bl = allowCycle = this.getScrollYOffset() == 0;
            }
        }
        do {
            if (forwardFocus) {
                if (++i >= items.length) {
                    if (!allowCycle) break;
                    if (!this.fireContinueCycle(2)) {
                        return false;
                    }
                    allowCycle = false;
                    i = 0;
                }
            } else if (--i < 0) {
                if (!allowCycle) break;
                if (!this.fireContinueCycle(1)) {
                    return false;
                }
                allowCycle = false;
                i = items.length - 1;
            }
            item = items[i];
        } while (item.appearanceMode == 0);
        if (item == null || item.appearanceMode == 0 || item == focItem) {
            return false;
        }
        int direction = 1;
        if (forwardFocus) {
            direction = 6;
        }
        this.focusChild(i, item, direction, false);
        return true;
    }

    public int getFocusedIndex() {
        return this.focusedIndex;
    }

    public Item getFocusedItem() {
        return this.focusedItem;
    }

    public void setStyle(Style style) {
        this.setStyleWithBackground(style, false);
    }

    public void setStyleWithBackground(Style style, boolean ignoreBackground) {
        Boolean pressAllBool;
        Boolean focusAllBool;
        Integer columns;
        super.setStyle(style);
        if (ignoreBackground) {
            this.background = null;
            this.border = null;
            this.marginTop = 0;
            this.marginBottom = 0;
            this.marginLeft = 0;
            this.marginRight = 0;
        }
        this.isIgnoreMargins = ignoreBackground;
        if (this.view != null && this.view instanceof ContainerView) {
            ContainerView viewType;
            this.containerView = viewType = (ContainerView)this.view;
            this.view = null;
            viewType.parentContainer = this;
            viewType.focusFirstElement = this.autoFocusEnabled;
            viewType.allowCycling = this.allowCycling;
            if (this.focusedItem != null) {
                viewType.focusItem(this.focusedIndex, this.focusedItem, 0);
            }
        } else if (!this.preserveViewType && style.getObjectProperty(39) == null && !this.setView) {
            this.containerView = null;
        }
        if (this.containerView == null && (columns = style.getIntProperty(4)) != null && columns > 1) {
            this.containerView = new ContainerView();
            this.containerView.parentContainer = this;
            this.containerView.focusFirstElement = this.autoFocusEnabled;
            this.containerView.allowCycling = this.allowCycling;
        }
        if (this.containerView != null) {
            this.containerView.setStyle(style);
        }
        if ((focusAllBool = style.getBooleanProperty(359)) != null) {
            this.isFocusAllChildren = focusAllBool;
        }
        if ((pressAllBool = style.getBooleanProperty(470)) != null) {
            this.isPressAllChildren = pressAllBool;
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        if (this.containerView != null) {
            this.containerView.setStyle(style, resetStyle);
        }
    }

    public void resetStyle(boolean recursive) {
        super.resetStyle(recursive);
        if (recursive) {
            Item item;
            Object[] items = this.itemsList.getInternalArray();
            for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
                item.resetStyle(recursive);
            }
        }
    }

    public void changeChildStyles(String oldChildStyleName, String newChildStyleName) {
        Style newChildStyle = StyleSheet.getStyle(newChildStyleName);
        if (newChildStyle == null) {
            throw new IllegalArgumentException("for " + newChildStyleName);
        }
        Style oldChildStyle = StyleSheet.getStyle(oldChildStyleName);
        this.changeChildStyles(oldChildStyle, newChildStyle);
    }

    public void changeChildStyles(Style oldChildStyle, Style newChildStyle) {
        Item child;
        if (newChildStyle == null) {
            throw new IllegalArgumentException();
        }
        Object[] children = this.itemsList.getInternalArray();
        for (int i = 0; i < children.length && (child = (Item)children[i]) != null; ++i) {
            if (child.style != oldChildStyle) continue;
            child.setStyle(newChildStyle);
        }
    }

    public String parseIndexUrl(String url, Item item) {
        int pos = url.indexOf("%INDEX%");
        if (pos != -1) {
            int index = this.itemsList.indexOf(item);
            url = url.substring(0, pos) + index + url.substring(pos + 7);
        }
        return url;
    }

    public int getPosition(Item item) {
        return this.itemsList.indexOf(item);
    }

    protected Style focus(Style focusStyle, int direction) {
        Style labStyle;
        Style orStyle;
        Object[] myItems;
        Item item;
        if (this.isFocused) {
            return this.style;
        }
        this.plainStyle = null;
        if (this.itemsList.size() == 0) {
            return super.focus(focusStyle, direction);
        }
        focusStyle = this.getFocusedStyle();
        if (this.isFocusAllChildren) {
            Object[] myItems2 = this.itemsList.getInternalArray();
            for (int i = 0; i < myItems2.length && (item = (Item)myItems2[i]) != null; ++i) {
                Style itemFocusedStyle = item.getFocusedStyle();
                if (itemFocusedStyle == focusStyle || itemFocusedStyle == StyleSheet.focusedStyle || item.isFocused) continue;
                if (item.style != null) {
                    item.setAttribute(KEY_ORIGINAL_STYLE, item.style);
                }
                item.focus(itemFocusedStyle, direction);
            }
        }
        Style result = this.style;
        if (focusStyle != null && focusStyle != StyleSheet.focusedStyle && (this.parent == null || this.parent.getFocusedStyle() != focusStyle) || this.includeLabel && focusStyle != null) {
            this.plainStyle = result = super.focus(focusStyle, direction);
        }
        if (!this.isStyleInitialised && result != null) {
            this.setStyle(result);
        }
        if (this.containerView != null) {
            this.containerView.focus(focusStyle, direction);
        }
        this.isFocused = true;
        int newFocusIndex = this.focusedIndex;
        if (this.containerView == null || this.containerView.allowsAutoTraversal) {
            myItems = this.getItems();
            if (this.autoFocusEnabled && this.autoFocusIndex < myItems.length && ((Item)myItems[this.autoFocusIndex]).appearanceMode != 0) {
                newFocusIndex = this.autoFocusIndex;
                this.setAutoFocusEnabled(false);
            } else if (direction == 1 || direction == 2) {
                int i = myItems.length;
                while (--i >= 0) {
                    Object item2 = myItems[i];
                    if (((Item)item2).appearanceMode == 0) continue;
                    newFocusIndex = i;
                    break;
                }
            } else {
                for (int i = 0; i < myItems.length; ++i) {
                    Object item3 = myItems[i];
                    if (((Item)item3).appearanceMode == 0) continue;
                    newFocusIndex = i;
                    break;
                }
            }
            this.focusedIndex = newFocusIndex;
            if (newFocusIndex == -1) {
                if (this.plainStyle != null) {
                    this.style = this.plainStyle;
                }
                return super.focus(focusStyle, direction);
            }
        } else if (this.focusedIndex == -1) {
            Item item4;
            myItems = this.itemsList.getInternalArray();
            for (int i = 0; i < myItems.length && (item4 = (Item)myItems[i]) != null; ++i) {
                if (item4.appearanceMode == 0) continue;
                newFocusIndex = i;
                break;
            }
            this.focusedIndex = newFocusIndex;
            if (newFocusIndex == -1) {
                if (this.plainStyle != null) {
                    this.style = this.plainStyle;
                }
                return super.focus(focusStyle, direction);
            }
        }
        item = this.get(this.focusedIndex);
        this.showCommandsHasBeenCalled = false;
        if (item.isFocused && (orStyle = (Style)item.getAttribute(KEY_ORIGINAL_STYLE)) != null) {
            item.style = orStyle;
        }
        this.focusChild(this.focusedIndex, item, direction, true);
        if (!this.showCommandsHasBeenCalled && this.commands != null) {
            this.showCommands();
        }
        if (this.label != null && focusStyle != null && (labStyle = (Style)focusStyle.getObjectProperty(3)) != null) {
            this.labelStyle = this.label.style;
            this.label.setStyle(labStyle);
        }
        return result;
    }

    public void defocus(Style originalStyle) {
        if (this.isFocusAllChildren) {
            Item item;
            Object[] myItems = this.itemsList.getInternalArray();
            for (int i = 0; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
                Style itemPlainStyle = (Style)item.removeAttribute(KEY_ORIGINAL_STYLE);
                if (itemPlainStyle == null) continue;
                item.defocus(itemPlainStyle);
            }
        }
        Style originalItemStyle = this.itemStyle;
        if (this.itemsList.size() == 0 || this.focusedIndex == -1) {
            super.defocus(originalStyle);
        } else {
            Item item;
            if (this.plainStyle != null) {
                super.defocus(this.plainStyle);
                if (originalStyle == null) {
                    originalStyle = this.plainStyle;
                }
                this.plainStyle = null;
            } else if (this.isPressed) {
                this.notifyItemPressedEnd();
            }
            this.isFocused = false;
            if (this.containerView != null) {
                this.containerView.defocus(originalStyle);
                this.setInitialized(false);
            }
            if ((item = this.focusedItem) != null) {
                Screen scr;
                if (item.isFocused) {
                    item.defocus(originalItemStyle);
                }
                this.isFocused = false;
                if (item.commands == null && this.commands != null && (scr = this.getScreen()) != null) {
                    scr.removeItemCommands(this);
                }
            }
            Style tmpLabelStyle = null;
            if (originalStyle != null) {
                tmpLabelStyle = (Style)originalStyle.getObjectProperty(3);
            }
            if (tmpLabelStyle == null) {
                tmpLabelStyle = StyleSheet.labelStyle;
            }
            if (this.label != null && tmpLabelStyle != null && this.label.style != tmpLabelStyle) {
                this.label.setStyle(tmpLabelStyle);
            }
        }
    }

    public void showCommands() {
        this.showCommandsHasBeenCalled = true;
        super.showCommands();
    }

    protected boolean handleCommand(Command cmd) {
        boolean handled = super.handleCommand(cmd);
        if (!handled && this.focusedItem != null) {
            return this.focusedItem.handleCommand(cmd);
        }
        return handled;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        ContainerView contView;
        Screen scr;
        int speed;
        super.animate(currentTime, repaintRegion);
        boolean addFullRepaintRegion = false;
        int target = this.targetYOffset;
        int current = this.yOffset;
        int diff = 0;
        if (target != current) {
            int nextOffset;
            long passedTime = currentTime - this.scrollStartTime;
            this.yOffset = nextOffset = CssAnimation.calculatePointInRange(this.scrollStartYOffset, target, passedTime, this.scrollDuration, 5);
            addFullRepaintRegion = true;
        }
        if ((speed = this.scrollSpeed) != 0) {
            if ((speed = speed * (100 - this.scrollDamping) / 100) <= 0) {
                speed = 0;
            }
            this.scrollSpeed = speed;
            long timeDelta = currentTime - this.lastAnimationTime;
            if (timeDelta > 1000L) {
                timeDelta = 50L;
            }
            if ((speed = (int)((long)speed * timeDelta / 1000L)) == 0) {
                this.scrollSpeed = 0;
            }
            int offset = this.yOffset;
            if (this.scrollDirection == 1) {
                target = offset += speed;
                if (offset > 0) {
                    this.scrollSpeed = 0;
                    target = 0;
                }
            } else {
                target = offset -= speed;
                int maxItemHeight = this.getItemAreaHeight();
                scr = this.screen;
                if (scr != null && this == scr.container && this.relativeY > scr.contentY) {
                    maxItemHeight += this.relativeY - scr.contentY;
                }
                if (offset + maxItemHeight < this.scrollHeight) {
                    this.scrollSpeed = 0;
                    target = this.scrollHeight - maxItemHeight;
                }
            }
            this.yOffset = offset;
            this.targetYOffset = target;
            addFullRepaintRegion = true;
        }
        if (addFullRepaintRegion) {
            int width;
            int y;
            int x;
            scr = this.getScreen();
            int height = this.getItemAreaHeight();
            if (this.parent == null && (this.scrollHeight > height || this.enableScrolling)) {
                x = scr.contentX;
                y = scr.contentY;
                height = scr.contentHeight;
                width = scr.contentWidth + scr.getScrollBarWidth();
            } else {
                x = this.getAbsoluteX();
                y = this.getAbsoluteY();
                width = this.itemWidth;
                width += scr.getScrollBarWidth();
            }
            repaintRegion.addRegion(x, y, width, height + diff + 1);
        }
        this.lastAnimationTime = currentTime;
        Item focItem = this.focusedItem;
        if (focItem != null) {
            focItem.animate(currentTime, repaintRegion);
        }
        if ((contView = this.containerView) != null) {
            contView.animate(currentTime, repaintRegion);
        }
        if (this.isFocusAllChildren && this.isFocused) {
            Item[] items = this.getItems();
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                item.animate(currentTime, repaintRegion);
            }
        }
    }

    public void addRepaintArea(ClippingRegion repaintRegion) {
        if (this.enableScrolling) {
            Screen scr = this.getScreen();
            int x = scr.contentX;
            int y = scr.contentY;
            int height = scr.contentHeight;
            int width = scr.contentWidth + scr.getScrollBarWidth();
            repaintRegion.addRegion(x, y, width, height);
        } else {
            super.addRepaintArea(repaintRegion);
        }
    }

    protected void showNotify() {
        super.showNotify();
        if (this.style != null && !this.isStyleInitialised) {
            this.setStyle(this.style);
        } else if (this.style == null) {
            this.initStyle();
        }
        if (this.containerView != null) {
            this.containerView.showNotify();
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            if (item.style != null && !item.isStyleInitialised) {
                item.setStyle(item.style);
            } else if (item.style == null) {
                this.initStyle();
            }
            item.showNotify();
        }
    }

    protected void hideNotify() {
        if (this.containerView != null) {
            this.containerView.hideNotify();
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            item.hideNotify();
        }
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        this.lastPointerPressY = relY;
        this.lastPointerPressYOffset = this.getScrollYOffset();
        this.lastPointerPressTime = System.currentTimeMillis();
        int origRelX = relX;
        int origRelY = relY;
        relY -= this.yOffset;
        relY -= this.contentY;
        relX -= this.contentX;
        int viewXOffset = 0;
        ContainerView contView = this.containerView;
        if (contView != null) {
            viewXOffset = contView.getScrollXOffset();
            relX -= viewXOffset;
        }
        boolean eventHandled = false;
        Item item = this.focusedItem;
        if (item != null) {
            int itemLayout = item.layout;
            boolean processed = item.handlePointerPressed(relX - item.relativeX, relY - item.relativeY);
            if (processed) {
                if (item.layout != itemLayout && this.isInitialized()) {
                    if (item.availableWidth != 0) {
                        item.init(item.availableWidth, item.availableWidth, item.availableHeight);
                    } else {
                        item.init(this.contentWidth, this.contentWidth, this.contentHeight);
                    }
                    item.relativeX = item.isLayoutLeft() ? 0 : (item.isLayoutCenter() ? (this.contentWidth - item.itemWidth) / 2 : this.contentWidth - item.itemWidth);
                }
                this.notifyItemPressedStart();
                return true;
            }
            if (item.isPressed) {
                eventHandled = this.notifyItemPressedStart();
            }
        }
        if (contView != null) {
            if (contView.handlePointerPressed((relX += viewXOffset) + this.contentX, relY + this.contentY)) {
                this.notifyItemPressedStart();
                return true;
            }
            relX -= viewXOffset;
        }
        if (!this.isInItemArea(origRelX, origRelY - this.yOffset) || item != null && item.isInItemArea(relX - item.relativeX, relY - item.relativeY)) {
            return this.defaultCommand != null && super.handlePointerPressed(origRelX, origRelY) || eventHandled;
        }
        Screen scr = this.screen;
        if (origRelY < 0 && (scr == null || origRelY + this.relativeY - scr.contentY < 0) || this.enableScrolling && origRelY > this.scrollHeight) {
            return this.defaultCommand != null && super.handlePointerPressed(origRelX, origRelY) || eventHandled;
        }
        Item nextItem = this.getChildAt(origRelX, origRelY);
        if (nextItem != null && nextItem != item) {
            int index = this.itemsList.indexOf(nextItem);
            int offset = this.getScrollYOffset();
            this.focusChild(index, nextItem, 0, true);
            this.setScrollYOffset(offset, false);
            nextItem.handlePointerPressed(relX - nextItem.relativeX, relY - nextItem.relativeY);
            if (!this.isFocused) {
                this.setAutoFocusEnabled(true);
                this.autoFocusIndex = index;
            }
            this.notifyItemPressedStart();
            return true;
        }
        boolean handledBySuperImplementation = this.defaultCommand != null && super.handlePointerPressed(origRelX, origRelY) || eventHandled;
        return handledBySuperImplementation;
    }

    protected boolean handlePointerScrollReleased(int relX, int relY) {
        if (Display.getInstance().hasPointerMotionEvents()) {
            return false;
        }
        int yDiff = relY - this.lastPointerPressY;
        int bottomY = Math.max(this.itemHeight, this.internalY + this.internalHeight);
        if (this.focusedItem != null && this.focusedItem.relativeY + this.focusedItem.backgroundHeight > bottomY) {
            bottomY = this.focusedItem.relativeY + this.focusedItem.backgroundHeight;
        }
        if (this.enableScrolling && (this.itemHeight > this.scrollHeight || this.yOffset != 0) && (yDiff < -5 && this.yOffset + bottomY > this.scrollHeight || yDiff > 5 && this.yOffset != 0)) {
            int offset = this.yOffset + yDiff;
            if (offset > 0) {
                offset = 0;
            }
            this.setScrollYOffset(offset, true);
            return true;
        }
        return false;
    }

    public void handleOnFocusSoftKeyboardDisplayBehavior() {
        Item focItem = this.focusedItem;
        if (focItem != null) {
            focItem.handleOnFocusSoftKeyboardDisplayBehavior();
        } else {
            super.handleOnFocusSoftKeyboardDisplayBehavior();
        }
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        if (this.isJustFocused) {
            this.isJustFocused = false;
            this.handleOnFocusSoftKeyboardDisplayBehavior();
        }
        Item item = this.focusedItem;
        if (this.enableScrolling) {
            this.isScrolling = false;
            int scrollDiff = Math.abs(this.getScrollYOffset() - this.lastPointerPressYOffset);
            if (scrollDiff > Display.getScreenHeight() / 10 || this.handlePointerScrollReleased(relX, relY)) {
                long dragTime;
                boolean processed = false;
                if (item != null && item.isPressed) {
                    processed = item.handlePointerReleased(relX - item.relativeX, relY - item.relativeY);
                    this.setInitialized(false);
                }
                if (!processed) {
                    while (item instanceof Container) {
                        if (item.isPressed) {
                            item.notifyItemPressedEnd();
                        }
                        item = ((Container)item).focusedItem;
                    }
                    if (item != null && item.isPressed) {
                        item.notifyItemPressedEnd();
                        this.setInitialized(false);
                    }
                }
                if ((dragTime = System.currentTimeMillis() - this.lastPointerPressTime) < 1000L && dragTime > 1L) {
                    int direction = 6;
                    if (this.yOffset > this.lastPointerPressYOffset) {
                        direction = 1;
                    }
                    this.startScroll(direction, (int)((long)(scrollDiff * 1000) / dragTime), 20);
                } else if (this.yOffset > 0) {
                    this.setScrollYOffset(0, true);
                } else if (this.yOffset + this.contentHeight < this.availContentHeight) {
                    int maxItemHeight = this.getItemAreaHeight();
                    Screen scr = this.screen;
                    if (scr != null && this == scr.container && this.relativeY > scr.contentY) {
                        maxItemHeight += this.relativeY - scr.contentY;
                    }
                    if (this.yOffset + maxItemHeight < this.scrollHeight) {
                        int target = this.scrollHeight - maxItemHeight;
                        this.setScrollYOffset(target, true);
                    }
                }
                if (this.isPressed) {
                    this.notifyItemPressedEnd();
                }
                return true;
            }
        }
        int origRelX = relX;
        int origRelY = relY;
        relY -= this.yOffset;
        relY -= this.contentY;
        relX -= this.contentX;
        int viewXOffset = 0;
        ContainerView contView = this.containerView;
        if (contView != null) {
            if (contView.handlePointerReleased(relX + this.contentX, relY + this.contentY)) {
                if (this.isPressed) {
                    this.notifyItemPressedEnd();
                }
                return true;
            }
            viewXOffset = contView.getScrollXOffset();
            relX -= viewXOffset;
        }
        if (item != null) {
            int itemLayout = item.layout;
            boolean processed = item.handlePointerReleased(relX - item.relativeX, relY - item.relativeY);
            if (processed) {
                if (this.isPressed) {
                    this.notifyItemPressedEnd();
                }
                if (item.layout != itemLayout && this.isInitialized()) {
                    if (item.availableWidth != 0) {
                        item.init(item.availableWidth, item.availableWidth, item.availableHeight);
                    } else {
                        item.init(this.contentWidth, this.contentWidth, this.contentHeight);
                    }
                    item.relativeX = item.isLayoutLeft() ? 0 : (item.isLayoutCenter() ? (this.contentWidth - item.itemWidth) / 2 : this.contentWidth - item.itemWidth);
                }
                if (this.isPressed) {
                    this.notifyItemPressedEnd();
                }
                return true;
            }
            if (item.isInItemArea(relX - item.relativeX, relY - item.relativeY)) {
                return this.defaultCommand != null && super.handlePointerReleased(origRelX, origRelY);
            }
        }
        if (!this.isInItemArea(origRelX, origRelY)) {
            return this.defaultCommand != null && super.handlePointerReleased(origRelX, origRelY);
        }
        Item nextItem = this.getChildAt(origRelX, origRelY);
        if (nextItem != null && nextItem != item) {
            item = nextItem;
            int itemRelX = relX - item.relativeX;
            int itemRelY = relY - item.relativeY;
            item.handlePointerReleased(itemRelX, itemRelY);
            if (this.isPressed) {
                this.notifyItemPressedEnd();
            }
            return true;
        }
        return this.defaultCommand != null && super.handlePointerReleased(origRelX, origRelY);
    }

    protected boolean handlePointerDragged(int relX, int relY) {
        return false;
    }

    protected boolean handlePointerDragged(int relX, int relY, ClippingRegion repaintRegion) {
        Item item = this.focusedItem;
        if (item != null && item.handlePointerDragged(relX - this.contentX - item.relativeX, relY - this.yOffset - this.contentY - item.relativeY, repaintRegion)) {
            return true;
        }
        if (item != null) {
            this.focusChild(-1);
            UiAccess.init(item, item.getAvailableWidth(), item.getAvailableWidth(), item.getAvailableHeight());
        }
        if (this.containerView != null && this.containerView.handlePointerDragged(relX, relY, repaintRegion)) {
            return true;
        }
        if (this.enableScrolling) {
            int maxItemHeight = this.getItemAreaHeight();
            Screen scr = this.screen;
            if (scr != null && this == scr.container && this.relativeY > scr.contentY) {
                maxItemHeight += this.relativeY - scr.contentY;
            }
            if (maxItemHeight > this.scrollHeight || this.yOffset != 0) {
                int lastOffset = this.getScrollYOffset();
                int nextOffset = this.lastPointerPressYOffset + (relY - this.lastPointerPressY);
                if (nextOffset > this.scrollHeight / 3) {
                    nextOffset = this.scrollHeight / 3;
                } else if (nextOffset + (maxItemHeight += this.scrollHeight / 3) < this.scrollHeight) {
                    nextOffset = this.scrollHeight - maxItemHeight;
                }
                boolean bl = this.isScrolling = nextOffset != lastOffset;
                if (this.isScrolling) {
                    this.setScrollYOffset(nextOffset, false);
                    this.addRepaintArea(repaintRegion);
                    return true;
                }
            }
        }
        return super.handlePointerDragged(relX, relY, repaintRegion);
    }

    public int getItemAreaHeight() {
        int max = super.getItemAreaHeight();
        Item item = this.focusedItem;
        if (item != null) {
            max = Math.max(max, this.contentY + item.relativeY + item.getItemAreaHeight());
        }
        return max;
    }

    public Item getItemAt(int relX, int relY) {
        int itemRelY;
        int itemRelX;
        Item item;
        relY -= this.yOffset;
        relX -= this.contentX;
        relY -= this.contentY;
        if (this.containerView != null) {
            relX -= this.containerView.getScrollXOffset();
        }
        if ((item = this.focusedItem) != null && item.isInItemArea(itemRelX = relX - item.relativeX, itemRelY = relY - item.relativeY)) {
            return item.getItemAt(itemRelX, itemRelY);
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            item = myItems[i];
            int itemRelX2 = relX - item.relativeX;
            int itemRelY2 = relY - item.relativeY;
            if (i == this.focusedIndex || !item.isInItemArea(itemRelX2, itemRelY2)) continue;
            return item.getItemAt(itemRelX2, itemRelY2);
        }
        relY += this.yOffset;
        return super.getItemAt(relX += this.contentX, relY += this.contentY);
    }

    public Item getChildAt(int relX, int relY) {
        if (this.containerView != null) {
            return this.containerView.getChildAt(relX, relY);
        }
        return this.getChildAtImpl(relX, relY);
    }

    protected Item getChildAtImpl(int relX, int relY) {
        Item item;
        relY -= this.yOffset;
        relY -= this.contentY;
        relX -= this.contentX;
        int viewXOffset = 0;
        ContainerView contView = this.containerView;
        if (contView != null) {
            viewXOffset = contView.getScrollXOffset();
            relX -= viewXOffset;
        }
        if ((item = this.focusedItem) != null && item.isInItemArea(relX - item.relativeX, relY - item.relativeY)) {
            return item;
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            item = myItems[i];
            int itemRelX = relX - item.relativeX;
            int itemRelY = relY - item.relativeY;
            if (i == this.focusedIndex || item.appearanceMode == 0 || !item.isInItemArea(itemRelX, itemRelY)) continue;
            return item;
        }
        return null;
    }

    public void requestDefocus(Item item) {
        boolean success;
        if (item == this.focusedItem && !(success = this.shiftFocus(true, 1))) {
            this.defocus(this.itemStyle);
        }
    }

    public void requestFullInit() {
        for (int i = 0; i < this.itemsList.size(); ++i) {
            Item item = (Item)this.itemsList.get(i);
            item.setInitialized(false);
            if (!(item instanceof Container)) continue;
            ((Container)item).requestFullInit();
        }
        this.requestInit();
    }

    public int getScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getScrollYOffset();
        }
        int offset = this.targetYOffset;
        return offset;
    }

    public int getCurrentScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getCurrentScrollYOffset();
        }
        return this.yOffset;
    }

    public int getRelativeScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getRelativeScrollYOffset() + this.relativeY;
        }
        int offset = this.targetYOffset;
        return offset;
    }

    public void setScrollYOffset(int offset) {
        this.setScrollYOffset(offset, false);
    }

    public void setScrollYOffset(int offset, boolean smooth) {
        if (!this.enableScrolling && this.parent instanceof Container) {
            ((Container)this.parent).setScrollYOffset(offset, smooth);
            return;
        }
        this.scrollStartTime = System.currentTimeMillis();
        this.scrollStartYOffset = this.yOffset;
        if (!smooth) {
            this.yOffset = offset;
        }
        this.targetYOffset = offset;
        this.scrollSpeed = 0;
    }

    public boolean isScrolling() {
        if (this.enableScrolling) {
            return this.isScrolling || this.targetYOffset != this.yOffset || this.scrollSpeed != 0;
        }
        if (this.parent instanceof Container) {
            return ((Container)this.parent).isScrolling();
        }
        return false;
    }

    public void startScroll(int direction, int speed, int damping) {
        if (!this.enableScrolling && this.parent instanceof Container) {
            ((Container)this.parent).startScroll(direction, speed, damping);
            return;
        }
        this.scrollDirection = direction;
        this.scrollDamping = damping;
        this.scrollSpeed = speed;
    }

    public int indexOf(Item item) {
        Object object;
        Object[] myItems = this.itemsList.getInternalArray();
        for (int i = 0; i < myItems.length && (object = myItems[i]) != null; ++i) {
            if (object != item) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Item item) {
        return this.itemsList.contains(item);
    }

    public void setItemsList(ArrayList itemsList) {
        Item item;
        this.clear();
        if (this.isFocused) {
            this.setAutoFocusEnabled(true);
            this.autoFocusIndex = this.focusedIndex;
        }
        this.focusedIndex = -1;
        this.focusedItem = null;
        if (this.enableScrolling) {
            this.setScrollYOffset(0, false);
        }
        this.itemsList = itemsList;
        this.containerItems = null;
        Object[] myItems = this.itemsList.getInternalArray();
        for (int i = 0; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
            item.parent = this;
            if (!this.isShown) continue;
            item.showNotify();
        }
        this.requestInit();
    }

    public int getNumberOfInteractiveItems() {
        Item item;
        int number = 0;
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            if (item.appearanceMode == 0) continue;
            ++number;
        }
        return number;
    }

    public void releaseResources() {
        super.releaseResources();
        Item[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            item.releaseResources();
        }
        if (this.containerView != null) {
            this.containerView.releaseResources();
        }
    }

    public void destroy() {
        Item[] items = this.getItems();
        this.clear();
        super.destroy();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            item.destroy();
        }
        if (this.containerView != null) {
            this.containerView.destroy();
            this.containerView = null;
        }
    }

    public Object[] getInternalArray() {
        return this.itemsList.getInternalArray();
    }

    public boolean isInItemArea(int relX, int relY) {
        Item focItem = this.focusedItem;
        if (focItem != null && focItem.isInItemArea(relX - focItem.relativeX, relY - focItem.relativeY)) {
            return true;
        }
        return super.isInItemArea(relX, relY);
    }

    public void fireEvent(String eventName, Object eventData) {
        Item item;
        super.fireEvent(eventName, eventData);
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            item.fireEvent(eventName, eventData);
        }
    }

    public void setView(ItemView view) {
        if (!(view instanceof ContainerView)) {
            super.setView(view);
            return;
        }
        if (!this.isStyleInitialised && this.style != null) {
            this.setStyle(this.style);
        }
        if (view == null) {
            this.containerView = null;
            this.view = null;
        } else {
            ContainerView viewType = (ContainerView)view;
            viewType.parentContainer = this;
            viewType.focusFirstElement = this.autoFocusEnabled;
            viewType.allowCycling = this.allowCycling;
            this.containerView = viewType;
            if (this.style != null) {
                view.setStyle(this.style);
            }
        }
        this.setView = true;
    }

    public ItemView getView() {
        if (this.containerView != null) {
            return this.containerView;
        }
        return this.view;
    }

    protected ItemView getView(ItemView viewType, Style viewStyle) {
        if (viewType instanceof ContainerView) {
            if (this.containerView == null || this.containerView.getClass() != viewType.getClass()) {
                try {
                    viewType = (ItemView)viewType.getClass().newInstance();
                    viewType.parentItem = this;
                    if (this.isShown) {
                        if (this.containerView != null) {
                            this.containerView.hideNotify();
                        }
                        viewType.showNotify();
                    }
                    return viewType;
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.Container", 4602, (Object)"Container: Unable to init view-type ", e);
                }
            }
            return this.containerView;
        }
        return super.getView(viewType, viewStyle);
    }

    protected void initMargin(Style style, int availWidth) {
        if (this.isIgnoreMargins) {
            this.marginLeft = 0;
            this.marginRight = 0;
            this.marginTop = 0;
            this.marginBottom = 0;
        } else {
            this.marginLeft = style.getMarginLeft(availWidth);
            this.marginRight = style.getMarginRight(availWidth);
            this.marginTop = style.getMarginTop(availWidth);
            this.marginBottom = style.getMarginBottom(availWidth);
        }
    }

    public void onScreenSizeChanged(int screenWidth, int screenHeight) {
        Item item;
        Style lastStyle = this.style;
        super.onScreenSizeChanged(screenWidth, screenHeight);
        if (this.containerView != null) {
            this.containerView.onScreenSizeChanged(screenWidth, screenHeight);
        }
        if (this.plainStyle != null && this.style != lastStyle) {
            Style newStyle = null;
            if (screenWidth > screenHeight) {
                if (this.landscapeStyle != null && this.style != this.landscapeStyle) {
                    newStyle = this.landscapeStyle;
                }
            } else if (this.portraitStyle != null && this.style != this.portraitStyle) {
                newStyle = this.portraitStyle;
            }
            this.plainStyle = newStyle;
        }
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            item.onScreenSizeChanged(screenWidth, screenHeight);
        }
    }

    public Item getFocusedChild() {
        Item item = this.getFocusedItem();
        if (item == null) {
            return this;
        }
        if (item instanceof Container) {
            return ((Container)item).getFocusedChild();
        }
        return item;
    }

    public boolean notifyItemPressedStart() {
        boolean handled = super.notifyItemPressedStart();
        if (this.isPressAllChildren) {
            Item child;
            Object[] children = this.itemsList.getInternalArray();
            for (int i = 0; i < children.length && (child = (Item)children[i]) != null; ++i) {
                handled |= child.notifyItemPressedStart();
            }
        }
        return handled;
    }

    public void notifyItemPressedEnd() {
        super.notifyItemPressedEnd();
        if (this.isPressAllChildren) {
            Item child;
            Object[] children = this.itemsList.getInternalArray();
            for (int i = 0; i < children.length && (child = (Item)children[i]) != null; ++i) {
                child.notifyItemPressedEnd();
            }
        }
    }

    public void resetLastPointerPressYOffset() {
        this.lastPointerPressYOffset = this.targetYOffset;
    }
}

