/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.IdentityArrayList;

public class Command
extends javax.microedition.lcdui.Command {
    public static final int SCREEN = 1;
    public static final int BACK = 2;
    public static final int CANCEL = 3;
    public static final int OK = 4;
    public static final int HELP = 5;
    public static final int STOP = 6;
    public static final int EXIT = 7;
    public static final int ITEM = 8;
    public static final int SEPARATOR = 100;
    private String longLabel;
    private int commandType;
    private int priority;
    private IdentityArrayList children;
    private Style style;
    private String label;
    private ItemCommandListener itemCommandListener;
    private CommandListener commandListener;
    private Object data;

    public Command(String label, int commandType, int priority) {
        this(label, label, commandType, priority, null);
    }

    public Command(String label, int commandType, int priority, Style style) {
        this(label, label, commandType, priority, style);
    }

    public Command(String shortLabel, String longLabel, int commandType, int priority) {
        this(shortLabel, longLabel, commandType, priority, null);
    }

    public Command(String shortLabel, String longLabel, int commandType, int priority, Style style) {
        super(Command.getValidLabel(shortLabel), longLabel, Command.getValidType(commandType), priority);
        this.label = shortLabel;
        this.longLabel = longLabel;
        this.commandType = commandType;
        this.priority = priority;
        this.style = style;
    }

    private static int getValidType(int type) {
        if (type == 100) {
            type = 1;
        }
        return type;
    }

    private static String getValidLabel(String label) {
        if (label == null) {
            label = "";
        }
        return label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    public int getCommandType() {
        return this.commandType;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof Command)) {
            return false;
        }
        Command co = (Command)o;
        boolean bl = result = co.priority == this.priority && co.commandType == this.commandType;
        result = co.label != null ? (result &= co.label.equals(this.label)) : (result &= this.label == null);
        return result;
    }

    public int hashCode() {
        int code = 0;
        if (this.label != null) {
            code = this.label.hashCode();
        }
        return code | this.priority | this.commandType << 3;
    }

    public void setItemCommandListener(ItemCommandListener listener) {
        this.itemCommandListener = listener;
    }

    public ItemCommandListener getItemCommandListener() {
        return this.itemCommandListener;
    }

    public void setCommandListener(CommandListener listener) {
        this.commandListener = listener;
    }

    public CommandListener getCommandListener() {
        return this.commandListener;
    }

    public boolean commandAction(Item item, Displayable displayable) {
        Object listener;
        if (item != null) {
            listener = this.itemCommandListener;
            if (listener == null) {
                listener = item.getItemCommandListener();
            }
            if (listener != null) {
                while (item instanceof Container && (item.commands == null || !item.commands.contains(this))) {
                    item = ((Container)item).getFocusedItem();
                }
                if (item != null && (item.commands != null && item.commands.contains(this) || item.getDefaultCommand() == this)) {
                    listener.commandAction(this, item);
                    return true;
                }
            }
        }
        if (displayable != null) {
            listener = this.commandListener;
            if (listener == null && displayable instanceof Screen) {
                listener = ((Screen)displayable).getCommandListener();
            }
            if (listener != null) {
                listener.commandAction(this, displayable);
                return true;
            }
        }
        return false;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean addSubCommand(Command child) {
        if (this.children == null) {
            this.children = new IdentityArrayList();
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            return true;
        }
        return false;
    }

    public void removeSubCommand(Command child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void removeSubCommands() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public boolean hasSubCommands() {
        return this.children != null && this.children.size() > 0;
    }

    public Object[] getSubCommmandsArray() {
        if (this.children == null) {
            return null;
        }
        return this.children.getInternalArray();
    }

    public Command[] getSubCommands() {
        if (this.children == null) {
            return new Command[0];
        }
        return (Command[])this.children.toArray(new Command[this.children.size()]);
    }

    public int getSubCommandsCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }
}

