/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import java.util.Calendar;
import java.util.Date;

public class ClockItem
extends StringItem {
    private final Date date = new Date();
    private final Calendar calendar = Calendar.getInstance();
    private boolean includeSeconds = true;
    private boolean includeAmPm;
    private String formatStart;
    private String formatAfterHours;
    private String formatAfterMinutes;
    private String formatAfterSeconds;
    private String formatEnd;
    private long lastTimeUpdate;

    public ClockItem(String label) {
        this(label, (Style)null);
    }

    public ClockItem(String label, Style style) {
        super(label, null, style);
    }

    public boolean animate() {
        boolean animated = super.animate();
        long time = System.currentTimeMillis();
        if (this.includeSeconds && time / 1000L > this.lastTimeUpdate / 1000L || !this.includeSeconds && time / 60000L > this.lastTimeUpdate / 60000L) {
            this.updateTime(time);
            animated = true;
        }
        return animated;
    }

    public boolean includeSeconds() {
        return this.includeSeconds;
    }

    protected String createCssSelector() {
        return "clockitem";
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.updateTime(System.currentTimeMillis());
        super.initContent(firstLineWidth, availWidth, availHeight);
    }

    private void updateTime(long time) {
        this.lastTimeUpdate = time;
        if (this.formatStart == null) {
            this.formatStart = "";
            this.formatAfterHours = ":";
            this.formatAfterMinutes = ":";
            this.formatAfterSeconds = "";
            this.formatEnd = "";
        }
        StringBuffer buffer = new StringBuffer();
        this.date.setTime(time);
        this.calendar.setTime(this.date);
        buffer.append(this.formatStart);
        int hour = this.calendar.get(11);
        boolean isPm = false;
        if (this.includeAmPm && hour > 12) {
            hour -= 12;
            isPm = true;
        }
        buffer.append(hour);
        buffer.append(this.formatAfterHours);
        int minute = this.calendar.get(12);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        buffer.append(this.formatAfterMinutes);
        if (this.includeSeconds) {
            int seconds = this.calendar.get(13);
            if (seconds < 10) {
                buffer.append('0');
            }
            buffer.append(seconds);
            buffer.append(this.formatAfterSeconds);
        }
        if (this.includeAmPm) {
            if (isPm) {
                buffer.append("PM");
            } else {
                buffer.append("AM");
            }
        }
        buffer.append(this.formatEnd);
        this.setText(buffer.toString());
    }

    public String updateTime(String hours, String minutes, String seconds) {
        if (this.formatStart == null) {
            this.formatStart = "";
            this.formatAfterHours = ":";
            this.formatAfterMinutes = ":";
            this.formatAfterSeconds = "";
            this.formatEnd = "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.formatStart).append(hours).append(this.formatAfterHours).append(minutes);
        if (this.includeSeconds) {
            buffer.append(this.formatAfterMinutes).append(seconds);
        }
        buffer.append(this.formatEnd);
        return buffer.toString();
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void hideNotify() {
        super.hideNotify();
        AnimationThread.removeAnimationItem(this);
    }

    protected void showNotify() {
        super.showNotify();
        this.updateTime(System.currentTimeMillis());
        AnimationThread.addAnimationItem(this);
    }
}

