/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Graphics;

public class ChoiceTextField
extends TextField {
    public static final int MATCH_STARTS_WITH = 0;
    public static final int MATCH_INDEX_OF = 1;
    private final boolean isAllowFreeTextEntry;
    private final Container choicesContainer;
    private String[] choices;
    private String[] lowerCaseChoices;
    private int numberOfMatches;
    private boolean isInChoice;
    private Item[] choiceItems;
    private String lastMatchingText;
    private Style originalStyle;
    private Style focusingStyle;
    private int matchMode;
    private boolean reenableCaretFlashing = true;
    private int choicesYOffsetAdjustment;
    private boolean isOpen;
    private Style choiceItemStyle;
    private String appendChoiceDelimiter;
    private boolean isAppendMode;
    private int appendDelimiterIndex = -1;
    private boolean choiceTriggerEnabled;
    private char choiceTrigger;
    private boolean choiceTriggerAllowInputBeforeTrigger;

    public ChoiceTextField(String label, String text, int maxSize, int constraints, String[] availableChoices, boolean allowFreeTextEntry) {
        this(label, text, maxSize, constraints, availableChoices, allowFreeTextEntry, false, ";", null);
    }

    public ChoiceTextField(String label, String text, int maxSize, int constraints, String[] availableChoices, boolean allowFreeTextEntry, Style style) {
        this(label, text, maxSize, constraints, availableChoices, allowFreeTextEntry, false, ";", style);
    }

    public ChoiceTextField(String label, String text, int maxSize, int constraints, String[] availableChoices, boolean allowFreeTextEntry, boolean appendChoice, String appendChoiceDelimiter) {
        this(label, text, maxSize, constraints, availableChoices, allowFreeTextEntry, appendChoice, appendChoiceDelimiter, null);
    }

    public ChoiceTextField(String label, String text, int maxSize, int constraints, String[] availableChoices, boolean allowFreeTextEntry, boolean appendChoice, String appendChoiceDelimiter, Style style) {
        super(label, text, maxSize, constraints, style);
        this.choices = availableChoices;
        if (availableChoices != null) {
            this.lowerCaseChoices = new String[availableChoices.length];
            for (int i = 0; i < availableChoices.length; ++i) {
                String choice = availableChoices[i];
                this.lowerCaseChoices[i] = choice.toLowerCase();
            }
            this.choiceItems = new Item[availableChoices.length];
        }
        this.isAllowFreeTextEntry = allowFreeTextEntry;
        this.choicesContainer = new Container(false);
        this.choicesContainer.parent = this;
        this.isAppendMode = appendChoice;
        this.appendChoiceDelimiter = appendChoiceDelimiter;
        if (appendChoiceDelimiter != null && appendChoiceDelimiter.length() > 0) {
            this.emailSeparatorChar = appendChoiceDelimiter.charAt(0);
        }
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(firstLineWidth, availWidth, availHeight);
        this.choicesContainer.relativeY = this.contentHeight + this.paddingVertical;
    }

    public void setChoiceTrigger(char choiceTrigger, boolean allowChoicesBeforeTrigger) {
        this.isAppendMode = true;
        this.choiceTriggerEnabled = true;
        this.choiceTrigger = choiceTrigger;
        this.choiceTriggerAllowInputBeforeTrigger = allowChoicesBeforeTrigger;
    }

    public void setChoices(String[] choices) {
        this.choicesContainer.clear();
        if (choices == null) {
            this.choiceItems = new Item[0];
            this.openChoices(false);
            return;
        }
        this.choiceItems = new Item[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            String choiceText = choices[i];
            ChoiceItem item = new ChoiceItem(choiceText, null, 3, this.choiceItemStyle);
            this.choiceItems[i] = item;
            this.choicesContainer.add(item);
        }
        this.choices = choices;
        if (this.isFocused) {
            this.openChoices(choices.length > 0);
        }
    }

    public void setChoices(Item[] choices) {
        this.choicesContainer.clear();
        if (choices == null) {
            this.choiceItems = new Item[0];
            this.openChoices(false);
            return;
        }
        this.choiceItems = choices;
        for (int i = 0; i < choices.length; ++i) {
            Item item = choices[i];
            this.choicesContainer.add(item);
        }
        if (this.isFocused) {
            this.openChoices(choices.length > 0);
        }
    }

    public void setMatchMode(int mode) {
        this.matchMode = mode;
    }

    public int getMatchMode() {
        return this.matchMode;
    }

    protected void defocus(Style origStyle) {
        super.defocus(origStyle);
        if (!this.isAllowFreeTextEntry && this.numberOfMatches > 0 && this.choicesContainer.size() > 0) {
            Item item = this.choicesContainer.get(0);
            if (item instanceof StringItem) {
                this.setString(((StringItem)item).getText());
            } else {
                this.setString(item.toString());
            }
        }
        this.numberOfMatches = 0;
        this.choicesContainer.clear();
        this.openChoices(false);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.isFocused && this.numberOfMatches > 0) {
            this.choicesContainer.animate(currentTime, repaintRegion);
        }
    }

    protected Style focus(Style focStyle, int direction) {
        this.originalStyle = super.focus(focStyle, direction);
        this.focusingStyle = this.style;
        return this.originalStyle;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean isFireGameAction = this.getScreen().isGameActionFire(keyCode, gameAction);
        if (this.isInChoice) {
            if (this.choicesContainer.handleKeyPressed(keyCode, gameAction)) {
                return true;
            }
            if (isFireGameAction) {
                Item item = this.choicesContainer.getFocusedItem();
                item.notifyItemPressedStart();
            } else {
                this.enterChoices(false);
            }
            return true;
        }
        if (gameAction == 6 && keyCode != 56 && this.numberOfMatches > 0) {
            this.enterChoices(true);
            return true;
        }
        if (isFireGameAction) {
            String currentText;
            if (this.isOpen) {
                this.notifyItemPressedStart();
                this.numberOfMatches = 0;
                return true;
            }
            if (this.choiceTriggerEnabled && !this.choiceTriggerAllowInputBeforeTrigger && ((currentText = this.getString()) == null || currentText.length() == 0 || currentText.charAt(currentText.length() - 1) != this.choiceTrigger)) {
                return super.handleKeyPressed(keyCode, gameAction);
            }
            if (this.choices == null) {
                return super.handleKeyPressed(keyCode, gameAction);
            }
            this.notifyItemPressedStart();
            this.appendDelimiterIndex = -1;
            this.choicesContainer.clear();
            for (int i = 0; i < this.choices.length; ++i) {
                Item item = this.choiceItems[i];
                if (item == null) {
                    item = new ChoiceItem(this.choices[i], null, 3, this.choiceItemStyle);
                }
                this.choicesContainer.add(item);
            }
            this.numberOfMatches = this.choicesContainer.size();
            return true;
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean isFireGameAction = this.getScreen().isGameActionFire(keyCode, gameAction);
        if (this.isInChoice) {
            if (this.choicesContainer.handleKeyReleased(keyCode, gameAction)) {
                if (this.choicesContainer.internalX != -9999) {
                    this.internalX = this.choicesContainer.relativeX + this.choicesContainer.internalX;
                    this.internalY = this.choicesContainer.relativeY + this.choicesContainer.internalY;
                }
                return true;
            }
            if (isFireGameAction) {
                String choiceText;
                this.enterChoices(false);
                Item item = this.choicesContainer.getFocusedItem();
                item.notifyItemPressedEnd();
                if (item instanceof ChoiceItem) {
                    choiceText = ((ChoiceItem)item).getText();
                } else if (item != null) {
                    choiceText = item.toString();
                } else {
                    return false;
                }
                if (this.isAppendMode) {
                    String currentText = this.getString();
                    if (currentText != null) {
                        if (this.appendDelimiterIndex != -1 && this.appendDelimiterIndex < currentText.length()) {
                            currentText = currentText.substring(0, this.appendDelimiterIndex);
                        }
                        if (choiceText.startsWith(currentText)) {
                            if (this.appendChoiceDelimiter != null) {
                                choiceText = choiceText + this.appendChoiceDelimiter;
                            }
                        } else {
                            choiceText = this.appendChoiceDelimiter == null ? currentText + choiceText : (this.choiceTriggerEnabled ? currentText + choiceText + this.appendChoiceDelimiter : (currentText.endsWith(this.appendChoiceDelimiter) ? currentText + choiceText + this.appendChoiceDelimiter : currentText + this.appendChoiceDelimiter + choiceText + this.appendChoiceDelimiter));
                        }
                    } else if (this.appendChoiceDelimiter != null) {
                        choiceText = choiceText + this.appendChoiceDelimiter;
                    }
                    this.appendDelimiterIndex = choiceText.length();
                }
                if (!this.isAllowFreeTextEntry) {
                    this.lastMatchingText = choiceText;
                }
                this.setString(choiceText);
                this.setCaretPosition(choiceText.length());
                this.numberOfMatches = 0;
                this.openChoices(false);
                super.notifyStateChanged();
            }
            return true;
        }
        if (isFireGameAction) {
            this.notifyItemPressedEnd();
            this.openChoices(!this.isOpen);
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handlePointerPressed(int x, int y) {
        boolean handled = super.handlePointerPressed(x, y);
        if (!handled && this.isOpen) {
            handled = this.choicesContainer.handlePointerPressed(x - this.contentX, y - (this.choicesContainer.relativeY + this.contentY));
            if (handled && !this.isInChoice) {
                this.isInChoice = true;
            } else {
                this.openChoices(false);
                handled = true;
            }
        }
        return handled;
    }

    protected boolean handlePointerReleased(int x, int y) {
        boolean handled = super.handlePointerReleased(x, y);
        if (!handled && this.isOpen) {
            handled = this.choicesContainer.handlePointerReleased(x - this.contentX, y - (this.choicesContainer.relativeY + this.contentY));
            if (!handled && this.choicesContainer.focusedItem != null) {
                this.isInChoice = true;
                this.handleKeyReleased(0, 8);
            }
            handled = true;
        }
        return handled;
    }

    private void enterChoices(boolean enter) {
        if (enter) {
            this.choicesContainer.focusChild(0);
            this.setStyle(this.originalStyle);
            this.flashCaret = false;
            this.showCaret = false;
            if (!this.isInChoice) {
                this.getScreen().removeItemCommands(this);
            }
        } else {
            this.internalX = -9999;
            this.setStyle(this.focusingStyle);
            this.flashCaret = this.reenableCaretFlashing;
            this.showCaret = true;
            this.choicesContainer.setScrollYOffset(0, false);
            this.choicesContainer.defocus(this.originalStyle);
            if (this.isInChoice) {
                this.showCommands();
            }
        }
        this.isInChoice = enter;
    }

    private void openChoices(boolean open) {
        this.choicesContainer.focusChild(-1);
        if (open) {
            if (this.choicesContainer.size() == 0) {
                open = false;
            } else if (this.parent instanceof Container) {
                Container parentContainer = (Container)this.parent;
                if (parentContainer.enableScrolling) {
                    int availWidth = this.itemWidth - (this.marginLeft + this.marginRight);
                    int choicesHeight = this.choicesContainer.getItemHeight(availWidth, availWidth, this.availableHeight);
                    int choicesBottomY = this.contentY + this.contentHeight + this.paddingVertical + choicesHeight;
                    int parentYOffset = parentContainer.getScrollYOffset();
                    int overlap = choicesBottomY - (parentContainer.getContentScrollHeight() - (this.relativeY + parentYOffset));
                    if (overlap > 0) {
                        int yOffsetAdjustment;
                        this.choicesYOffsetAdjustment = yOffsetAdjustment = Math.min(this.relativeY + parentYOffset, overlap);
                        parentContainer.setScrollYOffset(parentYOffset - yOffsetAdjustment, true);
                        int itHeight = this.itemHeight;
                        int ctHeight = this.contentY + this.contentHeight + this.paddingVertical;
                        int max = Math.max(itHeight, ctHeight);
                        this.choicesContainer.setScrollHeight(parentContainer.getContentScrollHeight() - max);
                    } else {
                        this.choicesYOffsetAdjustment = 0;
                    }
                }
            }
        } else {
            if (this.isInChoice) {
                this.enterChoices(false);
            }
            this.choicesContainer.clear();
            if (this.choicesYOffsetAdjustment != 0 && this.parent instanceof Container) {
                Container parentContainer = (Container)this.parent;
                parentContainer.setScrollYOffset(parentContainer.getScrollYOffset() + this.choicesYOffsetAdjustment, true);
                this.choicesYOffsetAdjustment = 0;
            }
        }
        this.isOpen = open;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        if (this.isFocused && this.isOpen && this.numberOfMatches > 0) {
            this.choicesContainer.paint(x, y += this.contentHeight + this.paddingVertical, leftBorder, rightBorder, g);
        }
    }

    public void notifyStateChanged() {
        Screen scr = this.getScreen();
        if (scr != null && scr.itemStateListener != null) {
            super.notifyStateChanged();
        } else {
            String currentText;
            if (this.lowerCaseChoices == null) {
                return;
            }
            if (this.isOpen) {
                this.choicesContainer.focusChild(-1);
            }
            if ((currentText = this.getString()) != null) {
                int i;
                if (this.isAppendMode) {
                    if (this.appendChoiceDelimiter != null) {
                        int caretPosition = this.getCaretPosition();
                        if (caretPosition < currentText.length() && caretPosition != -1) {
                            currentText = currentText.substring(0, caretPosition);
                        }
                        this.appendDelimiterIndex = TextUtil.lastIndexOf(currentText, this.appendChoiceDelimiter);
                        if (this.appendDelimiterIndex != -1) {
                            currentText = currentText.substring(this.appendDelimiterIndex + 1);
                        }
                    } else if (this.appendDelimiterIndex != -1 && this.appendDelimiterIndex < currentText.length()) {
                        currentText = currentText.substring(this.appendDelimiterIndex);
                    }
                }
                if (this.choiceTriggerEnabled && currentText.length() > 0) {
                    char lastChar = currentText.charAt(currentText.length() - 1);
                    if (lastChar == this.choiceTrigger && !this.isOpen) {
                        this.handleKeyPressed(0, 8);
                        this.handleKeyReleased(0, 8);
                    }
                    return;
                }
                currentText = currentText.toLowerCase();
                if (this.isAllowFreeTextEntry) {
                    this.choicesContainer.clear();
                }
                int foundMatches = 0;
                for (i = 0; i < this.lowerCaseChoices.length; ++i) {
                    String choice = this.lowerCaseChoices[i];
                    if (!this.matches(currentText, choice)) continue;
                    ++foundMatches;
                    Item item = this.choiceItems[i];
                    if (item == null) {
                        item = new ChoiceItem(this.choices[i], null, 3, this.choiceItemStyle);
                    }
                    this.choicesContainer.add(item);
                }
                if (this.isAllowFreeTextEntry) {
                    this.numberOfMatches = foundMatches;
                } else if (foundMatches == 0) {
                    this.setString(this.lastMatchingText);
                } else {
                    this.lastMatchingText = this.getString();
                    i = this.numberOfMatches;
                    while (--i >= 0) {
                        this.choicesContainer.remove(0);
                    }
                    this.numberOfMatches = foundMatches;
                }
            }
            this.openChoices(this.numberOfMatches > 0);
        }
    }

    private boolean matches(String currentText, String choice) {
        if (this.matchMode == 0) {
            return choice.startsWith(currentText);
        }
        return choice.indexOf(currentText) != -1;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }
}

