/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public abstract class Background
implements Externalizable {
    public int borderWidth = 0;
    public transient Item parent;

    public void setParentItem(Item parent) {
        this.parent = parent;
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            this.addRelativeToBackgroundRegion(repaintRegion, screen, parent, 0, 0, 0, 0);
        }
    }

    protected void addRelativeToBackgroundRegion(ClippingRegion repaintRegion, Screen screen, Item parent, int left, int right, int top, int bottom) {
        if (parent != null) {
            parent.addRelativeToBackgroundRegion(repaintRegion, left, top, parent.backgroundWidth - left + right + 1, parent.backgroundHeight - top + bottom + 1);
        } else {
            repaintRegion.addRegion(0, 0, screen.getWidth(), screen.getScreenHeight());
        }
    }

    public boolean animate() {
        return false;
    }

    public abstract void paint(int var1, int var2, int var3, int var4, Graphics var5);

    public void releaseResources() {
    }

    public void hideNotify() {
    }

    public void showNotify() {
    }

    public void setStyle(Style style) {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.borderWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.borderWidth);
    }
}

