/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Animatable;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;

public class AnimationThread
extends Thread {
    public static final String EVENT_IDLE_MODE_ON = "idle-on";
    public static final String EVENT_IDLE_MODE_OFF = "idle-off";
    public static final long ANIMATION_INTERVAL = 50L;
    private static final int ANIMATION_YIELD_INTERVAL = Integer.MIN_VALUE;
    private static final long SLEEP_INTERVAL = 1000L;
    private static final long ANIMATION_MIN_INTERVAL = 10L;
    protected static boolean releaseResourcesOnScreenChange;
    private static ArrayList animationList;
    private static final long ANIMATION_TIMEOUT = 180000L;
    long totalDelta = -1L;
    private boolean isStopRequested;

    public AnimationThread() {
        super("AnimationThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long sleeptime = 50L;
        long currentTime = 0L;
        long usedTime = 0L;
        int i = 0;
        Object[] animationItems = null;
        Animatable animatable = null;
        Displayable d = null;
        ClippingRegion repaintRegion = new ClippingRegion();
        long lastIdleTime = 0L;
        int sleepIntervalCounter = 0;
        while (!this.isStopRequested) {
            try {
                Screen screen = StyleSheet.currentScreen;
                if (screen != null && screen.isShown()) {
                    currentTime = System.currentTimeMillis();
                    long idleTime = currentTime - screen.lastInteractionTime;
                    if (idleTime < 180000L) {
                        screen.animate(currentTime, repaintRegion);
                        if (animationList != null) {
                            animationItems = animationList.getInternalArray();
                            for (i = 0; i < animationItems.length && (animatable = (Animatable)animationItems[i]) != null; ++i) {
                                animatable.animate(currentTime, repaintRegion);
                            }
                        }
                        if (repaintRegion.containsRegion()) {
                            screen.requestRepaint(repaintRegion.getX(), repaintRegion.getY(), repaintRegion.getWidth() + 1, repaintRegion.getHeight() + 1);
                            repaintRegion.reset();
                            screen.serviceRepaints();
                        }
                        sleeptime = (usedTime = System.currentTimeMillis() - currentTime) >= 50L ? Integer.MIN_VALUE : 50L - usedTime;
                    } else if (sleeptime != 1000L) {
                        sleeptime = 1000L;
                        sleepIntervalCounter = 0;
                    } else if (++sleepIntervalCounter > 20) {
                        sleepIntervalCounter = 0;
                        Display instance = Display.getInstance();
                        if (instance != null) {
                            Display display = instance;
                            synchronized (display) {
                                instance.emitNotifyOnUserEvents(true);
                                instance.wait();
                                continue;
                            }
                        }
                    }
                    if (releaseResourcesOnScreenChange && (d = StyleSheet.display.getCurrent()) != screen) {
                        StyleSheet.currentScreen = null;
                    }
                    if (sleeptime == Integer.MIN_VALUE) {
                        Thread.sleep(10L);
                    } else {
                        Thread.sleep(sleeptime);
                    }
                    this.totalDelta = System.currentTimeMillis() - currentTime - 50L;
                    continue;
                }
                if (releaseResourcesOnScreenChange) {
                    StyleSheet.releaseResources();
                    releaseResourcesOnScreenChange = false;
                }
                sleeptime = 1000L;
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.AnimationThread", 283, (Object)"unable to animate screen", e);
            }
        }
    }

    public void requestStop() {
        this.isStopRequested = true;
    }

    public long getTotalDelta() {
        return this.totalDelta;
    }

    public static void addAnimationItem(Animatable item) {
        if (animationList == null) {
            animationList = new ArrayList();
        }
        if (!animationList.contains(item)) {
            animationList.add(item);
        }
    }

    public static void removeAnimationItem(Animatable item) {
        if (animationList != null) {
            animationList.remove(item);
        }
    }

    public static void addIdleEvent(String eventName, long timeout) {
        throw new IllegalStateException();
    }

    public static void removeIdleEvent(String eventName) {
        throw new IllegalStateException();
    }

    public static String[] getIdleEventNames() {
        String[] events = null;
        return events;
    }

    public static long[] getIdleEventTimeouts() {
        long[] timeouts = null;
        return timeouts;
    }

    public void handleEvent(String name, Object source, Object data) {
    }
}

