/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AlertType;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import de.enough.polish.util.Locale;
import javax.microedition.lcdui.Image;

public class Alert
extends Screen
implements CommandListener {
    public static final int FOREVER = -2;
    public static Command DISMISS_COMMAND = StyleSheet.OK_CMD;
    private int timeout = -2;
    private long showTime;
    private AlertType type;
    private IconItem iconItem;
    private Gauge indicator;
    protected Displayable nextDisplayable;
    private int numberOfCommands;
    private Style contentStyle;

    public Alert(String title) {
        this(title, null, null, null, StyleSheet.alertStyle);
    }

    public Alert(String title, Style style) {
        this(title, null, null, null, style);
    }

    public Alert(String title, String text) {
        this(title, text, null, null, StyleSheet.alertStyle);
    }

    public Alert(String title, String text, Style style) {
        this(title, text, null, null, style);
    }

    public Alert(String title, String alertText, Image alertImage, AlertType alertType) {
        this(title, alertText, alertImage, alertType, StyleSheet.alertStyle);
    }

    public Alert(String title, String alertText, Image alertImage, AlertType alertType, Style style) {
        super(title, style, true);
        String okLabel;
        if (alertText != null || alertImage != null) {
            if ("".equals(alertText) && title != null) {
                this.setTitle((String)null);
                alertText = title;
            }
            this.createItem(alertText, alertImage, null);
        }
        if ((okLabel = Locale.get(165)) != StyleSheet.OK_CMD.getLabel()) {
            DISMISS_COMMAND = StyleSheet.OK_CMD = new Command(okLabel, 4, 2);
        }
        this.addCommand(DISMISS_COMMAND);
        super.setCommandListener(this);
    }

    public void addCommand(Command cmd) {
        super.removeCommand(DISMISS_COMMAND);
        super.addCommand(cmd);
        ++this.numberOfCommands;
        if (this.numberOfCommands > 1) {
            this.timeout = -2;
        }
    }

    public void removeCommand(Command cmd) {
        super.removeCommand(cmd);
        --this.numberOfCommands;
        if (this.numberOfCommands == 0) {
            super.addCommand(DISMISS_COMMAND);
        }
    }

    public void setCommandListener(CommandListener listener) {
        if (listener == null) {
            super.setCommandListener(this);
        } else {
            super.setCommandListener(listener);
        }
    }

    private void createItem(String alertText, Image alertImage, Style itemStyle) {
        this.iconItem = itemStyle == null ? new IconItem(alertText, alertImage) : new IconItem(alertText, alertImage, itemStyle);
        this.iconItem.appearanceMode = 0;
        this.container.add(this.iconItem);
    }

    public int getDefaultTimeout() {
        return -2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public AlertType getType() {
        return this.type;
    }

    public void setType(AlertType type) {
        this.type = type;
    }

    public String getString() {
        if (this.iconItem == null) {
            return null;
        }
        return this.iconItem.getText();
    }

    public void setString(String str) {
        this.setString(str, null);
    }

    public void setString(String str, Style style) {
        if (style == null) {
            style = this.contentStyle;
        }
        if (this.iconItem == null) {
            this.createItem(str, null, style);
        } else if (style != null) {
            this.iconItem.setStyle(style);
        }
        this.iconItem.setText(str);
    }

    public Image getImage() {
        if (this.iconItem == null) {
            return null;
        }
        return this.iconItem.getImage();
    }

    public void setImage(Image img) {
        this.setImage(img, null);
    }

    public void setImage(Image img, Style style) {
        if (style == null) {
            style = this.contentStyle;
        }
        if (this.iconItem == null) {
            this.createItem(null, img, style);
        } else if (style != null) {
            this.iconItem.setStyle(style);
        }
        this.iconItem.setImage(img);
    }

    public void setIndicator(Gauge indicator) {
        this.setIndicator(indicator, null);
    }

    public void setIndicator(Gauge indicator, Style style) {
        if (this.indicator != null) {
            this.container.remove(this.indicator);
        }
        this.indicator = indicator;
        if (this.indicator != null) {
            if (style != null) {
                indicator.setStyle(style);
            }
            this.container.add(this.indicator);
        }
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    protected String createCssSelector() {
        return "alert";
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.iconItem != null) {
            this.iconItem.animate(currentTime, repaintRegion);
        }
        if (this.indicator != null) {
            this.indicator.animate(currentTime, repaintRegion);
        }
        if (this.timeout != -2 && currentTime - this.showTime > (long)this.timeout) {
            this.commandAction(DISMISS_COMMAND, this);
        }
    }

    public void commandAction(Command cmd, Displayable thisScreen) {
        if (this.nextDisplayable == null) {
            Debug.debug("error", "de.enough.polish.ui.Alert", 982, (Object)("unable to handle command " + cmd.getLabel()), ": nextDisplayable == null.");
            return;
        }
        Displayable next = this.nextDisplayable;
        this.nextDisplayable = null;
        StyleSheet.display.setCurrent(next);
    }

    public void showNotify() {
        Displayable last;
        this.showTime = System.currentTimeMillis();
        if (this.iconItem == null && this.getTitle() != null) {
            this.setString(this.getTitle());
            this.setTitle((String)null);
        }
        if (this.nextDisplayable == null && (last = StyleSheet.display.getCurrent()) != this && last != null) {
            this.nextDisplayable = last;
        }
        super.showNotify();
    }

    public static void setCurrent(Display display, Alert alert, Displayable nextDisplayable) {
        if (nextDisplayable == null) {
            nextDisplayable = display.getCurrent();
        }
        alert.nextDisplayable = nextDisplayable;
        display.setCurrent(alert);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void setNextDisplayable(Displayable next) {
        this.nextDisplayable = next;
    }
}

