/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.snapshot;

import de.enough.polish.camera.CameraResolution;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.TextUtil;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;

public class SnapshotUtil {
    private static final int MOUNT_POSITION_UNKNOWN = -1;
    private static final int MOUNT_POSITION_LANDSCAPE = 1;
    private static final int MOUNT_POSITION_PORTRAIT = 2;

    public static String getProtocol() throws MediaException {
        String[] contentTypes = Manager.getSupportedContentTypes("capture");
        if (contentTypes == null || contentTypes.length == 0) {
            throw new MediaException("capture not supported");
        }
        String protocol = "capture://video";
        String device = "video";
        boolean deviceIsSupported = false;
        for (int i = 0; i < contentTypes.length; ++i) {
            String contentType = contentTypes[i];
            if (contentType.equals("image")) {
                protocol = "capture://image";
                deviceIsSupported = true;
                break;
            }
            if (!contentType.startsWith(device)) continue;
            deviceIsSupported = true;
        }
        if (!deviceIsSupported && contentTypes.length > 0) {
            protocol = "capture://" + contentTypes[0];
        }
        return protocol;
    }

    public static int getCameraMountPosition() {
        try {
            String positionStr = System.getProperty("camera.mountorientation");
            if (positionStr != null) {
                if ((positionStr = positionStr.toUpperCase()).indexOf("LANDSCAPE") != -1) {
                    return 1;
                }
                if (positionStr.indexOf("PORTRAIT") != -1) {
                    return 2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static String[] getSnapshotEncodings() {
        String supportedEncodingsStr = System.getProperty("video.snapshot.encodings");
        if (supportedEncodingsStr == null) {
            return new String[0];
        }
        Object[] encodings = TextUtil.splitAndTrim(supportedEncodingsStr, ' ');
        Arrays.sort(encodings);
        return encodings;
    }

    public static CameraResolution[] getSnapshotResolutions() {
        String[] encodings = SnapshotUtil.getSnapshotEncodings();
        ArrayList resolutionsList = new ArrayList();
        for (int i = 0; i < encodings.length; ++i) {
            int xIndex;
            String resolutionStr;
            CameraResolution resolution;
            int start;
            String encoding = encodings[i];
            int widthIndex = encoding.indexOf("width=");
            if (widthIndex != -1) {
                int splitPos = encoding.indexOf(38, widthIndex + 1);
                String width = splitPos != -1 ? encoding.substring(widthIndex + "width=".length(), splitPos) : encoding.substring(widthIndex + "width=".length());
                int heightIndex = encoding.indexOf("height=");
                if (heightIndex == -1) continue;
                splitPos = encoding.indexOf(38, heightIndex + 1);
                String height = splitPos == -1 ? encoding.substring(heightIndex + "height=".length()) : encoding.substring(heightIndex + "height=".length(), splitPos);
                CameraResolution resolution2 = new CameraResolution(Integer.parseInt(width), Integer.parseInt(height));
                if (resolutionsList.contains(resolution2)) continue;
                resolutionsList.add(resolution2);
                continue;
            }
            int middlePos = encoding.indexOf(120);
            if (middlePos == -1) continue;
            int end = middlePos + 1;
            for (start = middlePos - 1; start >= 0 && Character.isDigit(encoding.charAt(start)); --start) {
            }
            if (start != 0) {
                ++start;
            }
            while (end < encoding.length() && Character.isDigit(encoding.charAt(end))) {
                ++end;
            }
            if (end != encoding.length() - 1) {
                --end;
            }
            if (start == middlePos || end == middlePos || resolutionsList.contains(resolution = new CameraResolution(Integer.parseInt((resolutionStr = encoding.substring(start, end + 1)).substring(0, xIndex = resolutionStr.indexOf(120))), Integer.parseInt(resolutionStr.substring(xIndex + 1))))) continue;
            resolutionsList.add(resolution);
        }
        Object[] resolutions = (CameraResolution[])resolutionsList.toArray(new CameraResolution[resolutionsList.size()]);
        Arrays.sort(resolutions);
        return resolutions;
    }

    public static CameraResolution getDefaultResolution() {
        int widthIndex;
        String encoding = System.getProperty("video.snapshot.encodings");
        if (encoding == null) {
            return null;
        }
        int splitPos = encoding.indexOf(32);
        if (splitPos != -1) {
            encoding = encoding.substring(0, splitPos);
        }
        if ((widthIndex = encoding.indexOf("width=")) != -1) {
            splitPos = encoding.indexOf(38, widthIndex + 1);
            String width = splitPos != -1 ? encoding.substring(widthIndex + "width=".length(), splitPos) : encoding.substring(widthIndex + "width=".length());
            int heightIndex = encoding.indexOf("height=");
            if (heightIndex != -1) {
                splitPos = encoding.indexOf(38, heightIndex + 1);
                String height = splitPos == -1 ? encoding.substring(heightIndex + "height=".length()) : encoding.substring(heightIndex + "height=".length(), splitPos);
                return new CameraResolution(Integer.parseInt(width), Integer.parseInt(height));
            }
        } else {
            int middlePos = encoding.indexOf(120);
            if (middlePos != -1) {
                int start;
                int end = middlePos + 1;
                for (start = middlePos - 1; start >= 0 && Character.isDigit(encoding.charAt(start)); --start) {
                }
                if (start != 0) {
                    ++start;
                }
                while (end < encoding.length() && Character.isDigit(encoding.charAt(end))) {
                    ++end;
                }
                if (end != encoding.length() - 1) {
                    --end;
                }
                if (start != middlePos && end != middlePos) {
                    String resolution = encoding.substring(start, end + 1);
                    splitPos = resolution.indexOf(120);
                    return new CameraResolution(Integer.parseInt(resolution.substring(0, splitPos)), Integer.parseInt(resolution.substring(splitPos + 1)));
                }
            }
        }
        return null;
    }

    public static String[] getSnapshotEncodingsWithResolutionCloseTo(int width, int height) {
        return SnapshotUtil.getSnapshotEncodingsWithResolutionCloseTo(width, height, false, false, null);
    }

    public static String[] getSnapshotEncodingsWithResolutionCloseTo(int width, int height, boolean needsToBeLarger, boolean needsToBeSmaller, String format) {
        CameraResolution[] resolutions = SnapshotUtil.getSnapshotResolutions();
        String defaultEncoding = format != null ? "encoding=" + format + "&width=" + width + "&height=" + height : "encoding=jpeg&width=" + width + "&height=" + height;
        if (resolutions.length == 0) {
            return new String[]{defaultEncoding};
        }
        int minDistance = Integer.MAX_VALUE;
        int closestWidth = 0;
        int closestHeight = 0;
        for (int i = 0; i < resolutions.length; ++i) {
            int distance;
            CameraResolution resolution = resolutions[i];
            int resWidth = resolution.width;
            int resHeight = resolution.height;
            if (needsToBeLarger && (resWidth < width || resHeight < height) || needsToBeSmaller && (resWidth > width || resHeight > height) || (distance = Math.abs(width - resWidth) + Math.abs(height - resHeight)) >= minDistance) continue;
            closestWidth = resWidth;
            closestHeight = resHeight;
            minDistance = distance;
        }
        if (minDistance == Integer.MAX_VALUE) {
            return new String[]{defaultEncoding};
        }
        Object[] encodings = SnapshotUtil.getSnapshotEncodings();
        if (format != null) {
            format = format.toLowerCase();
        }
        ArrayList bestEncodings = new ArrayList();
        String closestWidthStr = Integer.toString(closestWidth);
        String closestHeightStr = Integer.toString(closestHeight);
        for (int i = 0; i < encodings.length; ++i) {
            String encoding = encodings[i];
            if (format != null && encoding.toLowerCase().indexOf(format) == -1 || encoding.indexOf(closestWidthStr) == -1 || encoding.indexOf(closestHeightStr) == -1) continue;
            bestEncodings.add(encoding);
        }
        if (bestEncodings.size() == 0) {
            return new String[]{defaultEncoding};
        }
        encodings = (String[])bestEncodings.toArray(new String[bestEncodings.size()]);
        Arrays.sort(encodings);
        return encodings;
    }

    public static String[] getSnapshotFormats() {
        String[] encodings = SnapshotUtil.getSnapshotEncodings();
        ArrayList formats = new ArrayList();
        boolean pngAdded = false;
        boolean jpegAdded = false;
        boolean bmpAdded = false;
        boolean gifAdded = false;
        for (int i = 0; i < encodings.length; ++i) {
            String encoding = encodings[i].toLowerCase();
            if (!pngAdded && encoding.indexOf("png") != -1) {
                formats.add("png");
                pngAdded = true;
                continue;
            }
            if (!jpegAdded && encoding.indexOf("jpg") != -1) {
                formats.add("jpg");
                jpegAdded = true;
                continue;
            }
            if (!jpegAdded && encoding.indexOf("jpeg") != -1) {
                formats.add("jpeg");
                jpegAdded = true;
                continue;
            }
            if (!gifAdded && encoding.indexOf("gif") != -1) {
                formats.add("gif");
                gifAdded = true;
                continue;
            }
            if (bmpAdded || encoding.indexOf("bmp") == -1) continue;
            formats.add("bmp");
            bmpAdded = true;
        }
        return (String[])formats.toArray(new String[formats.size()]);
    }
}

