/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.ProcessingEvent;
import de.enough.polish.processing.ProcessingInterface;
import java.util.Enumeration;
import java.util.Vector;

public class ProcessingThread
extends Thread
implements Runnable {
    protected static Vector objects = new Vector();
    protected static Vector events = new Vector();
    protected static Thread thread = null;

    public static void addProcessingObject(ProcessingInterface object) {
        if (!objects.contains(object)) {
            objects.addElement(object);
        }
        if (objects.size() == 1 && thread == null) {
            thread = new ProcessingThread();
            ProcessingThread.startThread(thread);
        }
    }

    public static void queueEvent(ProcessingEvent event) {
        if (event.eventType != 13) {
            events.addElement(event);
        } else {
            ProcessingThread.addProcessingObject(event.object);
        }
    }

    public static void removeProcessingObject(ProcessingInterface object) {
        objects.removeElement(object);
    }

    protected static void startThread(Runnable object) {
        thread = new Thread(object);
        thread.start();
    }

    public void run() {
        while (objects.size() != 0) {
            Enumeration objList = events.elements();
            while (objList.hasMoreElements()) {
                ProcessingEvent event = (ProcessingEvent)objList.nextElement();
                switch (event.eventType) {
                    case 0: {
                        event.object.executeRefresh(true);
                        event.object.triggerRepaint();
                        break;
                    }
                    case 1: {
                        event.object.executeInitializationSequence();
                        break;
                    }
                    case 2: {
                        event.object.focus();
                        break;
                    }
                    case 3: {
                        event.object.lostFocus();
                        break;
                    }
                    case 4: {
                        event.object.setPointerCoordinates(event.param1, event.param2);
                        event.object.pointerPressed();
                        break;
                    }
                    case 5: {
                        event.object.setPointerCoordinates(event.param1, event.param2);
                        event.object.pointerDragged();
                        break;
                    }
                    case 6: {
                        event.object.setPointerCoordinates(event.param1, event.param2);
                        event.object.pointerReleased();
                        break;
                    }
                    case 7: {
                        event.object.setKeyAndKeyCode((char)event.param1, event.param2);
                        event.object.keyPressed();
                        break;
                    }
                    case 8: {
                        event.object.setKeyAndKeyCode((char)event.param1, event.param2);
                        event.object.keyReleased();
                        break;
                    }
                    case 9: {
                        event.object.softkeyPressed(event.strParam1);
                        break;
                    }
                    case 10: {
                        event.object.suspend();
                        break;
                    }
                    case 11: {
                        event.object.resume();
                        break;
                    }
                    case 12: {
                        event.object.destroy();
                        ProcessingThread.removeProcessingObject(event.object);
                    }
                }
            }
            events.setSize(0);
            objList = objects.elements();
            while (objList.hasMoreElements()) {
                ProcessingInterface temp = (ProcessingInterface)objList.nextElement();
                if (!temp.checkForRefresh() || !temp.isLooping()) continue;
                ProcessingThread.queueEvent(new ProcessingEvent(temp, 0));
            }
            try {
                ProcessingThread.sleep(50L);
            }
            catch (Exception EX) {}
        }
        thread = null;
    }
}

