/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.ProcessingContextContainerInterface;
import de.enough.polish.processing.ProcessingInterface;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class ProcessingItem
extends Item
implements ProcessingContextContainerInterface {
    protected ProcessingInterface context;
    protected Command cmd = new Command("", 8, 0);
    protected String softkeyCommandText = null;

    public ProcessingItem(ProcessingInterface context) {
        this.context = context;
        this.context.setParent(this);
        this.appearanceMode = 3;
        context.signalInitialization();
    }

    protected boolean isWithinBounds(int x, int y) {
        return x >= this.paddingLeft && x <= this.itemWidth - this.paddingRight && y >= this.paddingTop && y <= this.itemHeight - this.paddingBottom;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        this.setContentWidth(this.itemWidth - this.paddingLeft - this.paddingRight);
        this.setContentHeight(this.itemHeight - this.paddingTop - this.paddingBottom);
        this.context.signalSizeChange(this.contentWidth, this.contentHeight);
        if (!this.context.isDrawingTransparent()) {
            g.drawImage(this.context.getBuffer(), x, y, 20);
        } else {
            this.context.getTransparentRgbImage().paint(x, y, g);
        }
    }

    public void destroy() {
        this.context.signalDestroy();
        super.destroy();
    }

    protected void defocus(Style style) {
        this.removeCommand(this.cmd);
        this.cmd = null;
        this.context.lostFocus();
        super.defocus(style);
    }

    protected Style focus(Style style, int direction) {
        if (this.softkeyCommandText != null) {
            this.cmd = new Command(this.softkeyCommandText, 8, 0);
            this.addCommand(this.cmd);
        }
        this.context.focus();
        return super.focus(style, direction);
    }

    protected boolean handleCommand(Command cmd) {
        this.context.signalSoftkeyPressed(cmd.getLabel());
        return this.context.areSoftkeysCaptured() || super.handleCommand(cmd);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.setContentWidth(availWidth);
        this.setContentHeight(availHeight);
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.context.signalKeyPressed(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        this.context.signalKeyReleased(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        this.context.signalKeyPressed(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handlePointerPressed(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        this.context.signalPointerPressed(x -= this.paddingLeft, y -= this.paddingTop);
        return this.context.arePointerEventsCaptured();
    }

    protected boolean handlePointerReleased(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerReleased(x -= this.paddingLeft, y -= this.paddingTop);
        return this.context.arePointerEventsCaptured();
    }

    protected boolean handlePointerDragged(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerDragged(x -= this.paddingLeft, y -= this.paddingTop);
        return this.context.arePointerEventsCaptured();
    }

    public boolean handlePointerTouchDown(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerPressed(x -= this.paddingLeft, y -= this.paddingTop);
        return this.context.arePointerEventsCaptured();
    }

    public boolean handlePointerTouchUp(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerReleased(x -= this.paddingLeft, y -= this.paddingTop);
        return this.context.arePointerEventsCaptured();
    }

    protected String createCssSelector() {
        return "processing";
    }

    public void processingRequestRepaint() {
        this.repaint(0, 0, this.itemWidth, this.itemHeight);
    }

    public void setSoftkey(String text) {
        this.softkeyCommandText = text;
        if (this.softkeyCommandText != null) {
            this.removeCommand(this.cmd);
            this.cmd = new Command(this.softkeyCommandText, 8, 0);
            this.addCommand(this.cmd);
        } else {
            this.removeCommand(this.cmd);
        }
    }
}

