/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.PFont;
import de.enough.polish.processing.PImage;
import de.enough.polish.processing.ProcessingContextContainerInterface;
import de.enough.polish.processing.ProcessingEvent;
import de.enough.polish.processing.ProcessingInterface;
import de.enough.polish.processing.ProcessingTextInputForm;
import de.enough.polish.processing.ProcessingThread;
import de.enough.polish.processing.color;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.MathUtil;
import de.enough.polish.util.RgbImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ProcessingContext
implements ProcessingInterface {
    public ProcessingContextContainerInterface _parent = null;
    public Image _buffer;
    public Graphics _bufferg;
    public int _timeBetweenFrames = 20;
    public boolean _haltExecution = false;
    public boolean _loop = true;
    public boolean _refreshFlag = false;
    public int _prevWidth = -1;
    public int _prevHeight = -1;
    public int _shapeMode = 8;
    public int _rectMode = 0;
    public int _ellipseMode = 0;
    public int _imageMode = 0;
    public int[] _vertex;
    public int _vertexIndex;
    public int[] _curveVertex;
    public int _curveVertexIndex;
    public int[] _stack;
    public int _stackIndex;
    public boolean _hasStroke = true;
    public boolean _hasFill = true;
    public int _strokeWidth = 1;
    public int _strokeColor = 0;
    public int _fillColor = 0;
    public int _bgColor = 0;
    public PImage _bgImage = null;
    public boolean _bgImageMode = false;
    public volatile boolean _repaintBackground = false;
    public boolean _transparentDrawing = false;
    public boolean _fastDrawingEnabled = true;
    public int _transparentColor = 0xFFFFFF;
    public int _colorMode = 1;
    public int _colorRange1 = 255;
    public int _colorRange2 = 255;
    public int _colorRange3 = 255;
    public long _lastTransparentRgbImageTime = 0L;
    transient RgbImage _transparentImage = null;
    public static final String SOFTKEY1_NAME = "SOFT1";
    public static final String SOFTKEY2_NAME = "SOFT2";
    public static final String SEND_NAME = "SEND";
    public static final int MULTITAP_KEY_SPACE = 0;
    public static final int MULTITAP_KEY_UPPER = 1;
    public static final String MULTITAP_PUNCTUATION = ".,?!'\"-_:;/()@&#$%*+<=>^";
    public boolean _multitap;
    public char[] _multitapKeySettings;
    public int _multitapLastEdit;
    public int _multitapEditDuration;
    public boolean _multitapIsUpperCase;
    public String _multitapPunctuation;
    public boolean _pointerPressed = false;
    public boolean _areKeypressesCaptured = false;
    public boolean _arePointerEventsCaptured = false;
    public boolean _areSoftkeysCaptured = false;
    public Calendar _calendar = null;
    public Runtime _runtime;
    public long _startTime = -1L;
    public long _lastFrameTime = -1L;
    public long _lastDrawTime = 0L;
    public String _softkeyLabel = null;
    public PFont _defaultFont = new PFont(Font.getDefaultFont());
    public int _textAlignMode = 2;
    public Random _random = null;
    int[] __arrX = new int[4];
    int[] __arrY = new int[4];
    public boolean _hasBeenInitialized = false;
    public static final Canvas canvas = new Canvas(){

        public void paint(Graphics graphics) {
        }
    };
    public int width = 0;
    public int height = 0;
    public char key = '\u0000';
    public int keyCode = 0;
    public int rawKeyCode = 0;
    public boolean keyPressed = false;
    public char[] multitapBuffer = null;
    public String multitapText = "";
    public int multitapBufferIndex = 0;
    public int multitapBufferLength = 0;
    public int pointerX = 0;
    public int pointerY = 0;
    public static final int FP_PRECISION = 8;
    public static final int ONE = 256;
    public static final int PI = 804;
    public static final int TWO_PI = 1608;
    public static final int HALF_PI = 402;
    public static final double PI_D = Math.PI;
    public static final double TWO_PI_D = Math.PI * 2;
    public static final double HALF_PI_D = 1.5707963267948966;
    public static final int[] sin = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 128, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 128, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -128, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};

    public ProcessingContext() {
        this._initVars(-1, -1);
    }

    public ProcessingContext(int width, int height) {
        this._initVars(width, height);
    }

    public void triggerRepaint() {
        if (this._parent != null) {
            this._parent.processingRequestRepaint();
        }
    }

    public boolean checkForRefresh() {
        if (this._haltExecution) {
            return false;
        }
        if (!this._loop) {
            boolean refreshValue = this._refreshFlag;
            this._refreshFlag = false;
            return refreshValue;
        }
        long now = System.currentTimeMillis();
        return now - this._lastFrameTime > (long)this._timeBetweenFrames;
    }

    public void setParent(ProcessingContextContainerInterface parent) {
        this._parent = parent;
    }

    public void executeRefresh(boolean alsoUpdateLastFrameTime) {
        if (alsoUpdateLastFrameTime) {
            this._refresh();
        } else {
            long goodFrameTime = this._lastFrameTime;
            this._refresh();
            this._lastFrameTime = goodFrameTime;
        }
    }

    public void _refresh() {
        if (this._haltExecution) {
            return;
        }
        if (!this._hasBeenInitialized) {
            this._startTime = System.currentTimeMillis();
            try {
                Thread.sleep(5L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.redraw();
            return;
        }
        if (this._bufferg != null) {
            if (this._repaintBackground) {
                if (!this._bgImageMode) {
                    int lastColor = this._bufferg.getColor();
                    this._bufferg.setColor(this._bgColor);
                    this._bufferg.fillRect(0, 0, this.width, this.height);
                    this._bufferg.setColor(lastColor);
                } else {
                    this._bufferg.drawImage(this._bgImage.getImage(), this.width - this._bgImage.getWidth() / 2, this.height - this._bgImage.getHeight() / 2, 20);
                }
            }
            this.resetMatrix();
            this.draw();
            this._lastFrameTime = System.currentTimeMillis();
            this._refreshFlag = true;
        }
    }

    public boolean isLooping() {
        return this._loop;
    }

    public long getLastFrameTime() {
        return this._lastFrameTime;
    }

    public long getIntervalBetweenFrames() {
        if (!this._loop) {
            return Long.MAX_VALUE;
        }
        return this._timeBetweenFrames;
    }

    public Image getBuffer() {
        return this._buffer;
    }

    public void _resetImageSize(int width, int height) {
        this._buffer = Image.createImage(width, height);
        this._bufferg = this._buffer.getGraphics();
        this._bufferg.setColor(0xFFFFFF);
        this._bufferg.fillRect(0, 0, width, height);
        this.width = width;
        this.height = height;
        ProcessingThread.queueEvent(new ProcessingEvent(this, 1));
    }

    public void signalSizeChange(int width, int height) {
        if (width != this._prevWidth || height != this._prevHeight) {
            this._prevWidth = width;
            this._prevHeight = height;
            this._resetImageSize(width, height);
        }
    }

    public void executeInitializationSequence() {
        this.setup();
        this._hasBeenInitialized = true;
    }

    public void repaintBackground() {
        this._repaintBackground = true;
    }

    public void dontRepaintBackground() {
        this._repaintBackground = false;
    }

    public void transparentDrawing() {
        this._transparentDrawing = true;
    }

    public void opaqueDrawing() {
        this._transparentDrawing = false;
    }

    public void setTransparentColor(color color2) {
        this._transparentColor = color2.color;
    }

    public void setTransparentColor(int value1, int value2, int value3) {
        this._transparentColor = this.color((int)value1, (int)value2, (int)value3, (int)255).color;
    }

    public void setTransparentColor(int gray) {
        this._transparentColor = this.color((int)gray).color;
    }

    public int getTransparentColor() {
        return this._transparentColor;
    }

    public boolean isDrawingTransparent() {
        return this._transparentDrawing;
    }

    public RgbImage getTransparentRgbImage() {
        if (this._transparentImage == null) {
            this._transparentImage = new RgbImage(new int[this.getBuffer().getWidth() * this.getBuffer().getHeight()], this.getBuffer().getWidth());
        }
        if (this._lastTransparentRgbImageTime != this.getLastFrameTime()) {
            this._lastTransparentRgbImageTime = this.getLastFrameTime();
            if (this._transparentImage.getWidth() != this.getBuffer().getWidth() || this._transparentImage.getHeight() != this.getBuffer().getHeight()) {
                this._transparentImage = new RgbImage(this.getBuffer(), true);
            } else {
                this.getBuffer().getRGB(this._transparentImage.getRgbData(), 0, this._transparentImage.getWidth(), 0, 0, this._transparentImage.getWidth(), this._transparentImage.getHeight());
            }
            int maskColor = this.getTransparentColor() << 8;
            int[] data = this._transparentImage.getRgbData();
            for (int dataLength = data.length - 1; dataLength >= 0; --dataLength) {
                if (data[dataLength] << 8 != maskColor) continue;
                data[dataLength] = 0;
            }
        }
        return this._transparentImage;
    }

    public void signalPointerDragged(int x, int y) {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 5, x, y));
    }

    public void signalPointerReleased(int x, int y) {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 6, x, y));
    }

    public void signalPointerPressed(int x, int y) {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 4, x, y));
    }

    public void setPointerCoordinates(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
    }

    public void setRawKeyCode(int keyCode) {
        this._key(keyCode);
    }

    public void setKeyAndKeyCode(char key, int keyCode) {
        this.key = key;
        this.keyCode = keyCode;
    }

    public void signalKeyPressed(int keyCode) {
        this.keyPressed = true;
        if (this._multitap) {
            this._multitapKeyPressed(keyCode);
        }
        this._key(keyCode);
        ProcessingThread.queueEvent(new ProcessingEvent(this, 7, this.key, this.keyCode));
    }

    public void signalKeyReleased(int keyCode) {
        this.keyPressed = false;
        this._key(keyCode);
        ProcessingThread.queueEvent(new ProcessingEvent(this, 8, this.key, this.keyCode));
    }

    public void signalSoftkeyPressed(String label) {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 9, label));
    }

    public void signalApplicationSuspend() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 10));
    }

    public void signalApplicationResume() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 11));
    }

    public void signalDestroy() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 12));
    }

    public void signalInitialization() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 13));
    }

    public void signalHasFocus() {
        if (!this._hasBeenInitialized) {
            // empty if block
        }
        ProcessingThread.queueEvent(new ProcessingEvent(this, 2));
    }

    public void signalLostFocus() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 3));
    }

    public String getSoftkeyLabel() {
        return this._softkeyLabel;
    }

    public void captureKeyPresses() {
        this._areKeypressesCaptured = true;
    }

    public void releaseKeyPresses() {
        this._areKeypressesCaptured = false;
    }

    public boolean areKeypressesCaptured() {
        return this._areKeypressesCaptured;
    }

    public void captureSoftkeys() {
        this._areSoftkeysCaptured = true;
    }

    public void releaseSoftkeys() {
        this._areSoftkeysCaptured = false;
    }

    public boolean areSoftkeysCaptured() {
        return this._areSoftkeysCaptured;
    }

    public void enableFastDrawing() {
        this._fastDrawingEnabled = true;
    }

    public void disableFastDrawing() {
        this._fastDrawingEnabled = false;
    }

    public void capturePointerEvents() {
        this._arePointerEventsCaptured = true;
    }

    public void releasePointerEvents() {
        this._arePointerEventsCaptured = false;
    }

    public boolean arePointerEventsCaptured() {
        return this._arePointerEventsCaptured;
    }

    public void _initVars(int width, int height) {
        this.background(200);
        this._runtime = Runtime.getRuntime();
        this._hasFill = true;
        this._fillColor = 0xFFFFFF;
        this._rectMode = 2;
        this._ellipseMode = 0;
        this._imageMode = 2;
        this._prevHeight = -1;
        this._prevWidth = -1;
        this._shapeMode = -1;
        this._vertex = new int[16];
        this._vertexIndex = 0;
        this._curveVertex = new int[8];
        this._curveVertexIndex = 0;
        this.multitapBuffer = new char[64];
        this.multitapText = "";
        this._multitapKeySettings = new char[]{'#', '*'};
        this._multitapPunctuation = MULTITAP_PUNCTUATION;
        this._multitapEditDuration = 1000;
        this._lastFrameTime = -1L;
        this._stack = new int[6];
        this._stackIndex = 0;
    }

    public double _Hue_2_RGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public void _polygon(int startIndex, int endIndex) {
        if (endIndex >= startIndex + 2) {
            if (endIndex >= startIndex + 4 && this._hasFill) {
                this._bufferg.setColor(this._fillColor);
                int size = 1 + (endIndex - startIndex) / 2;
                int pos = 0;
                int[] arrX = new int[size];
                int[] arrY = new int[size];
                for (int ctr = startIndex; ctr <= endIndex; ctr += 2) {
                    arrX[pos] = this._vertex[ctr];
                    arrY[pos] = this._vertex[ctr + 1];
                    ++pos;
                }
                DrawUtil.fillPolygon(arrX, arrY, this._fillColor, this._bufferg);
            }
            if (this._hasStroke) {
                this._bufferg.setColor(this._strokeColor);
                for (int i = startIndex + 2; i <= endIndex; i += 2) {
                    this.line(this._vertex[i - 2], this._vertex[i - 1], this._vertex[i], this._vertex[i + 1]);
                }
                this.line(this._vertex[endIndex], this._vertex[endIndex + 1], this._vertex[startIndex], this._vertex[startIndex + 1]);
            }
        }
    }

    public void _plotCurveVertices(int x0, int y0, int x1, int y1, int dx0, int dx1, int dy0, int dy1) {
        this.vertex(x0 >> 8, y0 >> 8);
        for (int t = 0; t < 256; t += 26) {
            int t2 = t * t >> 8;
            int t3 = t * t2 >> 8;
            int h0 = (512 * t3 >> 8) - (768 * t2 >> 8) + 256;
            int h1 = (-512 * t3 >> 8) + (768 * t2 >> 8);
            int h2 = t3 - (512 * t2 >> 8) + t;
            int h3 = t3 - t2;
            int x = (h0 * x0 >> 8) + (h1 * x1 >> 8) + (h2 * dx0 >> 8) + (h3 * dx1 >> 8);
            int y = (h0 * y0 >> 8) + (h1 * y1 >> 8) + (h2 * dy0 >> 8) + (h3 * dy1 >> 8);
            this.vertex(x >> 8, y >> 8);
        }
        this.vertex(x1 >> 8, y1 >> 8);
    }

    public void _clip(int x, int y, int width, int height) {
        int x2 = x + width;
        int y2 = y + height;
        int clipX = this._bufferg.getClipX();
        int clipY = this._bufferg.getClipY();
        int clipX2 = clipX + this._bufferg.getClipWidth();
        int clipY2 = clipY + this._bufferg.getClipHeight();
        if (x < clipX2 && x2 > clipX && y < clipY2 && y2 > clipY) {
            int intersectX = Math.max(x, clipX);
            int intersectY = Math.max(y, clipY);
            int intersectWidth = Math.min(x2, clipX2) - intersectX;
            int intersectHeight = Math.min(y2, clipY2) - intersectY;
            this._bufferg.setClip(intersectX, intersectY, intersectWidth, intersectHeight);
        }
    }

    public void _key(int keyCode) {
        this.rawKeyCode = keyCode;
        if (keyCode >= 48 && keyCode <= 57) {
            this.key = (char)(48 + (keyCode - 48));
            this.keyCode = this.key;
        } else {
            switch (keyCode) {
                case 35: {
                    this.key = (char)35;
                    this.keyCode = this.key;
                    break;
                }
                case 42: {
                    this.key = (char)42;
                    this.keyCode = this.key;
                    break;
                }
                default: {
                    String name = canvas.getKeyName(keyCode);
                    if (name.equals(SOFTKEY1_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -6;
                        break;
                    }
                    if (name.equals(SOFTKEY2_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -7;
                        break;
                    }
                    if (name.equals(SEND_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -10;
                        break;
                    }
                    this.key = (char)65535;
                    this.keyCode = canvas.getGameAction(keyCode);
                    if (this.keyCode != 0) break;
                    this.keyCode = keyCode;
                }
            }
        }
    }

    public final void _multitapKeyPressed(int keyCode) {
        boolean editing = keyCode == this.keyCode && this.millis() - this._multitapLastEdit <= this._multitapEditDuration;
        char newChar = '\u0000';
        if (editing && Character.isUpperCase(newChar = this.multitapBuffer[this.multitapBufferIndex - 1])) {
            newChar = Character.toLowerCase(newChar);
        }
        char startChar = '\u0000';
        char endChar = '\u0000';
        char otherChar = '\u0000';
        block0 : switch (keyCode) {
            case -8: {
                this.multitapDeleteChar();
                break;
            }
            case 42: {
                if (this._multitapKeySettings[0] == '*') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '*';
                    break;
                }
                if (this._multitapKeySettings[1] == '*') {
                    editing = (newChar = this._multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '*';
                endChar = '*';
                otherChar = '*';
                editing = false;
                break;
            }
            case 35: {
                if (this._multitapKeySettings[0] == '#') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '#';
                    break;
                }
                if (this._multitapKeySettings[1] == '#') {
                    editing = (newChar = this._multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '#';
                endChar = '#';
                otherChar = '#';
                editing = false;
                break;
            }
            case 48: {
                if (this._multitapKeySettings[0] == '0') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '0';
                    break;
                }
                if (this._multitapKeySettings[1] == '0') {
                    editing = (newChar = this._multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '0';
                endChar = '0';
                otherChar = '0';
                editing = false;
                break;
            }
            case 49: {
                int index = 0;
                if (editing && (index = this._multitapPunctuation.indexOf(newChar) + 1) == this._multitapPunctuation.length()) {
                    index = 0;
                }
                newChar = this._multitapPunctuation.charAt(index);
                break;
            }
            case 50: {
                startChar = 'a';
                endChar = 'c';
                otherChar = '2';
                break;
            }
            case 51: {
                startChar = 'd';
                endChar = 'f';
                otherChar = '3';
                break;
            }
            case 52: {
                startChar = 'g';
                endChar = 'i';
                otherChar = '4';
                break;
            }
            case 53: {
                startChar = 'j';
                endChar = 'l';
                otherChar = '5';
                break;
            }
            case 54: {
                startChar = 'm';
                endChar = 'o';
                otherChar = '6';
                break;
            }
            case 55: {
                startChar = 'p';
                endChar = 's';
                otherChar = '7';
                break;
            }
            case 56: {
                startChar = 't';
                endChar = 'v';
                otherChar = '8';
                break;
            }
            case 57: {
                startChar = 'w';
                endChar = 'z';
                otherChar = '9';
                break;
            }
            default: {
                int action = canvas.getGameAction(keyCode);
                switch (action) {
                    case 2: {
                        this._multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.max(0, this.multitapBufferIndex - 1);
                        break block0;
                    }
                    case 5: {
                        this._multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.min(this.multitapBufferLength, this.multitapBufferIndex + 1);
                    }
                }
            }
        }
        if (startChar > '\u0000') {
            newChar = editing ? (char)((char)(newChar + 1)) : startChar;
            if (newChar == otherChar + 1) {
                newChar = startChar;
            } else if (newChar > endChar) {
                newChar = otherChar;
            }
        }
        if (newChar > '\u0000') {
            if (this._multitapIsUpperCase) {
                newChar = Character.toUpperCase(newChar);
            }
            if (editing) {
                if (this.multitapBuffer[this.multitapBufferIndex - 1] != newChar) {
                    this.multitapBuffer[this.multitapBufferIndex - 1] = newChar;
                    this._multitapLastEdit = this.millis();
                }
            } else {
                ++this.multitapBufferLength;
                if (this.multitapBufferLength == this.multitapBuffer.length) {
                    char[] oldBuffer = this.multitapBuffer;
                    this.multitapBuffer = new char[oldBuffer.length * 2];
                    System.arraycopy(oldBuffer, 0, this.multitapBuffer, 0, this.multitapBufferIndex);
                    System.arraycopy(oldBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                } else {
                    System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                }
                this.multitapBuffer[this.multitapBufferIndex] = newChar;
                ++this.multitapBufferIndex;
                this._multitapLastEdit = this.millis();
            }
            this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
        }
    }

    public void _checkCalendar() {
        if (this._calendar == null) {
            this._calendar = Calendar.getInstance();
        }
        this._calendar.setTime(new Date());
    }

    public void redraw() {
        ProcessingThread.queueEvent(new ProcessingEvent(this, 0));
    }

    public void loop() {
        this._loop = true;
    }

    public void noLoop() {
        this._loop = false;
    }

    public void destroy() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void setup() {
    }

    public void exit() {
        this.signalDestroy();
        this._haltExecution = true;
    }

    public void colorMode(int mode) {
        this._colorMode = mode;
    }

    public void colorMode(int mode, int range) {
        this._colorMode = mode;
        this._colorRange2 = this._colorRange3 = range;
        this._colorRange1 = this._colorRange3;
    }

    public void colorMode(int mode, int range1, int range2, int range3) {
        this._colorMode = mode;
        this._colorRange1 = range1;
        this._colorRange2 = range2;
        this._colorRange3 = range3;
    }

    public color color(int gray) {
        int col = 0xFF000000 | gray << 16 | gray << 8 | gray;
        return new color(col);
    }

    public color color(int gray, int alpha) {
        int col = alpha << 24 | gray << 16 | gray << 8 | gray;
        return new color(col);
    }

    public color color(int value1, int value2, int value3, int alpha) {
        if (this._colorMode == 1) {
            value1 = value1 * 255 / this._colorRange1;
            value2 = value2 * 255 / this._colorRange2;
            value3 = value3 * 255 / this._colorRange3;
            int col = alpha << 24 | value1 << 16 | value2 << 8 | value3;
            return new color(col);
        }
        if (this._colorMode == 2) {
            double B;
            double G;
            double R;
            double H = (double)value1 / (double)this._colorRange1;
            double S = (double)value2 / (double)this._colorRange2;
            double L = (double)value3 / (double)this._colorRange3;
            if (S == 0.0) {
                R = L * 255.0;
                G = L * 255.0;
                B = L * 255.0;
            } else {
                double temp2 = L < 0.5 ? L * (1.0 + S) : L + S - S * L;
                double temp1 = 2.0 * L - temp2;
                R = 255.0 * this._Hue_2_RGB(temp1, temp2, H + 0.3333333333333333);
                G = 255.0 * this._Hue_2_RGB(temp1, temp2, H);
                B = 255.0 * this._Hue_2_RGB(temp1, temp2, H - 0.3333333333333333);
            }
            int Ri = (int)R;
            int Gi = (int)G;
            int Bi = (int)B;
            int col = alpha << 24 | Ri << 16 | Gi << 8 | Bi;
            return new color(col);
        }
        return new color(0xFFFFFF);
    }

    public void background(int gray) {
        this._bgImageMode = false;
        color x = this.color(gray);
        this._bgColor = x.color;
        this._repaintBackground = true;
    }

    public void background(color color2) {
        this._bgImageMode = false;
        this._bgColor = color2.color;
        this._repaintBackground = true;
    }

    public void background(int value1, int value2, int value3) {
        this._bgImageMode = false;
        color x = this.color(value1, value2, value3, 255);
        this._bgColor = x.color;
        this._repaintBackground = true;
    }

    public void background(PImage image) {
        this._bgImageMode = true;
        this._bgImage = image;
        this._repaintBackground = true;
    }

    public void strokeWeight(int width) {
        this._strokeWidth = width;
    }

    public void stroke(color whatColor) {
        this._hasStroke = true;
        this._strokeColor = whatColor.color;
    }

    public void stroke(int color2) {
        color temp = this.color(color2);
        this._strokeColor = temp.color;
        this._hasStroke = true;
    }

    public void stroke(int v1, int v2, int v3) {
        color temp = this.color(v1, v2, v3, 255);
        this._strokeColor = temp.color;
        this._hasStroke = true;
    }

    public void noStroke() {
        this._hasStroke = false;
    }

    public void fill(int gray) {
        this._hasFill = true;
        color x = this.color(gray);
        this._fillColor = x.color;
    }

    public void fill(color color2) {
        this._hasFill = true;
        this._fillColor = color2.color;
    }

    public void fill(int value1, int value2, int value3) {
        this._hasFill = true;
        color x = this.color(value1, value2, value3, 255);
        this._fillColor = x.color;
    }

    public void noFill() {
        this._hasFill = false;
    }

    public void framerate(int framerate) {
        this._timeBetweenFrames = 1000 / framerate;
    }

    public void draw() {
    }

    public void line(int x1, int y1, int x2, int y2) {
        if (!this._hasStroke) {
            return;
        }
        this._bufferg.setColor(this._strokeColor);
        if (this._strokeWidth == 1) {
            this._bufferg.drawLine(x1, y1, x2, y2);
            return;
        }
        if (this._fastDrawingEnabled) {
            int strokeWidthDiv2 = this._strokeWidth / 2;
            double pointDistance = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            int startWidth = this._strokeWidth / 2;
            int remainingWidth = this._strokeWidth - startWidth;
            double lineCos = (double)(-(x1 - x2)) / pointDistance;
            double lineSin = (double)(-(y1 - y2)) / pointDistance;
            double cosPerpendicularLine = -lineSin;
            double sinPerpendicularLine = lineCos;
            this.__arrX[0] = (int)((double)x1 + cosPerpendicularLine * (double)startWidth);
            this.__arrX[1] = (int)((double)x1 - cosPerpendicularLine * (double)remainingWidth);
            this.__arrX[2] = (int)((double)x2 - cosPerpendicularLine * (double)remainingWidth);
            this.__arrX[3] = (int)((double)x2 + cosPerpendicularLine * (double)startWidth);
            this.__arrY[0] = (int)((double)y1 + sinPerpendicularLine * (double)startWidth);
            this.__arrY[1] = (int)((double)y1 - sinPerpendicularLine * (double)remainingWidth);
            this.__arrY[2] = (int)((double)y2 - sinPerpendicularLine * (double)remainingWidth);
            this.__arrY[3] = (int)((double)y2 + sinPerpendicularLine * (double)startWidth);
            DrawUtil.fillPolygon(this.__arrX, this.__arrY, this._strokeColor, this._bufferg);
            this._bufferg.fillArc(x1 - strokeWidthDiv2, y1 - strokeWidthDiv2, this._strokeWidth, this._strokeWidth, 0, 360);
            this._bufferg.fillArc(x2 - strokeWidthDiv2, y2 - strokeWidthDiv2, this._strokeWidth, this._strokeWidth, 0, 360);
        } else {
            this._bufferg.setColor(this._strokeColor);
            this._bufferg.drawLine(x1, y1, x2, y2);
            if (this._strokeWidth > 1) {
                int swap;
                boolean steep;
                boolean bl = steep = Math.abs(y2 - y1) > Math.abs(x2 - x1);
                if (steep) {
                    swap = x1;
                    x1 = y1;
                    y1 = swap;
                    swap = x2;
                    x2 = y2;
                    y2 = swap;
                }
                if (x1 > x2) {
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
                int dx = x2 - x1;
                int dy = y2 > y1 ? y2 - y1 : y1 - y2;
                int error = 0;
                int halfWidth = this._strokeWidth >> 1;
                int y = y1 - halfWidth;
                int ystep = y1 < y2 ? 1 : -1;
                int endx = x2 - halfWidth;
                for (int x = x1 - halfWidth; x <= endx; ++x) {
                    if (steep) {
                        this._bufferg.fillArc(y, x, this._strokeWidth, this._strokeWidth, 0, 360);
                    } else {
                        this._bufferg.fillArc(x, y, this._strokeWidth, this._strokeWidth, 0, 360);
                    }
                    if (2 * (error += dy) < dx) continue;
                    y += ystep;
                    error -= dx;
                }
            }
        }
    }

    public void point(int x1, int y1) {
        if (this._hasStroke) {
            this._bufferg.setColor(this._strokeColor);
            this._bufferg.drawLine(x1, y1, x1, y1);
        }
    }

    public void triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        int prevShapeMode = this._shapeMode;
        this._shapeMode = 8;
        this._vertex[0] = x1;
        this._vertex[1] = y1;
        this._vertex[2] = x2;
        this._vertex[3] = y2;
        this._vertex[4] = x3;
        this._vertex[5] = y3;
        this._vertexIndex = 6;
        this.endShape();
        this._shapeMode = prevShapeMode;
    }

    public void quad(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int prevShapeMode = this._shapeMode;
        this._shapeMode = 8;
        this._vertex[0] = x1;
        this._vertex[1] = y1;
        this._vertex[2] = x2;
        this._vertex[3] = y2;
        this._vertex[4] = x3;
        this._vertex[5] = y3;
        this._vertex[6] = x4;
        this._vertex[7] = y4;
        this._vertexIndex = 8;
        this.endShape();
        this._shapeMode = prevShapeMode;
    }

    public void rect(int x, int y, int width, int height) {
        switch (this._rectMode) {
            case 3: {
                int temp = x;
                x = Math.min(x, width);
                width = Math.abs(x - temp);
                temp = y;
                y = Math.min(y, height);
                height = Math.abs(y - temp);
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height / 2;
            }
        }
        if (this._hasFill) {
            this._bufferg.setColor(this._fillColor);
            this._bufferg.fillRect(x, y, width, height);
        }
        if (this._hasStroke) {
            this._bufferg.setColor(this._strokeColor);
            this._bufferg.drawRect(x, y, width, height);
        }
    }

    public void rectMode(int mode) {
        if (mode >= 0 && mode <= 2) {
            this._rectMode = mode;
        }
    }

    public void ellipse(int x, int y, int width, int height) {
        switch (this._ellipseMode) {
            case 3: {
                int temp = x;
                x = Math.min(x, width);
                width = Math.abs(x - temp);
                temp = y;
                y = Math.min(y, height);
                height = Math.abs(y - temp);
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 1: {
                x -= width;
                y -= height;
                width *= 2;
                height *= 2;
            }
        }
        if (this._hasFill) {
            this._bufferg.setColor(this._fillColor);
            this._bufferg.fillArc(x, y, width, height, 0, 360);
        }
        if (this._hasStroke) {
            this._bufferg.setColor(this._strokeColor);
            this._bufferg.drawArc(x, y, width, height, 0, 360);
        }
    }

    public void ellipseMode(int mode) {
        if (mode >= 0 && mode <= 3) {
            this._ellipseMode = mode;
        }
    }

    public void curve(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int prevShapeMode = this._shapeMode;
        this.beginShape(2);
        this.curveVertex(x1, y1);
        this.curveVertex(x1, y1);
        this.curveVertex(x2, y2);
        this.curveVertex(x3, y3);
        this.curveVertex(x4, y4);
        this.curveVertex(x4, y4);
        this.endShape();
        this._shapeMode = prevShapeMode;
    }

    public void bezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int prevShapeMode = this._shapeMode;
        this.beginShape(2);
        this.vertex(x1, y1);
        this.bezierVertex(x2, y2, x3, y3, x4, y4);
        this.endShape();
        this._shapeMode = prevShapeMode;
    }

    public void curveVertex(int x, int y) {
        this._curveVertex[this._curveVertexIndex] = x << 8;
        ++this._curveVertexIndex;
        this._curveVertex[this._curveVertexIndex] = y << 8;
        ++this._curveVertexIndex;
        if (this._curveVertexIndex == 8) {
            int tension = 128;
            int dx0 = (this._curveVertex[4] - this._curveVertex[0]) * tension >> 8;
            int dx1 = (this._curveVertex[6] - this._curveVertex[2]) * tension >> 8;
            int dy0 = (this._curveVertex[5] - this._curveVertex[1]) * tension >> 8;
            int dy1 = (this._curveVertex[7] - this._curveVertex[3]) * tension >> 8;
            this._plotCurveVertices(this._curveVertex[2], this._curveVertex[3], this._curveVertex[4], this._curveVertex[5], dx0, dx1, dy0, dy1);
            for (int i = 0; i < 6; ++i) {
                this._curveVertex[i] = this._curveVertex[i + 2];
            }
            this._curveVertexIndex = 6;
        }
    }

    public void bezierVertex(int x1, int y1, int x2, int y2, int x3, int y3) {
        this._vertexIndex -= 2;
        int x0 = this._vertex[this._vertexIndex] << 8;
        int y0 = this._vertex[this._vertexIndex + 1] << 8;
        int tension = 768;
        int dx0 = ((x1 <<= 8) - x0) * tension >> 8;
        int dx1 = ((x3 <<= 8) - (x2 <<= 8)) * tension >> 8;
        int dy0 = ((y1 <<= 8) - y0) * tension >> 8;
        int dy1 = ((y3 <<= 8) - (y2 <<= 8)) * tension >> 8;
        this._plotCurveVertices(x0, y0, x3, y3, dx0, dx1, dy0, dy1);
    }

    public void vertex(int x, int y) {
        this._vertex[this._vertexIndex] = x;
        ++this._vertexIndex;
        this._vertex[this._vertexIndex] = y;
        ++this._vertexIndex;
        int length = this._vertex.length;
        if (this._vertexIndex == length) {
            int[] old = this._vertex;
            this._vertex = new int[length * 2];
            System.arraycopy(old, 0, this._vertex, 0, length);
        }
    }

    public void beginShape(int mode) {
        this._shapeMode = mode >= 0 && mode <= 8 ? mode : 0;
        this._vertexIndex = 0;
        this._curveVertexIndex = 0;
    }

    public void endShape() {
        int step;
        int i;
        switch (this._shapeMode) {
            case 0: {
                i = 0;
                step = 2;
                break;
            }
            case 1: {
                i = 2;
                step = 4;
                break;
            }
            case 2: 
            case 3: {
                i = 2;
                step = 2;
                break;
            }
            case 4: {
                i = 4;
                step = 6;
                break;
            }
            case 5: {
                i = 4;
                step = 2;
                break;
            }
            case 6: {
                i = 6;
                step = 8;
                break;
            }
            case 7: {
                i = 6;
                step = 4;
                break;
            }
            case 8: {
                this._polygon(0, this._vertexIndex - 2);
                return;
            }
            default: {
                return;
            }
        }
        while (i < this._vertexIndex) {
            switch (this._shapeMode) {
                case 0: {
                    this.point(this._vertex[i], this._vertex[i + 1]);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.line(this._vertex[i - 2], this._vertex[i - 1], this._vertex[i], this._vertex[i + 1]);
                    break;
                }
                case 4: 
                case 5: {
                    this._polygon(i - 4, i);
                    break;
                }
                case 6: 
                case 7: {
                    this._polygon(i - 6, i);
                }
            }
            i += step;
        }
        if (this._shapeMode == 3 && this._vertexIndex >= 2) {
            this.line(this._vertex[this._vertexIndex - 2], this._vertex[this._vertexIndex - 1], this._vertex[0], this._vertex[1]);
        }
        this._vertexIndex = 0;
    }

    public PImage loadImage(String filename) {
        try {
            Image img = Image.createImage("/" + filename);
            return new PImage(img);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PImage loadImage(byte[] data) {
        return new PImage(data);
    }

    public void image(PImage img, int x, int y) {
        this._bufferg.drawImage(img.getImage(), x, y, 20);
    }

    public void image(PImage img, int sx, int sy, int swidth, int sheight, int dx, int dy) {
        if (this._imageMode == 3) {
            swidth -= sx;
            sheight -= sy;
        }
        this._clip(dx, dy, swidth, sheight);
        this._bufferg.drawImage(img.getImage(), dx - sx, dy - sy, 20);
        this._clip(0, 0, this.width, this.height);
    }

    public void imageMode(int mode) {
        this._imageMode = mode;
    }

    public final void multitap() {
        this._multitap = true;
    }

    public final void noMultitap() {
        this._multitap = false;
    }

    public final void multitapClear() {
        this.multitapBufferIndex = 0;
        this.multitapBufferLength = 0;
        this.multitapText = "";
    }

    public void softkeyPressed(String label) {
    }

    public void softkey(String label) {
        this._softkeyLabel = label;
        if (this._parent != null) {
            this._parent.setSoftkey(label);
        }
    }

    public final void multitapDeleteChar() {
        if (this.multitapBufferIndex > 0) {
            System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex - 1, this.multitapBufferLength - this.multitapBufferIndex);
            --this.multitapBufferLength;
            --this.multitapBufferIndex;
            this._multitapLastEdit = 0;
        }
        this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
    }

    public char _multitapUpperKeyPressed(boolean editing, char newChar) {
        boolean bl = this._multitapIsUpperCase = !this._multitapIsUpperCase;
        if (editing) {
            if (newChar == this._multitapKeySettings[1]) {
                this.multitapDeleteChar();
                this._multitapLastEdit = this.millis();
                newChar = '\u0000';
            } else {
                newChar = this._multitapKeySettings[1];
            }
        } else {
            this._multitapLastEdit = this.millis();
        }
        return newChar;
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void pointerDragged() {
    }

    public void pointerPressed() {
    }

    public void pointerReleased() {
    }

    public final int millis() {
        return (int)(System.currentTimeMillis() - this._startTime);
    }

    public final int second() {
        this._checkCalendar();
        return this._calendar.get(13);
    }

    public final int minute() {
        this._checkCalendar();
        return this._calendar.get(12);
    }

    public final int hour() {
        this._checkCalendar();
        return this._calendar.get(11);
    }

    public final int day() {
        this._checkCalendar();
        return this._calendar.get(5);
    }

    public final int month() {
        this._checkCalendar();
        return this._calendar.get(2);
    }

    public final int year() {
        this._checkCalendar();
        return this._calendar.get(1);
    }

    public final int currentMemory() {
        return (int)this._runtime.freeMemory();
    }

    public final int reportedMemory() {
        return (int)this._runtime.totalMemory();
    }

    public void focus() {
    }

    public void lostFocus() {
    }

    public String textInput() {
        return this.textInput("", "", Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String textInput(String title, String text, int max) {
        Displayable current = Display.getInstance().getCurrent();
        ProcessingTextInputForm form = new ProcessingTextInputForm(title, text, max);
        Thread t = new Thread(form);
        t.start();
        String result = null;
        Object object = form.getExternalLockObject();
        synchronized (object) {
            try {
                form.getExternalLockObject().wait();
            }
            catch (Exception ex) {
                // empty catch block
            }
            result = form.getText();
        }
        Display.getInstance().setCurrent(current);
        return result;
    }

    public void print(boolean data) {
        System.out.print(String.valueOf(data));
    }

    public void print(byte data) {
        System.out.print(String.valueOf(data));
    }

    public void print(char data) {
        System.out.print(String.valueOf(data));
    }

    public void print(int data) {
        System.out.print(String.valueOf(data));
    }

    public void print(Object data) {
        System.out.print(String.valueOf(data));
    }

    public void print(String data) {
        System.out.print(data);
    }

    public void println(boolean data) {
        System.out.println(String.valueOf(data));
    }

    public void println(byte data) {
        System.out.println(String.valueOf(data));
    }

    public void println(char data) {
        System.out.println(String.valueOf(data));
    }

    public void println(int data) {
        System.out.println(String.valueOf(data));
    }

    public void println(Object data) {
        System.out.println(String.valueOf(data));
    }

    public void println(String data) {
        System.out.println(data);
    }

    public int length(boolean[] array) {
        return array.length;
    }

    public int length(byte[] array) {
        return array.length;
    }

    public int length(char[] array) {
        return array.length;
    }

    public int length(int[] array) {
        return array.length;
    }

    public int length(Object[] array) {
        return array.length;
    }

    public String join(String[] anyArray, String separator) {
        StringBuffer buffer = new StringBuffer();
        int length = anyArray.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(anyArray[i]);
            if (i >= length - 1) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public String join(int[] anyArray, String separator) {
        StringBuffer buffer = new StringBuffer();
        int length = anyArray.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(anyArray[i]);
            if (i >= length - 1) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public String join(int[] intArray, String separator, int digits) {
        StringBuffer buffer = new StringBuffer();
        int length = intArray.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(this.nf(intArray[i], digits));
            if (i >= length - 1) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public String nf(int intValue, int digits) {
        StringBuffer buffer = new StringBuffer();
        for (int j = Integer.toString(intValue).length(); j < digits; ++j) {
            buffer.append("0");
        }
        buffer.append(intValue);
        return buffer.toString();
    }

    public String nfp(int intValue, int digits) {
        StringBuffer buffer = new StringBuffer();
        if (intValue < 0) {
            buffer.append("-");
        } else {
            buffer.append("+");
        }
        buffer.append(this.nf(intValue, digits));
        return buffer.toString();
    }

    public String[] split(String str, char delim) {
        return this.split(str, new String(new char[]{delim}));
    }

    public String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        int prevIndex = 0;
        int nextIndex = str.indexOf(delim, prevIndex);
        int delimLength = delim.length();
        while (nextIndex >= 0) {
            v.addElement(str.substring(prevIndex, nextIndex));
            prevIndex = nextIndex + delimLength;
            nextIndex = str.indexOf(delim, prevIndex);
        }
        if (prevIndex < str.length()) {
            v.addElement(str.substring(prevIndex));
        }
        Object[] tokens = new String[v.size()];
        v.copyInto(tokens);
        return tokens;
    }

    public String trim(String str) {
        return str.trim();
    }

    public String[] append(String[] array, String element) {
        String[] old = array;
        int length = old.length;
        array = new String[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public boolean[] append(boolean[] array, boolean element) {
        boolean[] old = array;
        int length = old.length;
        array = new boolean[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public byte[] append(byte[] array, byte element) {
        byte[] old = array;
        int length = old.length;
        array = new byte[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public char[] append(char[] array, char element) {
        char[] old = array;
        int length = old.length;
        array = new char[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public int[] append(int[] array, int element) {
        int[] old = array;
        int length = old.length;
        array = new int[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        String[] array = new String[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public boolean[] concat(boolean[] array1, boolean[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        boolean[] array = new boolean[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public byte[] concat(byte[] array1, byte[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        byte[] array = new byte[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public char[] concat(char[] array1, char[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        char[] array = new char[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public int[] concat(int[] array1, int[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        int[] array = new int[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public boolean[] contract(boolean[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            boolean[] old = array;
            array = new boolean[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public byte[] contract(byte[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            byte[] old = array;
            array = new byte[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public char[] contract(char[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            char[] old = array;
            array = new char[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public int[] contract(int[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            int[] old = array;
            array = new int[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public String[] contract(String[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            String[] old = array;
            array = new String[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public boolean[] expand(boolean[] array) {
        return this.expand(array, array.length * 2);
    }

    public boolean[] expand(boolean[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            boolean[] old = array;
            array = new boolean[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public byte[] expand(byte[] array) {
        return this.expand(array, array.length * 2);
    }

    public byte[] expand(byte[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            byte[] old = array;
            array = new byte[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public char[] expand(char[] array) {
        return this.expand(array, array.length * 2);
    }

    public char[] expand(char[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            char[] old = array;
            array = new char[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public int[] expand(int[] array) {
        return this.expand(array, array.length * 2);
    }

    public int[] expand(int[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            int[] old = array;
            array = new int[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public String[] expand(String[] array) {
        return this.expand(array, array.length * 2);
    }

    public String[] expand(String[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            String[] old = array;
            array = new String[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public boolean[] reverse(boolean[] array) {
        int length = array.length;
        boolean[] reversed = new boolean[length];
        for (int i = length - 1; i >= 0; --i) {
            reversed[i] = array[length - i - 1];
        }
        return reversed;
    }

    public byte[] reverse(byte[] array) {
        int length = array.length;
        byte[] reversed = new byte[length];
        for (int i = length - 1; i >= 0; --i) {
            reversed[i] = array[length - i - 1];
        }
        return reversed;
    }

    public char[] reverse(char[] array) {
        int length = array.length;
        char[] reversed = new char[length];
        for (int i = length - 1; i >= 0; --i) {
            reversed[i] = array[length - i - 1];
        }
        return reversed;
    }

    public int[] reverse(int[] array) {
        int length = array.length;
        int[] reversed = new int[length];
        for (int i = length - 1; i >= 0; --i) {
            reversed[i] = array[length - i - 1];
        }
        return reversed;
    }

    public String[] reverse(String[] array) {
        int length = array.length;
        String[] reversed = new String[length];
        for (int i = length - 1; i >= 0; --i) {
            reversed[i] = array[length - i - 1];
        }
        return reversed;
    }

    public boolean[] shorten(boolean[] array) {
        boolean[] old = array;
        int length = old.length - 1;
        array = new boolean[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public byte[] shorten(byte[] array) {
        byte[] old = array;
        int length = old.length - 1;
        array = new byte[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public char[] shorten(char[] array) {
        char[] old = array;
        int length = old.length - 1;
        array = new char[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public int[] shorten(int[] array) {
        int[] old = array;
        int length = old.length - 1;
        array = new int[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public String[] shorten(String[] array) {
        String[] old = array;
        int length = old.length - 1;
        array = new String[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public boolean[] subset(boolean[] array, int offset) {
        return this.subset(array, offset, array.length - offset);
    }

    public boolean[] subset(boolean[] array, int offset, int length) {
        boolean[] subset = new boolean[length];
        System.arraycopy(array, offset, subset, 0, length);
        return subset;
    }

    public byte[] subset(byte[] array, int offset) {
        return this.subset(array, offset, array.length - offset);
    }

    public byte[] subset(byte[] array, int offset, int length) {
        byte[] subset = new byte[length];
        System.arraycopy(array, offset, subset, 0, length);
        return subset;
    }

    public char[] subset(char[] array, int offset) {
        return this.subset(array, offset, array.length - offset);
    }

    public char[] subset(char[] array, int offset, int length) {
        char[] subset = new char[length];
        System.arraycopy(array, offset, subset, 0, length);
        return subset;
    }

    public int[] subset(int[] array, int offset) {
        return this.subset(array, offset, array.length - offset);
    }

    public int[] subset(int[] array, int offset, int length) {
        int[] subset = new int[length];
        System.arraycopy(array, offset, subset, 0, length);
        return subset;
    }

    public String[] subset(String[] array, int offset) {
        return this.subset(array, offset, array.length - offset);
    }

    public String[] subset(String[] array, int offset, int length) {
        String[] subset = new String[length];
        System.arraycopy(array, offset, subset, 0, length);
        return subset;
    }

    public boolean[] splice(boolean[] array, boolean value, int index) {
        int length = array.length;
        boolean[] splice = new boolean[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public boolean[] splice(boolean[] array, boolean[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        boolean[] splice = new boolean[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public byte[] splice(byte[] array, byte value, int index) {
        int length = array.length;
        byte[] splice = new byte[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public byte[] splice(byte[] array, byte[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        byte[] splice = new byte[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public char[] splice(char[] array, char value, int index) {
        int length = array.length;
        char[] splice = new char[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public char[] splice(char[] array, char[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        char[] splice = new char[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public int[] splice(int[] array, int value, int index) {
        int length = array.length;
        int[] splice = new int[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public int[] splice(int[] array, int[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        int[] splice = new int[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public String[] splice(String[] array, String value, int index) {
        int length = array.length;
        String[] splice = new String[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public String[] splice(String[] array, String[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        String[] splice = new String[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public String str(boolean val) {
        return String.valueOf(val);
    }

    public String str(byte val) {
        return String.valueOf(val);
    }

    public String str(char val) {
        return String.valueOf(val);
    }

    public String str(int val) {
        return String.valueOf(val);
    }

    public String[] str(boolean[] val) {
        String[] result = new String[val.length];
        for (int i = val.length - 1; i >= 0; --i) {
            result[i] = String.valueOf(val[i]);
        }
        return result;
    }

    public String[] str(byte[] val) {
        String[] result = new String[val.length];
        for (int i = val.length - 1; i >= 0; --i) {
            result[i] = String.valueOf(val[i]);
        }
        return result;
    }

    public String[] str(char[] val) {
        String[] result = new String[val.length];
        for (int i = val.length - 1; i >= 0; --i) {
            result[i] = String.valueOf(val[i]);
        }
        return result;
    }

    public String[] str(int[] val) {
        String[] result = new String[val.length];
        for (int i = val.length - 1; i >= 0; --i) {
            result[i] = String.valueOf(val[i]);
        }
        return result;
    }

    public void pushMatrix() {
        if (this._stackIndex == this._stack.length) {
            int[] old = this._stack;
            this._stack = new int[this._stackIndex * 2];
            System.arraycopy(old, 0, this._stack, 0, this._stackIndex);
        }
        this._stack[this._stackIndex++] = this._bufferg.getTranslateX();
        this._stack[this._stackIndex++] = this._bufferg.getTranslateY();
        this._stack[this._stackIndex++] = this._bufferg.getClipX();
        this._stack[this._stackIndex++] = this._bufferg.getClipY();
        this._stack[this._stackIndex++] = this._bufferg.getClipWidth();
        this._stack[this._stackIndex++] = this._bufferg.getClipHeight();
    }

    public void popMatrix() {
        if (this._stackIndex > 0) {
            this._stackIndex -= 6;
            int translateX = this._stack[this._stackIndex++];
            int translateY = this._stack[this._stackIndex++];
            this._bufferg.translate(translateX - this._bufferg.getTranslateX(), translateY - this._bufferg.getTranslateY());
            int clipX = this._stack[this._stackIndex++];
            int clipY = this._stack[this._stackIndex++];
            int clipWidth = this._stack[this._stackIndex++];
            int clipHeight = this._stack[this._stackIndex++];
            this._bufferg.setClip(clipX, clipY, clipWidth, clipHeight);
            this._stackIndex -= 6;
        }
    }

    public void resetMatrix() {
        this._stackIndex = 0;
        this._bufferg.translate(-this._bufferg.getTranslateX(), -this._bufferg.getTranslateY());
        this._bufferg.setClip(0, 0, this.width, this.height);
    }

    public void translate(int x, int y) {
        this._bufferg.translate(x, y);
    }

    public final int random(int value1) {
        return this.random(0, value1);
    }

    public final int random(int value1, int value2) {
        if (this._random == null) {
            this._random = new Random();
        }
        int min = Math.min(value1, value2);
        int range = Math.abs(value2 - value1);
        return min + Math.abs(this._random.nextInt() % range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] loadBytes(String filename) {
        block21: {
            result = null;
            try {
                store = null;
                try {
                    try {
                        name = filename;
                        if (name.length() > 32) {
                            name = name.substring(0, 32);
                        }
                        store = RecordStore.openRecordStore(name, false);
                        var5_9 = store.getRecord(1);
                        var7_11 = null;
                        if (store == null) return var5_9;
                    }
                    catch (RecordStoreNotFoundException rsnfe) {
                        var7_12 = null;
                        if (store != null) {
                            store.closeRecordStore();
                        }
                        break block21;
                    }
                }
                catch (Throwable var6_14) {
                    var7_13 = null;
                    if (store == null) throw var6_14;
                    store.closeRecordStore();
                    throw var6_14;
                }
                store.closeRecordStore();
                return var5_9;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        is = null;
        try {
            try {
                is = this.getClass().getResourceAsStream(filename);
                if (is != null) {
                    baos = new ByteArrayOutputStream();
                    buffer = new byte[1024];
                    bytesRead = is.read(buffer);
                    while (bytesRead >= 0) {
                        baos.write(buffer, 0, bytesRead);
                        bytesRead = is.read(buffer);
                    }
                    result = baos.toByteArray();
                } else {
                    result = new byte[]{};
                }
                baos = result;
                var9_16 = null;
                if (is == null) return baos;
            }
            catch (Exception e) {
                e.printStackTrace();
                var9_17 = null;
                if (is == null) return result;
                try {
                    is.close();
                    return result;
                }
                catch (IOException ioe) {
                    return result;
                }
            }
        }
        catch (Throwable var8_22) {
            var9_18 = null;
            if (is == null) throw var8_22;
            ** try [egrp 5[TRYBLOCK] [10 : 193->200)] { 
lbl68:
            // 1 sources

            is.close();
            throw var8_22;
lbl70:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            throw var8_22;
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return baos;
        }
        is.close();
        return baos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] loadStrings(String filename) {
        block26: {
            block25: {
                try {
                    store = null;
                    try {
                        try {
                            name = filename;
                            if (name.length() > 32) {
                                name = name.substring(0, 32);
                            }
                            store = RecordStore.openRecordStore(name, false);
                            numRecords = store.getNumRecords();
                            strings = new String[numRecords];
                            for (i = 0; i < numRecords; ++i) {
                                data = store.getRecord(i + 1);
                                strings[i] = data != null ? new String(data) : "";
                            }
                            i = strings;
                            var9_17 = null;
                            if (store == null) return i;
                        }
                        catch (RecordStoreNotFoundException rsnfe) {
                            var9_18 = null;
                            if (store != null) {
                                store.closeRecordStore();
                            }
                            break block25;
                        }
                    }
                    catch (Throwable var8_20) {
                        var9_19 = null;
                        if (store == null) throw var8_20;
                        store.closeRecordStore();
                        throw var8_20;
                    }
                    store.closeRecordStore();
                    return i;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            v = new Vector<String>();
            is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream(filename);
                    if (is != null) {
                        r = new InputStreamReader(is);
                        numStrings = 0;
                        buffer = new StringBuffer();
                        input = r.read();
                        while (true) {
                            if (input < 0 || input == 10) {
                                s = buffer.toString().trim();
                                if (s.length() > 0) {
                                    ++numStrings;
                                    v.addElement(s);
                                }
                                buffer.delete(0, 0x7FFFFFFF);
                                if (input < 0) {
                                    break;
                                }
                            } else {
                                buffer.append((char)input);
                            }
                            input = r.read();
                        }
                    }
                    var11_22 = null;
                    if (is == null) break block26;
                }
                catch (Exception e) {
                    var11_23 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block26;
                }
            }
            catch (Throwable var10_28) {
                var11_24 = null;
                if (is == null) throw var10_28;
                ** try [egrp 5[TRYBLOCK] [10 : 294->301)] { 
lbl80:
                // 1 sources

                is.close();
                throw var10_28;
lbl82:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                throw var10_28;
            }
            try {}
            catch (IOException ioe) {}
            is.close();
        }
        strings = new String[v.size()];
        v.copyInto(strings);
        return strings;
    }

    public final void saveBytes(String filename, byte[] data) {
        if (filename.length() > 32) {
            // empty if block
        }
        try {
            try {
                RecordStore.deleteRecordStore(filename);
            }
            catch (RecordStoreNotFoundException rsnfe) {
                // empty catch block
            }
            RecordStore store = RecordStore.openRecordStore(filename, true);
            store.addRecord(data, 0, data.length);
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void saveStrings(String filename, String[] strings) {
        if (filename.length() > 32) {
            // empty if block
        }
        try {
            try {
                RecordStore.deleteRecordStore(filename);
            }
            catch (RecordStoreNotFoundException rsnfe) {
                // empty catch block
            }
            RecordStore store = RecordStore.openRecordStore(filename, true);
            int length = strings.length;
            for (int i = 0; i < length; ++i) {
                byte[] data = strings[i].getBytes();
                store.addRecord(data, 0, data.length);
            }
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream openStream(String fileName) {
        try {
            return this.getClass().getResourceAsStream("/" + fileName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PFont loadFont(String fontname, color fgColor, color bgColor) {
        return new PFont(fontname, fgColor, bgColor);
    }

    public PFont loadFont(String fontname, color fgColor) {
        return new PFont(fontname, fgColor, new color(0xFFFFFF));
    }

    public PFont loadFont(String fontname) {
        return new PFont(fontname);
    }

    public PFont loadFont() {
        return new PFont(Font.getDefaultFont());
    }

    public PFont loadFont(int face, int style, int size) {
        return new PFont(Font.getFont(face, style, size));
    }

    public void textFont(PFont font) {
        this._defaultFont = font;
    }

    public String[] textWrap(String data, int width) {
        return this.textWrap(data, width, Integer.MAX_VALUE);
    }

    public String[] textWrap(String data, int width, int height) {
        int maxlines = height / this._defaultFont.getHeight();
        int textLength = data.length();
        Vector<String> lines = new Vector<String>();
        char[] line = new char[256];
        for (int i = 0; i < textLength; ++i) {
            char c = data.charAt(i);
            if (c != ' ') {
                int lineLength = 0;
                int last = -1;
                int lineWidth = 0;
                while (lineWidth <= width) {
                    if (i == textLength) {
                        last = lineLength;
                        break;
                    }
                    c = data.charAt(i);
                    ++i;
                    line[lineLength] = c;
                    ++lineLength;
                    if (c == ' ') {
                        last = lineLength - 1;
                        while (i < textLength && data.charAt(i) == ' ') {
                            ++i;
                            line[lineLength] = 32;
                            ++lineLength;
                        }
                    } else if (c == '\n') {
                        last = lineLength - 1;
                        break;
                    }
                    lineWidth = this._defaultFont.charsWidth(line, 0, lineLength);
                }
                if (last >= 0) {
                    lines.addElement(new String(line, 0, last));
                    i -= lineLength - last;
                } else {
                    lines.addElement(new String(line, 0, lineLength - 1));
                    i -= 2;
                }
            }
            if (lines.size() == maxlines) break;
        }
        Object[] array = new String[lines.size()];
        lines.copyInto(array);
        return array;
    }

    public int textWidth(String data) {
        return this._defaultFont.stringWidth(data);
    }

    public void textAlign(int mode) {
        this._textAlignMode = mode;
    }

    public void text(String text, int x, int y) {
        if (!this._defaultFont.isBitmapFont()) {
            this._bufferg.setColor(this._fillColor);
        }
        this.pushMatrix();
        this._defaultFont.draw(this._bufferg, text, x, y, 2);
        this.popMatrix();
    }

    public void text(String text, int x, int y, int width, int height) {
        String[] data = this.textWrap(text, width, height);
        if (!this._defaultFont.isBitmapFont()) {
            this._bufferg.setColor(this._fillColor);
        }
        this.pushMatrix();
        this._bufferg.setClip(x, y, width, height);
        int textX = x;
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            String line = data[i];
            switch (this._textAlignMode) {
                case 0: {
                    textX = x + (width - this.textWidth(line) >> 1);
                    break;
                }
                case 5: {
                    textX = x + width - this.textWidth(line);
                }
            }
            this._defaultFont.draw(this._bufferg, line, textX, y + this._defaultFont.getBaseline(), 2);
            y += this._defaultFont.getHeight();
        }
        this.popMatrix();
    }

    public final int abs(int value) {
        return Math.abs(value);
    }

    public final int max(int value1, int value2) {
        return Math.max(value1, value2);
    }

    public final int min(int value1, int value2) {
        return Math.min(value1, value2);
    }

    public final int sq(int value) {
        return value * value;
    }

    public final int pow(int base, int exponent) {
        int value = 1;
        for (int i = 0; i < exponent; ++i) {
            value *= base;
        }
        return value;
    }

    public final int constrain(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public final int mul(int value1, int value2) {
        return value1 * value2 >> 8;
    }

    public final int div(int dividend, int divisor) {
        return (dividend << 8) / divisor;
    }

    public final int itofp(int value1) {
        return value1 << 8;
    }

    public final int fptoi(int value1) {
        if (value1 < 0) {
            value1 += 255;
        }
        return value1 >> 8;
    }

    public final int sqrt(int value_fp) {
        int prev;
        int prev_fp = value_fp;
        int next_fp = 0;
        while ((prev = prev_fp >> 8) != 0) {
            next_fp = (prev_fp + value_fp / prev) / 2;
            int error_fp = prev_fp > next_fp ? prev_fp - next_fp : next_fp - prev_fp;
            prev_fp = next_fp;
            if (error_fp > 256) continue;
        }
        return next_fp;
    }

    public final int dist(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return this.sqrt(dx * dx + dy * dy << 8);
    }

    public final int dist_fp(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return this.sqrt((dx * dx >> 8) + (dy * dy >> 8));
    }

    public final int floor(int value1) {
        return value1 >> 8 << 8;
    }

    public final int ceil(int value1) {
        return value1 + 256 - 1 >> 8 << 8;
    }

    public final int round(int value1) {
        return value1 + 128 >> 8 << 8;
    }

    public final int radians(int angle) {
        return angle * 804 / 46080;
    }

    public final int sin(int rad) {
        int index = rad * 180 / 804 % 360;
        if (index < 0) {
            index += 360;
        }
        return sin[index];
    }

    public final int cos(int rad) {
        int index = (rad * 180 / 804 + 90) % 360;
        if (index < 0) {
            index += 360;
        }
        return sin[index];
    }

    public final int atan(int value1) {
        int sign = 1;
        if (value1 < 0) {
            sign = -1;
            value1 = -value1;
        }
        int result = value1 <= 256 ? this.div(value1, 256 + this.mul(71, this.mul(value1, value1))) : 402 - this.div(value1, this.mul(value1, value1) + 71);
        return sign * result;
    }

    public final int atan2(int y, int x) {
        int result = y == 0 && x == 0 ? 0 : (x > 0 ? this.atan(this.div(y, x)) : (x < 0 ? (y < 0 ? -(804 - this.atan(this.div(-y, -x))) : 804 - this.atan(this.div(y, -x))) : (y < 0 ? -402 : 402)));
        return result;
    }

    public double sind(double rad) {
        return Math.sin(rad);
    }

    public double cosd(double rad) {
        return Math.cos(rad);
    }

    public double atan(double value1) {
        return MathUtil.atan(value1);
    }

    public double atan2d(int x, int y) {
        return MathUtil.atan2(x, y);
    }

    public float[] append(float[] array, float element) {
        float[] old = array;
        int length = old.length;
        array = new float[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public double[] append(double[] array, double element) {
        double[] old = array;
        int length = old.length;
        array = new double[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public double random(double value) {
        double COEFF = 10000.0;
        int randomNumber = this.random((int)(value * COEFF));
        return (double)randomNumber / COEFF;
    }
}

