/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.ProcessingContextContainerInterface;
import de.enough.polish.processing.ProcessingInterface;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ProcessingBackground
extends Background
implements ProcessingContextContainerInterface {
    public transient ProcessingInterface context;
    public boolean lastFocusedState;
    public boolean focusHasBeenInitialized;

    public ProcessingBackground(ProcessingInterface context) {
        this.lastFocusedState = false;
        this.focusHasBeenInitialized = false;
        this.context = context;
        this.context.setParent(this);
        this.borderWidth = 0;
        context.signalInitialization();
    }

    public void setParentItem(Item parent) {
        super.setParentItem(parent);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.focusHasBeenInitialized) {
            if (this.parent.isFocused != this.lastFocusedState) {
                if (this.parent.isFocused) {
                    this.lastFocusedState = true;
                    this.context.signalHasFocus();
                } else {
                    this.lastFocusedState = false;
                    this.context.signalLostFocus();
                }
            }
        } else {
            this.focusHasBeenInitialized = true;
            this.lastFocusedState = !this.parent.isFocused;
            this.paint(x, y, width, height, g);
            return;
        }
        this.context.signalSizeChange(width, height);
        if (!this.context.isDrawingTransparent()) {
            g.drawImage(this.context.getBuffer(), x, y, 20);
        } else {
            this.context.getTransparentRgbImage().paint(x, y, g);
        }
    }

    public void processingRequestRepaint() {
        Screen scr;
        if (this.parent != null && (scr = this.parent.getScreen()) != null) {
            scr.repaint(this.parent.getAbsoluteX(), this.parent.getAbsoluteY(), this.parent.getBackgroundWidth(), this.parent.getBackgroundHeight());
        }
    }

    public void releaseResources() {
        this.context.signalDestroy();
    }

    public void setSoftkey(String text) {
    }

    public ProcessingBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.focusHasBeenInitialized = dataInputStream.readBoolean();
        this.lastFocusedState = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.focusHasBeenInitialized);
        dataOutputStream.writeBoolean(this.lastFocusedState);
    }
}

