/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.math;

public class FP {
    public static final int FIX_PRECISION = 16;
    public static final int MANTISSA_MASK = -65536;
    public static final int EXPONENT_MASK = Short.MAX_VALUE;
    public static final int FIX_ONE = 65536;
    public static final int FIX_HALF = 32768;
    public static final int FIX_QUATER = 16384;
    public static final int FIX_EIGHTS = 8192;
    public static final int FIX_MINF = Integer.MIN_VALUE;
    public static final int FIX_PINF = Integer.MAX_VALUE;
    public static final int FIX_EPS = 4;
    public static final int FIX_PI = 205887;
    public static final int FIX_PI_HALF = 102943;
    public static final int FIX_2PI = 411774;
    public static final int FIX_R2PI = 10430;
    public static final int FIX_90 = 0x5A0000;
    public static final int FIX_180 = 0xB40000;
    public static final int FIX_270 = 0x10E0000;
    public static final int FIX_360 = 23592960;
    private static final short[] sqrt_table = new short[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    private static final int sk_precision = 31;
    private static final int[] SK = new int[]{498, 10882};
    private static final int as_precision = 30;
    private static final int[] AS = new int[]{-1228, 4866, 13901, 102939};

    public static int intToFix(int anInt) {
        return anInt << 16;
    }

    public static int fixToInt(int a_fix) {
        return a_fix >> 16;
    }

    public static int floatToFix(float aFloat) {
        return (int)(65536.0f * aFloat);
    }

    public static float fixToFloat(int a_fix) {
        return (float)a_fix * 1.5258789E-5f;
    }

    public static int mul(int one_fix, int two_fix) {
        return (int)((long)one_fix * (long)two_fix >> 16);
    }

    public static int div(int one_fix, int two_fix) {
        if (two_fix > Math.abs(4)) {
            return (int)(((long)one_fix << 16) / (long)two_fix);
        }
        return 0;
    }

    public static int abs(int a_fix) {
        return a_fix < 0 ? -a_fix : a_fix;
    }

    public static int round(int a_fix) {
        return a_fix + 32768 >> 16;
    }

    public static int nearest(int a_fix) {
        return FP.truncate(a_fix + 32768);
    }

    public static int truncate(int a_fix) {
        return a_fix & 0xFFFF0000;
    }

    public static int fraction(int a_fix) {
        return a_fix & 0x8000FFFF;
    }

    public static int clamp(int a_fix, int clamp_fix) {
        return FP.div(a_fix, clamp_fix);
    }

    public static int min(int one_fix, int two_fix) {
        return one_fix < two_fix ? one_fix : two_fix;
    }

    public static int max(int one_fix, int two_fix) {
        return one_fix > two_fix ? one_fix : two_fix;
    }

    public static String toString(int a_fix) {
        return ((a_fix & 0xFFFF0000) >> 16) + "." + FP.div(Short.MAX_VALUE, a_fix & Short.MAX_VALUE);
    }

    private static int fastSqrt(int x) {
        if (x >= 65536) {
            if (x >= 0x1000000) {
                if (x >= 0x10000000) {
                    if (x >= 0x40000000) {
                        return sqrt_table[x >> 24] << 8;
                    }
                    return sqrt_table[x >> 22] << 7;
                }
                if (x >= 0x4000000) {
                    return sqrt_table[x >> 20] << 6;
                }
                return sqrt_table[x >> 18] << 5;
            }
            if (x >= 0x100000) {
                if (x >= 0x400000) {
                    return sqrt_table[x >> 16] << 4;
                }
                return sqrt_table[x >> 14] << 3;
            }
            if (x >= 262144) {
                return sqrt_table[x >> 12] << 2;
            }
            return sqrt_table[x >> 10] << 1;
        }
        if (x >= 256) {
            if (x >= 4096) {
                if (x >= 16384) {
                    return sqrt_table[x >> 8];
                }
                return sqrt_table[x >> 6] >> 1;
            }
            if (x >= 1024) {
                return sqrt_table[x >> 4] >> 2;
            }
            return sqrt_table[x >> 2] >> 3;
        }
        if (x >= 0) {
            return sqrt_table[x] >> 4;
        }
        return -1;
    }

    public static int sqrtRound(int x_fix) {
        return FP.fastSqrt(x_fix >> 16) << 16;
    }

    public static int sqrt(int a_fix) {
        int s_fixed = a_fix + 65536 >> 1;
        int i = 8;
        while (--i >= 0) {
            s_fixed = s_fixed + FP.div(a_fix, s_fixed) >> 1;
        }
        return s_fixed;
    }

    public static int degreeToRadian(int degree_fix) {
        return FP.mul(degree_fix, FP.div(205887, 0xB40000));
    }

    public static int radianToDegree(int radian_fix) {
        return FP.mul(radian_fix, FP.div(0xB40000, 205887));
    }

    public static int sin(int radians_fix) {
        int sign = 1;
        if ((radians_fix %= 411774) < 0) {
            radians_fix = 411774 + radians_fix;
        }
        if (radians_fix > 102943 && radians_fix <= 205887) {
            radians_fix = 205887 - radians_fix;
        } else if (radians_fix > 205887 && radians_fix <= 308830) {
            radians_fix -= 205887;
            sign = -1;
        } else if (radians_fix > 308830) {
            radians_fix = 411774 - radians_fix;
            sign = -1;
        }
        int sqr = FP.mul(radians_fix, radians_fix);
        int result = SK[0];
        result = FP.mul(result, sqr);
        result -= SK[1];
        result = FP.mul(result, sqr);
        result += 65536;
        result = FP.mul(result, radians_fix);
        return sign * result;
    }

    public static int cos(int radians_fix) {
        return FP.sin(102943 - radians_fix);
    }

    public static int tan(int radians_fix) {
        return FP.div(FP.sin(radians_fix), FP.cos(radians_fix));
    }

    public static int asin(int a_fix) {
        boolean neg = false;
        if (a_fix < 0) {
            neg = true;
            a_fix = -a_fix;
        }
        int fRoot = FP.sqrt(65536 - a_fix);
        int result = AS[0];
        result = FP.mul(result, a_fix);
        result += AS[1];
        result = FP.mul(result, a_fix);
        result -= AS[2];
        result = FP.mul(result, a_fix);
        result += AS[3];
        result = 102943 - FP.mul(fRoot, result);
        if (neg) {
            result = -result;
        }
        return result;
    }

    public static int acos(int a_fix) {
        return 102943 - FP.asin(a_fix);
    }

    public static int atan(int f) {
        return FP.asin(FP.div(f, FP.sqrt(65536 + FP.mul(f, f))));
    }
}

