/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.http;

import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpLogHandler
extends LogHandler
implements Runnable {
    public static final String SERVER_URL = null;
    private static final String HTTP_VALUE_LANGUAGE = "en-DE";
    private static final String HTTP_KEY_LANGUAGE = "Content-Language";
    private static final String HTTP_VALUE_USER_AGENT = "Profile/MIDP-2.0 Configuration/CLDC-1.0";
    private static final String HTTP_KEY_USER_AGENT = "User-Agent";
    private static final String HTTP_VALUE_IF_MODIFIER = "10 Nov 2000 17:29:12 GMT";
    private static final String HTTP_KEY_IF_MODIFIER = "IF-Modified-Since";
    private volatile ArrayList logStack = new ArrayList();
    private Thread logThread;
    private volatile boolean keepRunning = true;

    public HttpLogHandler() {
        if (SERVER_URL != null) {
            this.logThread = new Thread(this);
            this.logThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLogEntry(LogEntry logEntry) throws Exception {
        ArrayList arrayList = this.logStack;
        synchronized (arrayList) {
            this.logStack.add(logEntry);
        }
    }

    public void run() {
        while (this.keepRunning) {
            LogEntry entryToLog = this.getNextEntry();
            if (entryToLog == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.logCurrentEntry(entryToLog);
        }
    }

    public void exit() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentEntry(LogEntry logEntry) {
        HttpConnection connection = null;
        Object outputStream = null;
        Object inputStream = null;
        try {
            try {
                connection = this.initHttpConnection(this.getUrl(logEntry));
                connection.getResponseCode();
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var7_6 = null;
                this.closeStreams(connection, inputStream, outputStream);
                connection = null;
                inputStream = null;
                outputStream = null;
            }
            Object var7_5 = null;
            this.closeStreams(connection, inputStream, outputStream);
            connection = null;
            inputStream = null;
            outputStream = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeStreams(connection, inputStream, outputStream);
            connection = null;
            inputStream = null;
            outputStream = null;
            throw throwable;
        }
    }

    private void closeStreams(HttpConnection c, InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
    }

    private String getUrl(LogEntry logEntry) {
        StringBuffer url = new StringBuffer();
        Date timeDate = new Date(logEntry.time);
        url.append(SERVER_URL).append("?");
        url.append("time=").append(this.encodeURL(timeDate.toString()));
        url.append("&message=").append(this.encodeURL(logEntry.message));
        url.append("&classname=").append(logEntry.className);
        url.append("&lineNumber=").append(logEntry.lineNumber);
        url.append("&exception=").append(this.encodeURL(logEntry.exception));
        url.append("&level=").append(logEntry.level);
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry getNextEntry() {
        if (this.logStack.size() == 0) {
            return null;
        }
        ArrayList arrayList = this.logStack;
        synchronized (arrayList) {
            return (LogEntry)this.logStack.remove(0);
        }
    }

    private HttpConnection initHttpConnection(String url) throws IOException {
        HttpConnection logConnection = (HttpConnection)Connector.open(url);
        logConnection.setRequestMethod("GET");
        logConnection.setRequestProperty(HTTP_KEY_IF_MODIFIER, HTTP_VALUE_IF_MODIFIER);
        logConnection.setRequestProperty(HTTP_KEY_USER_AGENT, HTTP_VALUE_USER_AGENT);
        logConnection.setRequestProperty(HTTP_KEY_LANGUAGE, HTTP_VALUE_LANGUAGE);
        return logConnection;
    }

    public String encodeURL(String url) {
        String newurl = "";
        int urllen = url.length();
        for (int i = 0; i < urllen; ++i) {
            char c = url.charAt(i);
            newurl = this.isCharEncodingNotNecessary(c) ? newurl + c : (c == ' ' ? newurl + '+' : newurl + this.encodeChar(c));
        }
        return newurl;
    }

    private boolean isCharEncodingNotNecessary(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '*' || c == '_' || c == '/' || c == '~';
    }

    private String encodeChar(char c) {
        String encchar = "%";
        encchar = encchar + Integer.toHexString(c / 16 % 16).toUpperCase();
        encchar = encchar + Integer.toHexString(c % 16).toUpperCase();
        return encchar;
    }
}

