/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.json;

import de.enough.polish.json.JsonItem;
import de.enough.polish.json.JsonParser;

public class JsonUtil {
    public static final String escapeToJson(String value) {
        StringBuffer result = new StringBuffer();
        JsonUtil.escapeToJson(value, result);
        return result.toString();
    }

    public static final void escapeToJson(String value, StringBuffer stringBuffer) {
        int length = value.length();
        block8: for (int index = 0; index < length; ++index) {
            char c = value.charAt(index);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String unicodeBuffer = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + unicodeBuffer.substring(unicodeBuffer.length() - 4));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
    }

    public static final String toJsonValue(Object object) {
        StringBuffer buffer = new StringBuffer();
        JsonUtil.toJsonValue(object, buffer);
        return buffer.toString();
    }

    public static final void toJsonValue(Object object, StringBuffer stringBuffer) {
        if (object instanceof JsonItem) {
            ((JsonItem)object).serializeToStringBuffer(stringBuffer);
        } else {
            boolean needsQuotes;
            boolean bl = needsQuotes = !(object instanceof Integer) && !(object instanceof Long) && !(object instanceof Double) && !(object instanceof Float) && !(object instanceof Boolean) && object != JsonParser.NULL;
            if (needsQuotes) {
                stringBuffer.append('\"');
                JsonUtil.escapeToJson(object.toString(), stringBuffer);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(object.toString());
            }
        }
    }
}

