/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.json;

import de.enough.polish.json.JsonArray;
import de.enough.polish.json.JsonException;
import de.enough.polish.json.JsonNumber;
import de.enough.polish.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonParser {
    protected static final char TOKEN_BEGIN_ARRAY = '[';
    protected static final char TOKEN_BEGIN_OBJECT = '{';
    protected static final char TOKEN_END_ARRAY = ']';
    protected static final char TOKEN_END_OBJECT = '}';
    protected static final char TOKEN_NAME_SEPARATOR = ':';
    protected static final char TOKEN_VALUE_SEPARATOR = ',';
    protected static final char TOKEN_WHITESPACE_SPACE = ' ';
    protected static final char TOKEN_WHITESPACE_TAB = '\t';
    protected static final char TOKEN_WHITSPACE_LINE_FEED = '\n';
    protected static final char TOKEN_WHITESPACE_CARRIAGE_RETURN = '\r';
    protected static final char TOKEN_ESCAPE_CHARACTER = '\\';
    protected static final char TOKEN_QUOTATION_MARK = '\"';
    protected static final char CHARACTER_BACKSPACE = '\b';
    protected static final char CHARACTER_FORM_FEED = '\f';
    protected static final char CHARACTER_TAB = '\t';
    protected static final char CHARACTER_LINE_FEED = '\n';
    protected static final char CHARACTER_CARRIAGE_RETURN = '\r';
    public static final Object NULL = new Null();
    protected static final int EXCEPTION_UNEXPECTED_END_OF_STREAM = 1;
    protected static final int EXCEPTION_UNEXPECTED_TOKEN = 2;
    protected static final int EXCEPTION_INVALID_ESCAPE_CHARACTER = 3;
    protected static final int EXCEPTION_UNTERMINATED_STRING = 4;
    protected static final int[] LITERAL_CODES_TRUE = new int[]{116, 114, 117, 101};
    protected static final int[] LITERAL_CODES_NULL = new int[]{110, 117, 108, 108};
    protected static final int[] LITERAL_CODES_FALSE = new int[]{102, 97, 108, 115, 101};
    int currentChar;
    Reader inputReader;

    protected static void throwJsonException(int exceptionType, String extraInfo) throws JsonException {
        switch (exceptionType) {
            case 1: {
                String exceptionText = "Unexpected end of this.stream encountered";
                if (extraInfo != null) {
                    exceptionText = exceptionText + ": " + extraInfo;
                }
                throw new JsonException(exceptionText);
            }
            case 2: {
                throw new JsonException("Unexpected token encountered: " + extraInfo);
            }
            case 3: {
                throw new JsonException("Invalid escape character encountered: " + extraInfo);
            }
            case 4: {
                throw new JsonException("Unterminated string \"" + extraInfo + "...\"");
            }
        }
        String exceptionText = "General exception encountered";
        if (extraInfo != null) {
            exceptionText = exceptionText + ": " + extraInfo;
        }
        throw new JsonException(exceptionText);
    }

    protected void skipWhitespace() throws IOException, JsonException {
        while (this.currentChar == 32 || this.currentChar == 9 || this.currentChar == 10 || this.currentChar == 13) {
            this.currentChar = this.inputReader.read();
        }
        if (this.currentChar == -1) {
            JsonParser.throwJsonException(1, null);
        }
    }

    public Object parseJson(String json) throws IOException, JsonException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(json.getBytes());
        return this.parseJson(byteArrayInputStream);
    }

    public Object parseJson(InputStream inputStream) throws IOException, JsonException {
        return this.parseJson(inputStream, null);
    }

    public Object parseJson(InputStream inputStream, String encoding) throws IOException, JsonException {
        this.inputReader = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
        this.currentChar = 32;
        this.skipWhitespace();
        return this.readEntity();
    }

    protected JsonObject readJsonObject() throws IOException, JsonException {
        if (this.currentChar != 123) {
            JsonParser.throwJsonException(2, "encountered '" + (char)this.currentChar + "' while expecting '" + '{' + "' when reading an object");
        }
        JsonObject result = new JsonObject();
        this.currentChar = this.inputReader.read();
        this.skipWhitespace();
        if (this.currentChar == 125) {
            this.currentChar = this.inputReader.read();
            return result;
        }
        while (true) {
            StringBuffer currentObject;
            if (this.currentChar != 34) {
                currentObject = new StringBuffer();
                result.serializeToStringBuffer(currentObject);
                JsonParser.throwJsonException(2, "'" + (char)this.currentChar + "' encountered while reading a member name of the object " + currentObject.toString());
            }
            String memberName = this.readJsonString();
            this.skipWhitespace();
            if (this.currentChar != 58) {
                currentObject = new StringBuffer();
                result.serializeToStringBuffer(currentObject);
                JsonParser.throwJsonException(2, "'" + (char)this.currentChar + "' encountered instead of name separator in the object " + currentObject.toString());
            }
            this.currentChar = this.inputReader.read();
            this.skipWhitespace();
            Object value = this.readEntity();
            result.put(memberName, value);
            this.skipWhitespace();
            if (this.currentChar == 125) {
                this.currentChar = this.inputReader.read();
                return result;
            }
            if (this.currentChar == 44) {
                this.currentChar = this.inputReader.read();
                this.skipWhitespace();
                continue;
            }
            StringBuffer currentArray = new StringBuffer();
            result.serializeToStringBuffer(currentArray);
            JsonParser.throwJsonException(2, "'" + String.valueOf((char)this.currentChar) + "' encountered while reading array " + currentArray.toString());
        }
    }

    protected Object readJsonArray() throws IOException, JsonException {
        if (this.currentChar != 91) {
            JsonParser.throwJsonException(2, "encountered '" + (char)this.currentChar + "' while expecting '" + '[' + "' when reading an object");
        }
        JsonArray result = new JsonArray();
        this.currentChar = this.inputReader.read();
        this.skipWhitespace();
        if (this.currentChar == 93) {
            this.currentChar = this.inputReader.read();
            return result;
        }
        while (true) {
            result.put(this.readEntity());
            this.skipWhitespace();
            if (this.currentChar == 93) {
                this.currentChar = this.inputReader.read();
                return result;
            }
            if (this.currentChar == 44) {
                this.currentChar = this.inputReader.read();
                this.skipWhitespace();
                continue;
            }
            StringBuffer currentArray = new StringBuffer();
            result.serializeToStringBuffer(currentArray);
            JsonParser.throwJsonException(2, String.valueOf((char)this.currentChar) + " encountered while reading array " + currentArray.toString());
        }
    }

    protected Object readEntity() throws IOException, JsonException {
        switch (this.currentChar) {
            case 91: {
                return this.readJsonArray();
            }
            case 123: {
                return this.readJsonObject();
            }
            case 34: {
                return this.readJsonString();
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readJsonNumber();
            }
            case 102: 
            case 110: 
            case 116: {
                return this.readJsonLiteral();
            }
        }
        JsonParser.throwJsonException(2, String.valueOf((char)this.currentChar) + " encountered while trying to read a value");
        return null;
    }

    protected Object readJsonLiteral() throws JsonException, IOException {
        int originalCharacter = this.currentChar;
        int[] arrayToUse = null;
        switch (this.currentChar) {
            case 116: {
                arrayToUse = LITERAL_CODES_TRUE;
                break;
            }
            case 110: {
                arrayToUse = LITERAL_CODES_NULL;
                break;
            }
            case 102: {
                arrayToUse = LITERAL_CODES_FALSE;
                break;
            }
            default: {
                JsonParser.throwJsonException(2, "expected literal, but no JSON literal can start with the letter '" + (char)this.currentChar + "'");
            }
        }
        int size = arrayToUse.length;
        int currentIndex = 0;
        while (currentIndex < size) {
            if (this.currentChar == arrayToUse[currentIndex]) {
                ++currentIndex;
            } else if (this.currentChar == -1) {
                JsonParser.throwJsonException(1, " end of stream encountered while trying to read literal");
            } else {
                JsonParser.throwJsonException(2, "found unexpected character '" + (char)this.currentChar + "' in literal");
            }
            this.currentChar = this.inputReader.read();
        }
        switch (originalCharacter) {
            case 116: {
                return Boolean.TRUE;
            }
            case 102: {
                return Boolean.FALSE;
            }
            case 110: {
                return NULL;
            }
        }
        return null;
    }

    protected JsonNumber readJsonNumber() throws IOException, JsonException {
        boolean integerPartFound = false;
        boolean decimalPointFound = false;
        boolean exponentSignFound = false;
        StringBuffer result = new StringBuffer();
        if (this.currentChar == 45) {
            result.append('-');
            this.currentChar = this.inputReader.read();
        }
        while (true) {
            switch (this.currentChar) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    integerPartFound = true;
                    break;
                }
                case 46: {
                    if (decimalPointFound) {
                        JsonParser.throwJsonException(2, "extra decimal point found in number" + result.toString());
                    } else if (!integerPartFound) {
                        JsonParser.throwJsonException(2, "decimal point found before integer part in number" + result.toString());
                    }
                    decimalPointFound = true;
                    break;
                }
                case 69: 
                case 101: {
                    if (exponentSignFound) {
                        JsonParser.throwJsonException(2, "extra exponent sign found in number" + result.toString());
                    } else if (!integerPartFound) {
                        JsonParser.throwJsonException(2, "exponent sign found before integer part in number" + result.toString());
                    }
                    exponentSignFound = true;
                    break;
                }
                case -1: {
                    JsonParser.throwJsonException(1, "while trying to read number beginning with \"" + result.toString() + "...\"");
                }
                default: {
                    return new JsonNumber(result.toString());
                }
            }
            result.append((char)this.currentChar);
            this.currentChar = this.inputReader.read();
        }
    }

    protected String readJsonString() throws IOException, JsonException {
        if (this.currentChar != 34) {
            JsonParser.throwJsonException(2, "encountered '" + (char)this.currentChar + "' while expecting '" + '\"' + "' when reading an object");
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer unicodeBuffer = new StringBuffer(4);
        this.currentChar = this.inputReader.read();
        while (true) {
            block0 : switch (this.currentChar) {
                case -1: {
                    JsonParser.throwJsonException(1, "while trying to read string beginning with \"" + buffer.toString() + "...\"");
                }
                case 34: {
                    this.currentChar = this.inputReader.read();
                    return buffer.toString();
                }
                case 92: {
                    this.currentChar = this.inputReader.read();
                    switch (this.currentChar) {
                        case 116: {
                            buffer.append('\t');
                            break block0;
                        }
                        case 110: {
                            buffer.append('\n');
                            break block0;
                        }
                        case 114: {
                            buffer.append('\r');
                            break block0;
                        }
                        case 102: {
                            buffer.append('\f');
                            break block0;
                        }
                        case 98: {
                            buffer.append('\b');
                            break block0;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            buffer.append((char)this.currentChar);
                            break block0;
                        }
                        case 117: {
                            unicodeBuffer.delete(0, 4);
                            for (int unicodeIndex = 0; unicodeIndex < 4; ++unicodeIndex) {
                                this.currentChar = this.inputReader.read();
                                if (this.currentChar == -1) {
                                    JsonParser.throwJsonException(1, "while trying to read next unicode character in string \"" + buffer.toString() + "...\"");
                                }
                                unicodeBuffer.append((char)this.currentChar);
                            }
                            buffer.append((char)Integer.parseInt(unicodeBuffer.toString(), 16));
                            break block0;
                        }
                    }
                    JsonParser.throwJsonException(3, "'" + (char)this.currentChar + "' found in string \"" + buffer.toString() + "...\"");
                    break;
                }
                case 10: 
                case 13: {
                    JsonParser.throwJsonException(4, buffer.toString());
                }
                default: {
                    buffer.append((char)this.currentChar);
                }
            }
            this.currentChar = this.inputReader.read();
        }
    }

    private static final class Null {
        private Null() {
        }

        public String toString() {
            return "null";
        }

        public boolean equals(Object object) {
            return object == null || object == this || object instanceof Null;
        }
    }
}

