/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io;

import de.enough.polish.io.RedirectHttpConnection;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.TextUtil;
import java.io.IOException;

public class PostRedirectHttpConnection
extends RedirectHttpConnection {
    private final StringBuffer body;

    public PostRedirectHttpConnection(String url) throws IOException {
        this(url, null, 0);
    }

    public PostRedirectHttpConnection(String url, int timeout) throws IOException {
        this(url, null, timeout);
    }

    public PostRedirectHttpConnection(String url, HashMap requestProperties) throws IOException {
        this(url, requestProperties, 0);
    }

    public PostRedirectHttpConnection(String url, HashMap requestProperties, int timeout) throws IOException {
        super(url, requestProperties, timeout);
        this.setRequestMethod("POST");
        this.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        this.body = new StringBuffer();
    }

    public void addPostParameter(String name, String value) {
        if (this.body.length() > 0) {
            this.body.append('&');
        }
        this.body.append(TextUtil.encodeUrl(name)).append('=').append(TextUtil.encodeUrl(value));
    }

    protected synchronized void ensureConnectionCreated() throws IOException {
        if (this.httpConnection == null) {
            byte[] data = this.body.toString().getBytes();
            this.openOutputStream().write(data, 0, data.length);
        }
        super.ensureConnectionCreated();
    }
}

