/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.geometry2d;

import de.enough.polish.geometry2d.Line2D;
import de.enough.polish.geometry2d.Point2D;

public class Util2D {
    public static final double VERY_SMALL_DISTANCE = 1.0E-6;
    public static final Point2D origin = new Point2D(0.0, 0.0);

    public static double getSlope(Point2D point1, Point2D point2) {
        return (point1.y - point2.y) / (point1.x - point2.x);
    }

    public static double getSlope(Line2D line) {
        return Util2D.getSlope(line.p1, line.p2);
    }

    public static double getDistance(Point2D p1, Point2D p2) {
        return Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
    }

    public static double getYIntercept(Line2D line) {
        double m = Util2D.getSlope(line);
        return line.p1.y - m * line.p1.x;
    }

    public static double getXIntercept(Line2D line) {
        return -Util2D.getYIntercept(line) / Util2D.getSlope(line);
    }

    public static Line2D line2DFromGeneralEquation(double A, double B, double C) {
        Point2D p1 = new Point2D(C / A, 0.0);
        Point2D p2 = new Point2D(0.0, C / B);
        Line2D result = new Line2D(p1, p2, false);
        return result;
    }

    public static boolean isVertical(Line2D line) {
        return Math.abs(line.p1.x - line.p2.x) < 1.0E-6;
    }

    public static boolean areParallel(Line2D line1, Line2D line2) {
        if (Util2D.isVertical(line1) && Util2D.isVertical(line2)) {
            return true;
        }
        if (Util2D.isVertical(line1) || Util2D.isVertical(line2)) {
            return false;
        }
        return Math.abs(Util2D.getSlope(line1) - Util2D.getSlope(line2)) < 1.0E-6;
    }
}

