/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.geometry2d;

import de.enough.polish.geometry2d.Line2D;
import de.enough.polish.geometry2d.Point2D;
import de.enough.polish.geometry2d.Polygon2D;
import java.util.Enumeration;

public class Rotation2D {
    public static void rotate(Point2D point, Point2D origin, double angle) {
        double cos = Math.cos(Math.PI * angle / 180.0);
        double sin = Math.cos(Math.PI * angle / 180.0);
        Rotation2D.rotate(point, origin, cos, sin);
    }

    public static void rotate(Point2D point, Point2D origin, double cos, double sin) {
        double x = point.x - origin.x;
        double y = point.y - origin.y;
        point.x = x * cos - y * sin;
        point.y = x * sin + y * cos;
        point.x += origin.x;
        point.y += origin.y;
    }

    public static void rotate(Line2D line, Point2D origin, double angle) {
        double cos = Math.cos(Math.PI * angle / 180.0);
        double sin = Math.sin(Math.PI * angle / 180.0);
        Rotation2D.rotate(line, origin, cos, sin);
    }

    private static void rotate(Line2D line, Point2D origin, double cos, double sin) {
        Rotation2D.rotate(line.p1, origin, cos, sin);
        Rotation2D.rotate(line.p2, origin, cos, sin);
    }

    public static void rotate(Polygon2D polygon, Point2D origin, double angle) {
        double cos = Math.cos(Math.PI * angle / 180.0);
        double sin = Math.sin(Math.PI * angle / 180.0);
        Rotation2D.rotate(polygon, origin, cos, sin);
    }

    public static void rotate(Polygon2D polygon, Point2D origin, double cos, double sin) {
        Enumeration points = polygon.points.elements();
        while (points.hasMoreElements()) {
            Rotation2D.rotate((Point2D)points.nextElement(), origin, cos, sin);
        }
    }
}

