/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.format.atom;

import de.enough.polish.format.atom.AtomAuthor;
import de.enough.polish.format.atom.AtomEntry;
import de.enough.polish.format.atom.AtomUpdateConsumer;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.RedirectHttpConnection;
import de.enough.polish.io.StringReader;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.TimePoint;
import de.enough.polish.xml.XmlDomNode;
import de.enough.polish.xml.XmlDomParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class AtomFeed
implements Externalizable {
    private static final int VERSION = 101;
    private static int maxNumberOfSerializedEntries;
    private final IdentityArrayList entries = new IdentityArrayList();
    private String feedId;
    private String title;
    private String subtitle;
    private String updatedString;
    private TimePoint updated;
    private AtomAuthor author;
    private boolean isUpdating;
    private Object data;

    public AtomFeed() {
    }

    public AtomFeed(InputStream in) throws IOException {
        this();
        this.parse(in);
    }

    public static void setMaxNumberOfSerializedEntries(int max) {
        maxNumberOfSerializedEntries = max;
    }

    public static int getMaxNumberOfSerializedEntries() {
        return maxNumberOfSerializedEntries;
    }

    public void parse(String document) throws IOException {
        this.parse(new StringReader(document));
    }

    public void parse(InputStream in) throws IOException {
        this.parse(new InputStreamReader(in));
    }

    public void parse(InputStream in, String encoding) throws IOException {
        InputStreamReader inputStreamReader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        this.parse(inputStreamReader);
    }

    public void parse(Reader reader) throws IOException {
        XmlDomNode root = XmlDomParser.parseTree(reader);
        this.parse(root);
    }

    public void parse(XmlDomNode root) {
        this.feedId = root.getChildText("id");
        this.title = root.getChildText("title");
        this.subtitle = root.getChildText("subtitle");
        this.updatedString = root.getChildText("updated");
        XmlDomNode authorNode = root.getChild("author");
        if (authorNode != null) {
            this.author = new AtomAuthor(authorNode.getChildText("name"), authorNode.getChildText("email"), authorNode.getChildText("uri"));
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            XmlDomNode node = root.getChild(i);
            if (!"entry".equals(node.getName())) continue;
            AtomEntry entry = new AtomEntry(node);
            this.entries.add(entry);
        }
    }

    public void update(InputStream in, AtomUpdateConsumer consumer) throws IOException {
        this.update(new InputStreamReader(in), consumer);
    }

    public void update(InputStream in, String encoding, AtomUpdateConsumer consumer) throws IOException {
        InputStreamReader inputStreamReader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        this.update(inputStreamReader, consumer);
    }

    public void update(Reader reader, AtomUpdateConsumer consumer) throws IOException {
        XmlDomNode root = XmlDomParser.parseTree(reader);
        this.update(root, consumer);
    }

    public void update(XmlDomNode root, AtomUpdateConsumer consumer) throws IOException {
        this.feedId = root.getChildText("id");
        this.title = root.getChildText("title");
        this.subtitle = root.getChildText("subtitle");
        this.updatedString = root.getChildText("updated");
        XmlDomNode authorNode = root.getChild("author");
        if (authorNode != null) {
            this.author = new AtomAuthor(authorNode.getChildText("name"), authorNode.getChildText("email"), authorNode.getChildText("uri"));
        }
        String lastEntryId = null;
        if (this.entries.size() > 0) {
            AtomEntry lastEntry = (AtomEntry)this.entries.get(0);
            lastEntryId = lastEntry.getId();
        }
        int childCount = root.getChildCount();
        int index = 0;
        for (int i = 0; i < childCount; ++i) {
            XmlDomNode node = root.getChild(i);
            if (!"entry".equals(node.getName())) continue;
            AtomEntry entry = new AtomEntry(node);
            String id = entry.getId();
            if (lastEntryId != null && lastEntryId.equals(id)) break;
            this.entries.add(index, entry);
            ++index;
            if (consumer == null) continue;
            consumer.onUpdated(this, entry);
        }
    }

    public String getId() {
        return this.feedId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public TimePoint getUpdated() {
        if (this.updated == null && this.updatedString != null) {
            this.updated = TimePoint.parseRfc3339(this.updatedString);
        }
        return this.updated;
    }

    public void setUpdated(TimePoint tp) {
        this.updated = tp;
    }

    public AtomAuthor getAuthor() {
        return this.author;
    }

    public AtomEntry[] getEntries() {
        return (AtomEntry[])this.entries.toArray(new AtomEntry[this.entries.size()]);
    }

    public Object[] getEntriesAsInternalArray() {
        return this.entries.getInternalArray();
    }

    public int size() {
        return this.entries.size();
    }

    public AtomEntry getEntry(int index) {
        return (AtomEntry)this.entries.get(index);
    }

    public void update(AtomUpdateConsumer consumer, String url) {
        this.update(consumer, url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void update(AtomUpdateConsumer consumer, String url, HashMap requestProperties) {
        block25: {
            IOException e222;
            InputStream in;
            RedirectHttpConnection connection;
            block23: {
                this.isUpdating = true;
                connection = null;
                in = null;
                connection = new RedirectHttpConnection(url, requestProperties);
                in = connection.openInputStream();
                if (connection.getResponseCode() != 200) {
                    throw new IOException("response code " + connection.getResponseCode() + " for " + url);
                }
                String contentEncoding = null;
                contentEncoding = connection.getEncoding();
                if (contentEncoding == null && (contentEncoding = connection.getHeaderField("Content-Encoding")) == null) {
                    contentEncoding = "UTF-8";
                }
                this.update(in, contentEncoding, consumer);
                Object var8_8 = null;
                if (consumer != null) {
                    consumer.onUpdateFinished(this);
                }
                if (in == null) break block23;
                try {
                    in.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            this.isUpdating = false;
            {
                break block25;
                catch (Throwable e3) {
                    IOException e222;
                    if (consumer != null) {
                        consumer.onUpdateError(this, e3);
                    }
                    Object var8_9 = null;
                    if (consumer != null) {
                        consumer.onUpdateFinished(this);
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    this.isUpdating = false;
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var8_10 = null;
                if (consumer != null) {
                    consumer.onUpdateFinished(this);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                this.isUpdating = false;
                throw throwable;
            }
        }
    }

    public void updateInBackground(final AtomUpdateConsumer consumer, final String url) {
        Thread t = new Thread(){

            public void run() {
                AtomFeed.this.update(consumer, url);
            }
        };
        t.start();
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(101);
        boolean notNull = this.feedId != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.feedId);
        }
        notNull = this.title != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.title);
        }
        notNull = this.subtitle != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.subtitle);
        }
        notNull = this.getUpdated() != null;
        out.writeBoolean(notNull);
        if (notNull) {
            this.getUpdated().write(out);
        }
        notNull = this.author != null;
        out.writeBoolean(notNull);
        if (notNull) {
            this.author.write(out);
        }
        int size = this.entries.size();
        if (maxNumberOfSerializedEntries > 0 && size > maxNumberOfSerializedEntries) {
            size = maxNumberOfSerializedEntries;
        }
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            AtomEntry entry = (AtomEntry)this.entries.get(i);
            entry.write(out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 101) {
            throw new IOException("unknown verion " + version);
        }
        boolean notNull = in.readBoolean();
        if (notNull) {
            this.feedId = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.title = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.subtitle = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            if (version == 100) {
                this.updatedString = in.readUTF();
            } else {
                this.updated = new TimePoint(in);
            }
        }
        if (notNull = in.readBoolean()) {
            this.author = new AtomAuthor();
            this.author.read(in);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            AtomEntry entry = new AtomEntry();
            entry.read(in);
            this.entries.add(entry);
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }
}

