/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.format.atom;

import de.enough.polish.format.atom.AtomContentLink;
import de.enough.polish.format.atom.AtomEntryLink;
import de.enough.polish.format.atom.AtomImage;
import de.enough.polish.format.atom.AtomImageConsumer;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.RedirectHttpConnection;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.StreamUtil;
import de.enough.polish.util.TimePoint;
import de.enough.polish.xml.XmlDomNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AtomEntry
implements Externalizable {
    private static final int VERSION = 102;
    private String id;
    private String title;
    private String sourceId;
    private String sourceTitle;
    private String updatedString;
    private TimePoint updated;
    private String summary;
    private String content;
    private String contentType;
    private IdentityArrayList images;
    private IdentityArrayList linksList;
    private boolean hasLoadedImages;
    private boolean isRead;

    public AtomEntry() {
    }

    public AtomEntry(XmlDomNode node) {
        this.id = node.getChildText("id");
        this.title = node.getChildText("title");
        XmlDomNode sourceNode = node.getChild("source");
        if (sourceNode != null) {
            this.sourceId = sourceNode.getChildText("id");
            this.sourceTitle = sourceNode.getChildText("title");
        }
        this.updatedString = node.getChildText("updated");
        this.summary = node.getChildText("summary");
        XmlDomNode contNode = node.getChild("content");
        if (contNode == null) {
            contNode = node.getChild("atom:content");
        }
        if (contNode != null) {
            this.content = contNode.getText();
            this.contentType = contNode.getAttribute("type");
        }
        int childCount = node.getChildCount();
        for (int contentChildIndex = 0; contentChildIndex < childCount; ++contentChildIndex) {
            String href;
            XmlDomNode linkNode = node.getChild(contentChildIndex);
            String linkNodeName = linkNode.getName();
            if ("link".equals(linkNodeName)) {
                String href2;
                if (this.linksList == null) {
                    this.linksList = new IdentityArrayList();
                }
                AtomEntryLink link = new AtomEntryLink(linkNode);
                this.linksList.add(link);
                String type = linkNode.getAttribute("type");
                if (type == null || !type.startsWith("image") || (href2 = linkNode.getAttribute("href")) == null) continue;
                if (this.images == null) {
                    this.images = new IdentityArrayList();
                }
                this.images.add(new AtomImage(href2));
                continue;
            }
            if (!"media:thumbnail".equals(linkNodeName) || (href = linkNode.getAttribute("url")) == null) continue;
            if (this.images == null) {
                this.images = new IdentityArrayList();
            }
            this.images.add(new AtomImage(href));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceTitle() {
        return this.sourceTitle;
    }

    public TimePoint getUpdated() {
        if (this.updated == null && this.updatedString != null) {
            this.updated = TimePoint.parseRfc3339(this.updatedString);
        }
        return this.updated;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AtomContentLink[] getContentLinks() {
        int foundIndex;
        if (this.content == null) {
            return new AtomContentLink[0];
        }
        IdentityArrayList links = new IdentityArrayList();
        int startIndex = 0;
        while ((foundIndex = this.content.indexOf("<a", startIndex)) != -1) {
            int hrefIndex = this.content.indexOf("href", foundIndex + 2);
            if (hrefIndex != -1) {
                char c;
                boolean isInQuotes = false;
                StringBuffer href = new StringBuffer();
                while (hrefIndex < this.content.length()) {
                    c = this.content.charAt(hrefIndex);
                    if (c == '\"') {
                        if (isInQuotes) break;
                        isInQuotes = true;
                    } else if (isInQuotes) {
                        href.append(c);
                    }
                    ++hrefIndex;
                }
                StringBuffer description = new StringBuffer();
                isInQuotes = false;
                while (hrefIndex < this.content.length()) {
                    c = this.content.charAt(hrefIndex);
                    if (c == '>') {
                        isInQuotes = true;
                    } else {
                        if (c == '<') break;
                        if (isInQuotes) {
                            description.append(c);
                        }
                    }
                    ++hrefIndex;
                }
                links.add(new AtomContentLink(href.toString(), description.toString()));
            }
            startIndex = hrefIndex;
        }
        return (AtomContentLink[])links.toArray(new AtomContentLink[links.size()]);
    }

    public boolean hasImages() {
        return this.images != null;
    }

    public AtomImage[] getImages() {
        if (this.images == null) {
            return new AtomImage[0];
        }
        return (AtomImage[])this.images.toArray(new AtomImage[this.images.size()]);
    }

    public int getImagesSize() {
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    public Object[] getImagesAsInternalArray() {
        if (this.images == null) {
            return null;
        }
        return this.images.getInternalArray();
    }

    public boolean hasLoadedImages() {
        return this.hasLoadedImages;
    }

    public void loadImages(AtomImageConsumer consumer) {
        this.loadImages(consumer, null);
    }

    public void loadImages(AtomImageConsumer consumer, HashMap requestProperties) {
        if (this.images == null) {
            if (consumer != null) {
                consumer.onAtomImageLoadFinished(this);
            }
            return;
        }
        InputStream in = null;
        RedirectHttpConnection connection = null;
        for (int i = 0; i < this.images.size(); ++i) {
            AtomImage image = (AtomImage)this.images.get(i);
            String url = image.getUrl();
            try {
                connection = new RedirectHttpConnection(url, requestProperties);
                in = connection.openInputStream();
                if (connection.getResponseCode() != 200) {
                    throw new IOException("response code " + connection.getResponseCode() + " for " + url);
                }
                byte[] data = StreamUtil.readFully(in);
                image.setData(data);
                if (consumer != null) {
                    consumer.onAtomImageLoaded(image, this);
                }
                try {
                    in.close();
                    in = null;
                    connection.close();
                    connection = null;
                }
                catch (Exception e) {}
                continue;
            }
            catch (Throwable e) {
                if (consumer == null) continue;
                consumer.onAtomImageLoadError(image, this, e);
            }
        }
        if (consumer != null) {
            consumer.onAtomImageLoadFinished(this);
        }
        this.hasLoadedImages = true;
    }

    public AtomEntryLink[] getLinks() {
        if (this.linksList == null) {
            return new AtomEntryLink[0];
        }
        return (AtomEntryLink[])this.linksList.toArray(new AtomEntryLink[this.linksList.size()]);
    }

    public int getLinksSize() {
        if (this.linksList == null) {
            return 0;
        }
        return this.linksList.size();
    }

    public Object[] getLinksAsInternalArray() {
        if (this.linksList == null) {
            return null;
        }
        return this.linksList.getInternalArray();
    }

    public AtomEntryLink getLink(String rel, String type) {
        AtomEntryLink link;
        if (this.linksList == null) {
            return null;
        }
        Object[] links = this.linksList.getInternalArray();
        for (int i = 0; i < links.length && (link = (AtomEntryLink)links[i]) != null; ++i) {
            boolean isMatching = true;
            if (rel != null && !rel.equals(link.getRel())) {
                isMatching = false;
            }
            if (isMatching && type != null && !type.equals(link.getType())) {
                isMatching = false;
            }
            if (!isMatching) continue;
            return link;
        }
        return null;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean markRead() {
        return this.setRead(true);
    }

    public boolean setRead(boolean isRead) {
        if (this.isRead != isRead) {
            this.isRead = isRead;
            return true;
        }
        return false;
    }

    public void write(DataOutputStream out) throws IOException {
        int i;
        int size;
        out.writeInt(102);
        boolean notNull = this.id != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.id);
        }
        notNull = this.title != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.title);
        }
        notNull = this.updatedString != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.updatedString);
        }
        notNull = this.summary != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.summary);
        }
        notNull = this.content != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.content);
        }
        notNull = this.images != null;
        out.writeBoolean(notNull);
        if (notNull) {
            size = this.images.size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                AtomImage image = (AtomImage)this.images.get(i);
                image.write(out);
            }
        }
        out.writeBoolean(this.isRead);
        notNull = this.linksList != null;
        out.writeBoolean(notNull);
        if (notNull) {
            size = this.linksList.size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                AtomEntryLink link = (AtomEntryLink)this.linksList.get(i);
                link.write(out);
            }
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size;
        int version = in.readInt();
        if (version > 102) {
            throw new IOException("unknown verion " + version);
        }
        boolean notNull = in.readBoolean();
        if (notNull) {
            this.id = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.title = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.updatedString = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.summary = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            this.content = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            size = in.readInt();
            this.images = new IdentityArrayList(size);
            boolean dataLoaded = false;
            for (int i = 0; i < size; ++i) {
                AtomImage image = new AtomImage();
                image.read(in);
                this.images.add(image);
                if (image.getData() == null) continue;
                dataLoaded = true;
            }
            this.hasLoadedImages = dataLoaded;
        }
        if (version > 100) {
            this.isRead = in.readBoolean();
        }
        if (version > 101 && (notNull = in.readBoolean())) {
            size = in.readInt();
            this.linksList = new IdentityArrayList(size);
            for (int i = 0; i < size; ++i) {
                AtomEntryLink link = new AtomEntryLink();
                link.read(in);
                this.linksList.add(link);
            }
        }
    }

    public void setImages(AtomImage[] images) {
        if (images == null) {
            this.images = null;
            this.hasLoadedImages = false;
        } else {
            boolean isLoaded = true;
            if (this.images == null) {
                this.images = new IdentityArrayList();
            } else {
                this.images.clear();
            }
            for (int i = 0; i < images.length; ++i) {
                AtomImage atomImage = images[i];
                this.images.add(atomImage);
                if (!isLoaded || atomImage.getData() != null) continue;
                isLoaded = false;
            }
            this.hasLoadedImages = isLoaded;
        }
    }
}

