/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.event.EventListener;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.util.Hashtable;

public class EventManager {
    public static final String EVENT_PRESS = "press";
    public static final String EVENT_UNPRESS = "unpress";
    public static final String EVENT_FOCUS = "focus";
    public static final String EVENT_DEFOCUS = "defocus";
    public static final String EVENT_SHOW = "show";
    public static final String EVENT_SHOW_FIRST_TIME = "show-first";
    public static final String EVENT_HIDE = "hide";
    public static final String EVENT_VALUE_CHANGE = "value-change";
    public static final String EVENT_MENU_CLOSE = "menu-close";
    public static final String EVENT_MENU_OPEN = "menu-open";
    public static final String EVENT_VISIT = "visit";
    public static final String EVENT_UNVISIT = "unvisit";
    public static final String EVENT_POINTER_HANDLED = "touch-handled";
    public static final String EVENT_KEY_HANDLED = "key-handled";
    private static EventManager INSTANCE = new EventManager();
    private final Hashtable eventListenersByEvent = new Hashtable();
    private final ArrayList generalPurposeListeners = new ArrayList();
    private Hashtable remappedEventsByName;

    private EventManager() {
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public static EventManager createNewInstance() {
        return new EventManager();
    }

    public static void fireEvent(String name, Object source, Object data) {
        Object[] sources;
        INSTANCE.fireEventImpl(name, source, data);
        if (EventManager.INSTANCE.remappedEventsByName != null && (sources = (Object[])EventManager.INSTANCE.remappedEventsByName.get(name)) != null) {
            for (int i = 0; i < sources.length; ++i) {
                Object altSource = sources[i];
                INSTANCE.fireEventImpl(name, altSource, data);
            }
        }
    }

    private void fireEventImpl(String name, Object source, Object data) {
        EventListener listener;
        Object[] generalListeners = this.generalPurposeListeners.getInternalArray();
        for (int i = 0; i < generalListeners.length && (listener = (EventListener)generalListeners[i]) != null; ++i) {
            try {
                listener.handleEvent(name, source, data);
                continue;
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.event.EventManager", 148, (Object)("Unable to forward event " + name + " to " + listener), e);
            }
        }
        EventListener[] listeners = (EventListener[])this.eventListenersByEvent.get(name);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                EventListener listener2 = listeners[i];
                try {
                    listener2.handleEvent(name, source, data);
                    continue;
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.event.EventManager", 159, (Object)("Unable to forward event " + name + " to " + listener2), e);
                }
            }
        }
    }

    public void addEventListener(String eventName, EventListener listener) {
        if (eventName == null) {
            this.generalPurposeListeners.add(listener);
        } else {
            EventListener[] listeners = (EventListener[])this.eventListenersByEvent.get(eventName);
            if (listeners == null) {
                this.eventListenersByEvent.put(eventName, new EventListener[]{listener});
            } else {
                EventListener[] newListeners = new EventListener[listeners.length + 1];
                System.arraycopy(listeners, 0, newListeners, 0, listeners.length);
                newListeners[listeners.length] = listener;
                this.eventListenersByEvent.put(eventName, newListeners);
            }
        }
    }

    public void remapEvent(String eventName, Object alternativeSource) {
        Object[] sources;
        if (this.remappedEventsByName == null) {
            this.remappedEventsByName = new Hashtable();
        }
        if ((sources = (Object[])this.remappedEventsByName.get(eventName)) == null) {
            this.remappedEventsByName.put(eventName, new Object[]{alternativeSource});
        } else {
            Object[] newSources = new Object[sources.length + 1];
            System.arraycopy(sources, 0, newSources, 0, sources.length);
            newSources[sources.length] = alternativeSource;
            this.remappedEventsByName.put(eventName, newSources);
        }
    }

    public void removeRemapEvent(String eventName) {
        if (this.remappedEventsByName == null) {
            return;
        }
        this.remappedEventsByName.remove(eventName);
    }

    public void removeRemapEvent(String eventName, Object alternativeSource) {
        if (this.remappedEventsByName == null) {
            return;
        }
        Object[] sources = (Object[])this.remappedEventsByName.remove(eventName);
        if (sources == null) {
            return;
        }
        if (sources.length == 1) {
            return;
        }
        Object[] altSources = new Object[sources.length - 1];
        int fillIndex = 0;
        for (int i = 0; i < sources.length; ++i) {
            Object source = sources[i];
            if (source == alternativeSource) continue;
            altSources[i] = source;
            ++fillIndex;
        }
        this.remappedEventsByName.put(eventName, altSources);
    }

    public void removeAllRemappings() {
        this.remappedEventsByName = null;
    }
}

