/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content.storage;

import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.storage.StorageReference;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.Comparator;
import de.enough.polish.util.ToStringHelper;

public class StorageIndex
implements Comparator {
    protected ArrayList index;
    long cacheSize = 0L;
    final long maxCacheSize;
    boolean isPrepared;

    public StorageIndex(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.index = new ArrayList();
        this.isPrepared = false;
    }

    public void prepare() {
        ArrayList loadedIndex = this.load();
        if (loadedIndex != null) {
            for (int i = 0; i < loadedIndex.size(); ++i) {
                this.addToIndex((StorageReference)loadedIndex.get(i));
            }
        }
        this.isPrepared = true;
    }

    void addToIndex(StorageReference reference) {
        this.index.add(reference);
        this.cacheSize += (long)reference.size();
    }

    void removeFromIndex(StorageReference reference) {
        this.cacheSize -= (long)reference.size();
        this.index.remove(reference);
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void addReference(StorageReference reference) {
        this.addToIndex(reference);
        this.store(this.index);
    }

    public void removeReference(StorageReference reference) {
        this.removeFromIndex(reference);
        this.store(this.index);
    }

    public int getDisposableIndex() {
        int currentDisposableIndex = 0;
        if (this.index.size() == 0) {
            return 0;
        }
        int minPrioritySoFar = ((StorageReference)this.index.get(0)).getPriority();
        int currentPriority = 0;
        for (int i = 0; i < this.index.size(); ++i) {
            currentPriority = ((StorageReference)this.index.get(i)).getPriority();
            if (currentPriority >= minPrioritySoFar) continue;
            minPrioritySoFar = currentPriority;
            currentDisposableIndex = i;
        }
        return currentDisposableIndex;
    }

    public StorageReference getReference(int i) {
        return (StorageReference)this.index.get(i);
    }

    public int size() {
        return this.index.size();
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    protected ArrayList load() {
        return null;
    }

    protected void store(ArrayList index) {
    }

    public StorageReference getReference(ContentDescriptor descriptor) {
        int index = this.index.indexOf(descriptor);
        if (index != -1) {
            return (StorageReference)this.index.get(index);
        }
        return null;
    }

    public boolean isCleanNeeded() {
        return this.getCacheSize() > this.maxCacheSize;
    }

    public int compare(Object first, Object second) {
        StorageReference reference = (StorageReference)first;
        StorageReference master = (StorageReference)second;
        if (this.isDisposableTo(reference, master)) {
            return -1;
        }
        return 1;
    }

    public boolean isDisposableTo(StorageReference reference, StorageReference master) {
        return reference.getPriority() <= master.getPriority() && reference.getCreationTime() < master.getCreationTime();
    }

    public void applyOrder() {
        this.index.trimToSize();
        Arrays.shellSort(this.index.getInternalArray(), this);
    }

    public void shutdown() {
    }

    public String toString() {
        return ToStringHelper.createInstance("StorageIndex").set("cacheSize", this.cacheSize).set("maxCacheSize", this.maxCacheSize).set("isPrepared", this.isPrepared).set("index", this.index).toString();
    }
}

