/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content.source;

import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.ContentException;
import de.enough.polish.content.filter.ContentFilter;
import de.enough.polish.content.storage.StorageIndex;
import de.enough.polish.content.storage.StorageReference;
import de.enough.polish.content.transform.ContentTransform;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.ToStringHelper;
import java.io.IOException;

public abstract class ContentSource {
    final String id;
    final StorageIndex storageIndex;
    final ArrayList sources = new ArrayList();
    final HashMap transformers = new HashMap();
    ContentFilter filter;

    public ContentSource(String id) {
        this(id, null);
    }

    public ContentSource(String id, StorageIndex index) {
        this.id = id;
        this.storageIndex = index;
    }

    public void attachSource(ContentSource source) {
        if (this.sources.size() > 0 && !this.hasFiltersComplete()) {
            throw new IllegalArgumentException("please add filters to all used source for " + this);
        }
        this.sources.add(source);
    }

    boolean hasFiltersComplete() {
        for (int i = 0; i < this.sources.size(); ++i) {
            ContentSource source = (ContentSource)this.sources.get(i);
            if (source.getFilter() != null) continue;
            return false;
        }
        return true;
    }

    public void detachSource(ContentSource source) {
        this.sources.remove(source);
    }

    public void setContentFilter(ContentFilter filter) {
        this.filter = filter;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public void addContentTransform(ContentTransform transformer) {
        String id = transformer.getTransformId();
        if (id.equals(ContentDescriptor.TRANSFORM_NONE) || this.transformers.containsKey(id)) {
            // empty if block
        }
        this.transformers.put(id, transformer);
    }

    public void removeContentTransform(ContentTransform transformer) {
        String id = transformer.getTransformId();
        this.transformers.remove(id);
    }

    public Object loadContent(ContentDescriptor descriptor) throws ContentException {
        Object data = this.loadContentData(descriptor);
        if (data == null) {
            if (this.sources.size() > 0) {
                for (int index = 0; index < this.sources.size(); ++index) {
                    ContentSource source = (ContentSource)this.sources.get(index);
                    ContentFilter filter = source.getFilter();
                    if (filter != null && !filter.filter(descriptor) || (data = source.loadContent(descriptor)) == null) continue;
                    data = this.transformContent(descriptor, data);
                    if (descriptor.getCachingPolicy() == ContentDescriptor.CACHING_READ_WRITE) {
                        this.storeContent(descriptor, data);
                    }
                    return data;
                }
            } else {
                String message = this.getClass().getName() + " : no source found, please add a source";
                throw new ContentException(message);
            }
            String message = this.getClass().getName() + " : no source is applicable due to their filtering";
            throw new ContentException(message);
        }
        return data;
    }

    protected Object transformContent(ContentDescriptor descriptor, Object data) {
        ContentTransform transformer;
        if (this.transformers.size() > 0 && descriptor.getTransformID() != ContentDescriptor.TRANSFORM_NONE && !(data instanceof ContentException) && (transformer = (ContentTransform)this.transformers.get(descriptor.getTransformID())) != null) {
            try {
                data = transformer.transformContent(data);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.content.source.ContentSource", 242, (Object)("error transforming " + descriptor + ":"), e);
            }
            return data;
        }
        return data;
    }

    protected Object loadContentData(ContentDescriptor descriptor) throws ContentException {
        if (this.hasStorage()) {
            StorageReference reference;
            if (!this.storageIndex.isPrepared()) {
                this.storageIndex.prepare();
            }
            if ((reference = this.storageIndex.getReference(descriptor)) != null) {
                reference.updateActivity();
                return this.loadContent(descriptor, reference);
            }
        }
        return this.loadContent(descriptor, null);
    }

    boolean hasStorage() {
        return this.storageIndex != null;
    }

    protected Object loadContent(ContentDescriptor descriptor, StorageReference reference) throws ContentException {
        if (reference != null && reference.getVersion() != descriptor.getVersion()) {
            this.destroyContent(descriptor);
            return null;
        }
        try {
            if (reference != null) {
                return this.load(reference);
            }
            return this.load(descriptor);
        }
        catch (IOException e) {
            String message = this.getClass().getName() + " : " + e;
            throw new ContentException(message);
        }
    }

    protected abstract Object[] storeContentAndGetDataSize(ContentDescriptor var1, Object var2) throws IOException;

    protected void storeContent(ContentDescriptor descriptor, Object data) throws ContentException {
        try {
            if (this.hasStorage()) {
                Object reference;
                int size;
                Object[] result = this.storeContentAndGetDataSize(descriptor, data);
                if (result != null) {
                    size = (Integer)result[0];
                    reference = result[1];
                } else {
                    size = this.getSize(descriptor, data);
                    reference = this.store(descriptor, data);
                }
                this.storageIndex.addReference(new StorageReference(descriptor, size, reference));
            }
        }
        catch (IOException e) {
            String message = "error storing content : " + e;
            throw new ContentException(message);
        }
        this.clean();
    }

    protected void destroyContent(ContentDescriptor descriptor) throws ContentException {
        StorageReference reference;
        if (this.hasStorage() && (reference = this.storageIndex.getReference(descriptor)) != null) {
            this.storageIndex.removeReference(reference);
            try {
                this.destroy(reference);
            }
            catch (IOException e) {
                String message = "error destroying content : " + e;
                throw new ContentException(message);
            }
        }
    }

    public void clean() throws ContentException {
        if (this.hasStorage()) {
            if (!this.storageIndex.isCleanNeeded()) {
                return;
            }
            if (this.storageIndex.size() == 0) {
                return;
            }
            this.storageIndex.applyOrder();
            do {
                int index = this.storageIndex.getDisposableIndex();
                StorageReference reference = this.storageIndex.getReference(index);
                this.destroyContent(reference);
            } while (this.storageIndex.isCleanNeeded());
        }
    }

    public StorageIndex getStorageIndex() {
        return this.storageIndex;
    }

    protected int getSize(ContentDescriptor descriptor, Object data) throws ContentException {
        int dataSize = Integer.MIN_VALUE;
        String transformId = descriptor.getTransformID();
        ContentTransform transform = (ContentTransform)this.transformers.get(transformId);
        if (transform != null) {
            dataSize = transform.calculateDataSize(data);
            return dataSize;
        }
        if (dataSize == Integer.MIN_VALUE && data instanceof byte[]) {
            return ((byte[])data).length;
        }
        throw new ContentException("unable to determine size of " + data);
    }

    protected abstract Object load(ContentDescriptor var1) throws IOException;

    protected abstract Object load(StorageReference var1) throws IOException;

    protected abstract Object store(ContentDescriptor var1, Object var2) throws IOException;

    protected abstract void destroy(StorageReference var1) throws IOException;

    public void sweep(boolean includeSources) throws ContentException {
        if (this.hasStorage()) {
            while (this.storageIndex.size() > 0) {
                StorageReference reference = this.storageIndex.getReference(0);
                this.destroyContent(reference);
            }
        }
        if (includeSources) {
            for (int index = 0; index < this.sources.size(); ++index) {
                ContentSource source = (ContentSource)this.sources.get(index);
                source.sweep(true);
            }
        }
    }

    protected void shutdown() {
        if (this.hasStorage()) {
            this.storageIndex.shutdown();
        }
        for (int index = 0; index < this.sources.size(); ++index) {
            ContentSource source = (ContentSource)this.sources.get(index);
            source.shutdown();
        }
    }

    public String toString() {
        return ToStringHelper.createInstance("ContentSource").set("id", this.id).set("sources", this.sources).set("transformers", this.transformers).set("filter", this.filter).toString();
    }

    public void info(String info) {
        System.out.println(this.id + " : " + info);
    }
}

