/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.calendar.CalendarEntryList;
import de.enough.polish.calendar.CalendarEntryModel;
import de.enough.polish.calendar.CalendarRenderer;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.TextUtil;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;
import java.util.Calendar;
import java.util.Date;

public class CalendarItem
extends TableItem {
    public static final int SHOW_MODE_LABEL = 0;
    public static final int SHOW_MODE_TITLE = 1;
    public static final int SHOW_MODE_ITEM = 2;
    public static final int SHOW_MODE_NONE = 3;
    private static int FIRST_DAY_OF_WEEK = 2;
    private static String WEEKDAY_ABBREVIATIONS = "M,T,W,T,F,S,S";
    private static String MONTHS = "January,February,March,April,May,June,July,August,September,October,November,December";
    private TimePoint originalDay;
    private TimePoint shownMonth;
    private int showMode;
    private Style calendarWeekdayStyle;
    private Style calendarDayInactiveStyle;
    private Style calendarDayStyle;
    private Style calendarCurrentdayStyle;
    private Style calendarDayInvalidStyle;
    private CalendarEntryModel model;
    private boolean isLimitToEnabledEntries;
    private CalendarRenderer renderer;
    private TimePoint firstColumnFirstRowDay;
    private boolean isEditable = true;
    private boolean isBuild;
    private TimePeriod validPeriod;
    private Command cmdDayDefault;
    private boolean calendarInactiveDaysAreInteractice = true;
    private boolean isMonthNameSelectable;
    private Style monthNameStyle;
    private boolean isMonthNameFocused;

    public static int getFirstDayOfWeek() {
        return FIRST_DAY_OF_WEEK;
    }

    public static void setFirstDayOfWeek(int firstDayOfWeek) {
        FIRST_DAY_OF_WEEK = firstDayOfWeek;
    }

    public static String getWeekDayAbbreviations() {
        return WEEKDAY_ABBREVIATIONS;
    }

    public static void setWeekDayAbbreviations(String abbreviations) {
        WEEKDAY_ABBREVIATIONS = abbreviations;
    }

    public static String getMonths() {
        return MONTHS;
    }

    public static void setMonths(String months) {
        MONTHS = months;
    }

    public CalendarItem() {
        this(TimePoint.now(), null, null);
    }

    public CalendarItem(Style style) {
        this(TimePoint.now(), null, style);
    }

    public CalendarItem(Calendar cal) {
        this(cal, null);
    }

    public CalendarItem(Calendar cal, Style style) {
        this(new TimePoint(cal), null, style);
    }

    public CalendarItem(TimePoint timePoint) {
        this(timePoint, null, null);
    }

    public CalendarItem(TimePoint originalDay, Style style) {
        this(originalDay, null, style);
    }

    public CalendarItem(TimePoint originalDay, CalendarEntryModel model) {
        this(originalDay, model, null);
    }

    public CalendarItem(TimePoint originalDay, CalendarEntryModel model, Style style) {
        super(7, 7, style);
        this.model = model;
        this.originalDay = originalDay;
        String[] abbreviations = TextUtil.split(WEEKDAY_ABBREVIATIONS, ',');
        for (int i = 0; i < abbreviations.length; ++i) {
            String abbreviation = abbreviations[i];
            StringItem item = new StringItem(null, abbreviation, StyleSheet.calendarweekdayStyle);
            this.set(i, 0, item);
        }
        this.shownMonth = new TimePoint(originalDay);
        this.setSelectionMode(10);
    }

    protected void buildCalendar(TimePoint forMonth) {
        int col;
        Screen scr;
        this.shownMonth = forMonth;
        this.ignoreRepaintRequests = true;
        this.isBuild = true;
        int selRow = this.getSelectedRow();
        int selCol = this.getSelectedColumn();
        int currentMonth = forMonth.getMonth();
        int currentYear = forMonth.getYear();
        String infoText = TextUtil.split(MONTHS, ',')[currentMonth] + " " + currentYear;
        if (this.showMode == 0) {
            this.setLabel(infoText);
        } else if (this.showMode == 1 && (scr = this.getScreen()) != null) {
            scr.setTitle(infoText);
        }
        TimePoint day = new TimePoint(forMonth);
        day.setDay(1);
        int dayOfWeek = day.getDayOfWeek();
        for (col = this.getColumn(dayOfWeek); col > 0; --col) {
            day.addDay(-1);
        }
        this.firstColumnFirstRowDay = new TimePoint(day);
        CalendarEntryList eventsList = null;
        CalendarEntry[] entriesForTheDay = null;
        if (this.model != null) {
            int daysToAdd = 7 * (this.getNumberOfRows() - 1) + 1;
            TimePoint endDate = new TimePoint(day);
            endDate.addDay(daysToAdd);
            TimePeriod period = new TimePeriod(day, true, endDate, false);
            eventsList = this.isLimitToEnabledEntries ? this.model.getEnabledEntries(period) : this.model.getEntries(period);
        }
        for (int row = 1; row < this.getNumberOfRows(); ++row) {
            for (col = 0; col < 7; ++col) {
                if (eventsList != null) {
                    entriesForTheDay = eventsList.getEntriesForDay(day);
                }
                Item item = this.createCalendaryDay(day, forMonth, this.originalDay, entriesForTheDay, col, row);
                this.set(col, row, item);
                day.addDay(1);
            }
        }
        this.ignoreRepaintRequests = false;
        if (selCol != -1 && selRow != -1) {
            this.setSelectedCell(selCol, selRow);
        } else if (!this.isMonthNameFocused && this.shownMonth.equalsMonth(this.originalDay)) {
            this.go(this.originalDay);
        }
        if (this.availableWidth != 0) {
            this.init(this.availableWidth, this.availableWidth, this.availableHeight);
        }
        this.repaint();
    }

    protected Item createCalendaryDay(TimePoint day, TimePoint currentMonth, TimePoint originalCurrentDay, CalendarEntry[] entriesForTheDay, int col, int row) {
        Item item = this.renderer != null ? this.renderer.createCalendaryDay(day, currentMonth, originalCurrentDay, entriesForTheDay, this) : CalendarItem.createCalendaryDay(day, currentMonth, originalCurrentDay, entriesForTheDay, this);
        if (this.cmdDayDefault != null && day.equalsMonth(currentMonth) && item.getDefaultCommand() == null) {
            item.setDefaultCommand(this.cmdDayDefault);
        }
        if (this.validPeriod != null && !this.validPeriod.matches(day, TimePeriod.SCOPE_DAY)) {
            item.setAppearanceMode(0);
        }
        return item;
    }

    public static Item createCalendaryDay(TimePoint day, TimePoint currentMonth, TimePoint originalCurrentDay, CalendarEntry[] entriesForTheDay, CalendarItem parent) {
        StringItem item;
        boolean dayIsInteractive = true;
        if (!day.equalsMonth(currentMonth)) {
            item = new StringItem(null, Integer.toString(day.getDay()), StyleSheet.calendardayinactiveStyle);
            if (parent != null) {
                if (parent.calendarDayInactiveStyle != null) {
                    item.setStyle(parent.calendarDayInactiveStyle);
                }
                if (!parent.calendarInactiveDaysAreInteractice) {
                    dayIsInteractive = false;
                }
            }
        } else if (day.equalsDay(originalCurrentDay)) {
            item = new StringItem(null, Integer.toString(day.getDay()), StyleSheet.calendarcurrentdayStyle);
            if (parent != null && parent.calendarCurrentdayStyle != null) {
                item.setStyle(parent.calendarCurrentdayStyle);
            }
        } else {
            item = new StringItem(null, Integer.toString(day.getDay()), StyleSheet.calendardayStyle);
            if (parent != null) {
                if (parent.validPeriod != null && parent.calendarDayInvalidStyle != null && !parent.validPeriod.matches(day, TimePeriod.SCOPE_DAY)) {
                    item.setStyle(parent.calendarDayInvalidStyle);
                } else if (parent.calendarDayStyle != null) {
                    item.setStyle(parent.calendarDayStyle);
                }
            }
        }
        if (dayIsInteractive && (parent == null || parent.selectionMode != 0)) {
            item.setAppearanceMode(3);
        }
        return item;
    }

    public void setRenderer(CalendarRenderer renderer) {
        this.renderer = renderer;
        if (renderer != null && this.isBuild) {
            this.buildCalendar(this.shownMonth);
        }
    }

    public void setDayDefaultCommand(Command cmd) {
        this.cmdDayDefault = cmd;
    }

    public int getColumn(TimePoint day) {
        return this.getColumn(day.getDayOfWeek());
    }

    public int getRow(TimePoint day) {
        int daysFromStart = day.getDay();
        day.setDay(1);
        int col = this.getColumn(day) - 1;
        day.setDay(daysFromStart);
        return (daysFromStart += col) / 7 + 1;
    }

    private int getColumn(int dayOfWeek) {
        return dayOfWeek >= FIRST_DAY_OF_WEEK ? dayOfWeek - FIRST_DAY_OF_WEEK : 7 + dayOfWeek - FIRST_DAY_OF_WEEK;
    }

    private String getDayOfWeekName(int dayOfWeek) {
        String[] days = new String[]{null, "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        return days[dayOfWeek];
    }

    public int getDaysInMonth() {
        return this.shownMonth.getDaysInMonth();
    }

    public static int getDaysInMonth(Calendar cal) {
        TimePoint point = new TimePoint(cal);
        return point.getDaysInMonth();
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.isMonthNameFocused) {
            if (gameAction == 2) {
                return this.goPreviousMonth();
            }
            if (gameAction == 5) {
                return this.goNextMonth();
            }
            if (gameAction == 6) {
                UiAccess.defocus(this.label, this.monthNameStyle);
                this.isMonthNameFocused = false;
                this.shownMonth.setDay(1);
                this.go(this.shownMonth);
                return true;
            }
            return false;
        }
        boolean handled = super.handleKeyPressed(keyCode, gameAction);
        if (!handled && this.isInteractive()) {
            if (gameAction == 2 || gameAction == 1) {
                int col;
                Object o;
                int selectedRow;
                if (gameAction == 2 && this.getSelectedColumn() == 0 && (selectedRow = this.getSelectedRow()) > 1 && (o = this.get(col = 6, --selectedRow)) instanceof Item && ((Item)o).isInteractive()) {
                    this.setSelectedCell(col, selectedRow);
                    return true;
                }
                if (this.isMonthNameSelectable && gameAction == 1) {
                    this.monthNameStyle = UiAccess.focus(this.label, 0, null);
                    this.isMonthNameFocused = true;
                    this.setSelectedCell(-1, -1);
                    return true;
                }
                return this.goPreviousMonth();
            }
            if (gameAction == 5 || gameAction == 6) {
                int col;
                Object o;
                int selectedRow;
                if (gameAction == 5 && this.getSelectedColumn() == 6 && (selectedRow = this.getSelectedRow()) < 6 && (o = this.get(col = 0, ++selectedRow)) instanceof Item && ((Item)o).isInteractive()) {
                    this.setSelectedCell(col, selectedRow);
                    return true;
                }
                return this.goNextMonth();
            }
        }
        return handled;
    }

    public boolean goNextMonth() {
        TimePeriod range = this.validPeriod;
        TimePoint nextMonth = range == null ? this.shownMonth : new TimePoint(this.shownMonth);
        nextMonth.addMonth(1);
        nextMonth.setDay(1);
        if (range == null || range.matches(nextMonth, TimePeriod.SCOPE_DAY)) {
            this.buildCalendar(nextMonth);
            if (!this.isMonthNameFocused) {
                this.go(nextMonth);
            }
            return true;
        }
        return false;
    }

    public boolean goPreviousMonth() {
        TimePeriod range = this.validPeriod;
        TimePoint nextMonth = range == null ? this.shownMonth : new TimePoint(this.shownMonth);
        nextMonth.addMonth(-1);
        if (range != null) {
            nextMonth.setDay(nextMonth.getDaysInMonth());
            if (!range.matches(nextMonth, TimePeriod.SCOPE_DAY)) {
                return false;
            }
        }
        nextMonth.setDay(1);
        this.buildCalendar(nextMonth);
        if (!this.isMonthNameFocused) {
            if (range != null && range.getStart().equalsMonth(nextMonth)) {
                nextMonth.setDay(nextMonth.getDaysInMonth());
            }
            this.go(nextMonth);
        }
        return true;
    }

    public void go(TimePoint day) {
        if (this.validPeriod != null && !this.validPeriod.matches(day, TimePeriod.SCOPE_DAY)) {
            if (day.equalsMonth(this.validPeriod.getStart()) || day.isBefore(this.validPeriod.getStart(), TimePeriod.SCOPE_DAY)) {
                day.setDate(this.validPeriod.getStart());
                if (!this.validPeriod.isIncludeStart()) {
                    day.addDay(1);
                }
            } else {
                day.setDate(this.validPeriod.getEnd());
                if (!this.validPeriod.isIncludeEnd()) {
                    day.addDay(-1);
                }
            }
        }
        if (this.isBuild) {
            if (!day.equalsMonth(this.shownMonth)) {
                this.buildCalendar(day);
            }
            int col = this.getColumn(day);
            int row = this.getRow(day);
            this.setSelectedCell(col, row);
        } else {
            this.originalDay = day;
            this.shownMonth = new TimePoint(day);
        }
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        if (this.isInteractive() && relY <= this.contentY && relY >= 0) {
            if (relX <= this.itemWidth / 2) {
                this.goPreviousMonth();
                return true;
            }
            if (relX <= this.itemWidth) {
                this.goNextMonth();
                return true;
            }
        } else if (this.isMonthNameFocused) {
            UiAccess.defocus(this.label, this.monthNameStyle);
            this.isMonthNameFocused = false;
            this.shownMonth.setDay(1);
            this.go(this.shownMonth);
        }
        return super.handlePointerReleased(relX, relY);
    }

    public TimePoint getCellTimePoint(int row, int col) {
        if (this.firstColumnFirstRowDay == null) {
            TimePoint day = new TimePoint(this.originalDay);
            day.setDay(1);
            int dayOfWeek = day.getDayOfWeek();
            for (int daycol = this.getColumn(dayOfWeek); daycol > 0; --daycol) {
                day.addDay(-1);
            }
            this.firstColumnFirstRowDay = new TimePoint(day);
        }
        TimePoint tp = new TimePoint(this.firstColumnFirstRowDay);
        tp.addDay(row * 7 + col);
        return tp;
    }

    public Calendar getCellCalendar(int row, int col) {
        return this.getCellTimePoint(row, col).getAsCalendar();
    }

    public TimePoint getSelectedTimePoint() {
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow() - 1;
        return this.getCellTimePoint(row, col);
    }

    public Calendar getSelectedCalendar() {
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow() - 1;
        return this.getCellCalendar(row, col);
    }

    public Date getSelectedDate() {
        return this.getSelectedCalendar().getTime();
    }

    public void setEditable(boolean isInteractive) {
        this.isEditable = isInteractive;
        if (isInteractive) {
            this.setAppearanceMode(3);
        } else {
            this.setAppearanceMode(0);
        }
    }

    public void setMonthNameSelectable(boolean isSelectable) {
        this.isMonthNameSelectable = isSelectable;
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        if (!this.isBuild) {
            this.buildCalendar(this.shownMonth);
        }
        super.initContent(firstLineWidth, availWidth, availHeight);
        if (!this.isEditable || this.selectionMode == 0) {
            this.appearanceMode = 0;
        }
    }

    public Style getCalendarWeekdayStyle() {
        return this.calendarWeekdayStyle;
    }

    public void setCalendarWeekdayStyle(Style calendarWeekdayStyle) {
        this.calendarWeekdayStyle = calendarWeekdayStyle;
    }

    public Style getCalendarDayInactiveStyle() {
        return this.calendarDayInactiveStyle;
    }

    public void setCalendarDayInactiveStyle(Style calendarDayInactiveStyle) {
        this.calendarDayInactiveStyle = calendarDayInactiveStyle;
    }

    public Style getCalendarDayStyle() {
        return this.calendarDayStyle;
    }

    public void setCalendarDayStyle(Style calendarDayStyle) {
        this.calendarDayStyle = calendarDayStyle;
    }

    public Style getCalendarCurrentdayStyle() {
        return this.calendarCurrentdayStyle;
    }

    public void setCalendarCurrentdayStyle(Style calendarCurrentdayStyle) {
        this.calendarCurrentdayStyle = calendarCurrentdayStyle;
    }

    public void setCalendarInactiveDaysAreInteractive(boolean isInteractive) {
        this.calendarInactiveDaysAreInteractice = isInteractive;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        Style dayInactiveStyle = (Style)style.getObjectProperty(407);
        if (dayInactiveStyle != null) {
            this.calendarDayInactiveStyle = dayInactiveStyle;
        }
        Style dayInvalidStyle = (Style)style.getObjectProperty(480);
        if (dayInactiveStyle != null) {
            this.calendarDayInvalidStyle = dayInvalidStyle;
        }
    }

    public void setStyleCurrentDay(Style dayStyle) {
        this.calendarCurrentdayStyle = dayStyle;
    }

    public void setStyleInactiveDay(Style dayStyle) {
        this.calendarDayInactiveStyle = dayStyle;
    }

    public void setStyleDay(Style dayStyle) {
        this.calendarDayStyle = dayStyle;
    }

    public void setStyleInvalidDay(Style dayStyle) {
        this.calendarDayInvalidStyle = dayStyle;
    }

    public int getShownMonth() {
        return this.shownMonth.getMonth();
    }

    public TimePoint getShownTimePoint() {
        return this.shownMonth;
    }

    public void setModel(CalendarEntryModel model) {
        this.model = model;
        if (this.renderer != null && this.isBuild) {
            this.buildCalendar(this.shownMonth);
        }
    }

    public CalendarEntryModel getModel() {
        return this.model;
    }

    public void setModelLimitToEnabledCategories(boolean limit) {
        this.isLimitToEnabledEntries = limit;
    }

    public void setShowMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException();
        }
        if (mode != this.showMode) {
            this.showMode = mode;
            if (this.isInitialized()) {
                this.requestInit();
            }
        }
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setValidPeriod(TimePeriod validPeriod) {
        TimePoint tp;
        this.validPeriod = validPeriod;
        if (validPeriod != null && this.isBuild && !validPeriod.matches(tp = this.getSelectedTimePoint(), TimePeriod.SCOPE_DAY)) {
            if (tp.isBefore(validPeriod.getStart(), TimePeriod.SCOPE_DAY)) {
                this.go(validPeriod.getStart());
            } else {
                this.go(validPeriod.getEnd());
            }
        }
    }

    public TimePeriod getValidPeriod() {
        return this.validPeriod;
    }
}

