/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.calendar.CalendarCategory;
import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.calendar.CalendarEntryList;
import de.enough.polish.calendar.CalendarObserver;
import de.enough.polish.calendar.CalendarSubject;
import de.enough.polish.calendar.CalendarTextResolver;
import de.enough.polish.calendar.EventRepeatRule;
import de.enough.polish.io.Externalizable;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.Comparator;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.IdentityHashMap;
import de.enough.polish.util.Iterator;
import de.enough.polish.util.LongHashMap;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TimeZone;

public class CalendarEntryModel
implements Externalizable,
CalendarSubject {
    private static final int VERSION = 100;
    private TimeZone timeZone;
    private IdentityHashMap calendarEntriesByCategory = new IdentityHashMap();
    private final IdentityArrayList rootCategories = new IdentityArrayList();
    private IdentityArrayList listeners;
    private IdentityArrayList observers;
    private boolean isDirty;
    private Comparator rootCategoriesComparator;
    private CalendarEntry recentChangedEntry;
    private CalendarEntry recentDeletedEntry;
    private CalendarCategory recentChangedCategory;

    public void addEntry(CalendarEntry entry) {
        this.addEntry(entry, false);
    }

    public void addEntry(CalendarEntry entry, boolean notifyObserver) {
        CalendarCategory category = entry.getCategory();
        CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
        if (list == null) {
            list = this.addCategory(category, false);
        }
        list.add(entry);
        this.isDirty = true;
        if (notifyObserver) {
            this.notifyObservers();
        }
    }

    public void updateEntry(CalendarEntry entry) {
        this.updateEntry(entry, false);
    }

    public void updateEntry(CalendarEntry entry, boolean notifyObserver) {
        this.removeEntry(entry);
        this.addEntry(entry);
        if (notifyObserver) {
            this.recentChangedEntry = entry;
            this.notifyObservers();
        }
    }

    public CalendarEntryList addCategory(CalendarCategory category) {
        return this.addCategory(category, false);
    }

    public CalendarEntryList addCategory(CalendarCategory category, boolean notifyObserver) {
        CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
        if (list == null) {
            CalendarCategory parent = category;
            while (parent.getParentCategory() != null) {
                parent = parent.getParentCategory();
            }
            if (!this.rootCategories.contains(parent)) {
                this.rootCategories.add(parent);
            }
            list = new CalendarEntryList();
            this.calendarEntriesByCategory.put(category, list);
            this.isDirty = true;
            if (notifyObserver) {
                this.recentChangedCategory = category;
                this.notifyObservers();
            }
        }
        return list;
    }

    public boolean removeEntry(CalendarEntry entry) {
        CalendarCategory category = entry.getCategory();
        CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
        if (list != null) {
            return list.remove(entry);
        }
        return false;
    }

    public boolean removeEntry(long categoryGuid, long entryGuid) {
        CalendarEntryList list;
        CalendarCategory category = this.getCategory(categoryGuid);
        if (category != null && (list = (CalendarEntryList)this.calendarEntriesByCategory.get(category)) != null) {
            return list.remove(entryGuid);
        }
        return false;
    }

    public boolean removeEntry(CalendarEntry entry, boolean removeEmptyCategory) {
        if (removeEmptyCategory) {
            CalendarCategory category = entry.getCategory();
            CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
            if (list != null) {
                boolean removed = list.remove(entry);
                if (list.size() == 0) {
                    this.calendarEntriesByCategory.remove(category);
                    boolean noEntriesFound = true;
                    block0: while (category.getParentCategory() != null && noEntriesFound) {
                        category = category.getParentCategory();
                        CalendarCategory[] children = category.getChildCategories();
                        for (int i = 0; i < children.length; ++i) {
                            CalendarCategory child = children[i];
                            if (this.calendarEntriesByCategory.get(child) == null) continue;
                            noEntriesFound = false;
                            continue block0;
                        }
                    }
                    if (noEntriesFound) {
                        this.rootCategories.remove(category);
                    }
                }
                return removed;
            }
            return false;
        }
        return this.removeEntry(entry);
    }

    public boolean removeEntry(CalendarEntry entry, boolean removeEmptyCategory, boolean notifyObserver) {
        boolean removed = this.removeEntry(entry, removeEmptyCategory);
        if (notifyObserver) {
            this.recentDeletedEntry = entry;
            this.notifyObservers();
        }
        return removed;
    }

    public void addEntries(CalendarEntryModel model) {
        this.addEntries(model, false, false);
    }

    public void addEntries(CalendarEntryModel model, boolean notifyObserver) {
        this.addEntries(model, notifyObserver, false);
    }

    public void addEntries(CalendarEntryModel model, boolean notifyObserver, boolean forEachEvent) {
        IdentityHashMap entriesByCategory = model.calendarEntriesByCategory;
        Iterator it = entriesByCategory.keysIterator();
        block0: while (it.hasNext()) {
            CalendarCategory category = (CalendarCategory)it.next();
            CalendarCategory original = this.getCategory(category.getGuid());
            CalendarEntryList originalList = null;
            if (original != null) {
                originalList = (CalendarEntryList)this.calendarEntriesByCategory.get(original);
            }
            CalendarCategory child = category;
            for (CalendarCategory parent = category.getParentCategory(); parent != null; parent = parent.getParentCategory()) {
                CalendarCategory originalParent = this.getCategory(parent.getGuid());
                if (originalParent != null) {
                    if (original != null) {
                        child.setParentCategory(originalParent);
                        break;
                    }
                    CalendarCategory originalChild = originalParent.getChildCategory(child.getGuid());
                    if (originalChild == null) {
                        originalParent.addChildCategory(child);
                        break;
                    }
                    child.setParentCategory(originalParent);
                    break;
                }
                child = parent;
            }
            CalendarEntryList entriesList = (CalendarEntryList)entriesByCategory.get(category);
            Object[] entries = entriesList.getInternalArray();
            for (int i = 0; i < entries.length; ++i) {
                CalendarEntry entry = (CalendarEntry)entries[i];
                if (entry == null) {
                    if (i != 0 || original != null) continue block0;
                    this.addCategory(category);
                    continue block0;
                }
                if (original != null) {
                    entry.setCategory(original);
                }
                if (originalList != null && originalList.containsEntryWithGuid(entry.getGuid())) continue;
                this.addEntry(entry, forEachEvent);
            }
        }
        if (notifyObserver && !forEachEvent) {
            this.notifyObservers();
        }
    }

    public CalendarCategory getCategory(long guid) {
        for (int i = 0; i < this.rootCategories.size(); ++i) {
            CalendarCategory root = (CalendarCategory)this.rootCategories.get(i);
            CalendarCategory found = this.getCategory(guid, root);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private CalendarCategory getCategory(long guid, CalendarCategory root) {
        CalendarCategory child;
        if (guid == root.getGuid()) {
            return root;
        }
        Object[] children = root.getChildCategoriesAsInternalArray();
        for (int i = 0; i < children.length && (child = (CalendarCategory)children[i]) != null; ++i) {
            CalendarCategory found = this.getCategory(guid, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean removeCategory(CalendarCategory category) {
        return this.removeCategory(category, false);
    }

    public boolean removeCategory(CalendarCategory category, boolean notifyObserver) {
        if (category.hasChildCategories()) {
            throw new IllegalStateException();
        }
        CalendarEntryList entryList = this.getEntries(category);
        this.calendarEntriesByCategory.remove(category);
        CalendarCategory parentCategory = category.getParentCategory();
        if (parentCategory != null) {
            ArrayList childCategoryList = parentCategory.getChildCategoriesAsList();
            boolean removed = childCategoryList.remove(category);
            if (notifyObserver) {
                this.recentChangedCategory = parentCategory;
                this.notifyObservers();
            }
            this.isDirty = true;
            return removed;
        }
        return false;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void enableCategory(CalendarCategory category) {
        this.isDirty = category.setEnabled(true);
    }

    public void disableCategory(CalendarCategory category) {
        this.isDirty = category.setEnabled(false);
    }

    public int enableCategoryByName(String name) {
        return this.enableCategoryByName(name, true, false);
    }

    public int disableCategoryByName(String name) {
        return this.enableCategoryByName(name, false, false);
    }

    public int enableCategoryById(String name) {
        return this.enableCategoryByName(name, true, true);
    }

    public int disableCategoryById(String name) {
        return this.enableCategoryByName(name, false, true);
    }

    private int enableCategoryByName(String name, boolean enable, boolean useId) {
        int matchingCategories = 0;
        for (int i = 0; i < this.rootCategories.size(); ++i) {
            CalendarCategory category = (CalendarCategory)this.rootCategories.get(i);
            matchingCategories += this.enableCategoryByName(category, name, enable, useId);
        }
        return matchingCategories;
    }

    private int enableCategoryByName(CalendarCategory category, String name, boolean enable, boolean useId) {
        CalendarCategory child;
        int matchingCategories = 0;
        if (!useId && name.equals(category.getName())) {
            category.setEnabled(enable);
            ++matchingCategories;
        } else if (useId && name.equals(category.getId())) {
            category.setEnabled(enable);
            ++matchingCategories;
        }
        Object[] children = category.getChildCategoriesAsInternalArray();
        for (int i = 0; i < children.length && (child = (CalendarCategory)children[i]) != null; ++i) {
            matchingCategories += this.enableCategoryByName(child, name, enable, useId);
        }
        return matchingCategories;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirtyFlag() {
        this.isDirty = false;
    }

    public CalendarCategory[] getRootCategories() {
        Object[] roots = (CalendarCategory[])this.rootCategories.toArray(new CalendarCategory[this.rootCategories.size()]);
        if (this.rootCategoriesComparator != null) {
            Arrays.sort(roots, this.rootCategoriesComparator);
        }
        return roots;
    }

    public CalendarCategory[] getEnabledRootCategories() {
        IdentityArrayList list = new IdentityArrayList();
        for (int i = 0; i < this.rootCategories.size(); ++i) {
            CalendarCategory category = (CalendarCategory)this.rootCategories.get(i);
            if (!category.isEnabled()) continue;
            list.add(category);
        }
        Object[] roots = (CalendarCategory[])list.toArray(new CalendarCategory[list.size()]);
        if (this.rootCategoriesComparator != null) {
            Arrays.sort(roots, this.rootCategoriesComparator);
        }
        return roots;
    }

    public void setRootCategoriesComparator(Comparator comparator) {
        this.rootCategoriesComparator = comparator;
    }

    public CalendarEntryList getEntries(TimePeriod period) {
        return this.getEntries(period, false);
    }

    public CalendarEntryList getEnabledEntries(TimePeriod period) {
        return this.getEntries(period, true);
    }

    public CalendarEntryList getEntries(CalendarCategory category, TimePeriod period) {
        CalendarEntryList returnList = new CalendarEntryList();
        TimePeriod nextDatePeriod = new TimePeriod(period);
        CalendarEntryList entryList = this.getEntries(category, period, nextDatePeriod);
        if (entryList == null || entryList.size() == 0) {
            System.out.println("Searching children...");
            boolean hasChildCategories = category.hasChildCategories();
            while (hasChildCategories) {
                CalendarCategory[] childCategories = category.getChildCategories();
                for (int i = 0; i < childCategories.length; ++i) {
                    CalendarEntry entry;
                    CalendarCategory childCategory = childCategories[i];
                    entryList = this.getEntries(childCategory, period);
                    Object[] objects = entryList.getInternalArray();
                    for (int j = 0; j < objects.length && (entry = (CalendarEntry)objects[j]) != null; ++j) {
                        returnList.add(entry);
                    }
                }
                hasChildCategories = false;
            }
        } else {
            returnList = entryList;
        }
        return returnList;
    }

    private CalendarEntryList getEntries(TimePeriod period, boolean filterByEnabledCategories) {
        CalendarCategory[] categories = (CalendarCategory[])this.calendarEntriesByCategory.keys(new CalendarCategory[this.calendarEntriesByCategory.size()]);
        TimePeriod nextDatePeriod = new TimePeriod(period);
        CalendarEntryList returnList = new CalendarEntryList();
        for (int i = 0; i < categories.length; ++i) {
            CalendarCategory category = categories[i];
            if (filterByEnabledCategories && !category.isEnabled()) continue;
            CalendarEntryList list = this.getEntries(category, period, nextDatePeriod);
            returnList.add(list);
        }
        return returnList;
    }

    private CalendarEntryList getEntries(CalendarCategory category, TimePeriod period, TimePeriod nextDatePeriod) {
        CalendarEntry entry;
        CalendarEntryList returnList = new CalendarEntryList();
        CalendarEntryList calendarEntryList = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
        if (calendarEntryList == null) {
            return returnList;
        }
        Object[] entries = calendarEntryList.getInternalArray();
        for (int j = 0; j < entries.length && (entry = (CalendarEntry)entries[j]) != null; ++j) {
            TimePoint nextDate;
            EventRepeatRule rule = entry.getRepeat();
            if (rule == null) {
                if (!entry.matches(period)) continue;
                returnList.add(entry);
                continue;
            }
            nextDatePeriod.setStart(period.getStart(), period.isIncludeStart());
            while ((nextDate = rule.getNextDate(entry, nextDatePeriod)) != null) {
                CalendarEntry copy = entry.clone(nextDate);
                returnList.add(copy);
                nextDatePeriod.setStart(nextDate, false);
            }
        }
        return returnList;
    }

    public CalendarEntryList getEntries(CalendarCategory category) {
        CalendarEntryList entryList = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
        if (entryList == null || entryList.size() == 0) {
            CalendarEntryList returnList = new CalendarEntryList();
            boolean hasChildCategory = category.hasChildCategories();
            while (hasChildCategory) {
                CalendarCategory[] childCategory = category.getChildCategories();
                for (int i = 0; i < childCategory.length; ++i) {
                    CalendarEntry entry;
                    entryList = this.getEntries(childCategory[i]);
                    Object[] objects = entryList.getInternalArray();
                    for (int j = 0; j < objects.length && (entry = (CalendarEntry)objects[j]) != null; ++j) {
                        returnList.add(entry);
                    }
                }
                hasChildCategory = false;
            }
            return returnList;
        }
        return entryList;
    }

    public void setTextResolver(CalendarCategory category, int entryType, CalendarTextResolver textResolver) {
        if (category != null) {
            this.setTextResolver(this.getEntries(category), entryType, textResolver);
        } else {
            Object[] keys = this.calendarEntriesByCategory.keys();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(key);
                this.setTextResolver(list, entryType, textResolver);
            }
        }
    }

    private void setTextResolver(CalendarEntryList entriesList, int entryType, CalendarTextResolver textResolver) {
        CalendarEntry entry;
        Object[] entries = entriesList.getInternalArray();
        for (int i = 0; i < entries.length && (entry = (CalendarEntry)entries[i]) != null; ++i) {
            if (entry.getType() != entryType) continue;
            entry.setTextResolver(textResolver);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int i;
        int version = in.readInt();
        if (version != 100) {
            throw new IOException("unknown version " + version);
        }
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.timeZone = TimeZone.getTimeZone(in.readUTF());
        }
        int categoriesSize = in.readInt();
        CalendarCategory[] roots = new CalendarCategory[categoriesSize];
        LongHashMap categoriesByGuid = new LongHashMap();
        for (i = 0; i < roots.length; ++i) {
            CalendarCategory root = new CalendarCategory();
            root.read(in);
            roots[i] = root;
            this.storeCategoryGuids(root, categoriesByGuid);
        }
        categoriesSize = in.readInt();
        for (i = 0; i < categoriesSize; ++i) {
            long guid = in.readLong();
            CalendarCategory category = (CalendarCategory)categoriesByGuid.get(guid);
            if (category == null) {
                throw new IOException("Encountered invalid CalendarCategory GUID " + guid);
            }
            int entriesSize = in.readInt();
            for (int j = 0; j < entriesSize; ++j) {
                CalendarEntry entry = new CalendarEntry();
                entry.read(in);
                entry.setCategory(category);
                this.addEntry(entry);
            }
        }
    }

    private void storeCategoryGuids(CalendarCategory category, LongHashMap categoriesByGuid) {
        CalendarCategory child;
        categoriesByGuid.put(category.getGuid(), category);
        categoriesByGuid.put(category.getGuidOld(), category);
        Object[] objects = category.getChildCategoriesAsInternalArray();
        for (int i = 0; i < objects.length && (child = (CalendarCategory)objects[i]) != null; ++i) {
            this.storeCategoryGuids(child, categoriesByGuid);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        boolean notNull = this.timeZone != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.timeZone.getID());
        }
        CalendarCategory[] roots = this.getRootCategories();
        out.writeInt(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            CalendarCategory root = roots[i];
            root.write(out);
        }
        CalendarCategory[] categories = (CalendarCategory[])this.calendarEntriesByCategory.keys(new CalendarCategory[this.calendarEntriesByCategory.size()]);
        out.writeInt(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            CalendarEntry entry;
            CalendarCategory category = categories[i];
            out.writeLong(category.getGuid());
            CalendarEntryList list = (CalendarEntryList)this.calendarEntriesByCategory.get(category);
            out.writeInt(list.size());
            Object[] entries = list.getInternalArray();
            for (int j = 0; j < entries.length && (entry = (CalendarEntry)entries[j]) != null; ++j) {
                entry.setCategory(null);
                entry.write(out);
                entry.setCategory(category);
            }
        }
        this.isDirty = false;
    }

    public void addObserver(CalendarObserver observer) {
        if (this.observers == null) {
            this.observers = new IdentityArrayList();
            this.observers.add(observer);
        } else if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(CalendarObserver observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }

    public void notifyObservers() {
        if (this.observers != null) {
            CalendarObserver observer;
            Object[] objects = this.observers.getInternalArray();
            for (int i = 0; i < objects.length && (observer = (CalendarObserver)objects[i]) != null; ++i) {
                observer.updatedCalendarModel(this, this.recentChangedEntry, this.recentDeletedEntry, this.recentChangedCategory);
            }
        }
    }
}

