/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.Comparator;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;

public class CalendarEntryList
implements Comparator {
    private final IdentityArrayList list = new IdentityArrayList();
    private CalendarEntry[] sortedEntries;

    public void add(CalendarEntry entry) {
        this.sortedEntries = null;
        this.list.add(entry);
    }

    public void add(CalendarEntryList entryList) {
        CalendarEntry entryToAdd;
        Object[] objects = entryList.getInternalArray();
        for (int i = 0; i < objects.length && (entryToAdd = (CalendarEntry)objects[i]) != null; ++i) {
            this.add(entryToAdd);
        }
    }

    public boolean remove(CalendarEntry entry) {
        boolean removed = this.list.remove(entry);
        if (!removed) {
            return this.remove(entry.getGuid());
        }
        this.sortedEntries = null;
        return removed;
    }

    public boolean remove(long guid) {
        CalendarEntry entry;
        Object[] objects = this.list.getInternalArray();
        for (int i = 0; i < objects.length && (entry = (CalendarEntry)objects[i]) != null; ++i) {
            if (entry.getGuid() != guid) continue;
            this.list.remove(i);
            this.sortedEntries = null;
            return true;
        }
        return false;
    }

    public void clear() {
        this.sortedEntries = null;
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public CalendarEntry[] getEntries() {
        Object[] entries = this.sortedEntries;
        if (entries == null) {
            entries = (CalendarEntry[])this.list.toArray(new CalendarEntry[this.list.size()]);
            Arrays.sort(entries, this);
            this.sortedEntries = entries;
        }
        return entries;
    }

    public CalendarEntry[] getEntriesForDay(TimePoint day) {
        if (this.list.size() == 0) {
            return new CalendarEntry[0];
        }
        ArrayList l = new ArrayList();
        CalendarEntry[] entries = this.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            CalendarEntry entry = entries[i];
            TimePoint start = entry.getStartDate();
            if (start == null || !start.equalsDay(day)) continue;
            l.add(entry);
        }
        return (CalendarEntry[])l.toArray(new CalendarEntry[l.size()]);
    }

    public CalendarEntryList getEntriesForPeriod(TimePeriod period) {
        CalendarEntryList returnList = new CalendarEntryList();
        for (int i = 0; i < this.list.size(); ++i) {
            CalendarEntry entry = (CalendarEntry)this.list.get(i);
            if (!entry.matches(period)) continue;
            returnList.add(entry);
        }
        return returnList;
    }

    public CalendarEntry[] searchEntries(String searchString, boolean onlyAtStart) {
        if (this.list.size() == 0) {
            return new CalendarEntry[0];
        }
        ArrayList foundMatches = new ArrayList();
        CalendarEntry[] entries = this.getEntries();
        searchString = searchString.toLowerCase();
        for (int i = 0; i < entries.length; ++i) {
            CalendarEntry entry = entries[i];
            String summary = entry.getSummary();
            if (summary == null) continue;
            summary = summary.toLowerCase();
            if (onlyAtStart) {
                if (!summary.startsWith(searchString)) continue;
                foundMatches.add(entry);
                continue;
            }
            if (summary.indexOf(searchString) == -1) continue;
            foundMatches.add(entry);
        }
        Object[] matches = new CalendarEntry[foundMatches.size()];
        foundMatches.toArray(matches);
        return matches;
    }

    public int compare(Object o1, Object o2) {
        CalendarEntry e1 = (CalendarEntry)o1;
        CalendarEntry e2 = (CalendarEntry)o2;
        TimePoint st1 = e1.getStartDate();
        TimePoint st2 = e2.getStartDate();
        int result = 0;
        if (st1 != null && st2 != null) {
            result = st1.compareTo(st2);
        }
        if (result == 0) {
            String su1 = e1.getSummary();
            String su2 = e2.getSummary();
            if (su1 != null && su2 != null) {
                result = su1.compareTo(su2);
            }
        }
        return result;
    }

    public Object[] getInternalArray() {
        return this.list.getInternalArray();
    }

    public boolean containsEntryWithGuid(long guid) {
        CalendarEntry entry;
        Object[] entries = this.list.getInternalArray();
        for (int i = 0; i < entries.length && (entry = (CalendarEntry)entries[i]) != null; ++i) {
            if (entry.getGuid() != guid) continue;
            return true;
        }
        return false;
    }
}

