/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.rss;

import de.enough.polish.browser.Browser;
import de.enough.polish.browser.TagHandler;
import de.enough.polish.browser.rss.RssItem;
import de.enough.polish.io.StringReader;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.Locale;
import de.enough.polish.util.TextUtil;
import de.enough.polish.xml.SimplePullParser;

public class RssTagHandler
extends TagHandler {
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_LINK = "link";
    private static final String TAG_LANGUAGE = "language";
    private static final String TAG_COPYRIGHT = "copyright";
    private static final String TAG_PUBDATE = "pubDate";
    private static final String TAG_GUID = "guid";
    private static final String TAG_IMAGE = "image";
    private static final String TAG_URL = "url";
    private static final String TAG_ITEM = "item";
    private static final String TAG_TITLE = "title";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_AUTHOR = "author";
    private static final String TAG_DIGG_DIGGCOUNT = "digg:diggCount";
    private static final String TAG_DIGG_USERNAME = "digg:username";
    private static final String TAG_DIGG_USERIMAGE = "digg:userimage";
    private static final String TAG_DIGG_CATEGORY = "digg:category";
    private static final String TAG_DIGG_COMMENTCOUNT = "digg:commentCount";
    private static final String TAG_FEEDBURNER_ORIGLINK = "feedburner:origLink";
    public static final String ATTR_RSS_ITEM = "RSS_ITEM";
    public static Command CMD_RSS_ITEM_SELECT = new Command(Locale.get(199), 4, 1);
    public static Command CMD_GO_TO_ARTICLE = new Command(Locale.get(198), 1, 2);
    private Browser browser;
    private boolean inChannelTag;
    private boolean inItemTag;
    private String title;
    private String description;
    private String url;
    private Command linkCommand;
    private ItemCommandListener itemListener;
    private boolean includeDescriptions;
    private Style rssLinkStyle;

    public RssTagHandler(Command linkCommand, ItemCommandListener listener) {
        this.linkCommand = linkCommand;
        this.itemListener = listener;
        if (Locale.get(199) != CMD_RSS_ITEM_SELECT.getLabel()) {
            CMD_RSS_ITEM_SELECT = new Command(Locale.get(199), 4, 1);
            CMD_GO_TO_ARTICLE = new Command(Locale.get(198), 1, 2);
        }
    }

    public void setLinkCommand(Command link) {
        this.linkCommand = link;
    }

    public void register(Browser browser) {
        this.browser = browser;
        browser.addTagHandler(TAG_CHANNEL, this);
        browser.addTagHandler(TAG_LINK, this);
        browser.addTagHandler(TAG_LANGUAGE, this);
        browser.addTagHandler(TAG_COPYRIGHT, this);
        browser.addTagHandler(TAG_PUBDATE, this);
        browser.addTagHandler(TAG_GUID, this);
        browser.addTagHandler(TAG_IMAGE, this);
        browser.addTagHandler(TAG_URL, this);
        browser.addTagHandler(TAG_ITEM, this);
        browser.addTagHandler(TAG_TITLE, this);
        browser.addTagHandler(TAG_DESCRIPTION, this);
        browser.addTagHandler(TAG_AUTHOR, this);
        browser.addTagHandler(TAG_DIGG_DIGGCOUNT, this);
        browser.addTagHandler(TAG_DIGG_USERNAME, this);
        browser.addTagHandler(TAG_DIGG_USERIMAGE, this);
        browser.addTagHandler(TAG_DIGG_CATEGORY, this);
        browser.addTagHandler(TAG_DIGG_COMMENTCOUNT, this);
        browser.addTagHandler(TAG_FEEDBURNER_ORIGLINK, this);
    }

    private static String decodeHtml(String encodedHtml) {
        String tmp = TextUtil.replace(encodedHtml, "&lt;", "<");
        tmp = TextUtil.replace(tmp, "&gt;", ">");
        return TextUtil.replace(tmp, "&quot;", "\"");
    }

    public boolean handleTag(Container parentItem, SimplePullParser parser, String tagName, boolean opening, HashMap attributeMap, Style style) {
        if (TAG_CHANNEL.equals(tagName)) {
            this.inChannelTag = opening;
            return true;
        }
        if (this.inChannelTag) {
            if (TAG_ITEM.equals(tagName)) {
                this.inItemTag = opening;
                if (!opening && this.title != null && this.description != null) {
                    this.addRssItem(this.title, this.description, this.url);
                    this.title = null;
                    this.description = null;
                    this.url = null;
                }
                return true;
            }
            if (this.inItemTag) {
                if (TAG_TITLE.equals(tagName)) {
                    if (opening) {
                        parser.next();
                        this.title = this.trim(parser.getText());
                    }
                    return true;
                }
                if (TAG_LINK.equals(tagName)) {
                    if (opening) {
                        parser.next();
                        this.url = this.trim(parser.getText());
                    }
                    return true;
                }
                if (TAG_DESCRIPTION.equals(tagName)) {
                    if (opening) {
                        parser.next();
                        this.description = this.trim(parser.getText());
                        this.description = RssTagHandler.decodeHtml(this.description);
                        if (this.includeDescriptions) {
                            try {
                                this.browser.loadPartialPage(new StringReader(this.description));
                            }
                            catch (Exception e) {
                                Debug.debug("error", "de.enough.polish.browser.rss.RssTagHandler", 228, (Object)("Unable to load description " + this.description), e);
                            }
                        }
                    }
                    return true;
                }
            } else if (TAG_TITLE.equals(tagName)) {
                if (opening) {
                    parser.next();
                    String text = this.trim(parser.getText());
                    this.browser.getScreen().setTitle(text);
                }
                return true;
            }
        }
        if (!this.inItemTag && (TAG_LINK.equals(tagName) || TAG_DESCRIPTION.equals(tagName)) || TAG_LANGUAGE.equals(tagName) || TAG_PUBDATE.equals(tagName) || TAG_GUID.equals(tagName) || TAG_URL.equals(tagName) || TAG_DIGG_DIGGCOUNT.equals(tagName) || TAG_DIGG_USERNAME.equals(tagName) || TAG_DIGG_USERIMAGE.equals(tagName) || TAG_DIGG_CATEGORY.equals(tagName) || TAG_DIGG_COMMENTCOUNT.equals(tagName) || TAG_FEEDBURNER_ORIGLINK.equals(tagName)) {
            if (opening) {
                parser.next();
            }
            return true;
        }
        return false;
    }

    protected void addRssItem(String rssTitle, String rssDescription, String rssUrl) {
        StringItem item = new StringItem(null, rssTitle, StyleSheet.browserlinkStyle);
        item.setAppearanceMode(1);
        item.setDefaultCommand(CMD_RSS_ITEM_SELECT);
        item.setItemCommandListener(this.itemListener);
        item.setAttribute(ATTR_RSS_ITEM, new RssItem(rssTitle, rssDescription, this.url));
        item.addCommand(this.linkCommand);
        if (this.url != null) {
            item.setAttribute("href", rssUrl);
        }
        this.applyStylingForRssLink(item, this.browser.size(), rssUrl);
        this.browser.add(item);
    }

    protected void applyStylingForRssLink(Item item, int index, String rssUrl) {
        if (this.rssLinkStyle != null) {
            item.setStyle(this.rssLinkStyle);
        }
    }

    protected void onViewUrl(String rssUrl, Item item) {
    }

    public void setRssLinkStyle() {
    }

    public void setRssLinkStyle(Style style) {
        this.rssLinkStyle = style;
    }

    public boolean isIncludeDescriptions() {
        return this.includeDescriptions;
    }

    public void setIncludeDescriptions(boolean includeDescriptions) {
        this.includeDescriptions = includeDescriptions;
    }
}

